/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.grammar;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class NamedDeclaration {
    public final String nsURI;
    public final String localName;
    private static final int CHOICES_THRESHOLD = 8;

    private NamedDeclaration() {
        this.nsURI = null;
        this.localName = null;
    }

    public NamedDeclaration(String string2, String string3) {
        assert (string2 == null || string2 == string2.intern());
        assert (string3 == null || string3 == string3.intern());
        this.nsURI = string2;
        this.localName = string3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" :: ");
        if (this.nsURI != null && this.nsURI.length() > 0) {
            stringBuilder.append('{').append(this.nsURI).append('}');
        }
        if (this.localName != null && this.localName.length() > 0) {
            stringBuilder.append(this.localName);
        } else {
            stringBuilder.append("##ANONYMOUS");
        }
        return stringBuilder.toString();
    }

    public static Entry[] createMap(NamedDeclaration[] namedDeclarationArray) {
        return NamedDeclaration.createMap(namedDeclarationArray, false);
    }

    public static Entry[] createMap(NamedDeclaration[] namedDeclarationArray, boolean bl) {
        if (namedDeclarationArray != null && namedDeclarationArray.length > 8) {
            int n2;
            int n3 = namedDeclarationArray.length;
            int n4 = n3 * 4 / 3;
            for (n2 = 1; n2 <= n4 && n2 != 0x40000000; n2 <<= 1) {
            }
            Entry[] entryArray = ArrayAllocator.newObjectArray(Entry.class, n2);
            if (bl) {
                for (int i = n3 - 1; i >= 0; --i) {
                    NamedDeclaration namedDeclaration = namedDeclarationArray[i];
                    int n5 = namedDeclaration.localName.hashCode() & entryArray.length - 1;
                    entryArray[n5] = new Entry(namedDeclaration, i, entryArray[n5]);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    NamedDeclaration namedDeclaration = namedDeclarationArray[i];
                    int n6 = namedDeclaration.localName.hashCode() & entryArray.length - 1;
                    entryArray[n6] = new Entry(namedDeclaration, i, entryArray[n6]);
                }
            }
            return entryArray;
        }
        return null;
    }

    public static int findQNameInChoices(NamedDeclaration[] namedDeclarationArray, Entry[] entryArray, QName qName) {
        return NamedDeclaration.findQNameInChoices(namedDeclarationArray, entryArray, qName.nsURI, qName.localName);
    }

    public static int findQNameInChoices(NamedDeclaration[] namedDeclarationArray, Entry[] entryArray, String string2, String string3) {
        int n2 = namedDeclarationArray.length;
        if (n2 == 1) {
            NamedDeclaration namedDeclaration = namedDeclarationArray[0];
            return string3 == namedDeclaration.localName && string2 == namedDeclaration.nsURI ? 0 : -1;
        }
        if (entryArray == null) {
            return NamedDeclaration.linearSearch(string2, string3, n2, namedDeclarationArray);
        }
        return NamedDeclaration.searchMap(string2, string3, entryArray);
    }

    private static int linearSearch(String string2, String string3, int n2, NamedDeclaration[] namedDeclarationArray) {
        for (int i = n2 - 1; i >= 0; --i) {
            NamedDeclaration namedDeclaration = namedDeclarationArray[i];
            if (string3 != namedDeclaration.localName || string2 != namedDeclaration.nsURI) continue;
            return i;
        }
        return -1;
    }

    private static int searchMap(String string2, String string3, Entry[] entryArray) {
        int n2 = string3.hashCode() & entryArray.length - 1;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (string3 == entry.localName && string2 == entry.nsURI) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    public static int findLocalNameInChoices(NamedDeclaration[] namedDeclarationArray, Entry[] entryArray, String string2, boolean bl) {
        int n2 = namedDeclarationArray.length;
        if (n2 == 1) {
            NamedDeclaration namedDeclaration = namedDeclarationArray[0];
            return string2 == namedDeclaration.localName && NamedDeclaration.isNamespaceAllowed(namedDeclaration.nsURI, bl) ? 0 : -1;
        }
        if (entryArray == null) {
            return NamedDeclaration.linearSearch(string2, n2, namedDeclarationArray, bl);
        }
        return NamedDeclaration.searchMap(string2, entryArray, bl);
    }

    private static int linearSearch(String string2, int n2, NamedDeclaration[] namedDeclarationArray, boolean bl) {
        int n3 = -1;
        for (int i = n2 - 1; i >= 0; --i) {
            NamedDeclaration namedDeclaration = namedDeclarationArray[i];
            if (string2 != namedDeclaration.localName || !NamedDeclaration.isNamespaceAllowed(namedDeclaration.nsURI, bl)) continue;
            if (n3 == -1) {
                n3 = i;
                continue;
            }
            return -1;
        }
        return n3;
    }

    private static int searchMap(String string2, Entry[] entryArray, boolean bl) {
        int n2 = string2.hashCode() & entryArray.length - 1;
        int n3 = -1;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (string2 == entry.localName && NamedDeclaration.isNamespaceAllowed(entry.nsURI, bl)) {
                if (n3 == -1) {
                    n3 = entry.value;
                } else {
                    return -1;
                }
            }
            entry = entry.next;
        }
        return n3;
    }

    private static boolean isNamespaceAllowed(String string2, boolean bl) {
        if (bl) {
            return string2 == null || string2.length() == 0;
        }
        return true;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class Entry {
        final String localName;
        final String nsURI;
        final int value;
        final Entry next;

        public Entry(NamedDeclaration namedDeclaration, int n2, Entry entry) {
            this.localName = namedDeclaration.localName;
            this.nsURI = namedDeclaration.nsURI;
            this.value = n2;
            this.next = entry;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
            stringBuilder.append(" :: ");
            if (this.nsURI != null && this.nsURI.length() > 0) {
                stringBuilder.append('{').append(this.nsURI).append('}');
            }
            if (this.localName != null && this.localName.length() > 0) {
                stringBuilder.append(this.localName);
            }
            if (this.next != null) {
                stringBuilder.append(" --> ");
                stringBuilder.append(this.next.toString());
            }
            return stringBuilder.toString();
        }
    }
}

