/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DTDSupport;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DTDGrammar;
import com.ibm.xml.xlxp.internal.s1.scan.util.DTDGrammarCache;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityManager;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DTDScanner
extends DTDSupport
implements EntityManager.EntitySupport {
    public static final int SEPARATOR_CHOICE = 0;
    public static final int SEPARATOR_SEQUENCE = 1;
    public static final int OCCURRENCE_ZERO_OR_ONE = 0;
    public static final int OCCURRENCE_ZERO_OR_MORE = 1;
    public static final int OCCURRENCE_ONE_OR_MORE = 2;
    private static final byte[] PUBLIC_BYTES = new byte[]{80, 85, 66, 76, 73, 67};
    private static final byte[] SYSTEM_BYTES = new byte[]{83, 89, 83, 84, 69, 77};
    private static final byte[] ELEMENT_BYTES = new byte[]{69, 76, 69, 77, 69, 78, 84};
    private static final byte[] ATTLIST_BYTES = new byte[]{65, 84, 84, 76, 73, 83, 84};
    private static final byte[] ENTITY_BYTES = new byte[]{69, 78, 84, 73, 84, 89};
    private static final byte[] NOTATION_BYTES = new byte[]{78, 79, 84, 65, 84, 73, 79, 78};
    private static final byte[] INCLUDE_BYTES = new byte[]{73, 78, 67, 76, 85, 68, 69};
    private static final byte[] IGNORE_BYTES = new byte[]{73, 71, 78, 79, 82, 69};
    private static final byte[] INCLUDESECT_START_BYTES = new byte[]{60, 33, 91};
    private static final byte[] INCLUDESECT_END_BYTES = new byte[]{93, 93, 62};
    private static final byte[] EMPTY_BYTES = new byte[]{69, 77, 80, 84, 89};
    private static final byte[] ANY_BYTES = new byte[]{65, 78, 89};
    private static final byte[] PCDATA_BYTES = new byte[]{35, 80, 67, 68, 65, 84, 65};
    private static final byte[] FIXED_BYTES = new byte[]{35, 70, 73, 88, 69, 68};
    private static final byte[] IMPLIED_BYTES = new byte[]{35, 73, 77, 80, 76, 73, 69, 68};
    private static final byte[] REQUIRED_BYTES = new byte[]{35, 82, 69, 81, 85, 73, 82, 69, 68};
    private static final byte[] CDATA_BYTES = new byte[]{67, 68, 65, 84, 65};
    private static final byte[] ID_BYTES = new byte[]{73, 68};
    private static final byte[] REF_BYTES = new byte[]{82, 69, 70};
    private static final byte[] ENTIT_BYTES = new byte[]{69, 78, 84, 73, 84};
    private static final byte[] IES_BYTES = new byte[]{73, 69, 83};
    private static final byte[] NMTOKEN_BYTES = new byte[]{78, 77, 84, 79, 75, 69, 78};
    private static final byte[] NDATA_BYTES = new byte[]{78, 68, 65, 84, 65};
    private static final byte[] PI_END_BYTES = new byte[]{63, 62};
    private static final byte[] intSubsetMap = new byte[]{7, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final byte[] extSubsetMap = new byte[]{7, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final byte[] pubidCharMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final byte[] sysidCharMap = new byte[]{6, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final byte[] entityValueMap = new byte[]{7, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 4, 1, 1, 2, 3, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final byte[] ignoreSectMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    protected final SymbolTable fSymbolTable;
    protected final EntityManager fEntityManager;
    protected ParsedEntity fCurrentEntity;
    protected DTDGrammar fDTDGrammar;
    protected QName fDeclElementType;
    protected final XMLString fContentModel;
    protected QName fDeclAttrName;
    protected XMLString fDeclAttType;
    protected final XMLString fInternalEntityValue;
    protected int fMarkupDepth;
    protected boolean fUsingCachedGrammar;
    private XMLStringBuffer fGrammarStringBuffer;
    private boolean fGrammarCachingEnabled;
    private boolean fShouldCacheGrammar;
    private boolean fHaveExternalSubset;
    private DTDGrammarCache fDTDGrammarCache;
    private final XMLString fRootElementType;
    private final XMLString fDoctypePublicID;
    private final XMLString fDoctypeSystemID;
    private final QName fQName1;
    private final QName fQName2;
    private int fTempStringCount;
    private XMLString[] fTempStrings;
    private byte[] fOpStack;
    private int fContentModelOffset;
    private boolean fContentModelPCDATA;
    private boolean fScannedDefaultAttValue;
    private int fDefaultAttValueOffset;
    private final XMLString fDefaultAttValue;
    private int fEntityValueOffset;
    private int fIncludeSectDepth;

    public DTDScanner(DocumentScanner documentScanner, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
        super(documentScanner);
        this.fSymbolTable = symbolTable;
        this.fEntityManager = new EntityManager(this, documentScanner, symbolTable, parsedEntityFactory);
        this.fQName1 = new QName();
        this.fQName2 = new QName();
        this.fTempStrings = ArrayAllocator.newObjectArray(XMLString.class, 8);
        for (int i = 0; i < this.fTempStrings.length; ++i) {
            this.fTempStrings[i] = new XMLString();
        }
        this.fRootElementType = new XMLString();
        this.fDoctypePublicID = new XMLString();
        this.fDoctypeSystemID = new XMLString();
        this.fContentModel = new XMLString();
        this.fDefaultAttValue = new XMLString();
        this.fInternalEntityValue = new XMLString();
        this.fOpStack = ArrayAllocator.newByteArray(32);
    }

    public void reset(boolean bl) {
        this.fIncludeSectDepth = 0;
        this.fMarkupDepth = 0;
        this.fEntityManager.reset(bl);
        this.clearState();
        if (this.fDTDGrammar != null) {
            this.fDTDGrammar.reset(bl);
        }
        this.fHaveExternalSubset = false;
        if (this.fRootElementType.firstBuffer != null) {
            this.fRootElementType.clear();
        }
        if (this.fDoctypePublicID.firstBuffer != null) {
            this.fDoctypePublicID.clear();
        }
        if (this.fDoctypeSystemID.firstBuffer != null) {
            this.fDoctypeSystemID.clear();
        }
        if (this.fUsingCachedGrammar) {
            this.setGrammar(null);
            this.fUsingCachedGrammar = false;
        }
    }

    protected void clearState() {
        this.fQName1.clear();
        this.fQName2.clear();
        this.fTempStringCount = 0;
        for (int i = 0; i < this.fTempStrings.length; ++i) {
            if (this.fTempStrings[i].firstBuffer == null) continue;
            this.fTempStrings[i].clear();
        }
        this.fContentModel.clear();
        this.fDefaultAttValue.clear();
        this.fInternalEntityValue.clear();
    }

    public boolean hasElementContentElements() {
        return this.fDTDGrammar != null && this.fDTDGrammar.hasElementContentElements();
    }

    public boolean hasElementContent(String string2) {
        return this.fDTDGrammar != null && this.fDTDGrammar.hasElementContent(string2);
    }

    public boolean hasDefaultAttributes() {
        return this.fDTDGrammar != null && this.fDTDGrammar.hasAttDefs();
    }

    public boolean addDefaultAttributes(boolean bl) {
        if (this.fDTDGrammar == null || !this.fDTDGrammar.hasAttDefs()) {
            return true;
        }
        return this.fDTDGrammar.addDefaultAttributes(this.fScanner, bl, this.fEntityManager.isStandalone());
    }

    protected XMLString allocateTempString() {
        if (this.fTempStringCount == this.fTempStrings.length) {
            this.growTempStrings();
        }
        return this.fTempStrings[this.fTempStringCount++];
    }

    protected void releaseTempString() {
        XMLString xMLString = this.fTempStrings[--this.fTempStringCount];
        if (xMLString.firstBuffer != null) {
            xMLString.clear();
        }
    }

    private void growTempStrings() {
        int n2 = this.fTempStrings.length;
        this.fTempStrings = ArrayAllocator.resizeObjectArray(XMLString.class, this.fTempStrings, n2 << 1);
        for (int i = (n2 << 1) - 1; i >= n2; --i) {
            this.fTempStrings[i] = new XMLString();
        }
    }

    protected void setInvalidCharParameter(int n2) {
        int n3 = this.fCurrentEntity.decodeCharacter();
        this.fScanner.setInvalidCharParameter(n2, n3);
    }

    private boolean reportFatalError(int n2) {
        return this.fScanner.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", n2);
    }

    protected boolean skippedXML11LineBreak() {
        return !this.fCurrentEntity.isXML10 && !this.fCurrentEntity.lineBreaksNormalized && this.fCurrentEntity.skippedXML11EOLCharacter();
    }

    public void setEntityContent(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fScanner.setEntityContent(this.fCurrentEntity);
    }

    public int entityDepth() {
        return this.fEntityManager.entityDepth();
    }

    public boolean endOfEntity(int n2) {
        return this.fEntityManager.endOfEntity(n2);
    }

    public final boolean scanDoctypeDecl() {
        if (this.scanDoctypeDeclCommon()) {
            return this.fScanner.produceDoctypeEvent();
        }
        return false;
    }

    protected boolean scanDoctypeDeclCommon() {
        boolean bl;
        XMLString xMLString = this.fScanner.rootElementType;
        XMLString xMLString2 = this.fScanner.publicID;
        XMLString xMLString3 = this.fScanner.systemID;
        xMLString2.clear();
        xMLString3.clear();
        if (!this.scanRequiredWhitespace()) {
            return this.reportFatalError(14);
        }
        int n2 = this.fScanner.scanQNameOrName(this.fQName1);
        if (n2 == 0) {
            return this.reportFatalError(15);
        }
        if (n2 == 6) {
            this.fCurrentEntity.skipSpaces();
            int n3 = this.fCurrentEntity.currentByte();
            if (n3 != 91 && n3 != 62) {
                if (this.fCurrentEntity.skippedBytes(PUBLIC_BYTES)) {
                    if (!this.scanRequiredWhitespace()) {
                        return this.reportFatalError(60);
                    }
                    if (this.fCurrentEntity.skippedByte(34)) {
                        n3 = 34;
                    } else if (this.fCurrentEntity.skippedByte(39)) {
                        n3 = 39;
                    } else {
                        return this.reportFatalError(10);
                    }
                    if (!this.scanPublicID(n3, xMLString2)) {
                        return false;
                    }
                } else if (!this.fCurrentEntity.skippedBytes(SYSTEM_BYTES)) {
                    return this.reportFatalError(59);
                }
                if (!this.scanRequiredWhitespace()) {
                    return this.reportFatalError(62);
                }
                if (this.fCurrentEntity.skippedByte(34)) {
                    n3 = 34;
                } else if (this.fCurrentEntity.skippedByte(39)) {
                    n3 = 39;
                } else {
                    return this.reportFatalError(8);
                }
                if (!this.scanSystemID(n3, xMLString3)) {
                    return false;
                }
                this.fCurrentEntity.skipSpaces();
            }
        }
        xMLString.setValues(this.fQName1);
        this.fQName1.clear();
        if (this.fCurrentEntity.skippedByte(62)) {
            bl = false;
        } else if (this.fCurrentEntity.skippedByte(91)) {
            bl = true;
        } else {
            this.fScanner.setParameter(0, xMLString);
            return this.reportFatalError(16);
        }
        this.processDoctype(xMLString, xMLString2, xMLString3, bl);
        if (bl) {
            this.fScanner.nextStateIntSubset();
        } else if (this.fHaveExternalSubset) {
            this.fScanner.nextStateExtSubset();
        } else {
            this.nextStateProlog();
        }
        this.fScanner.internalSubset = bl;
        return true;
    }

    private boolean scanPublicID(int n2, XMLString xMLString) {
        this.fCurrentEntity.startString(xMLString);
        block6: while (true) {
            switch (this.fCurrentEntity.skipBytesUsingMap(pubidCharMap, 1)) {
                case 2: {
                    if (this.fCurrentEntity.currentByte() == n2) {
                        this.fCurrentEntity.endString(xMLString);
                        if ((xMLString.flags & 0xC) != 0) {
                            this.fGrammarStringBuffer.addXMLString(xMLString, xMLString);
                        }
                        if (!xMLString.isNormalized()) {
                            this.fGrammarStringBuffer.normalizePublicID(xMLString);
                        }
                        this.fCurrentEntity.nextByte();
                        return true;
                    }
                    if (this.fCurrentEntity.skippedByte(39)) continue block6;
                }
                case 3: {
                    if (this.skippedXML11LineBreak()) {
                        xMLString.flags = (short)(xMLString.flags | 8);
                        continue block6;
                    }
                    this.setInvalidCharParameter(0);
                    if (this.fCurrentEntity.skippedValidCharacter()) {
                        return this.reportFatalError(12);
                    }
                    return this.reportFatalError(3);
                }
                case 4: {
                    if (!this.fCurrentEntity.lineBreaksNormalized) {
                        xMLString.flags = (short)(xMLString.flags | 4);
                    }
                    this.fCurrentEntity.nextByte();
                    continue block6;
                }
                case 5: {
                    if (!this.fCurrentEntity.atEndOfEntity()) break block6;
                    return this.reportFatalError(11);
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        if (this.fCurrentEntity.skippedValidCharacter()) {
            return this.reportFatalError(12);
        }
        return this.reportFatalError(3);
    }

    private boolean scanSystemID(int n2, XMLString xMLString) {
        boolean bl = false;
        this.fCurrentEntity.startString(xMLString);
        block8: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(sysidCharMap, 1, xMLString)) {
                case 2: {
                    if (this.fCurrentEntity.currentByte() == n2) {
                        this.fCurrentEntity.endString(xMLString);
                        if ((xMLString.flags & 0xC) != 0) {
                            this.fGrammarStringBuffer.addXMLString(xMLString, xMLString);
                        }
                        this.fCurrentEntity.nextByte();
                        if (!bl) {
                            return true;
                        }
                        this.fScanner.setParameter(0, xMLString);
                        return this.fScanner.reportRecoverableError("http://www.w3.org/TR/2000/REC-xml-20001006", 63);
                    }
                    this.fCurrentEntity.nextByte();
                    continue block8;
                }
                case 3: {
                    this.fCurrentEntity.nextByte();
                    bl = true;
                    continue block8;
                }
                case 4: {
                    continue block8;
                }
                case 5: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 6: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        return this.reportFatalError(9);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 7: {
                    if (!this.fCurrentEntity.isXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block8;
                }
            }
            if (this.fCurrentEntity.isXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    public boolean scanInternalDTDSubset() {
        return this.scanInternalSubset();
    }

    /*
     * Unable to fully structure code
     */
    private boolean scanInternalSubset() {
        block9: while (true) {
            switch (DTDScanner.intSubsetMap[this.fCurrentEntity.currentByte() & 255]) {
                case 2: {
                    this.fCurrentEntity.nextByte();
                    if (this.scanMarkupDecl()) continue block9;
                    return false;
                }
                case 3: {
                    this.fCurrentEntity.nextByte();
                    var1_1 = this.allocateTempString();
                    if (!this.scanPEReference(var1_1)) {
                        this.releaseTempString();
                        return false;
                    }
                    if (!this.fEntityManager.internalSubsetPEReference(var1_1)) {
                        this.releaseTempString();
                        return false;
                    }
                    this.releaseTempString();
                    continue block9;
                }
                case 4: {
                    return this.endInternalSubset();
                }
                case 5: {
                    this.fCurrentEntity.nextByte();
                    this.fCurrentEntity.skipSpaces();
                    continue block9;
                }
                case 6: {
                    if (!this.skippedXML11LineBreak()) ** break;
                    continue block9;
                    if (this.fCurrentEntity.skippedValidCharacter()) {
                        return this.reportFatalError(19);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(5);
                }
                case 7: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        return this.reportFatalError(16);
                    }
                }
                default: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(5);
                }
                case 1: 
            }
            break;
        }
        return this.reportFatalError(19);
    }

    public boolean intSubsetPEReference(XMLString xMLString) {
        return this.scanIntSubsetDecl() && this.endOfEntity(1);
    }

    /*
     * Unable to fully structure code
     */
    private boolean scanIntSubsetDecl() {
        block8: while (true) {
            switch (DTDScanner.intSubsetMap[this.fCurrentEntity.currentByte() & 255]) {
                case 2: {
                    this.fCurrentEntity.nextByte();
                    if (this.scanMarkupDecl()) continue block8;
                    return false;
                }
                case 3: {
                    this.fCurrentEntity.nextByte();
                    var1_1 = this.allocateTempString();
                    if (!this.scanPEReference(var1_1)) {
                        this.releaseTempString();
                        return false;
                    }
                    if (!this.fEntityManager.internalSubsetPEReference(var1_1)) {
                        this.releaseTempString();
                        return false;
                    }
                    this.releaseTempString();
                    continue block8;
                }
                case 5: {
                    this.fCurrentEntity.nextByte();
                    this.fCurrentEntity.skipSpaces();
                    continue block8;
                }
                case 6: {
                    if (!this.skippedXML11LineBreak()) ** break;
                    continue block8;
                    if (!this.fCurrentEntity.skippedValidCharacter()) {
                        this.setInvalidCharParameter(0);
                        return this.reportFatalError(5);
                    }
                }
                case 1: 
                case 4: {
                    return this.reportFatalError(19);
                }
                case 7: {
                    if (!this.fCurrentEntity.atEndOfEntity()) break block8;
                    return true;
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(5);
    }

    public boolean scanExternalSubset1() {
        if (this.fScanner.scanTextDecl() && this.scanExtSubsetDecl()) {
            if (this.fEntityManager.entityDepth() == 2) {
                return this.endOfEntity(1);
            }
            return this.reportFatalError(18);
        }
        this.endOfEntity(1);
        return false;
    }

    public boolean extSubsetPEReference(XMLString xMLString) {
        boolean bl = this.scanExtSubsetDecl();
        this.endOfEntity(1);
        return bl;
    }

    private boolean scanExtSubsetDecl() {
        int n2 = this.fIncludeSectDepth;
        int n3 = this.fEntityManager.entityDepth();
        block9: while (true) {
            switch (extSubsetMap[this.fCurrentEntity.currentByte() & 0xFF]) {
                case 2: {
                    this.fCurrentEntity.nextByte();
                    ++this.fMarkupDepth;
                    if (!this.scanMarkupDecl()) {
                        return false;
                    }
                    --this.fMarkupDepth;
                    continue block9;
                }
                case 3: {
                    this.fCurrentEntity.nextByte();
                    XMLString xMLString = this.allocateTempString();
                    if (!this.scanPEReference(xMLString)) {
                        this.releaseTempString();
                        return false;
                    }
                    if (!this.fEntityManager.externalSubsetPEReference(xMLString)) {
                        this.releaseTempString();
                        return false;
                    }
                    this.releaseTempString();
                    continue block9;
                }
                case 4: {
                    if (this.fIncludeSectDepth > 0 && this.fCurrentEntity.skippedBytes(INCLUDESECT_END_BYTES)) {
                        this.endOfConditionalSection(this.fIncludeSectDepth, n2);
                        --this.fIncludeSectDepth;
                        continue block9;
                    }
                    return this.reportFatalError(19);
                }
                case 5: {
                    this.fCurrentEntity.nextByte();
                    this.fCurrentEntity.skipSpaces();
                    continue block9;
                }
                case 6: {
                    if (this.skippedXML11LineBreak()) continue block9;
                    if (!this.fCurrentEntity.skippedValidCharacter()) {
                        this.setInvalidCharParameter(0);
                        return this.reportFatalError(6);
                    }
                }
                case 1: {
                    return this.reportFatalError(19);
                }
                case 7: {
                    if (!this.fCurrentEntity.atEndOfEntity()) break block9;
                    if (this.fEntityManager.entityDepth() == n3) {
                        if (this.fIncludeSectDepth > n2) {
                            return this.reportFatalError(46);
                        }
                        return true;
                    }
                    if (this.fEntityManager.inPEReferenceWithinMarkup()) {
                        this.endPEReferenceWithinMarkup();
                        continue block9;
                    }
                    return this.reportFatalError(19);
                }
            }
            break;
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(6);
    }

    protected void endOfConditionalSection(int n2, int n3) {
    }

    private boolean scanDefaultAttValue(int n2) {
        boolean bl = true;
        int n3 = this.fEntityManager.entityDepth();
        this.fCurrentEntity.startString(this.fDefaultAttValue);
        block10: while (true) {
            switch (this.fCurrentEntity.skipBytesUsingMap(DocumentScanner.attValueMap, 1)) {
                case 2: {
                    if (n3 == this.fEntityManager.entityDepth() && this.fCurrentEntity.currentByte() == n2) {
                        this.fCurrentEntity.endString(this.fDefaultAttValue);
                        if (this.fDefaultAttValue.length > 0) {
                            this.defaultAttValueCharacters(bl);
                        } else {
                            this.fDefaultAttValue.clear();
                        }
                        this.fCurrentEntity.nextByte();
                        return true;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
                case 3: {
                    this.fCurrentEntity.endString(this.fDefaultAttValue);
                    if (this.fDefaultAttValue.length > 0) {
                        this.defaultAttValueCharacters(bl);
                    } else {
                        this.fDefaultAttValue.clear();
                    }
                    this.fCurrentEntity.nextByte();
                    if (!this.checkReferenceInDefaultAttValue()) {
                        return false;
                    }
                    this.fCurrentEntity.startString(this.fDefaultAttValue);
                    bl = true;
                    continue block10;
                }
                case 4: {
                    this.setAttValueErrorParameters();
                    return this.fScanner.reportFatalError(25);
                }
                case 5: {
                    this.fCurrentEntity.nextByte();
                    bl = false;
                    continue block10;
                }
                case 6: {
                    if (!this.fCurrentEntity.lineBreaksNormalized) {
                        this.fDefaultAttValue.flags = (short)(this.fDefaultAttValue.flags | 4);
                    }
                    this.fCurrentEntity.nextByte();
                    bl = false;
                    continue block10;
                }
                case 7: {
                    if (this.skippedXML11LineBreak()) {
                        this.fDefaultAttValue.flags = (short)(this.fDefaultAttValue.flags | 8);
                        bl = false;
                        continue block10;
                    }
                    if (this.fCurrentEntity.skippedValidCharacter()) continue block10;
                    this.setAttValueErrorParameters();
                    this.setInvalidCharParameter(2);
                    return this.fScanner.reportFatalError(21);
                }
                case 8: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        this.fCurrentEntity.endString(this.fDefaultAttValue);
                        if (this.fDefaultAttValue.length > 0) {
                            this.defaultAttValueCharacters(bl);
                        } else {
                            this.fDefaultAttValue.clear();
                        }
                        if (this.endOfEntity(1)) {
                            this.fCurrentEntity.startString(this.fDefaultAttValue);
                            bl = true;
                            continue block10;
                        }
                        this.setAttValueErrorParameters();
                        return this.fScanner.reportFatalError(26);
                    }
                    this.setAttValueErrorParameters();
                    this.setInvalidCharParameter(2);
                    return this.fScanner.reportFatalError(21);
                }
                case 9: {
                    if (!this.fCurrentEntity.isXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
            }
            if (this.fCurrentEntity.isXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setAttValueErrorParameters();
        this.setInvalidCharParameter(2);
        return this.fScanner.reportFatalError(21);
    }

    private boolean scanEntityValue(int n2) {
        int n3 = this.fEntityManager.entityDepth();
        this.fCurrentEntity.startString(this.fInternalEntityValue);
        block9: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(entityValueMap, 1, this.fInternalEntityValue)) {
                case 2: {
                    this.fCurrentEntity.endString(this.fInternalEntityValue);
                    if (this.fInternalEntityValue.length > 0) {
                        this.entityValueCharacters();
                    } else {
                        this.fInternalEntityValue.clear();
                    }
                    this.fCurrentEntity.nextByte();
                    XMLString xMLString = this.allocateTempString();
                    if (!this.scanPEReference(xMLString)) {
                        this.releaseTempString();
                        return false;
                    }
                    if (!this.fEntityManager.inExternalEntity()) {
                        this.fScanner.setParameter(0, xMLString);
                        this.releaseTempString();
                        return this.reportFatalError(17);
                    }
                    this.fEntityManager.peReferenceInEntityValue(xMLString);
                    this.releaseTempString();
                    this.fCurrentEntity.startString(this.fInternalEntityValue);
                    continue block9;
                }
                case 3: {
                    this.fCurrentEntity.endString(this.fInternalEntityValue);
                    if (this.fInternalEntityValue.length > 0) {
                        this.entityValueCharacters();
                    } else {
                        this.fInternalEntityValue.clear();
                    }
                    this.fCurrentEntity.nextByte();
                    if (!this.checkReferenceInEntityValue()) {
                        return false;
                    }
                    this.fCurrentEntity.startString(this.fInternalEntityValue);
                    continue block9;
                }
                case 4: {
                    if (n3 == this.fEntityManager.entityDepth() && this.fCurrentEntity.currentByte() == n2) {
                        this.fCurrentEntity.endString(this.fInternalEntityValue);
                        if (this.fInternalEntityValue.length > 0) {
                            this.entityValueCharacters();
                        } else {
                            this.fInternalEntityValue.clear();
                        }
                        this.fCurrentEntity.nextByte();
                        return true;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block9;
                }
                case 5: {
                    continue block9;
                }
                case 6: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(1);
                }
                case 7: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        this.fCurrentEntity.endString(this.fInternalEntityValue);
                        if (this.fInternalEntityValue.length > 0) {
                            this.entityValueCharacters();
                        } else {
                            this.fInternalEntityValue.clear();
                        }
                        if (this.endOfEntity(n3)) {
                            this.fCurrentEntity.startString(this.fInternalEntityValue);
                            continue block9;
                        }
                        return this.reportFatalError(13);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(1);
                }
                case 8: {
                    if (!this.fCurrentEntity.isXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block9;
                }
            }
            if (this.fCurrentEntity.isXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(1);
    }

    private boolean scanMarkupDecl() {
        if (this.fCurrentEntity.skippedByte(33)) {
            if (this.fCurrentEntity.skippedBytes(ELEMENT_BYTES)) {
                return this.scanElementDecl();
            }
            if (this.fCurrentEntity.skippedBytes(ATTLIST_BYTES)) {
                return this.scanAttlistDecl();
            }
            if (this.fCurrentEntity.skippedBytes(ENTITY_BYTES)) {
                return this.scanEntityDecl();
            }
            if (this.fCurrentEntity.skippedBytes(NOTATION_BYTES)) {
                return this.scanNotationDecl();
            }
            if (this.fCurrentEntity.skippedByte(45)) {
                if (!this.fCurrentEntity.skippedByte(45)) {
                    return this.fScanner.reportFatalError(27);
                }
                return this.scanDTDComment();
            }
            if (this.fEntityManager.inExternalEntity() && this.fCurrentEntity.skippedByte(91)) {
                return this.scanConditionalSection();
            }
        } else if (this.fCurrentEntity.skippedByte(63)) {
            return this.scanDTDPI();
        }
        return this.reportFatalError(19);
    }

    protected boolean scanConditionalSection() {
        if (!this.checkForPEReference(false)) {
            return false;
        }
        if (this.fCurrentEntity.skippedBytes(INCLUDE_BYTES)) {
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.skippedByte(91)) {
                ++this.fIncludeSectDepth;
                return true;
            }
        } else if (this.fCurrentEntity.skippedBytes(IGNORE_BYTES)) {
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.skippedByte(91)) {
                return this.scanIgnoreSectContents();
            }
        }
        return this.reportFatalError(19);
    }

    private boolean scanElementDecl() {
        if (!this.scanRequiredWhitespace2()) {
            return this.reportFatalError(21);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        QName qName = this.fQName1;
        int n2 = this.fScanner.scanQNameOrName(qName);
        if (n2 == 0) {
            return this.reportFatalError(22);
        }
        this.startElementDecl(qName);
        if (!this.scanRequiredWhitespace2()) {
            this.fScanner.setParameter(0, qName);
            return this.reportFatalError(23);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        if (this.fCurrentEntity.skippedBytes(ANY_BYTES)) {
            this.contentModelANY();
        } else if (this.fCurrentEntity.skippedBytes(EMPTY_BYTES)) {
            this.contentModelEMPTY();
        } else if (this.fCurrentEntity.skippedByte(40)) {
            this.startContentModelGroup((byte)40);
            if (!this.checkForPEReference(true)) {
                return false;
            }
            if (this.fCurrentEntity.skippedBytes(PCDATA_BYTES)) {
                this.contentModelPCDATA();
                if (!this.scanMixed()) {
                    return false;
                }
            } else if (!this.scanChildren()) {
                return false;
            }
        } else {
            this.fScanner.setParameter(0, qName);
            return this.reportFatalError(24);
        }
        if (!this.fCurrentEntity.skippedByte(62)) {
            if (!this.checkForPEReference(true)) {
                return false;
            }
            if (!this.fCurrentEntity.skippedByte(62)) {
                this.fScanner.setParameter(0, qName);
                return this.reportFatalError(25);
            }
        }
        this.endElementDecl();
        this.fDeclElementType.clear();
        this.fDeclElementType = null;
        this.fContentModel.clear();
        if (this.fQName2.firstBuffer != null) {
            this.fQName2.clear();
        }
        return true;
    }

    private void startContentModelGroup(byte by2) {
        int n2;
        if ((n2 = this.fMarkupDepth++) >= this.fOpStack.length) {
            int n3;
            for (n3 = this.fOpStack.length << 1; n2 >= n3; n3 <<= 1) {
            }
            this.fOpStack = ArrayAllocator.resizeByteArray(this.fOpStack, n3);
        }
        this.fOpStack[n2] = by2;
        this.contentModelStartGroup();
    }

    private byte endContentModelGroup() {
        this.contentModelEndGroup();
        int n2 = --this.fMarkupDepth;
        return this.fOpStack[n2];
    }

    private boolean scanMixed() {
        boolean bl = false;
        while (this.checkForPEReference(true)) {
            if (!this.fCurrentEntity.skippedByte(124)) {
                if (!this.fCurrentEntity.skippedByte(41)) {
                    this.fScanner.setParameter(0, this.fDeclElementType);
                    return this.reportFatalError(29);
                }
                this.endContentModelGroup();
                if (this.fCurrentEntity.skippedByte(42)) {
                    this.contentModelOccurrence(1);
                } else if (bl) {
                    this.fScanner.setParameter(0, this.fDeclElementType);
                    return this.reportFatalError(30);
                }
                return true;
            }
            this.contentModelSeparator(0);
            bl = true;
            if (!this.checkForPEReference(true)) {
                return false;
            }
            QName qName = this.fQName2;
            int n2 = this.fScanner.scanQNameOrName(qName);
            if (n2 == 0) {
                this.fScanner.setParameter(0, this.fDeclElementType);
                return this.reportFatalError(28);
            }
            this.contentModelElement(qName);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean scanChildren() {
        var1_1 = this.fMarkupDepth - 1;
        var2_2 = 40;
        do lbl-1000:
        // 3 sources

        {
            block19: {
                if (!this.fCurrentEntity.skippedByte(40)) break block19;
                this.startContentModelGroup((byte)var2_2);
                var2_2 = 40;
                if (this.checkForPEReference(true)) ** GOTO lbl-1000
                return false;
            }
            var3_3 = this.fQName2;
            var4_4 = this.fScanner.scanQNameOrName(var3_3);
            if (var4_4 == 0) {
                this.fScanner.setParameter(0, this.fDeclElementType);
                return this.reportFatalError(26);
            }
            this.contentModelElement(var3_3);
            if (this.fCurrentEntity.skippedByte(63)) {
                this.contentModelOccurrence(0);
            } else if (this.fCurrentEntity.skippedByte(42)) {
                this.contentModelOccurrence(1);
            } else if (this.fCurrentEntity.skippedByte(43)) {
                this.contentModelOccurrence(2);
            }
            if (!this.checkForPEReference(true)) {
                return false;
            }
            while (this.fCurrentEntity.skippedByte(41)) {
                var2_2 = this.endContentModelGroup();
                if (this.fCurrentEntity.skippedByte(63)) {
                    this.contentModelOccurrence(0);
                } else if (this.fCurrentEntity.skippedByte(42)) {
                    this.contentModelOccurrence(1);
                } else if (this.fCurrentEntity.skippedByte(43)) {
                    this.contentModelOccurrence(2);
                }
                if (this.fMarkupDepth == var1_1) {
                    return true;
                }
                if (this.checkForPEReference(true)) continue;
                return false;
            }
            if (this.fCurrentEntity.skippedByte(124)) {
                if (var2_2 == 44) {
                    this.fScanner.setParameter(0, this.fDeclElementType);
                    return this.reportFatalError(27);
                }
                var2_2 = 124;
                this.contentModelSeparator(0);
                continue;
            }
            if (this.fCurrentEntity.skippedByte(44)) {
                if (var2_2 == 124) {
                    this.fScanner.setParameter(0, this.fDeclElementType);
                    return this.reportFatalError(27);
                }
                var2_2 = 44;
                this.contentModelSeparator(1);
                continue;
            }
            this.fScanner.setParameter(0, this.fDeclElementType);
            return this.reportFatalError(27);
        } while (this.checkForPEReference(true));
        return false;
    }

    private boolean scanAttlistDecl() {
        if (!this.scanRequiredWhitespace2()) {
            return this.reportFatalError(31);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        QName qName = this.fQName1;
        int n2 = this.fScanner.scanQNameOrName(qName);
        if (n2 == 0) {
            return this.reportFatalError(32);
        }
        this.startAttlistDecl(qName);
        while (true) {
            boolean bl;
            XMLString xMLString;
            XMLString xMLString2;
            boolean bl2 = this.scanRequiredWhitespace2();
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.skippedByte(62)) break;
            if (!bl2) {
                this.fScanner.setParameter(0, qName);
                return this.reportFatalError(33);
            }
            QName qName2 = this.fQName2;
            n2 = this.fScanner.scanQNameOrName(qName2);
            if (n2 == 0) {
                this.fScanner.setParameter(0, qName);
                return this.reportFatalError(34);
            }
            if (!this.scanRequiredWhitespace2()) {
                this.fScanner.setParameter(0, qName);
                this.fScanner.setParameter(1, qName2);
                return this.reportFatalError(35);
            }
            if (!this.checkForPEReference(false)) {
                return false;
            }
            boolean bl3 = this.fCurrentEntity.skippedByte(40);
            if (!bl3) {
                xMLString2 = this.allocateTempString();
                if (!this.scanAttType(xMLString2)) {
                    this.fScanner.setParameter(0, qName);
                    this.fScanner.setParameter(1, qName2);
                    return this.reportFatalError(36);
                }
                if (this.isNotationType(xMLString2)) {
                    if (!this.scanRequiredWhitespace2()) {
                        this.fScanner.setParameter(0, qName);
                        this.fScanner.setParameter(1, qName2);
                        return this.reportFatalError(39);
                    }
                    if (!this.checkForPEReference(false)) {
                        return false;
                    }
                    if (!this.fCurrentEntity.skippedByte(40)) {
                        this.fScanner.setParameter(0, qName);
                        this.fScanner.setParameter(1, qName2);
                        return this.reportFatalError(40);
                    }
                    bl3 = true;
                }
            } else {
                xMLString2 = null;
            }
            this.startAttDef(qName2, xMLString2);
            if (bl3) {
                this.startEnumerationType();
                do {
                    if (!this.checkForPEReference(true)) {
                        return false;
                    }
                    XMLString xMLString3 = this.allocateTempString();
                    if (xMLString2 != null) {
                        n2 = this.fScanner.scanNCName(xMLString3);
                        if (n2 == 0) {
                            this.fScanner.setParameter(0, qName);
                            this.fScanner.setParameter(1, qName2);
                            return this.reportFatalError(41);
                        }
                    } else {
                        n2 = this.fScanner.scanNmtoken(xMLString3);
                        if (n2 == 0) {
                            this.fScanner.setParameter(0, qName);
                            this.fScanner.setParameter(1, qName2);
                            return this.reportFatalError(43);
                        }
                    }
                    this.enumerationType(xMLString3);
                    this.releaseTempString();
                    if (this.checkForPEReference(true)) continue;
                    return false;
                } while (this.fCurrentEntity.skippedByte(124));
                if (!this.fCurrentEntity.skippedByte(41)) {
                    this.fScanner.setParameter(0, qName);
                    this.fScanner.setParameter(1, qName2);
                    if (xMLString2 != null) {
                        return this.reportFatalError(42);
                    }
                    return this.reportFatalError(44);
                }
                this.endEnumerationType();
            }
            if (!this.scanRequiredWhitespace2()) {
                this.fScanner.setParameter(0, qName);
                this.fScanner.setParameter(1, qName2);
                return this.reportFatalError(37);
            }
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.currentByte() == 35) {
                xMLString = this.allocateTempString();
                this.fCurrentEntity.startString(xMLString);
                if (this.fCurrentEntity.skippedBytes(FIXED_BYTES)) {
                    this.fCurrentEntity.endString(xMLString);
                    if (!this.scanRequiredWhitespace2()) {
                        this.fScanner.setParameter(0, qName);
                        this.fScanner.setParameter(1, qName2);
                        return this.reportFatalError(45);
                    }
                    if (!this.checkForPEReference(false)) {
                        return false;
                    }
                    bl = true;
                } else {
                    if (!this.fCurrentEntity.skippedBytes(IMPLIED_BYTES) && !this.fCurrentEntity.skippedBytes(REQUIRED_BYTES)) {
                        this.fScanner.setParameter(0, qName);
                        this.fScanner.setParameter(1, qName2);
                        return this.reportFatalError(38);
                    }
                    this.fCurrentEntity.endString(xMLString);
                    bl = false;
                }
            } else {
                xMLString = null;
                bl = true;
            }
            if (bl) {
                int n3;
                if (this.fCurrentEntity.skippedByte(34)) {
                    n3 = 34;
                } else if (this.fCurrentEntity.skippedByte(39)) {
                    n3 = 39;
                } else {
                    this.fScanner.setParameter(0, qName);
                    this.fScanner.setParameter(1, qName2);
                    return this.fScanner.reportFatalError(24);
                }
                this.startDefaultAttValue();
                if (!this.scanDefaultAttValue(n3)) {
                    return false;
                }
            }
            this.endAttDef(xMLString);
            if (xMLString2 != null) {
                this.releaseTempString();
                this.fDeclAttType = null;
            }
            if (xMLString == null) continue;
            this.releaseTempString();
        }
        this.endAttlistDecl();
        this.fDeclElementType.clear();
        this.fDeclElementType = null;
        if (this.fDeclAttrName != null) {
            this.fDeclAttrName.clear();
            this.fDeclAttrName = null;
        }
        return true;
    }

    private boolean scanEntityDecl() {
        XMLString xMLString;
        int n2;
        XMLString xMLString2;
        int n3;
        boolean bl;
        if (!this.fEntityManager.inExternalEntity()) {
            if (!this.scanRequiredWhitespace()) {
                return this.reportFatalError(50);
            }
            bl = this.fCurrentEntity.skippedByte(37);
            if (bl && !this.scanRequiredWhitespace()) {
                return this.reportFatalError(52);
            }
        } else {
            boolean bl2 = false;
            if (this.fCurrentEntity.skippedSpaces()) {
                if (!this.fCurrentEntity.skippedByte(37)) {
                    bl = false;
                } else if (this.fCurrentEntity.skippedSpace()) {
                    if (!this.checkForPEReference(false)) {
                        return false;
                    }
                    bl = true;
                } else if (this.fCurrentEntity.skippedByte(37)) {
                    if (!this.checkForPEReference(false)) {
                        return false;
                    }
                    bl = true;
                } else {
                    bl2 = true;
                    bl = false;
                }
            } else {
                if (!this.fCurrentEntity.skippedByte(37)) {
                    return this.reportFatalError(50);
                }
                if (this.fCurrentEntity.skippedSpace()) {
                    return this.reportFatalError(51);
                }
                bl2 = true;
                bl = false;
            }
            if (bl2) {
                while (true) {
                    block63: {
                        XMLString xMLString3;
                        if (!this.scanPEReference(xMLString3 = this.allocateTempString())) {
                            this.releaseTempString();
                            return false;
                        }
                        this.startPEReferenceWithinMarkup(xMLString3);
                        this.releaseTempString();
                        do {
                            this.fCurrentEntity.skipSpaces();
                            if (!this.fCurrentEntity.atEndOfEntity()) break block63;
                            assert (false);
                            if (this.fCurrentEntity.currentByte() != 0) continue;
                        } while (this.endPEReferenceWithinMarkup());
                        return false;
                    }
                    if (!this.fCurrentEntity.skippedByte(37)) break;
                    if (bl) continue;
                    if (this.fCurrentEntity.skippedSpace()) {
                        if (!this.checkForPEReference(false)) {
                            return false;
                        }
                        bl = true;
                        break;
                    }
                    bl = this.fCurrentEntity.skippedByte(37);
                }
            }
        }
        if ((n3 = this.fScanner.scanNCName(xMLString2 = this.allocateTempString())) == 0) {
            return this.reportFatalError(53);
        }
        if (!this.scanRequiredWhitespace2()) {
            this.fScanner.setParameter(0, xMLString2);
            return this.reportFatalError(54);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        boolean bl3 = this.fCurrentEntity.skippedByte(34);
        if (bl3 || this.fCurrentEntity.skippedByte(39)) {
            int n4 = bl3 ? 34 : 39;
            this.startEntityValue();
            if (!this.scanEntityValue(n4)) {
                return false;
            }
            if (!this.checkForPEReference(true)) {
                return false;
            }
            if (!this.fCurrentEntity.skippedByte(62)) {
                this.fScanner.setParameter(0, xMLString2);
                return this.reportFatalError(58);
            }
            if (bl) {
                this.internalPEDecl(xMLString2);
            } else {
                this.internalEntityDecl(xMLString2);
            }
            this.releaseTempString();
            return true;
        }
        if (this.fCurrentEntity.skippedBytes(PUBLIC_BYTES)) {
            if (!this.scanRequiredWhitespace2()) {
                return this.reportFatalError(60);
            }
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.skippedByte(34)) {
                n2 = 34;
            } else if (this.fCurrentEntity.skippedByte(39)) {
                n2 = 39;
            } else {
                return this.reportFatalError(10);
            }
            xMLString = this.allocateTempString();
            if (!this.scanPublicID(n2, xMLString)) {
                return false;
            }
        } else if (this.fCurrentEntity.skippedBytes(SYSTEM_BYTES)) {
            xMLString = null;
        } else {
            return this.reportFatalError(59);
        }
        if (!this.scanRequiredWhitespace2()) {
            return this.reportFatalError(62);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        if (this.fCurrentEntity.skippedByte(34)) {
            n2 = 34;
        } else if (this.fCurrentEntity.skippedByte(39)) {
            n2 = 39;
        } else {
            return this.reportFatalError(8);
        }
        XMLString xMLString4 = this.allocateTempString();
        if (!this.scanSystemID(n2, xMLString4)) {
            return false;
        }
        boolean bl4 = this.scanRequiredWhitespace2();
        if (!this.checkForPEReference(false)) {
            return false;
        }
        if (this.fCurrentEntity.skippedByte(62)) {
            if (bl) {
                this.externalPEDecl(xMLString2, xMLString, xMLString4);
            } else {
                this.externalEntityDecl(xMLString2, xMLString, xMLString4);
            }
        } else {
            if (bl || !bl4) {
                this.fScanner.setParameter(0, xMLString2);
                return this.reportFatalError(58);
            }
            if (!this.fCurrentEntity.skippedBytes(NDATA_BYTES)) {
                this.fScanner.setParameter(0, xMLString2);
                return this.reportFatalError(58);
            }
            if (!this.scanRequiredWhitespace2()) {
                this.fScanner.setParameter(0, xMLString2);
                return this.reportFatalError(56);
            }
            if (!this.checkForPEReference(false)) {
                return false;
            }
            XMLString xMLString5 = this.allocateTempString();
            n3 = this.fScanner.scanNCName(xMLString5);
            if (n3 == 0) {
                this.fScanner.setParameter(0, xMLString2);
                return this.reportFatalError(57);
            }
            if (!this.checkForPEReference(true)) {
                return false;
            }
            if (!this.fCurrentEntity.skippedByte(62)) {
                this.fScanner.setParameter(0, xMLString2);
                return this.reportFatalError(58);
            }
            this.unparsedEntityDecl(xMLString2, xMLString, xMLString4, xMLString5);
            this.releaseTempString();
        }
        this.releaseTempString();
        if (xMLString != null) {
            this.releaseTempString();
        }
        this.releaseTempString();
        return true;
    }

    private boolean scanNotationDecl() {
        boolean bl;
        XMLString xMLString;
        int n2;
        if (!this.scanRequiredWhitespace2()) {
            return this.reportFatalError(64);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        XMLString xMLString2 = this.allocateTempString();
        int n3 = this.fScanner.scanNCName(xMLString2);
        if (n3 == 0) {
            return this.reportFatalError(65);
        }
        if (!this.scanRequiredWhitespace2()) {
            this.fScanner.setParameter(0, xMLString2);
            return this.reportFatalError(66);
        }
        if (!this.checkForPEReference(false)) {
            return false;
        }
        if (this.fCurrentEntity.skippedBytes(PUBLIC_BYTES)) {
            if (!this.scanRequiredWhitespace2()) {
                return this.reportFatalError(60);
            }
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.skippedByte(34)) {
                n2 = 34;
            } else if (this.fCurrentEntity.skippedByte(39)) {
                n2 = 39;
            } else {
                return this.reportFatalError(10);
            }
            xMLString = this.allocateTempString();
            if (!this.scanPublicID(n2, xMLString)) {
                return false;
            }
            bl = this.scanRequiredWhitespace2();
            if (!this.checkForPEReference(false)) {
                return false;
            }
            if (this.fCurrentEntity.skippedByte(62)) {
                this.notationDecl(xMLString2, xMLString, null);
                this.releaseTempString();
                this.releaseTempString();
                return true;
            }
        } else if (this.fCurrentEntity.skippedBytes(SYSTEM_BYTES)) {
            xMLString = null;
            bl = this.scanRequiredWhitespace2();
            if (!this.checkForPEReference(false)) {
                return false;
            }
        } else {
            return this.reportFatalError(59);
        }
        if (!bl) {
            return this.reportFatalError(62);
        }
        if (this.fCurrentEntity.skippedByte(34)) {
            n2 = 34;
        } else if (this.fCurrentEntity.skippedByte(39)) {
            n2 = 39;
        } else {
            return this.reportFatalError(8);
        }
        XMLString xMLString3 = this.allocateTempString();
        if (!this.scanSystemID(n2, xMLString3)) {
            return false;
        }
        if (!this.checkForPEReference(true)) {
            return false;
        }
        if (!this.fCurrentEntity.skippedByte(62)) {
            this.fScanner.setParameter(0, xMLString2);
            return this.reportFatalError(67);
        }
        this.notationDecl(xMLString2, xMLString, xMLString3);
        this.releaseTempString();
        if (xMLString != null) {
            this.releaseTempString();
        }
        this.releaseTempString();
        return true;
    }

    private boolean scanIgnoreSectContents() {
        int n2 = 1;
        block7: while (true) {
            switch (this.fCurrentEntity.skipBytesUsingMap(ignoreSectMap, 1)) {
                case 2: {
                    if (this.fCurrentEntity.skippedBytes(INCLUDESECT_START_BYTES)) {
                        ++n2;
                        continue block7;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
                case 3: {
                    if (this.fCurrentEntity.skippedBytes(INCLUDESECT_END_BYTES)) {
                        if (--n2 != 0) continue block7;
                        return true;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
                case 4: {
                    if (this.fCurrentEntity.skippedValidCharacter()) continue block7;
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(7);
                }
                case 5: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        return this.reportFatalError(47);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(7);
                }
                case 6: {
                    if (!this.fCurrentEntity.isXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
            }
            if (this.fCurrentEntity.isXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(7);
    }

    private boolean scanAttType(XMLString xMLString) {
        this.fCurrentEntity.startString(xMLString);
        if (!this.fCurrentEntity.skippedBytes(CDATA_BYTES)) {
            if (this.fCurrentEntity.skippedBytes(ID_BYTES)) {
                if (this.fCurrentEntity.skippedBytes(REF_BYTES)) {
                    this.fCurrentEntity.skippedByte(83);
                }
            } else if (this.fCurrentEntity.skippedBytes(ENTIT_BYTES)) {
                if (!this.fCurrentEntity.skippedByte(89) && !this.fCurrentEntity.skippedBytes(IES_BYTES)) {
                    return false;
                }
            } else if (this.fCurrentEntity.currentByte() == 78) {
                if (this.fCurrentEntity.skippedBytes(NMTOKEN_BYTES)) {
                    this.fCurrentEntity.skippedByte(83);
                } else if (!this.fCurrentEntity.skippedBytes(NOTATION_BYTES)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        this.fCurrentEntity.endString(xMLString);
        return true;
    }

    private boolean scanRequiredWhitespace() {
        return this.fCurrentEntity.skippedSpaces();
    }

    private boolean scanRequiredWhitespace2() {
        if (!this.fEntityManager.inExternalEntity()) {
            return this.fCurrentEntity.skippedSpaces();
        }
        if (this.fCurrentEntity.skippedByte(32)) {
            return true;
        }
        int n2 = this.fCurrentEntity.currentByte();
        if (n2 == 10 || n2 == 9 || n2 == 13) {
            return true;
        }
        if (this.skippedXML11LineBreak()) {
            return true;
        }
        if (n2 == 37) {
            return true;
        }
        return n2 == 0 && this.fCurrentEntity.atEndOfEntity();
    }

    private boolean checkForPEReference(boolean bl) {
        if (!this.fEntityManager.inExternalEntity()) {
            if (bl) {
                this.fCurrentEntity.skipSpaces();
            }
            return true;
        }
        while (true) {
            this.fCurrentEntity.skipSpaces();
            int n2 = this.fCurrentEntity.currentByte();
            if (n2 == 0 && this.fCurrentEntity.atEndOfEntity()) {
                if (this.endPEReferenceWithinMarkup()) continue;
                return false;
            }
            if (n2 != 37) {
                return true;
            }
            this.fCurrentEntity.nextByte();
            XMLString xMLString = this.allocateTempString();
            if (!this.scanPEReference(xMLString)) {
                this.releaseTempString();
                return false;
            }
            this.startPEReferenceWithinMarkup(xMLString);
            this.releaseTempString();
        }
    }

    private boolean scanDTDPI() {
        XMLString xMLString = this.fScanner.piTarget;
        int n2 = this.fScanner.scanNCName(xMLString);
        switch (n2) {
            case 0: {
                return this.fScanner.reportFatalError(30);
            }
            case 3: 
            case 6: {
                if (!DocumentScanner.reservedPITarget(xMLString)) {
                    XMLString xMLString2 = this.fScanner.content;
                    if (n2 == 6) {
                        this.fCurrentEntity.skipSpaces();
                        if (this.fScanner.scanPIData(xMLString2)) {
                            return this.processingInstructionInDTD(xMLString, xMLString2);
                        }
                        return false;
                    }
                    if (!this.fCurrentEntity.skippedBytes(PI_END_BYTES)) break;
                    xMLString2.clear();
                    return this.processingInstructionInDTD(xMLString, xMLString2);
                }
                return this.fScanner.reportFatalError(33);
            }
        }
        return this.fScanner.reportFatalError(31);
    }

    protected boolean processingInstructionInDTD(XMLString xMLString, XMLString xMLString2) {
        return true;
    }

    private boolean scanDTDComment() {
        XMLString xMLString = this.allocateTempString();
        if (this.fScanner.scanComment(xMLString) && this.commentInDTD(xMLString)) {
            this.releaseTempString();
            return true;
        }
        this.releaseTempString();
        return false;
    }

    protected boolean commentInDTD(XMLString xMLString) {
        return true;
    }

    protected boolean endInternalSubset() {
        this.fCurrentEntity.nextByte();
        this.fCurrentEntity.skipSpaces();
        if (!this.fCurrentEntity.skippedByte(62)) {
            return this.reportFatalError(19);
        }
        if (this.fHaveExternalSubset) {
            this.fScanner.nextStateExtSubset();
        } else {
            this.nextStateProlog();
        }
        return true;
    }

    public boolean scanExternalDTDSubset() {
        boolean bl = this.scanExternalSubset();
        this.nextStateProlog();
        return bl;
    }

    protected void nextStateProlog() {
        this.fScanner.nextStateProlog();
        this.clearState();
    }

    private boolean scanExternalSubset() {
        if (this.fHaveExternalSubset) {
            XMLString xMLString = this.fDoctypePublicID.firstBuffer != null ? this.fDoctypePublicID : null;
            XMLString xMLString2 = this.fDoctypeSystemID.firstBuffer != null ? this.fDoctypeSystemID : null;
            boolean bl = this.fEntityManager.scanExternalSubset2(xMLString, xMLString2);
            if (this.fShouldCacheGrammar) {
                if (this.fDTDGrammarCache == null) {
                    this.fDTDGrammarCache = new DTDGrammarCache();
                }
                this.fDTDGrammar.addGrammarToCache(this.fDTDGrammarCache, this.fRootElementType, xMLString, xMLString2);
                this.setGrammar(null);
                this.fUsingCachedGrammar = true;
            }
            if (this.fRootElementType.firstBuffer != null) {
                this.fRootElementType.clear();
            }
            if (this.fDoctypePublicID.firstBuffer != null) {
                this.fDoctypePublicID.clear();
            }
            if (this.fDoctypeSystemID.firstBuffer != null) {
                this.fDoctypeSystemID.clear();
            }
            return bl;
        }
        return true;
    }

    protected void processDoctype(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        DTDGrammar dTDGrammar;
        if (xMLString2.length > 0) {
            this.fSymbolTable.addSymbolSetValues(xMLString2, this.fDoctypePublicID);
        } else {
            xMLString2 = null;
            if (this.fDoctypePublicID.firstBuffer != null) {
                this.fDoctypePublicID.clear();
            }
        }
        boolean bl2 = this.fHaveExternalSubset = xMLString3.length > 0;
        if (this.fHaveExternalSubset) {
            this.fEntityManager.setHaveExternalSubsetOrPEReferences();
            this.fSymbolTable.addSymbolSetValues(xMLString3, this.fDoctypeSystemID);
        } else {
            if (this.fDoctypeSystemID.firstBuffer != null) {
                this.fDoctypeSystemID.clear();
            }
            xMLString3 = null;
        }
        if (!bl && this.fGrammarCachingEnabled && this.fDTDGrammarCache != null && (dTDGrammar = this.fDTDGrammarCache.lookupGrammar(xMLString, xMLString2, xMLString3)) != null) {
            this.setGrammar(dTDGrammar);
            this.fHaveExternalSubset = false;
            this.fUsingCachedGrammar = true;
        }
        if (bl || this.fHaveExternalSubset) {
            if (this.fDTDGrammar == null) {
                this.setGrammar(this.createDTDGrammar());
            }
            if (this.fHaveExternalSubset) {
                this.fShouldCacheGrammar = !bl && this.fGrammarCachingEnabled;
            }
        }
    }

    private boolean checkReferenceInDefaultAttValue() {
        if (this.fCurrentEntity.skippedByte(35)) {
            int n2 = this.fScanner.scanCharacterReference();
            if (n2 != -1) {
                this.defaultAttValueCharacter(n2, false);
                return true;
            }
            return false;
        }
        int n3 = this.fScanner.scanNCName(this.fScanner.entityName);
        if (n3 == 8) {
            this.fCurrentEntity.nextByte();
            return this.fEntityManager.entityReferenceInDefaultAttValue(this.fScanner.entityName);
        }
        if (n3 == 0) {
            return this.fScanner.reportFatalError(39);
        }
        this.fScanner.setParameter(0, this.fScanner.entityName);
        return this.fScanner.reportFatalError(40);
    }

    private boolean checkReferenceInEntityValue() {
        if (this.fCurrentEntity.skippedByte(35)) {
            int n2 = this.fScanner.scanCharacterReference();
            if (n2 != -1) {
                this.entityValueCharacter(n2);
                return true;
            }
            return false;
        }
        XMLString xMLString = this.allocateTempString();
        int n3 = this.fScanner.scanNCName(xMLString);
        if (n3 == 8) {
            this.fCurrentEntity.nextByte();
            this.entityReferenceInEntityValue(xMLString);
            this.releaseTempString();
            return true;
        }
        if (n3 == 0) {
            this.releaseTempString();
            return this.fScanner.reportFatalError(39);
        }
        this.fScanner.setParameter(0, xMLString);
        this.releaseTempString();
        return this.fScanner.reportFatalError(40);
    }

    private boolean scanPEReference(XMLString xMLString) {
        int n2 = this.fScanner.scanNCName(xMLString);
        if (n2 == 8) {
            this.fCurrentEntity.nextByte();
            return true;
        }
        if (n2 == 0) {
            return this.reportFatalError(48);
        }
        this.fScanner.setParameter(0, xMLString);
        return this.reportFatalError(49);
    }

    private boolean isNotationType(XMLString xMLString) {
        if (xMLString.length == 8) {
            byte[] byArray = xMLString.bytes;
            int n2 = xMLString.startOffset;
            int n3 = 0;
            if (byArray != null) {
                while (n2 < xMLString.endOffset) {
                    if (byArray[n2++] == NOTATION_BYTES[n3++]) continue;
                    return false;
                }
            } else {
                DataBuffer dataBuffer = xMLString.firstBuffer;
                int n4 = dataBuffer.endOffset;
                byArray = dataBuffer.bytes;
                while (true) {
                    if (byArray[n2++] != NOTATION_BYTES[n3++]) {
                        return false;
                    }
                    if (n2 != n4) continue;
                    if (dataBuffer == xMLString.lastBuffer) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n2 = dataBuffer.startOffset;
                    n4 = dataBuffer != xMLString.lastBuffer ? dataBuffer.endOffset : xMLString.endOffset;
                }
            }
            return true;
        }
        return false;
    }

    public boolean undeclaredParameterEntity(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        return this.reportFatalError(107);
    }

    public boolean skippedExternalSubsetEntity() {
        return true;
    }

    protected DTDGrammar createDTDGrammar() {
        return new DTDGrammar(this.fSymbolTable);
    }

    protected void setGrammar(DTDGrammar dTDGrammar) {
        this.fDTDGrammar = dTDGrammar;
        if (dTDGrammar != null) {
            this.fEntityManager.setEntityDeclPool(this.fDTDGrammar.getEntityDeclPool());
            this.fGrammarStringBuffer = this.fDTDGrammar.getStringBuffer();
        } else {
            this.fEntityManager.setDefaultEntityDeclPool();
            this.fGrammarStringBuffer = null;
        }
    }

    protected void startElementDecl(QName qName) {
        this.fDeclElementType = qName;
        this.fContentModel.clear();
        this.fContentModelOffset = -1;
        this.fContentModelPCDATA = false;
    }

    protected void contentModelANY() {
        this.fSymbolTable.addSymbolSetValues("ANY", this.fContentModel);
    }

    protected void contentModelEMPTY() {
        this.fSymbolTable.addSymbolSetValues("EMPTY", this.fContentModel);
    }

    protected void contentModelStartGroup() {
        if (this.fContentModelOffset == -1) {
            this.fContentModelOffset = this.fGrammarStringBuffer.getOffset();
        }
        this.fGrammarStringBuffer.appendChar(40);
    }

    protected void contentModelPCDATA() {
        this.fGrammarStringBuffer.appendBytes(PCDATA_BYTES, 0, PCDATA_BYTES.length);
        this.fContentModelPCDATA = true;
    }

    protected void contentModelElement(QName qName) {
        this.fGrammarStringBuffer.appendQName(qName);
    }

    protected void contentModelSeparator(int n2) {
        if (n2 == 0) {
            this.fGrammarStringBuffer.appendChar(124);
        } else {
            this.fGrammarStringBuffer.appendChar(44);
        }
    }

    protected void contentModelOccurrence(int n2) {
        if (n2 == 0) {
            this.fGrammarStringBuffer.appendChar(63);
        } else if (n2 == 1) {
            this.fGrammarStringBuffer.appendChar(42);
        } else {
            this.fGrammarStringBuffer.appendChar(43);
        }
    }

    protected void contentModelEndGroup() {
        this.fGrammarStringBuffer.appendChar(41);
    }

    protected void endElementDecl() {
        if (this.fContentModelOffset != -1) {
            if (!this.fContentModelPCDATA) {
                this.fDTDGrammar.setElementContentElement(this.fDeclElementType.rawName);
            }
            this.fGrammarStringBuffer.setStringValues(this.fContentModelOffset, this.fGrammarStringBuffer.getOffset(), this.fContentModel);
        }
    }

    private void startAttlistDecl(QName qName) {
        this.fDeclElementType = qName;
    }

    protected void startAttDef(QName qName, XMLString xMLString) {
        this.fDeclAttrName = qName;
        this.fDeclAttType = xMLString;
        this.fScannedDefaultAttValue = false;
        this.fDTDGrammar.startAttDef(qName, xMLString);
    }

    protected void startEnumerationType() {
    }

    protected void enumerationType(XMLString xMLString) {
        this.fDTDGrammar.enumerationType(this.fSymbolTable.addSymbol(xMLString), this.fScanner);
    }

    protected void endEnumerationType() {
    }

    protected void startDefaultAttValue() {
        this.fScannedDefaultAttValue = true;
        this.fDefaultAttValueOffset = -1;
    }

    private void setAttValueErrorParameters() {
        this.fScanner.setParameter(0, this.fDeclElementType);
        this.fScanner.setParameter(1, this.fDeclAttrName);
    }

    private void defaultAttValueCharacters(boolean bl) {
        if (this.fDefaultAttValueOffset == -1) {
            this.fDefaultAttValueOffset = this.fGrammarStringBuffer.getOffset();
        }
        if (bl) {
            this.fGrammarStringBuffer.appendXMLString(this.fDefaultAttValue);
        } else {
            this.fGrammarStringBuffer.normalizedAppend(this.fDefaultAttValue);
        }
    }

    public void defaultAttValueCharacter(int n2, boolean bl) {
        if (this.fDefaultAttValueOffset == -1) {
            this.fDefaultAttValueOffset = this.fGrammarStringBuffer.getOffset();
        }
        this.fGrammarStringBuffer.appendChar(n2);
    }

    protected void endAttDef(XMLString xMLString) {
        QName qName = this.fDeclElementType;
        QName qName2 = this.fDeclAttrName;
        XMLString xMLString2 = this.fDeclAttType;
        if (this.fDTDGrammar.lookupAttDef(qName, qName2) == null) {
            this.fDTDGrammar.saveAttDef(qName, qName2, xMLString2, xMLString, this.defaultAttValueString(xMLString2), this.fEntityManager.inExternalEntity(), this.fScanner, this.fCurrentEntity.isXML10);
        } else {
            this.duplicateAttDef(qName, qName2);
        }
    }

    private void endAttlistDecl() {
    }

    protected void duplicateAttDef(QName qName, QName qName2) {
    }

    private XMLString defaultAttValueString(XMLString xMLString) {
        if (!this.fScannedDefaultAttValue) {
            return null;
        }
        if (this.fDefaultAttValueOffset == -1) {
            NullDataBufferFactory.setEmptyStringValues(this.fDefaultAttValue);
        } else {
            this.fGrammarStringBuffer.setStringValues(this.fDefaultAttValueOffset, this.fGrammarStringBuffer.getOffset(), this.fDefaultAttValue);
        }
        return this.fDefaultAttValue;
    }

    private void startEntityValue() {
        this.fEntityValueOffset = -1;
    }

    private void entityValueCharacters() {
        if (this.fEntityValueOffset == -1) {
            this.fEntityValueOffset = this.fGrammarStringBuffer.getOffset();
        }
        this.fGrammarStringBuffer.appendXMLString(this.fInternalEntityValue);
    }

    private void entityValueCharacter(int n2) {
        if (this.fEntityValueOffset == -1) {
            this.fEntityValueOffset = this.fGrammarStringBuffer.getOffset();
        }
        this.fGrammarStringBuffer.appendChar(n2);
    }

    private void entityReferenceInEntityValue(XMLString xMLString) {
        if (this.fEntityValueOffset == -1) {
            this.fEntityValueOffset = this.fGrammarStringBuffer.getOffset();
        }
        this.fGrammarStringBuffer.appendChar(38);
        this.fGrammarStringBuffer.appendXMLString(xMLString);
        this.fGrammarStringBuffer.appendChar(59);
    }

    protected void internalEntityDecl(XMLString xMLString) {
        XMLString xMLString2 = this.internalEntityValue();
        this.fEntityManager.addInternalEntityDecl(xMLString, xMLString2);
    }

    protected void externalEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        this.fEntityManager.addExternalEntityDecl(xMLString, xMLString2, xMLString3);
    }

    protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
        this.fEntityManager.addUnparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
    }

    protected void internalPEDecl(XMLString xMLString) {
        XMLString xMLString2 = this.internalEntityValue();
        this.fEntityManager.addInternalPEDecl(xMLString, xMLString2);
    }

    protected void externalPEDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        this.fEntityManager.addExternalPEDecl(xMLString, xMLString2, xMLString3);
    }

    private XMLString internalEntityValue() {
        if (this.fEntityValueOffset == -1) {
            NullDataBufferFactory.setEmptyStringValues(this.fInternalEntityValue);
        } else {
            int n2 = this.fGrammarStringBuffer.getOffset();
            this.fGrammarStringBuffer.appendChar(0);
            this.fGrammarStringBuffer.setStringValues(this.fEntityValueOffset, n2, this.fInternalEntityValue);
        }
        return this.fInternalEntityValue;
    }

    protected void notationDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        if (xMLString3 != null) {
            this.fEntityManager.expandSystemID(xMLString3);
        }
    }

    public void setScanInternalGeneralEntities(boolean bl) {
        this.fEntityManager.setScanInternalGeneralEntities(bl);
    }

    public boolean getScanInternalGeneralEntities() {
        return this.fEntityManager.getScanInternalGeneralEntities();
    }

    public void setScanExternalGeneralEntities(boolean bl) {
        this.fEntityManager.setScanExternalGeneralEntities(bl);
    }

    public boolean getScanExternalGeneralEntities() {
        return this.fEntityManager.getScanExternalGeneralEntities();
    }

    public void setScanExternalParameterEntities(boolean bl) {
        this.fEntityManager.setScanExternalParameterEntities(bl);
    }

    public boolean getScanExternalParameterEntities() {
        return this.fEntityManager.getScanExternalParameterEntities();
    }

    public void setSupportDTD(boolean bl) {
        this.fEntityManager.setSupportDTD(bl);
    }

    public void setResolveDTDURIs(String string2, boolean bl) {
        this.fEntityManager.setResolveDTDURIs(bl);
    }

    public boolean getResolveDTDURIs(String string2) {
        return this.fEntityManager.getResolveDTDURIs();
    }

    public void setStandalone() {
        this.fEntityManager.setStandalone();
    }

    public boolean isStandalone() {
        return this.fEntityManager.isStandalone();
    }

    public DTDGrammar getDTDGrammar() {
        return this.fDTDGrammar;
    }

    public boolean hadExternalEntity() {
        return this.fEntityManager.hadExternalEntity();
    }

    public boolean inExternalEntity() {
        return this.fEntityManager.inExternalEntity();
    }

    public String currentBaseURI() {
        return this.fEntityManager.currentBaseURI();
    }

    public void setDocumentEntity(ParsedEntity parsedEntity) {
        this.fEntityManager.setDocumentEntity(parsedEntity);
        this.fCurrentEntity = parsedEntity;
    }

    public boolean entityReferenceInContent(XMLString xMLString) {
        return this.fEntityManager.entityReferenceInContent(xMLString);
    }

    public boolean entityReferenceInAttValue(XMLString xMLString) {
        return this.fEntityManager.entityReferenceInAttValue(xMLString);
    }

    protected boolean startPEReferenceWithinMarkup(XMLString xMLString) {
        return this.fEntityManager.startPEReferenceWithinMarkup(xMLString);
    }

    protected boolean endPEReferenceWithinMarkup() {
        if (this.fEntityManager.inPEReferenceWithinMarkup()) {
            if (this.endOfEntity(1)) {
                return true;
            }
            return this.reportFatalError(18);
        }
        return this.reportFatalError(18);
    }
}

