/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DTDSupport;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentState;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.AttrList;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ErrorReporter;
import com.ibm.xml.xlxp.internal.s1.scan.util.NSDeclList;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.PositionHelper;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.Symbol;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLTracer;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DocumentScanner
extends DocumentState
implements ErrorReporter,
AttrList,
NSDeclList {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String cn = DocumentScanner.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(DocumentScanner.class);
    protected static final int DEFAULT_ATTRIBUTE_SIZE = 8;
    protected static final int DEFAULT_ERROR_PARAM_SIZE = 8;
    public static final int RESULT_NONAME = 0;
    public static final int RESULT_COLON = 1;
    public static final int RESULT_ENDOFNAME = 3;
    public static final int RESULT_FORWARDSLASH = 4;
    public static final int RESULT_GREATERTHAN = 5;
    public static final int RESULT_WHITESPACE = 6;
    public static final int RESULT_EQUALSIGN = 7;
    public static final int RESULT_SEMICOLON = 8;
    public final QName elementQName;
    public XMLString elementValue;
    public int elementDepth;
    public int attrCount;
    public boolean inElementContent;
    public final XMLString content;
    public int singleCh;
    public final XMLString piTarget;
    public final XMLString entityName;
    public final XMLString version;
    public final XMLString encName;
    public final XMLString standalone;
    public final XMLString rootElementType;
    public final XMLString publicID;
    public final XMLString systemID;
    public boolean internalSubset;
    public String errorURI;
    public int errorCode;
    public int errorParamsCount;
    public XMLString[] errorParamStrings;
    public long errorOffset;
    protected static final int STATE_CONTENT = 0;
    protected static final int STATE_START_ELEMENT = 1;
    protected static final int STATE_END_ELEMENT = 2;
    protected static final int STATE_MARKUP = 3;
    protected static final int STATE_END_NSSCOPE_CONTENT = 4;
    protected static final int STATE_END_NSSCOPE_START_ELEMENT = 5;
    protected static final int STATE_END_NSSCOPE_END_ELEMENT = 6;
    protected static final int STATE_END_NSSCOPE_MARKUP = 7;
    protected static final int STATE_END_NSSCOPE_MISC = 8;
    protected static final int STATE_START_DOCUMENT = 9;
    protected static final int STATE_PROLOG = 10;
    protected static final int STATE_INT_SUBSET = 11;
    protected static final int STATE_EXT_SUBSET = 12;
    protected static final int STATE_END_OF_ENTITY = 13;
    protected static final int STATE_TRAILING_MISC = 14;
    protected static final int STATE_END_DOCUMENT = 15;
    private static final int COLON = 4;
    private static final int BUFFEREND = 8;
    private static final int INVALID = 12;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    protected static final int USE_HASHTABLE_ATTR_COUNT = 16;
    protected static final int MAX_HASH_COLLISIONS = 640;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected static final int CLEANUP_XML_DECL = 1;
    protected static final int CLEANUP_TEXT_DECL = 2;
    protected static final int CLEANUP_START_ELEMENT = 4;
    protected static final int CLEANUP_LEAF_ELEMENT = 8;
    protected static final int CLEANUP_END_ELEMENT = 16;
    protected static final int CLEANUP_CHARACTERS = 32;
    protected static final int CLEANUP_PROCESSING_INSTRUCTION = 64;
    protected static final int CLEANUP_COMMENT = 128;
    protected static final int CLEANUP_DOCTYPE = 256;
    protected static final int CLEANUP_ENTITY_REFERENCE = 512;
    protected static final int CLEANUP_RECOVERABLE_ERROR = 1024;
    private static final byte[] XMLDECL_BYTES = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] VERSION_BYTES = new byte[]{118, 101, 114, 115, 105, 111, 110};
    private static final byte[] VERSION10_BYTES = new byte[]{49, 46, 48};
    private static final byte[] VERSION11_BYTES = new byte[]{49, 46, 49};
    private static final byte[] ENCODING_BYTES = new byte[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final byte[] STANDALONE_BYTES = new byte[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final byte[] YES_BYTES = new byte[]{121, 101, 115};
    private static final byte[] NO_BYTES = new byte[]{110, 111};
    private static final byte[] DOCTYPE_BYTES = new byte[]{68, 79, 67, 84, 89, 80, 69};
    private static final byte[] CDSTART_BYTES = new byte[]{91, 67, 68, 65, 84, 65, 91};
    private static final byte[] CDEND_BYTES = new byte[]{93, 93, 62};
    private static final byte[] PI_END_BYTES = new byte[]{63, 62};
    private static final byte[] XML11_BYTES = new byte[]{49, 46, 49};
    private static final byte[] contentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] elementContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedElementContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] cdSectMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final byte[] piMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final byte[] commentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    protected static final byte[] attValueMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] encNameCharMap = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] markupMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final byte[] digitMap = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] nameStartCharMap = new byte[]{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final byte[] nameCharMap = new byte[]{8, 12, 12, 12, 12, 12, 12, 12, 12, 24, 24, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 2, 2, 16, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 32, 12, 28, 20, 12, 12, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 12, 12, 12, 12, 3, 12, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final byte[] scanQNameMap = new byte[]{2, 3, 3, 3, 3, 3, 3, 3, 3, 6, 6, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 7, 5, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private final int id = DocumentScanner.assignNextId();
    private final String idLabel = "id=" + this.id;
    private static int fgIdCounter = 0;
    protected final DataBufferFactory fBufferFactory;
    protected XMLStringBuffer fStringBuffer;
    protected XMLStringBuffer fAttValueStringBuffer;
    protected boolean fCopyAttValuesToBuffer;
    protected final boolean fIncremental;
    protected SymbolTable fSymbolTable;
    protected Symbol fLastQNameSymbol;
    protected ParsedEntity fCurrentEntity;
    private ParsedEntity fDocumentEntity;
    protected boolean fLineBreaksNormalized;
    protected int fCurrentState;
    protected int fCurrentEvent;
    protected boolean fNeedPushElement;
    protected Referrer fCurrentEventPositionReferrer;
    protected DataBuffer fCurrentEventFirstBuffer;
    protected int fCurrentEventStartOffset;
    protected DTDSupport fDTDSupport;
    protected boolean fSeenDoctype;
    protected XMLString fAttValueChars;
    protected int fSkippedElementDepth;
    protected final boolean fComponentsInternal;
    protected boolean fIsXML10;
    protected boolean fIsNamespaceAware;
    protected boolean fHasElementContentElements;
    protected boolean fHasDefaultAttributes;
    protected boolean fSeenAttrWithPrefix;
    protected boolean fSeenNSDecl;
    protected boolean fSeenDefaultNamespaceMapping;
    protected boolean fScanForLeafElement;
    protected String fNamespaceDeclPrefix;
    protected int fAttValueOffset;
    protected int fCurrentEntityID;
    protected QName fTempQName;
    protected QName[] fAttributeNames;
    protected String[] fAttributeTypes;
    protected XMLString[] fAttributeValues;
    protected boolean[] fAttributeValueNormalized;
    protected boolean[] fAttributeSpecified;
    protected Object fExtensionState;
    protected int fCleanupFlags;
    private final XMLString fErrorString;
    private ElementInfoStack fElementInfoStack;
    private int[] fAttrHashtable;
    private int[] fNextAttrInBucket;
    private int[] fHashMultipliers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int assignNextId() {
        Class<DocumentScanner> clazz = DocumentScanner.class;
        synchronized (DocumentScanner.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++fgIdCounter;
        }
    }

    private static String threadLabel() {
        return "***XLXP[" + Thread.currentThread().getId() + "]*** ";
    }

    private String scannerLabel() {
        return DocumentScanner.threadLabel() + this.idLabel;
    }

    public DocumentScanner() {
        this(null, null, false);
    }

    public DocumentScanner(boolean bl) {
        this(null, null, bl);
    }

    public DocumentScanner(DataBufferFactory dataBufferFactory, SymbolTable symbolTable) {
        this(dataBufferFactory, symbolTable, false);
    }

    public DocumentScanner(DataBufferFactory dataBufferFactory, SymbolTable symbolTable, boolean bl) {
        int n2;
        if (LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINE, cn, "DocumentScanner", this.scannerLabel() + ", " + "created");
        }
        boolean bl2 = this.fComponentsInternal = symbolTable == null;
        if (this.fComponentsInternal) {
            this.fBufferFactory = new SimpleDataBufferFactory();
            this.fSymbolTable = new SymbolTable();
        } else {
            this.fBufferFactory = dataBufferFactory;
            this.fSymbolTable = symbolTable;
        }
        this.fStringBuffer = null;
        this.fIncremental = bl;
        this.fCurrentEventPositionReferrer = new Referrer();
        this.fIsXML10 = true;
        this.fIsNamespaceAware = true;
        this.fErrorString = new XMLString();
        this.fTempQName = new QName();
        this.fAttValueChars = new XMLString();
        this.fElementInfoStack = new ElementInfoStack();
        this.elementQName = new QName();
        this.fAttributeNames = ArrayAllocator.newObjectArray(QName.class, 8);
        for (n2 = 0; n2 < 8; ++n2) {
            this.fAttributeNames[n2] = new QName();
        }
        this.fAttributeTypes = ArrayAllocator.newStringArray(8);
        this.fAttributeValues = ArrayAllocator.newObjectArray(XMLString.class, 8);
        for (n2 = 0; n2 < 8; ++n2) {
            this.fAttributeValues[n2] = new XMLString();
        }
        this.fAttributeValueNormalized = ArrayAllocator.newBooleanArray(8);
        this.fAttributeSpecified = ArrayAllocator.newBooleanArray(8);
        this.entityName = new XMLString();
        this.piTarget = new XMLString();
        this.content = new XMLString();
        this.version = new XMLString();
        this.encName = new XMLString();
        this.standalone = new XMLString();
        this.rootElementType = new XMLString();
        this.publicID = new XMLString();
        this.systemID = new XMLString();
        this.errorParamStrings = ArrayAllocator.newObjectArray(XMLString.class, 8);
        for (n2 = 0; n2 < 8; ++n2) {
            this.errorParamStrings[n2] = new XMLString();
        }
    }

    public DataBufferFactory getBufferFactory() {
        return this.fBufferFactory;
    }

    public void getCurrentExternalEntity(PositionHelper positionHelper) {
        positionHelper.setCurrentExternalEntity(this.fCurrentEntity);
    }

    public void reset(boolean bl) {
        int n2;
        if (LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINE, cn, "reset", this.scannerLabel());
        }
        this.fIsXML10 = true;
        this.inElementContent = false;
        this.fSeenDefaultNamespaceMapping = false;
        this.fSeenDoctype = false;
        this.fNeedPushElement = false;
        if (this.fErrorString.firstBuffer != null) {
            this.fErrorString.clear();
        }
        if (this.fAttValueChars.firstBuffer != null) {
            this.fAttValueChars.clear();
        }
        if (this.fTempQName.firstBuffer != null) {
            this.fTempQName.clear();
        }
        if (this.fDocumentEntity != null) {
            this.fDocumentEntity.release();
        }
        this.fDocumentEntity = null;
        this.fCurrentEntity = null;
        this.elementDepth = 0;
        this.fElementInfoStack.moveToRoot();
        if (this.elementQName.firstBuffer != null) {
            this.elementQName.clear();
        }
        if (this.content.firstBuffer != null) {
            this.content.clear();
        }
        if (this.entityName.firstBuffer != null) {
            this.entityName.clear();
        }
        if (this.piTarget.firstBuffer != null) {
            this.piTarget.clear();
        }
        if (this.version.firstBuffer != null) {
            this.version.clear();
        }
        if (this.encName.firstBuffer != null) {
            this.encName.clear();
        }
        if (this.standalone.firstBuffer != null) {
            this.standalone.clear();
        }
        if (this.rootElementType.firstBuffer != null) {
            this.rootElementType.clear();
        }
        if (this.publicID.firstBuffer != null) {
            this.publicID.clear();
        }
        if (this.systemID.firstBuffer != null) {
            this.systemID.clear();
        }
        for (n2 = 0; n2 < this.fAttributeNames.length && this.fAttributeNames[n2].firstBuffer != null; ++n2) {
            this.fAttributeNames[n2].clear();
        }
        for (n2 = 0; n2 < this.fAttributeValues.length && this.fAttributeValues[n2].firstBuffer != null; ++n2) {
            this.fAttributeValues[n2].clear();
        }
        for (n2 = 0; n2 < this.errorParamStrings.length && this.errorParamStrings[n2].firstBuffer != null; ++n2) {
            this.errorParamStrings[n2].clear();
        }
        this.errorParamsCount = 0;
        this.fCurrentEventPositionReferrer.active = false;
        this.fCurrentEventFirstBuffer = null;
        if (this.fStringBuffer != null) {
            this.fStringBuffer.reset(bl);
        }
        if (this.fComponentsInternal) {
            this.fSymbolTable.reset(bl);
            this.fBufferFactory.reset(bl);
        }
    }

    protected final void moveToStringBuffer(XMLString xMLString) {
        this.getStringBuffer().addXMLString(xMLString, xMLString);
    }

    public void dropBufferReferences() {
        if (this.fDocumentEntity != null && this.fCurrentState == 15) {
            this.fDocumentEntity.release();
            this.fDocumentEntity = null;
            this.fCurrentEventPositionReferrer.active = false;
        }
        if (this.fCleanupFlags != 0) {
            this.internalDropBufferReferences();
        }
    }

    private void internalDropBufferReferences() {
        int n2;
        if ((this.fCleanupFlags & 3) != 0) {
            if (this.version.firstBuffer != null) {
                this.version.clear();
            }
            if (this.encName.firstBuffer != null) {
                this.encName.clear();
            }
            if (this.standalone.firstBuffer != null) {
                this.standalone.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFFC;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0xE0) != 0) {
            if (this.content.firstBuffer != null) {
                this.content.clear();
            }
            this.fCleanupFlags &= 0xFFFFFF5F;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x40) != 0) {
            if (this.piTarget.firstBuffer != null) {
                this.piTarget.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFBF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x14) != 0) {
            if (this.elementQName.firstBuffer != null) {
                this.elementQName.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFEF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 4) != 0) {
            for (n2 = 0; n2 < this.fAttributeNames.length && this.fAttributeNames[n2].firstBuffer != null; ++n2) {
                this.fAttributeNames[n2].clear();
            }
            for (n2 = 0; n2 < this.fAttributeValues.length && this.fAttributeValues[n2].firstBuffer != null; ++n2) {
                this.fAttributeValues[n2].clear();
            }
            if (this.fAttValueChars.firstBuffer != null) {
                this.fAttValueChars.clear();
            }
            this.fCleanupFlags &= 0xFFFFFFFB;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x200) != 0) {
            if (this.entityName.firstBuffer != null) {
                this.entityName.clear();
            }
            this.fCleanupFlags &= 0xFFFFFDFF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x400) != 0) {
            for (n2 = 0; n2 < this.errorParamStrings.length && this.errorParamStrings[n2].firstBuffer != null; ++n2) {
                this.errorParamStrings[n2].clear();
            }
            this.fCleanupFlags &= 0xFFFFFBFF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if ((this.fCleanupFlags & 0x100) != 0) {
            this.fDTDSupport.dropBufferReferences();
            if (this.rootElementType.firstBuffer != null) {
                this.rootElementType.clear();
            }
            if (this.publicID.firstBuffer != null) {
                this.publicID.clear();
            }
            if (this.systemID.firstBuffer != null) {
                this.systemID.clear();
            }
            this.fCleanupFlags &= 0xFFFFFEFF;
            if (this.fCleanupFlags == 0) {
                return;
            }
        }
        if (this.fCleanupFlags == 0) {
            return;
        }
    }

    public final void setDTDSupport(DTDSupport dTDSupport) {
        this.fDTDSupport = dTDSupport;
    }

    public final void setNamespaceAwareness(boolean bl) {
        this.fIsNamespaceAware = bl;
    }

    public final void parseDocumentEntity(ParsedEntity parsedEntity) {
        this.setDocumentEntity(parsedEntity);
        this.nextEvent();
    }

    private void incrementalCleanup() {
        this.fCurrentEntity.loadCalled = false;
        if (this.fCleanupFlags != 0) {
            this.internalDropBufferReferences();
        }
        this.fBufferFactory.reclaimBuffers(false);
    }

    public final void setDocumentEntity(ParsedEntity parsedEntity) {
        assert (this.elementDepth == 0);
        if (LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINE, cn, "setDocumentEntity", this.scannerLabel() + ", entity id=" + parsedEntity.id);
        }
        this.fDocumentEntity = parsedEntity;
        this.fCurrentState = 9;
        if (this.fDTDSupport == null) {
            this.setDTDSupport(new DTDSupport(this));
        }
        this.fDTDSupport.setDocumentEntity(parsedEntity);
        this.setEntityContent(parsedEntity);
        this.fCurrentEventPositionReferrer.fCurrentEventFirstBuffer = this.fCurrentEventFirstBuffer = this.fCurrentEntity.buffer;
        this.fCurrentEventStartOffset = this.fCurrentEntity.offset;
        this.fCurrentEventPositionReferrer.active = true;
        if (this.fCurrentEventPositionReferrer.factory != this.fBufferFactory) {
            this.fBufferFactory.addReferrer(this.fCurrentEventPositionReferrer);
        }
    }

    public final void setEntityContent(ParsedEntity parsedEntity) {
        this.cacheEntityContentState(parsedEntity);
        this.fCurrentEntity = parsedEntity;
        this.fLineBreaksNormalized = parsedEntity.lineBreaksNormalized;
        this.fIsXML10 = parsedEntity.isXML10;
    }

    protected void cacheEntityContentState(ParsedEntity parsedEntity) {
        this.fCurrentEntityID = parsedEntity.id;
    }

    protected final boolean reportFatalError(int n2) {
        return this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n2);
    }

    protected final void setContentOrMarkupState() {
        switch (this.fCurrentEntity.checkForMarkup()) {
            case 0: {
                this.fCurrentState = 0;
                break;
            }
            case 1: {
                this.fCurrentState = 1;
                break;
            }
            case 2: {
                this.fCurrentState = 2;
                break;
            }
            default: {
                this.fCurrentState = 3;
            }
        }
    }

    private void setEndNamespacesScopeState() {
        if (this.elementDepth > 0) {
            switch (this.fCurrentEntity.checkForMarkup()) {
                case 0: {
                    this.fCurrentState = 4;
                    break;
                }
                case 1: {
                    this.fCurrentState = 5;
                    break;
                }
                case 2: {
                    this.fCurrentState = 6;
                    break;
                }
                default: {
                    this.fCurrentState = 7;
                    break;
                }
            }
        } else {
            this.fCurrentState = 8;
        }
    }

    protected final void setStartCurrentEvent() {
        this.fCurrentEventPositionReferrer.fCurrentEventFirstBuffer = this.fCurrentEventFirstBuffer = this.fCurrentEntity.buffer;
        this.fCurrentEventStartOffset = this.fCurrentEntity.offset;
    }

    public final int nextEvent() {
        block17: while (true) {
            if (this.fNeedPushElement) {
                this.fNeedPushElement = false;
                this.pushElement();
            }
            if (this.fCurrentEntity.loadCalled) {
                this.incrementalCleanup();
            }
            switch (this.fCurrentState) {
                case 5: {
                    this.fElementInfoStack.resetNamespacesScope();
                    this.fCurrentState = 1;
                    if (this.scanStartElement()) continue block17;
                    return this.fCurrentEvent;
                }
                case 0: {
                    if (!(!this.inElementContent ? !this.scanContent() : !this.scanElementContent())) continue block17;
                    return this.fCurrentEvent;
                }
                case 6: {
                    this.fElementInfoStack.resetNamespacesScope();
                    this.fCurrentState = 2;
                    if (this.scanEndElement()) continue block17;
                    return this.fCurrentEvent;
                }
                case 1: {
                    if (this.scanStartElement()) continue block17;
                    return this.fCurrentEvent;
                }
                case 2: {
                    if (this.scanEndElement()) continue block17;
                    return this.fCurrentEvent;
                }
                case 8: {
                    this.fElementInfoStack.resetNamespacesScope();
                    this.fCurrentState = 14;
                    if (this.scanTrailingMisc()) continue block17;
                    return this.fCurrentEvent;
                }
                case 9: {
                    if (this.scanXMLDecl()) continue block17;
                    return this.fCurrentEvent;
                }
                case 10: {
                    if (this.scanProlog()) continue block17;
                    return this.fCurrentEvent;
                }
                case 4: {
                    this.fElementInfoStack.resetNamespacesScope();
                    this.fCurrentState = 0;
                    if (!(!this.inElementContent ? !this.scanContent() : !this.scanElementContent())) continue block17;
                    return this.fCurrentEvent;
                }
                case 3: {
                    if (this.scanMarkup()) continue block17;
                    return this.fCurrentEvent;
                }
                case 7: {
                    this.fElementInfoStack.resetNamespacesScope();
                    this.fCurrentState = 3;
                    if (this.scanMarkup()) continue block17;
                    return this.fCurrentEvent;
                }
                case 14: {
                    if (this.scanTrailingMisc()) continue block17;
                    return this.fCurrentEvent;
                }
                case 15: {
                    this.reportFatalError(12);
                    return this.fCurrentEvent;
                }
                case 11: {
                    if (this.fDTDSupport.scanInternalDTDSubset()) continue block17;
                    return this.fCurrentEvent;
                }
                case 12: {
                    if (this.fDTDSupport.scanExternalDTDSubset()) continue block17;
                    return this.fCurrentEvent;
                }
            }
            if (!this.endOfEntityInContent()) break;
        }
        return this.fCurrentEvent;
    }

    protected final void setInvalidCharParameter(int n2) {
        int n3 = this.fCurrentEntity.decodeCharacter();
        this.setInvalidCharParameter(n2, n3);
    }

    public final boolean endDocument() {
        this.fDTDSupport.endOfEntity(0);
        this.fCurrentState = 15;
        return this.produceEndDocumentEvent();
    }

    public final boolean hasElementContentElements() {
        return this.fDTDSupport.hasElementContentElements();
    }

    public final boolean hasElementContent(String string2) {
        return this.fDTDSupport.hasElementContent(string2);
    }

    public final boolean hasDefaultAttributes() {
        return this.fDTDSupport.hasDefaultAttributes();
    }

    public final boolean addDefaultAttributes(boolean bl) {
        return this.fDTDSupport.addDefaultAttributes(bl);
    }

    protected final void nextStateProlog() {
        this.fCurrentState = 10;
    }

    protected final void nextStateIntSubset() {
        this.fCurrentState = 11;
    }

    protected final void nextStateExtSubset() {
        this.fCurrentState = 12;
    }

    private boolean scanXMLDecl() {
        this.setStartCurrentEvent();
        this.fCurrentState = 10;
        this.fCurrentEntity.setMark();
        if (this.fCurrentEntity.skippedBytes(XMLDECL_BYTES) && this.fCurrentEntity.skippedSpaces()) {
            this.fCurrentEntity.clearMark();
            return this.scanXMLDeclOrTextDecl(true);
        }
        this.fCurrentEntity.resetToMark();
        return this.produceStartDocumentEvent();
    }

    public final boolean scanTextDecl() {
        this.fCurrentEntity.setMark();
        if (!this.fCurrentEntity.skippedBytes(XMLDECL_BYTES) || !this.fCurrentEntity.skippedSpaces()) {
            this.fCurrentEntity.resetToMark();
            return true;
        }
        this.fCurrentEntity.clearMark();
        return this.scanXMLDeclOrTextDecl(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanXMLDeclOrTextDecl(boolean bl) {
        int n2;
        int n3 = 0;
        do {
            String string2;
            if (bl) {
                if (n3 == 0) {
                    if (!this.fCurrentEntity.skippedBytes(VERSION_BYTES)) return this.reportFatalError(10);
                    n3 = 1;
                    string2 = "version";
                } else if (n3 != 1 || !this.fCurrentEntity.skippedBytes(ENCODING_BYTES)) {
                    if (!this.fCurrentEntity.skippedBytes(STANDALONE_BYTES)) break;
                    if (n3 == 1) {
                        this.encName.clear();
                    }
                    n3 = 3;
                    string2 = "standalone";
                } else {
                    n3 = 2;
                    string2 = "encoding";
                }
            } else if (n3 == 0 && this.fCurrentEntity.skippedBytes(VERSION_BYTES)) {
                n3 = 1;
                string2 = "version";
            } else {
                if (!this.fCurrentEntity.skippedBytes(ENCODING_BYTES)) return this.reportFatalError(45);
                if (n3 == 0) {
                    this.version.clear();
                }
                n3 = 2;
                string2 = "encoding";
            }
            this.fCurrentEntity.skipSpaces();
            if (!this.fCurrentEntity.skippedByte(61)) {
                int n4 = bl ? 7 : 41;
                this.setParameter(0, string2);
                return this.reportFatalError(n4);
            }
            this.fCurrentEntity.skipSpaces();
            n2 = this.fCurrentEntity.skippedQuote();
            if (n2 == 0) {
                int n5 = bl ? 8 : 42;
                this.setParameter(0, string2);
                return this.reportFatalError(n5);
            }
            switch (n3) {
                case 1: {
                    this.fCurrentEntity.startString(this.version);
                    boolean bl2 = this.fCurrentEntity.skippedBytes(VERSION10_BYTES) ? true : !this.fIsXML10 && this.fCurrentEntity.skippedBytes(VERSION11_BYTES);
                    if (!bl2 || !this.fCurrentEntity.lookingAt(n2)) {
                        if (!this.fCurrentEntity.skipToChar(n2)) {
                            int n6 = bl ? 8 : 42;
                            this.setParameter(0, string2);
                            return this.reportFatalError(n6);
                        }
                        this.fCurrentEntity.endString(this.version);
                        this.setParameter(0, this.version);
                        return this.reportFatalError(34);
                    }
                    this.fCurrentEntity.endString(this.version);
                    this.fCurrentEntity.nextByte();
                    if (this.fCurrentEntity.skippedSpaces()) break;
                    if (!bl) return this.reportFatalError(43);
                    this.encName.clear();
                    this.standalone.clear();
                    n3 = 4;
                    break;
                }
                case 2: {
                    this.fCurrentEntity.startString(this.encName);
                    if (!this.fCurrentEntity.skipToChar(n2)) {
                        int n7 = bl ? 8 : 42;
                        this.setParameter(0, string2);
                        return this.reportFatalError(n7);
                    }
                    this.fCurrentEntity.endString(this.encName);
                    if (!DocumentScanner.validEncName(this.encName)) {
                        this.setParameter(0, this.encName);
                        return this.reportFatalError(46);
                    }
                    this.fCurrentEntity.nextByte();
                    if (!this.fCurrentEntity.skippedSpaces()) {
                        if (bl) {
                            this.standalone.clear();
                        }
                        n3 = 4;
                        break;
                    }
                    if (bl) break;
                    n3 = 4;
                    break;
                }
                case 3: {
                    this.fCurrentEntity.startString(this.standalone);
                    if (!this.fCurrentEntity.skippedBytes(YES_BYTES) && !this.fCurrentEntity.skippedBytes(NO_BYTES) || !this.fCurrentEntity.lookingAt(n2)) {
                        if (!this.fCurrentEntity.skipToChar(n2)) {
                            this.setParameter(0, string2);
                            return this.reportFatalError(8);
                        }
                        this.fCurrentEntity.endString(this.standalone);
                        this.setParameter(0, this.standalone);
                        return this.reportFatalError(13);
                    }
                    this.fCurrentEntity.endString(this.standalone);
                    this.fCurrentEntity.nextByte();
                    this.fCurrentEntity.skipSpaces();
                    n3 = 4;
                }
            }
        } while (n3 != 4);
        if (!this.fCurrentEntity.skippedByte(63) || !this.fCurrentEntity.skippedByte(62)) {
            n2 = bl ? 9 : 44;
            return this.reportFatalError(n2);
        }
        if (bl) {
            if (this.standalone.length != 3) return this.produceStartDocumentEvent();
            this.fDTDSupport.setStandalone();
            return this.produceStartDocumentEvent();
        }
        this.fCleanupFlags |= 2;
        return true;
    }

    private static boolean validEncName(XMLString xMLString) {
        byte[] byArray = xMLString.bytes;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        if (byArray != null) {
            byte by2;
            if (n2 < n3 && encNameCharMap[(by2 = byArray[n2++]) & 0xFF] == 1) {
                while (n2 < n3) {
                    if (encNameCharMap[(by2 = byArray[n2++]) & 0xFF] != 0) continue;
                    return false;
                }
                return true;
            }
        } else {
            byte by3;
            DataBuffer dataBuffer = xMLString.firstBuffer;
            byArray = dataBuffer.bytes;
            if (encNameCharMap[(by3 = byArray[n2++]) & 0xFF] == 1) {
                int n4 = dataBuffer.endOffset;
                while (true) {
                    if (n2 < n4) {
                        if (encNameCharMap[(by3 = byArray[n2++]) & 0xFF] != 0) continue;
                        return false;
                    }
                    if (dataBuffer == null) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n2 = dataBuffer.startOffset;
                    if (dataBuffer == xMLString.lastBuffer) {
                        n4 = n3;
                        dataBuffer = null;
                        continue;
                    }
                    n4 = dataBuffer.endOffset;
                }
            }
        }
        return false;
    }

    private boolean scanProlog() {
        int n2;
        block8: {
            block9: {
                while (true) {
                    n2 = this.fCurrentEntity.skipSpaces();
                    this.setStartCurrentEvent();
                    if (n2 != 60) break block8;
                    n2 = this.fCurrentEntity.peekByte();
                    if (n2 != 33) {
                        if (n2 != 63) {
                            this.endOfProlog();
                            this.fCurrentState = 1;
                            return this.scanRootElement();
                        }
                        this.fCurrentEntity.skipTwoBytes();
                        if (this.scanPI()) continue;
                        return false;
                    }
                    this.fCurrentEntity.skipTwoBytes();
                    if (this.fCurrentEntity.skippedByte(45)) {
                        if (this.fCurrentEntity.skippedByte(45)) {
                            if (this.scanComment()) continue;
                            return false;
                        }
                        return this.reportFatalError(27);
                    }
                    if (this.fSeenDoctype || !this.fCurrentEntity.skippedBytes(DOCTYPE_BYTES)) break block9;
                    this.fSeenDoctype = true;
                    if (!this.fDTDSupport.scanDoctypeDecl()) {
                        return false;
                    }
                    if (this.fCurrentState != 10) break;
                }
                return true;
            }
            return this.reportFatalError(11);
        }
        if (n2 == 38) {
            return this.reportFatalError(11);
        }
        if (this.fCurrentEntity.atEndOfEntity()) {
            return this.reportFatalError(0);
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(4);
    }

    protected boolean scanDoctypeDeclDefault() {
        if (!this.fCurrentEntity.skippedSpaces()) {
            return this.reportFatalError(11);
        }
        int n2 = this.scanName(this.fTempQName);
        if (n2 == 0) {
            return this.reportFatalError(11);
        }
        do {
            if (this.fCurrentEntity.skippedByte(91)) {
                do {
                    if (!this.fCurrentEntity.skippedByte(93)) continue;
                    this.fCurrentEntity.skipSpaces();
                    if (!this.fCurrentEntity.skippedByte(62)) continue;
                    return true;
                } while (this.fCurrentEntity.skippedValidCharacter());
                if (this.fCurrentEntity.atEndOfEntity()) {
                    return this.reportFatalError(11);
                }
                this.setInvalidCharParameter(0);
                return this.reportFatalError(4);
            }
            if (!this.fCurrentEntity.skippedByte(62)) continue;
            return true;
        } while (this.fCurrentEntity.skippedValidCharacter());
        if (this.fCurrentEntity.atEndOfEntity()) {
            return this.reportFatalError(11);
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(4);
    }

    public boolean scanContent() {
        this.setStartCurrentEvent();
        assert (this.fCurrentState == 0);
        switch (this.fCurrentEntity.scanSimpleContent(this.content)) {
            case 0: {
                if (this.produceCharactersEvent()) {
                    this.fCurrentState = 1;
                    return this.scanStartElement();
                }
                this.fCurrentState = 1;
                return false;
            }
            case 1: {
                if (this.produceCharactersEvent()) {
                    this.fCurrentState = 2;
                    return this.scanEndElement();
                }
                this.fCurrentState = 2;
                return false;
            }
            case 2: {
                if (this.produceCharactersEvent()) {
                    this.fCurrentState = 3;
                    return this.scanMarkup();
                }
                this.fCurrentState = 3;
                return false;
            }
            case 3: {
                this.fCurrentState = 1;
                return this.scanStartElement();
            }
            case 4: {
                this.fCurrentState = 2;
                return this.scanEndElement();
            }
            case 5: {
                this.fCurrentState = 3;
                return this.scanMarkup();
            }
        }
        return this.scanContent2();
    }

    private boolean scanContent2() {
        byte[] byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
        this.fCurrentEntity.startString(this.content);
        block10: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(byArray, 1, this.content)) {
                case 2: {
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        if (!this.produceCharactersEvent()) {
                            this.fCurrentState = 3;
                            return false;
                        }
                    } else {
                        this.content.clear();
                    }
                    this.fCurrentState = 3;
                    return this.scanMarkup();
                }
                case 3: {
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        if (!this.produceCharactersEvent()) {
                            assert (this.fCurrentState == 0);
                            return false;
                        }
                    } else {
                        this.content.clear();
                    }
                    this.fCurrentEntity.nextByte();
                    assert (this.fCurrentState == 0);
                    return this.checkReferenceInContent();
                }
                case 4: {
                    if (this.fCurrentEntity.skippedBytes(CDEND_BYTES)) {
                        return this.reportFatalError(5);
                    }
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 6: {
                    continue block10;
                }
                case 7: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 8: {
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        this.fCurrentState = 13;
                        return this.produceCharactersEvent();
                    }
                    this.content.clear();
                    return this.endOfEntityInContent();
                }
                case 9: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    public boolean scanElementContent() {
        byte[] byArray;
        byte[] byArray2 = byArray = this.fLineBreaksNormalized ? normalizedElementContentMap : elementContentMap;
        assert (this.fCurrentState == 0);
        this.fCurrentEntity.startString(this.content);
        this.setStartCurrentEvent();
        while (this.fCurrentEntity.skipBytesUsingMap(byArray, 5) == 6) {
            this.fCurrentEntity.nextByte();
            this.content.flags = (short)(this.content.flags | 4);
            if (this.fIsXML10) {
                byArray = normalizedElementContentMap;
                continue;
            }
            if (!this.fCurrentEntity.skippedXML11EOLCharacter()) continue;
            this.content.flags = (short)(this.content.flags | 8);
        }
        this.fCurrentEntity.endString(this.content);
        if (this.content.length > 0) {
            this.content.flags = (short)(this.content.flags | 2);
            if (!this.produceWhitespaceEvent()) {
                this.setContentOrMarkupState();
                return false;
            }
        }
        if (this.fCurrentEntity.lookingAt(60)) {
            this.fCurrentState = 3;
            return this.scanMarkup();
        }
        this.fCurrentEntity.startString(this.content);
        this.setStartCurrentEvent();
        return this.scanElementContent2();
    }

    private boolean scanElementContent2() {
        block10: while (true) {
            switch (this.fCurrentEntity.skipBytesUsingMap(elementContentMap, 5)) {
                case 1: {
                    this.fCurrentEntity.skipBytesUsingMap(contentMap, 1);
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        this.content.flags = (short)(this.content.flags & 0xFFFFFFFD);
                        this.content.flags = (short)(this.content.flags | 1);
                        if (!this.produceCharactersEvent()) {
                            this.setContentOrMarkupState();
                            return false;
                        }
                    } else {
                        this.content.clear();
                    }
                    return this.scanContent();
                }
                case 2: {
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        this.content.flags = (short)(this.content.flags & 0xFFFFFFFE);
                        this.content.flags = (short)(this.content.flags | 2);
                        if (!this.produceWhitespaceEvent()) {
                            this.fCurrentState = 3;
                            return false;
                        }
                    } else {
                        this.content.clear();
                    }
                    this.fCurrentState = 3;
                    return this.scanMarkup();
                }
                case 3: {
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        this.content.flags = (short)(this.content.flags & 0xFFFFFFFE);
                        this.content.flags = (short)(this.content.flags | 2);
                        if (!this.produceWhitespaceEvent()) {
                            assert (this.fCurrentState == 0);
                            return false;
                        }
                    } else {
                        this.content.clear();
                    }
                    this.fCurrentEntity.nextByte();
                    assert (this.fCurrentState == 0);
                    return this.checkReferenceInContent();
                }
                case 4: {
                    if (this.fCurrentEntity.skippedBytes(CDEND_BYTES)) {
                        return this.reportFatalError(5);
                    }
                    this.fCurrentEntity.nextByte();
                    this.fCurrentEntity.skipBytesUsingMap(contentMap, 1);
                    this.fCurrentEntity.endString(this.content);
                    this.content.flags = (short)(this.content.flags & 0xFFFFFFFD);
                    this.content.flags = (short)(this.content.flags | 1);
                    if (!this.produceCharactersEvent()) {
                        return false;
                    }
                    return this.scanContent();
                }
                case 5: {
                    continue block10;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        this.content.flags = (short)(this.content.flags | 4);
                    }
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
                case 7: {
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && this.fCurrentEntity.skippedXML11EOLCharacter()) {
                        this.content.flags = (short)(this.content.flags | 8);
                        continue block10;
                    }
                    if (!this.fCurrentEntity.skippedValidCharacter()) {
                        this.setInvalidCharParameter(0);
                        return this.reportFatalError(2);
                    }
                    this.fCurrentEntity.skipBytesUsingMap(contentMap, 1);
                    this.fCurrentEntity.endString(this.content);
                    this.content.flags = (short)(this.content.flags & 0xFFFFFFFD);
                    this.content.flags = (short)(this.content.flags | 1);
                    if (this.fCurrentEntity.lookingAt(60)) {
                        this.fCurrentState = 3;
                        if (this.produceCharactersEvent()) {
                            return this.scanMarkup();
                        }
                        return false;
                    }
                    assert (this.fCurrentState == 0);
                    if (this.produceCharactersEvent()) {
                        return this.scanContent();
                    }
                    return false;
                }
                case 8: {
                    this.fCurrentEntity.endString(this.content);
                    if (this.content.length > 0) {
                        this.content.flags = (short)(this.content.flags & 0xFFFFFFFE);
                        this.content.flags = (short)(this.content.flags | 2);
                        this.fCurrentState = 13;
                        return this.produceWhitespaceEvent();
                    }
                    this.content.clear();
                    return this.endOfEntityInContent();
                }
            }
            break;
        }
        if (this.fIsXML10 && elementContentMap[this.fCurrentEntity.currentByte()] == 9 || !this.fIsXML10 && this.fCurrentEntity.isInternal && elementContentMap[this.fCurrentEntity.currentByte()] == 0) {
            this.fCurrentEntity.nextByte();
            this.fCurrentEntity.skipBytesUsingMap(contentMap, 1);
            this.fCurrentEntity.endString(this.content);
            this.content.flags = (short)(this.content.flags & 0xFFFFFFFD);
            this.content.flags = (short)(this.content.flags | 1);
            if (!this.produceCharactersEvent()) {
                return false;
            }
            return this.scanContent();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    private boolean endOfEntityInContent() {
        if (this.fCurrentEntity.atEndOfEntity()) {
            if (this.fCurrentEntity.isFragment) {
                this.fCurrentState = 15;
                return this.produceEndDocumentEvent();
            }
            if (this.fDTDSupport.endOfEntity(1)) {
                if (this.produceEndEntityEvent()) {
                    if (!this.fCurrentEntity.lookingAt(60)) {
                        this.fCurrentState = 0;
                        return this.scanContent();
                    }
                    this.fCurrentState = 3;
                    return this.scanMarkup();
                }
                this.setContentOrMarkupState();
                return false;
            }
            return this.reportFatalError(19);
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    private boolean scanMarkup() {
        assert (this.fCurrentState == 3);
        int n2 = this.fCurrentEntity.bytes[this.fCurrentEntity.offset + 1];
        if (n2 <= 0 && (n2 = this.fCurrentEntity.peekByte()) == 0 && this.fCurrentEntity.isFragment && this.fCurrentEntity.atEndOfEntity()) {
            this.fCurrentState = 15;
            return this.produceEndDocumentEvent();
        }
        switch (markupMap[n2]) {
            case 1: {
                this.fCurrentState = 1;
                return this.scanStartElement();
            }
            case 2: {
                this.fCurrentState = 2;
                return this.scanEndElement();
            }
            case 3: {
                this.setStartCurrentEvent();
                this.fCurrentEntity.skipTwoBytes();
                boolean bl = this.scanPI();
                this.setContentOrMarkupState();
                return bl;
            }
            case 4: {
                this.setStartCurrentEvent();
                this.fCurrentEntity.skipTwoBytes();
                if (this.fCurrentEntity.skippedByte(45)) {
                    if (this.fCurrentEntity.skippedByte(45)) {
                        boolean bl = this.scanComment();
                        this.setContentOrMarkupState();
                        return bl;
                    }
                    return this.reportFatalError(27);
                }
                if (this.fCurrentEntity.skippedBytes(CDSTART_BYTES)) {
                    boolean bl = this.scanCDSect();
                    this.setContentOrMarkupState();
                    return bl;
                }
                return this.reportFatalError(19);
            }
        }
        return this.reportFatalError(19);
    }

    protected boolean produceRootElementEvent(boolean bl) {
        if (bl) {
            return this.produceLeafElementEvent();
        }
        return this.produceStartElementEvent();
    }

    private boolean scanRootElement() {
        switch (this.scanStartElementCommon()) {
            case 0: {
                if (this.finishElement()) {
                    if (this.fScanForLeafElement && this.scanLeafElement()) {
                        return this.produceRootElementEvent(true);
                    }
                    return this.produceRootElementEvent(false);
                }
                return false;
            }
            case 1: {
                if (this.finishElement()) {
                    return this.produceRootElementEvent(true);
                }
                return false;
            }
        }
        return false;
    }

    public final boolean scanStartElement() {
        assert (this.fCurrentState == 1);
        switch (this.scanStartElementCommon()) {
            case 0: {
                if (this.finishElement()) {
                    if (this.fScanForLeafElement && this.scanLeafElement()) {
                        return this.produceLeafElementEvent();
                    }
                    return this.produceStartElementEvent();
                }
                return false;
            }
            case 1: {
                if (this.finishElement()) {
                    return this.produceLeafElementEvent();
                }
                return false;
            }
        }
        return false;
    }

    private int scanStartElementCommon() {
        boolean bl;
        this.setStartCurrentEvent();
        this.fCurrentEntity.nextByte();
        block0 : switch (this.scanElementType()) {
            case 4: {
                this.fCurrentEntity.nextByte();
                bl = true;
                break;
            }
            case 5: {
                this.fCurrentEntity.nextByte();
                bl = false;
                break;
            }
            case 6: {
                this.fCurrentEntity.skipSpaces();
                bl = this.fCurrentEntity.skippedByte(47);
                if (bl || this.fCurrentEntity.skippedByte(62)) break;
                switch (this.scanAttributes()) {
                    case 0: {
                        bl = false;
                        break block0;
                    }
                    case 1: {
                        bl = true;
                        break block0;
                    }
                }
                return -1;
            }
            case 3: 
            case 7: {
                this.setParameter(0, this.elementQName);
                this.reportFatalError(15);
                return -1;
            }
            default: {
                this.reportFatalError(19);
                return -1;
            }
            case 1: {
                this.reportFatalError(49);
                return -1;
            }
        }
        if (bl) {
            if (this.fCurrentEntity.skippedByte(62)) {
                this.setEndNamespacesScopeState();
                return 1;
            }
            this.setParameter(0, this.elementQName);
            this.reportFatalError(15);
            return -1;
        }
        this.setContentOrMarkupState();
        this.fNeedPushElement = true;
        return 0;
    }

    private int scanAttributes() {
        boolean bl;
        do {
            switch (this.scanAttributeName()) {
                case 7: {
                    this.fCurrentEntity.nextByte();
                    this.fCurrentEntity.skipSpaces();
                    break;
                }
                case 6: {
                    this.fCurrentEntity.skipSpaces();
                    if (this.fCurrentEntity.skippedByte(61)) {
                        this.fCurrentEntity.skipSpaces();
                        break;
                    }
                }
                case 3: 
                case 4: 
                case 5: {
                    this.setParameter(0, this.elementQName);
                    this.setParameter(1, this.currentAttributeName());
                    this.reportFatalError(16);
                    return -1;
                }
                default: {
                    this.setParameter(0, this.elementQName);
                    this.reportFatalError(15);
                    return -1;
                }
                case 1: {
                    this.reportFatalError(49);
                    return -1;
                }
            }
            int n2 = this.fCurrentEntity.skippedQuote();
            if (n2 == 0) {
                this.setParameter(0, this.elementQName);
                this.setParameter(1, this.currentAttributeName());
                this.reportFatalError(24);
                return -1;
            }
            if (!this.scanSpecifiedAttValue(n2)) {
                return -1;
            }
            bl = this.fCurrentEntity.skippedSpaces();
            if (this.fCurrentEntity.skippedByte(47)) {
                return 1;
            }
            if (!this.fCurrentEntity.skippedByte(62)) continue;
            return 0;
        } while (bl);
        this.setParameter(0, this.elementQName);
        this.reportFatalError(15);
        return -1;
    }

    private boolean scanRemainingAttValue(XMLString xMLString, int n2, int n3) {
        boolean bl = true;
        block10: while (true) {
            switch (this.fCurrentEntity.skipBytesUsingMap(attValueMap, 1)) {
                case 2: {
                    if (this.fDTDSupport.entityDepth() == n3 && this.fCurrentEntity.lookingAt(n2)) {
                        this.fCurrentEntity.endString(xMLString);
                        if (xMLString.length > 0) {
                            this.attributeValueCharacters(xMLString, bl);
                            if (xMLString == this.fAttValueChars) {
                                xMLString.clear();
                            }
                        } else {
                            xMLString.clear();
                        }
                        this.fCurrentEntity.nextByte();
                        return true;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
                case 3: {
                    this.fCurrentEntity.endString(xMLString);
                    if (xMLString.length > 0) {
                        this.attributeValueCharacters(xMLString, bl);
                        if (xMLString != this.fAttValueChars) {
                            this.fAttValueChars.clear();
                            this.attributeValueCharacters(this.fAttValueChars, true);
                        }
                    } else {
                        xMLString.clear();
                    }
                    this.fCurrentEntity.nextByte();
                    if (!this.checkReferenceInAttValue()) {
                        return false;
                    }
                    xMLString = this.fAttValueChars;
                    this.fCurrentEntity.startString(xMLString);
                    bl = true;
                    continue block10;
                }
                case 4: {
                    this.setParameter(0, this.elementQName);
                    this.setParameter(1, this.currentAttributeName());
                    return this.reportFatalError(25);
                }
                case 5: {
                    this.fCurrentEntity.nextByte();
                    bl = false;
                    continue block10;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags = (short)(xMLString.flags | 4);
                    }
                    bl = false;
                    this.fCurrentEntity.skipASCIISpaces();
                    continue block10;
                }
                case 7: {
                    if (this.fIsXML10 && this.fCurrentEntity.skippedValidCharacter()) continue block10;
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && this.fCurrentEntity.skippedXML11EOLCharacter()) {
                        xMLString.flags = (short)(xMLString.flags | 8);
                        bl = false;
                        continue block10;
                    }
                    if (!this.fIsXML10 && this.fCurrentEntity.skippedValidCharacter()) continue block10;
                    this.setParameter(0, this.elementQName);
                    this.setParameter(1, this.currentAttributeName());
                    this.setInvalidCharParameter(2);
                    return this.reportFatalError(21);
                }
                case 8: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        this.fCurrentEntity.endString(xMLString);
                        if (xMLString.length > 0) {
                            this.attributeValueCharacters(xMLString, bl);
                        } else {
                            xMLString.clear();
                        }
                        if (this.fDTDSupport.endOfEntity(1)) {
                            xMLString = this.fAttValueChars;
                            this.fCurrentEntity.startString(xMLString);
                            bl = true;
                            continue block10;
                        }
                        this.setParameter(0, this.elementQName);
                        this.setParameter(1, this.currentAttributeName());
                        return this.reportFatalError(26);
                    }
                    this.setParameter(0, this.elementQName);
                    this.setParameter(1, this.currentAttributeName());
                    this.setInvalidCharParameter(2);
                    return this.reportFatalError(21);
                }
                case 9: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block10;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setParameter(0, this.elementQName);
        this.setParameter(1, this.currentAttributeName());
        this.setInvalidCharParameter(2);
        return this.reportFatalError(21);
    }

    protected final boolean scanLeafElement() {
        boolean bl = false;
        this.fCurrentEntity.setMark();
        switch (this.fCurrentEntity.scanSimpleContent(this.content)) {
            case 1: {
                bl = true;
            }
            case 4: {
                this.fCurrentEntity.offset += 2;
                if ((!this.fCurrentEntity.skippedBytesMatchingXMLString(this.elementQName) || !this.fCurrentEntity.skippedByte(62)) && (!this.fCurrentEntity.skippedSpaces() || !this.fCurrentEntity.skippedByte(62))) break;
                this.fCurrentEntity.clearMark();
                this.setEndNamespacesScopeState();
                if (bl) {
                    this.elementValue = this.content;
                }
                return true;
            }
        }
        this.fCurrentEntity.resetToMark();
        return false;
    }

    public final boolean scanEndElement() {
        ParsedEntity parsedEntity = this.fCurrentEntity;
        assert (this.fCurrentState == 2);
        this.setStartCurrentEvent();
        if (parsedEntity.isFragment && parsedEntity.atEndOfEntity()) {
            this.fCurrentState = 15;
            return this.produceEndDocumentEvent();
        }
        parsedEntity.skipTwoBytes();
        if (this.popElement()) {
            if (this.fElementInfoStack.elementSymbol().skippedMatchingQName(this.fCurrentEntity, this.elementQName)) {
                if (parsedEntity.skippedByte(62) || parsedEntity.skippedSpaces() && parsedEntity.skippedByte(62)) {
                    this.setEndNamespacesScopeState();
                    return this.produceEndElementEvent();
                }
                this.setParameter(0, this.fElementInfoStack.elementSymbol().str);
                return this.reportFatalError(18);
            }
            this.scanName(this.fTempQName);
            this.setParameter(0, this.fTempQName);
            this.setParameter(1, this.fElementInfoStack.elementSymbol().str);
            return this.reportFatalError(14);
        }
        this.setParameter(0, this.topElement());
        return this.reportFatalError(20);
    }

    private boolean scanCDSect() {
        ParsedEntity parsedEntity = this.fCurrentEntity;
        parsedEntity.startString(this.content);
        block7: while (true) {
            switch (parsedEntity.skipValidXMLBytesUsingMapForXMLString(cdSectMap, 1, this.content)) {
                case 2: {
                    parsedEntity.setMark();
                    if (parsedEntity.skippedBytes(CDEND_BYTES)) {
                        parsedEntity.endStringAtMark(this.content);
                        return this.produceCDATASectionEvent();
                    }
                    parsedEntity.clearMark();
                    parsedEntity.nextByte();
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 4: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(1);
                }
                case 5: {
                    if (parsedEntity.atEndOfEntity()) {
                        return this.reportFatalError(6);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(1);
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    parsedEntity.nextByte();
                    continue block7;
                }
            }
            if (this.fIsXML10 || !parsedEntity.isInternal) break;
            parsedEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(1);
    }

    private boolean scanTrailingMisc() {
        do {
            if (this.fCurrentEntity.skippedSpaces()) continue;
            this.setStartCurrentEvent();
            if (this.fCurrentEntity.skippedByte(60)) {
                if (this.fCurrentEntity.skippedByte(63)) {
                    if (this.scanPI()) continue;
                    return false;
                }
                if (this.fCurrentEntity.skippedByte(33)) {
                    if (this.fCurrentEntity.skippedByte(45)) {
                        if (this.fCurrentEntity.skippedByte(45)) {
                            if (this.scanComment()) continue;
                            return false;
                        }
                        return this.reportFatalError(27);
                    }
                    return this.reportFatalError(12);
                }
                return this.reportFatalError(12);
            }
            if (this.fCurrentEntity.skippedByte(38)) {
                return this.reportFatalError(12);
            }
            if (this.fCurrentEntity.atEndOfEntity()) continue;
            this.setInvalidCharParameter(0);
            return this.reportFatalError(3);
        } while (!this.fCurrentEntity.atEndOfEntity());
        return this.endDocument();
    }

    protected final boolean endOfEntityDefault(int n2) {
        return n2 < 1;
    }

    private boolean scanPI() {
        XMLString xMLString = this.piTarget;
        int n2 = this.scanNCName(xMLString);
        switch (n2) {
            case 0: {
                return this.reportFatalError(30);
            }
            case 3: 
            case 6: {
                if (!DocumentScanner.reservedPITarget(xMLString)) {
                    if (n2 == 6) {
                        this.fCurrentEntity.skipSpaces();
                        return this.scanPIData(this.content) && this.produceProcessingInstructionEvent();
                    }
                    this.content.setValues(this.fCurrentEntity.buffer, this.fCurrentEntity.offset, this.fCurrentEntity.offset);
                    if (!this.fCurrentEntity.skippedBytes(PI_END_BYTES)) break;
                    return this.produceProcessingInstructionEvent();
                }
                return this.reportFatalError(33);
            }
        }
        return this.reportFatalError(31);
    }

    protected static boolean reservedPITarget(XMLString xMLString) {
        if (xMLString.length == 3) {
            byte[] byArray = xMLString.bytes;
            int n2 = xMLString.startOffset;
            if (byArray != null) {
                return !(byArray[n2 + 0] != 120 && byArray[n2 + 0] != 88 || byArray[n2 + 1] != 109 && byArray[n2 + 1] != 77 || byArray[n2 + 2] != 108 && byArray[n2 + 2] != 76);
            }
            int n3 = xMLString.firstBuffer.endOffset;
            byArray = xMLString.firstBuffer.bytes;
            if (byArray[n2] == 120 || byArray[n2] == 88) {
                if (++n2 == n3) {
                    byArray = xMLString.lastBuffer.bytes;
                    n2 = xMLString.lastBuffer.startOffset;
                    n3 = xMLString.endOffset;
                }
                if (byArray[n2] == 109 || byArray[n2] == 77) {
                    if (++n2 == n3) {
                        byArray = xMLString.lastBuffer.bytes;
                        n2 = xMLString.lastBuffer.startOffset;
                        n3 = xMLString.endOffset;
                    }
                    return byArray[n2] == 108 || byArray[n2] == 76;
                }
            }
        }
        return false;
    }

    protected final boolean scanPIData(XMLString xMLString) {
        this.fCurrentEntity.startString(xMLString);
        block7: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(piMap, 1, xMLString)) {
                case 2: {
                    if (this.fCurrentEntity.peekByte() == 62) {
                        this.fCurrentEntity.endString(xMLString);
                        this.fCurrentEntity.skipTwoBytes();
                        return true;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 4: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(23);
                }
                case 5: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        return this.reportFatalError(32);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(23);
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(23);
    }

    private boolean scanComment() {
        return this.scanComment(this.content) && this.produceCommentEvent();
    }

    protected final boolean scanComment(XMLString xMLString) {
        this.fCurrentEntity.startString(xMLString);
        block7: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(commentMap, 1, xMLString)) {
                case 2: {
                    if (this.fCurrentEntity.peekByte() == 45) {
                        this.fCurrentEntity.endString(xMLString);
                        this.fCurrentEntity.skipTwoBytes();
                        if (this.fCurrentEntity.skippedByte(62)) {
                            return true;
                        }
                        return this.reportFatalError(28);
                    }
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 4: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(22);
                }
                case 5: {
                    if (this.fCurrentEntity.atEndOfEntity()) {
                        return this.reportFatalError(29);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(22);
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block7;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(22);
    }

    protected final int scanCharacterReference() {
        int n2;
        boolean bl = false;
        this.fCurrentEntity.startString(this.entityName);
        if (this.fCurrentEntity.skippedByte(120)) {
            int n3 = digitMap[this.fCurrentEntity.currentByte()];
            if (n3 < 0) {
                this.reportFatalError(36);
                return -1;
            }
            this.fCurrentEntity.nextByte();
            n2 = n3;
            while (!this.fCurrentEntity.skippedByte(59)) {
                n3 = digitMap[this.fCurrentEntity.currentByte()];
                if (n3 < 0) {
                    this.reportFatalError(37);
                    return -1;
                }
                this.fCurrentEntity.nextByte();
                if ((n2 = (n2 << 4) + n3) <= 0x10FFFF) continue;
                bl = true;
                n2 = 0;
            }
        } else {
            int n4 = digitMap[this.fCurrentEntity.currentByte()];
            if (n4 < 0 || n4 > 9) {
                this.reportFatalError(35);
                return -1;
            }
            this.fCurrentEntity.nextByte();
            n2 = n4;
            while (!this.fCurrentEntity.skippedByte(59)) {
                n4 = digitMap[this.fCurrentEntity.currentByte()];
                if (n4 < 0 || n4 > 9) {
                    this.reportFatalError(37);
                    return -1;
                }
                this.fCurrentEntity.nextByte();
                if ((n2 = n2 * 10 + n4) <= 0x10FFFF) continue;
                bl = true;
                n2 = 0;
            }
        }
        if (!bl) {
            if (n2 < 55296) {
                bl = n2 < 32 && n2 != 10 && n2 != 9 && n2 != 13;
            } else {
                boolean bl2 = bl = n2 < 57344 || n2 >= 65534 && n2 < 65536 || n2 >= 0x110000;
            }
            if (!bl || !this.fIsXML10 && n2 < 32 && n2 != 0) {
                this.entityName.clear();
                return n2;
            }
        }
        this.fCurrentEntity.endString(this.entityName);
        this.setParameter(0, this.entityName);
        this.reportFatalError(38);
        return -1;
    }

    protected final int checkPredefinedEntities(XMLString xMLString) {
        byte[] byArray = xMLString.firstBuffer.bytes;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.length;
        switch (byArray[n2] + n3) {
            case 110: {
                if (byArray[n2 + 1] != 116) break;
                return 60;
            }
            case 105: {
                if (byArray[n2 + 1] != 116) break;
                return 62;
            }
            case 100: {
                if (byArray[n2 + 1] != 109 || byArray[n2 + 2] != 112) break;
                return 38;
            }
            case 101: {
                if (byArray[n2 + 1] != 112 || byArray[n2 + 2] != 111 || byArray[n2 + 3] != 115) break;
                return 39;
            }
            case 117: {
                if (byArray[n2 + 1] != 117 || byArray[n2 + 2] != 111 || byArray[n2 + 3] != 116) break;
                return 34;
            }
            default: {
                return -1;
            }
        }
        if (n3 >= 2 && n3 <= 4 && xMLString.bytes == null) {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            switch (byArray[n2] + n3) {
                case 110: {
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 116) break;
                    return 60;
                }
                case 105: {
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 116) break;
                    return 62;
                }
                case 100: {
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 109) break;
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 112) break;
                    return 38;
                }
                case 101: {
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 112) break;
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 111) break;
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 115) break;
                    return 39;
                }
                case 117: {
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 117) break;
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 111) break;
                    if (dataBuffer.bytes[++n2] == 0) {
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n2] != 116) break;
                    return 34;
                }
            }
        }
        return -1;
    }

    private boolean checkReferenceInContent() {
        if (this.fCurrentEntity.skippedByte(35)) {
            int n2 = this.scanCharacterReference();
            if (n2 != -1) {
                this.singleCh = n2;
                return this.produceCharacterEvent();
            }
            return false;
        }
        int n3 = this.scanNCName(this.entityName);
        if (n3 == 8) {
            this.fCurrentEntity.nextByte();
            return this.fDTDSupport.entityReferenceInContent(this.entityName);
        }
        if (n3 == 0) {
            return this.reportFatalError(39);
        }
        this.setParameter(0, this.entityName);
        return this.reportFatalError(40);
    }

    protected final boolean entityReferenceInContentDefault(XMLString xMLString) {
        int n2 = this.checkPredefinedEntities(xMLString);
        if (n2 != -1) {
            this.singleCh = n2;
            return this.producePredefinedEntityEvent();
        }
        this.setParameter(0, xMLString);
        return this.reportFatalError(47);
    }

    private boolean checkReferenceInAttValue() {
        if (this.fCurrentEntity.skippedByte(35)) {
            int n2 = this.scanCharacterReference();
            if (n2 != -1) {
                this.attributeValueCharacter(n2, false);
                return true;
            }
            return false;
        }
        int n3 = this.scanNCName(this.entityName);
        if (n3 == 8) {
            this.fCurrentEntity.nextByte();
            return this.fDTDSupport.entityReferenceInAttValue(this.entityName);
        }
        if (n3 == 0) {
            return this.reportFatalError(39);
        }
        this.setParameter(0, this.entityName);
        return this.reportFatalError(40);
    }

    protected final boolean entityReferenceInAttValueDefault(XMLString xMLString) {
        int n2 = this.checkPredefinedEntities(xMLString);
        if (n2 != -1) {
            this.attributeValueCharacter(n2, true);
            return true;
        }
        this.setParameter(0, xMLString);
        return this.reportFatalError(47);
    }

    public final boolean skipContent(XMLString xMLString) {
        return this.skipContent(xMLString, true);
    }

    public final boolean skipContent(XMLString xMLString, boolean bl) {
        assert (this.fCurrentEvent == 2);
        assert (this.fCurrentState == 0 || this.fCurrentState == 1 || this.fCurrentState == 2 || this.fCurrentState == 3);
        assert (this.fNeedPushElement);
        this.fSkippedElementDepth = 0;
        this.fCurrentEntity.startString(xMLString);
        this.fCurrentEntity.setMark();
        block6: while (true) {
            if (this.fCurrentEntity.lookingAt(60)) {
                switch (markupMap[this.fCurrentEntity.peekByte()]) {
                    case 1: {
                        this.fCurrentEntity.nextByte();
                        if (this.skipStartElement(xMLString, bl)) continue block6;
                        this.fCurrentEntity.resetToMark();
                        return false;
                    }
                    case 2: {
                        if (this.fSkippedElementDepth == 0) {
                            this.fCurrentState = 0;
                            this.fCurrentEntity.endString(xMLString);
                            this.fCurrentEntity.clearMark();
                            return true;
                        }
                        this.fCurrentEntity.skipTwoBytes();
                        if (this.skipEndElement(xMLString)) continue block6;
                        this.fCurrentEntity.resetToMark();
                        return false;
                    }
                    case 3: {
                        this.fCurrentEntity.skipTwoBytes();
                        if (this.skipPI(xMLString)) continue block6;
                        this.fCurrentEntity.resetToMark();
                        return false;
                    }
                    case 4: {
                        this.fCurrentEntity.skipTwoBytes();
                        if (!(this.fCurrentEntity.skippedByte(45) ? this.fCurrentEntity.skippedByte(45) && this.skipComment(xMLString) : this.fCurrentEntity.skippedBytes(CDSTART_BYTES) && this.skipCDSect(xMLString))) break;
                        continue block6;
                    }
                }
                this.fCurrentEntity.resetToMark();
                return false;
            }
            if (!bl && this.fCurrentEntity.skippedByte(38)) {
                if (this.fCurrentEntity.skippedByte(35)) {
                    if (!this.fCurrentEntity.skipToChar(59)) {
                        this.fCurrentEntity.resetToMark();
                        return false;
                    }
                } else {
                    if (this.scanNCName(this.entityName) != 8) {
                        this.fCurrentEntity.resetToMark();
                        return false;
                    }
                    if (this.checkPredefinedEntities(this.entityName) == -1) {
                        this.fCurrentEntity.resetToMark();
                        return false;
                    }
                }
                this.fCurrentEntity.nextByte();
                continue;
            }
            if (!this.fLineBreaksNormalized) {
                if (this.fCurrentEntity.skippedByte(13)) {
                    xMLString.flags = (short)(xMLString.flags | 4);
                    continue;
                }
                if (!this.fIsXML10 && this.fCurrentEntity.skippedXML11EOLCharacter()) {
                    xMLString.flags = (short)(xMLString.flags | 8);
                    continue;
                }
            }
            if (this.fCurrentEntity.lookingAt(0)) break;
            this.fCurrentEntity.nextByte();
        }
        this.fCurrentEntity.resetToMark();
        return false;
    }

    private boolean skipStartElement(XMLString xMLString, boolean bl) {
        block0: while (true) {
            int n2;
            if ((n2 = this.fCurrentEntity.currentByte()) == 62) {
                this.fCurrentEntity.nextByte();
                ++this.fSkippedElementDepth;
                return true;
            }
            if (n2 == 47) {
                this.fCurrentEntity.nextByte();
                return this.fCurrentEntity.skippedByte(62);
            }
            if (n2 == 34 || n2 == 39) {
                this.fCurrentEntity.nextByte();
                if (!bl) {
                    while (true) {
                        if (this.fCurrentEntity.skippedByte(n2)) continue block0;
                        if (this.fCurrentEntity.skippedByte(38)) {
                            if (this.fCurrentEntity.skippedByte(35)) {
                                if (!this.fCurrentEntity.skipToChar(59)) {
                                    return false;
                                }
                            } else {
                                if (this.scanNCName(this.entityName) != 8) {
                                    return false;
                                }
                                if (this.checkPredefinedEntities(this.entityName) == -1) {
                                    return false;
                                }
                            }
                        }
                        this.fCurrentEntity.nextByte();
                    }
                }
                if (this.fCurrentEntity.skipToChar(n2)) {
                    this.fCurrentEntity.nextByte();
                    continue;
                }
                return false;
            }
            if (!this.fLineBreaksNormalized) {
                if (this.fCurrentEntity.skippedByte(13)) {
                    xMLString.flags = (short)(xMLString.flags | 4);
                    continue;
                }
                if (!this.fIsXML10 && this.fCurrentEntity.skippedXML11EOLCharacter()) {
                    xMLString.flags = (short)(xMLString.flags | 8);
                    continue;
                }
            }
            if (n2 == 0) break;
            this.fCurrentEntity.nextByte();
        }
        return false;
    }

    private boolean skipEndElement(XMLString xMLString) {
        while (true) {
            if (this.fCurrentEntity.skippedByte(62)) {
                --this.fSkippedElementDepth;
                return true;
            }
            if (!this.fLineBreaksNormalized) {
                if (this.fCurrentEntity.skippedByte(13)) {
                    xMLString.flags = (short)(xMLString.flags | 4);
                    continue;
                }
                if (!this.fIsXML10 && this.fCurrentEntity.skippedXML11EOLCharacter()) {
                    xMLString.flags = (short)(xMLString.flags | 8);
                    continue;
                }
            }
            if (this.fCurrentEntity.lookingAt(0)) break;
            this.fCurrentEntity.nextByte();
        }
        return false;
    }

    private boolean skipPI(XMLString xMLString) {
        block6: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(piMap, 1, xMLString)) {
                case 2: {
                    this.fCurrentEntity.nextByte();
                    if (!this.fCurrentEntity.skippedByte(62)) continue block6;
                    return true;
                }
                case 3: {
                    continue block6;
                }
                case 4: 
                case 5: {
                    return false;
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block6;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        return false;
    }

    private boolean skipComment(XMLString xMLString) {
        block6: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(commentMap, 1, xMLString)) {
                case 2: {
                    this.fCurrentEntity.nextByte();
                    if (!this.fCurrentEntity.skippedByte(45)) continue block6;
                    return this.fCurrentEntity.skippedByte(62);
                }
                case 3: {
                    continue block6;
                }
                case 4: 
                case 5: {
                    return false;
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block6;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        return false;
    }

    private boolean skipCDSect(XMLString xMLString) {
        block6: while (true) {
            switch (this.fCurrentEntity.skipValidXMLBytesUsingMapForXMLString(cdSectMap, 1, xMLString)) {
                case 2: {
                    if (this.fCurrentEntity.skippedBytes(CDEND_BYTES)) {
                        return true;
                    }
                    this.fCurrentEntity.nextByte();
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
                case 4: 
                case 5: {
                    return false;
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.fCurrentEntity.nextByte();
                    continue block6;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.fCurrentEntity.nextByte();
        }
        return false;
    }

    protected final int scanNCName(XMLString xMLString) {
        int n2;
        if (!this.fIsNamespaceAware) {
            return this.scanName(xMLString);
        }
        ParsedEntity parsedEntity = this.fCurrentEntity;
        parsedEntity.startString(xMLString);
        if (nameStartCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF] == 0) {
            ++parsedEntity.offset;
        } else if (parsedEntity.scanNameStartCharacter() == -1) {
            xMLString.clear();
            return 0;
        }
        while (true) {
            if ((n2 = nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF]) < 4) {
                ++parsedEntity.offset;
                continue;
            }
            if (n2 != 12) {
                if (n2 != 8) break;
                if (parsedEntity.offset == parsedEntity.endOffset && parsedEntity.loadMore() != 0) continue;
                n2 = 12;
                break;
            }
            if (parsedEntity.scanNameCharacter() == -1) break;
        }
        parsedEntity.endString(xMLString);
        return n2 >> 2;
    }

    protected final int scanNmtoken(XMLString xMLString) {
        int n2;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        parsedEntity.startString(xMLString);
        if (nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF] <= 4) {
            ++parsedEntity.offset;
        } else if (parsedEntity.scanNameCharacter() == -1) {
            xMLString.clear();
            return 0;
        }
        while (true) {
            if ((n2 = nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF]) <= 4) {
                ++parsedEntity.offset;
                continue;
            }
            if (n2 != 12) {
                if (n2 != 8) break;
                if (parsedEntity.offset == parsedEntity.endOffset && parsedEntity.loadMore() != 0) continue;
                n2 = 12;
                break;
            }
            if (parsedEntity.scanNameCharacter() == -1) break;
        }
        parsedEntity.endString(xMLString);
        return n2 >> 2;
    }

    public final int scanName(QName qName) {
        int n2 = this.scanName((XMLString)qName);
        if (n2 != 0) {
            this.fLastQNameSymbol = this.fSymbolTable.addNameSymbol(qName);
        } else {
            qName.clear();
            this.fLastQNameSymbol = null;
        }
        return n2;
    }

    public final int scanName(XMLString xMLString) {
        int n2;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        parsedEntity.startString(xMLString);
        byte by2 = parsedEntity.bytes[parsedEntity.offset];
        if (by2 == 58 || nameStartCharMap[by2 & 0xFF] == 0) {
            ++parsedEntity.offset;
        } else if (parsedEntity.scanNameStartCharacter() == -1) {
            xMLString.clear();
            return 0;
        }
        while (true) {
            if ((n2 = nameCharMap[parsedEntity.bytes[parsedEntity.offset] & 0xFF]) <= 4) {
                ++parsedEntity.offset;
                continue;
            }
            if (n2 != 12) {
                if (n2 != 8) break;
                if (parsedEntity.offset == parsedEntity.endOffset && parsedEntity.loadMore() != 0) continue;
                n2 = 12;
                break;
            }
            if (parsedEntity.scanNameCharacter() == -1) break;
        }
        parsedEntity.endString(xMLString);
        return n2 >> 2;
    }

    public final int scanQNameOrName(QName qName) {
        if (this.fIsNamespaceAware) {
            return this.scanQName(qName);
        }
        return this.scanName(qName);
    }

    public final int scanQName(QName qName) {
        int n2;
        int n3;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        byte[] byArray = parsedEntity.bytes;
        int n4 = n3 = parsedEntity.offset;
        int n5 = 0;
        int n6 = byArray[n4] & 0xFF;
        while (scanQNameMap[n6] == 0) {
            n5 = n5 * 31 + n6;
            if (scanQNameMap[n6 = byArray[++n4] & 0xFF] != 0) break;
            n5 = n5 * 31 + n6;
            if (scanQNameMap[n6 = byArray[++n4] & 0xFF] != 0) break;
            n5 = n5 * 31 + n6;
            n6 = byArray[++n4] & 0xFF;
        }
        if ((n2 = scanQNameMap[n6]) >= 3) {
            qName.setValues(parsedEntity.buffer, n3, n4);
            qName.hashcode = n5;
            Symbol symbol = this.fSymbolTable.getQNameSymbol(qName);
            if (symbol != null) {
                this.fLastQNameSymbol = symbol;
                parsedEntity.offset = n4;
            } else {
                n2 = this.rescanQName(parsedEntity, qName);
            }
            return n2;
        }
        if (n2 == 2) {
            return this.scanQNameAcrossBuffers(parsedEntity, qName);
        }
        return this.scanQNameWithMultiByte(parsedEntity, qName);
    }

    public static final boolean checkQName(QName qName) {
        byte[] byArray = qName.bytes;
        int n2 = qName.startOffset;
        if (nameStartCharMap[byArray[n2++] & 0xFF] == 0) {
            byte by2;
            boolean bl = false;
            while (n2 < qName.endOffset) {
                if ((by2 = nameCharMap[byArray[n2++] & 0xFF]) < 4) continue;
                if (by2 == 4) {
                    if (!bl) {
                        bl = true;
                        if (n2 < qName.endOffset && nameStartCharMap[byArray[n2++] & 0xFF] == 0) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            by2 = nameCharMap[byArray[n2] & 0xFF];
            if (by2 > 8) {
                return true;
            }
        }
        return false;
    }

    private int scanQNameAcrossBuffers(ParsedEntity parsedEntity, QName qName) {
        return this.rescanQName(parsedEntity, qName);
    }

    private int scanQNameWithMultiByte(ParsedEntity parsedEntity, QName qName) {
        return this.rescanQName(parsedEntity, qName);
    }

    /*
     * Unable to fully structure code
     */
    private int rescanQName(ParsedEntity var1_1, QName var2_2) {
        block15: {
            var3_3 = var1_1.bytes;
            var4_4 = var1_1.offset;
            var5_5 = 0;
            var6_6 = false;
            var1_1.startString(var2_2);
            var7_7 = var3_3[var4_4];
            block0: while (true) {
                block17: {
                    block18: {
                        block16: {
                            if ((var8_8 = DocumentScanner.nameStartCharMap[var7_7 & 255]) != 0) break block16;
                            var5_5 = var5_5 * 31 + var7_7;
                            var7_7 = var3_3[++var4_4];
                            break block17;
                        }
                        if (var8_8 != 1 || var4_4 != var1_1.endOffset || !var1_1.loadNextBuffer(var4_4)) break block18;
                        var3_3 = var1_1.bytes;
                        var4_4 = var1_1.offset;
                        var7_7 = var3_3[var4_4];
                        if (var7_7 != 0) {
                            continue;
                        }
                        ** GOTO lbl-1000
                    }
                    if (var8_8 != 2) ** GOTO lbl-1000
                    var1_1.offset = var4_4;
                    var9_9 = var1_1.scanNameStartCharacter();
                    if (var9_9 != -1) {
                        if (var9_9 < 65536) {
                            var5_5 = var5_5 * 31 + var9_9;
                        } else {
                            var10_10 = var9_9 - 65536;
                            var9_9 = 55296 + (var10_10 >> 10);
                            var5_5 = var5_5 * 31 + var9_9;
                            var9_9 = 56320 + (var10_10 & 1023);
                            var5_5 = var5_5 * 31 + var9_9;
                        }
                        var4_4 = var1_1.offset;
                        var3_3 = var1_1.bytes;
                        var7_7 = var3_3[var4_4];
                    } else lbl-1000:
                    // 3 sources

                    {
                        var2_2.clear();
                        return 0;
                    }
                }
                while (true) {
                    if (var7_7 >= 0) {
                        var8_8 = DocumentScanner.nameCharMap[var7_7];
                        if (var8_8 < 4) {
                            var5_5 = var5_5 * 31 + var7_7;
                            var7_7 = var3_3[++var4_4];
                            continue;
                        }
                        if (var8_8 <= 8) {
                            if (var8_8 == 4) {
                                if (!var6_6) {
                                    var6_6 = true;
                                    var5_5 = var5_5 * 31 + 58;
                                    var7_7 = var3_3[++var4_4];
                                    continue block0;
                                }
                                var2_2.clear();
                                return 1;
                            }
                            if (var4_4 == var1_1.endOffset && var1_1.loadNextBuffer(var4_4) && ((var7_7 = (var3_3 = var1_1.bytes)[var4_4 = var1_1.offset]) != 0 || var4_4 < var1_1.endOffset)) continue;
                            var8_8 = 12;
                        }
                        break block15;
                    }
                    var1_1.offset = var4_4;
                    var9_9 = var1_1.scanNameCharacter();
                    if (var9_9 == -1) break block0;
                    if (var9_9 < 65536) {
                        var5_5 = var5_5 * 31 + var9_9;
                    } else {
                        var10_10 = var9_9 - 65536;
                        var9_9 = 55296 + (var10_10 >> 10);
                        var5_5 = var5_5 * 31 + var9_9;
                        var9_9 = 56320 + (var10_10 & 1023);
                        var5_5 = var5_5 * 31 + var9_9;
                    }
                    var4_4 = var1_1.offset;
                    var3_3 = var1_1.bytes;
                    var7_7 = var3_3[var4_4];
                }
                break;
            }
            var8_8 = 12;
        }
        var1_1.offset = var4_4;
        var1_1.endString(var2_2);
        this.fLastQNameSymbol = var10_11 = this.fSymbolTable.getQNameSymbol(var2_2, var5_5);
        if (!(DocumentScanner.$assertionsDisabled || var2_2.prefix != null && var2_2.localName != null)) {
            throw new AssertionError();
        }
        return var8_8 >> 2;
    }

    public final boolean produceStartDocumentEventDefault() {
        if (this.version.firstBuffer != null && this.version.equalsString(XML11_BYTES, 0, 3)) {
            this.fIsXML10 = false;
        }
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceStartDocumentEventDefault", this.scannerLabel() + ", " + XMLTracer.traceStartDocument(this.version, this.encName, this.standalone));
        }
        this.fCleanupFlags |= 1;
        this.fCurrentEvent = 1;
        return !this.fIncremental;
    }

    public boolean produceStartDocumentEvent() {
        return this.produceStartDocumentEventDefault();
    }

    public final boolean produceEndDocumentEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceEndDocumentEventDefault", this.scannerLabel() + ", " + XMLTracer.traceEndDocument());
        }
        this.fCurrentEvent = 18;
        return false;
    }

    public boolean produceEndDocumentEvent() {
        return this.produceEndDocumentEventDefault();
    }

    public final boolean produceLeafElementEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceLeafElementEventDefault", this.scannerLabel() + ", " + XMLTracer.traceLeafElement(this.elementQName, this, this, this.elementValue) + "<elementDepth depth=\"" + this.elementDepth + "\">\n");
        }
        this.fCleanupFlags |= 4;
        this.fCurrentEvent = 3;
        return !this.fIncremental;
    }

    public boolean produceLeafElementEvent() {
        return this.produceLeafElementEventDefault();
    }

    public final boolean produceStartElementEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceStartElementEventDefault", this.scannerLabel() + ", " + XMLTracer.traceStartElement(this.elementQName, this, this) + "<elementDepth depth=\"" + this.elementDepth + "\">\n");
        }
        this.fCleanupFlags |= 4;
        this.fCurrentEvent = 2;
        return !this.fIncremental;
    }

    public boolean produceStartElementEvent() {
        return this.produceStartElementEventDefault();
    }

    public final boolean produceEndElementEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceEndElementEventDefault", this.scannerLabel() + ", " + XMLTracer.traceEndElement(this.elementQName, this) + "<elementDepth depth=\"" + this.elementDepth + "\">\n");
        }
        this.fCleanupFlags |= 0x10;
        this.fCurrentEvent = 4;
        return !this.fIncremental;
    }

    public boolean produceEndElementEvent() {
        return this.produceEndElementEventDefault();
    }

    public final boolean produceCharactersEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceCharactersEventDefault", this.scannerLabel() + ", " + XMLTracer.traceCharacters(this.content));
        }
        this.fCleanupFlags |= 0x20;
        this.fCurrentEvent = 5;
        return !this.fIncremental;
    }

    public boolean produceCharactersEvent() {
        return this.produceCharactersEventDefault();
    }

    public final boolean produceCDATASectionEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceCDATASectionEventDefault", this.scannerLabel() + ", " + XMLTracer.traceCDATASection(this.content));
        }
        this.fCleanupFlags |= 0x20;
        this.fCurrentEvent = 6;
        return !this.fIncremental;
    }

    public boolean produceCDATASectionEvent() {
        return this.produceCDATASectionEventDefault();
    }

    public final boolean produceWhitespaceEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceWhitespaceEventDefault", this.scannerLabel() + ", " + XMLTracer.traceWhitespace(this.content));
        }
        this.fCleanupFlags |= 0x20;
        this.fCurrentEvent = 7;
        return !this.fIncremental;
    }

    public boolean produceWhitespaceEvent() {
        return this.produceWhitespaceEventDefault();
    }

    public final boolean produceCharacterEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceCharacterEventDefault", this.scannerLabel() + ", " + XMLTracer.traceCharacter(this.singleCh));
        }
        this.fCurrentEvent = 8;
        return !this.fIncremental;
    }

    public boolean produceCharacterEvent() {
        return this.produceCharacterEventDefault();
    }

    public final boolean producePredefinedEntityEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "producePredefinedEntityEventDefault", this.scannerLabel() + ", " + XMLTracer.tracePredefinedEntity(this.entityName, this.singleCh));
        }
        this.fCurrentEvent = 9;
        return !this.fIncremental;
    }

    public boolean producePredefinedEntityEvent() {
        return this.producePredefinedEntityEventDefault();
    }

    public final boolean produceProcessingInstructionEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceProcessingInstructionEventDefault", this.scannerLabel() + ", " + XMLTracer.traceProcessingInstruction(this.piTarget, this.content));
        }
        this.fCleanupFlags |= 0x40;
        this.fCurrentEvent = 10;
        return !this.fIncremental;
    }

    public boolean produceProcessingInstructionEvent() {
        return this.produceProcessingInstructionEventDefault();
    }

    public final boolean produceCommentEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceCommentEventDefault", this.scannerLabel() + ", " + XMLTracer.traceComment(this.content));
        }
        this.fCleanupFlags |= 0x80;
        this.fCurrentEvent = 11;
        return !this.fIncremental;
    }

    public boolean produceCommentEvent() {
        return this.produceCommentEventDefault();
    }

    public final boolean produceDoctypeEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceDoctypeEventDefault", this.scannerLabel() + ", " + XMLTracer.traceDoctype(this.rootElementType, this.publicID, this.systemID, this.internalSubset));
        }
        this.moveToStringBuffer(this.rootElementType);
        if (this.publicID != null && this.publicID.firstBuffer != null) {
            this.moveToStringBuffer(this.publicID);
        }
        if (this.systemID != null && this.systemID.firstBuffer != null) {
            this.moveToStringBuffer(this.systemID);
        }
        this.fCleanupFlags |= 0x100;
        this.fCurrentEvent = 12;
        return !this.fIncremental;
    }

    public boolean produceDoctypeEvent() {
        return this.produceDoctypeEventDefault();
    }

    public final boolean produceStartEntityEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceStartEntityEventDefault", this.scannerLabel() + ", " + XMLTracer.traceStartEntity(this.entityName));
        }
        this.fCleanupFlags |= 0x200;
        this.fCurrentEvent = 13;
        return !this.fIncremental;
    }

    public boolean produceStartEntityEvent() {
        return this.produceStartEntityEventDefault();
    }

    public final boolean produceEndEntityEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceEndEntityEventDefault", this.scannerLabel() + ", " + XMLTracer.traceEndEntity(this.entityName));
        }
        this.fCleanupFlags |= 0x200;
        this.fCurrentEvent = 14;
        return !this.fIncremental;
    }

    public boolean produceEndEntityEvent() {
        return this.produceEndEntityEventDefault();
    }

    public final boolean produceEntityReferenceEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceEntityReferenceEventDefault", this.scannerLabel() + ", " + XMLTracer.traceEntityReference(this.entityName));
        }
        this.fCleanupFlags |= 0x200;
        this.fCurrentEvent = 15;
        return !this.fIncremental;
    }

    public boolean produceEntityReferenceEvent() {
        return this.produceEntityReferenceEventDefault();
    }

    public final boolean produceWarningEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceWarningEventDefault", this.scannerLabel() + ", " + XMLTracer.traceWarning(this.errorURI, this.errorCode, this.errorParamsCount, this.errorParamStrings, 0, this.errorOffset));
        }
        this.fCleanupFlags |= 0x400;
        this.fCurrentEvent = 16;
        return !this.fIncremental;
    }

    public boolean produceWarningEvent() {
        return this.produceWarningEventDefault();
    }

    public final boolean produceRecoverableErrorEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceRecoverableErrorEventDefault", this.scannerLabel() + ", " + XMLTracer.traceRecoverableError(this.errorURI, this.errorCode, this.errorParamsCount, this.errorParamStrings, 0, this.errorOffset));
        }
        this.fCleanupFlags |= 0x400;
        this.fCurrentEvent = 17;
        return !this.fIncremental;
    }

    public boolean produceRecoverableErrorEvent() {
        return this.produceRecoverableErrorEventDefault();
    }

    public final boolean produceFatalErrorEventDefault() {
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "produceFatalErrorEventDefault", this.scannerLabel() + ", " + XMLTracer.traceFatalError(this.errorURI, this.errorCode, this.errorParamsCount, this.errorParamStrings, 0, this.errorOffset));
        }
        this.fCurrentEvent = 19;
        return false;
    }

    public boolean produceFatalErrorEvent() {
        return this.produceFatalErrorEventDefault();
    }

    public final void endOfProlog() {
        if (this.version.firstBuffer != null) {
            this.version.clear();
        }
        if (this.encName.firstBuffer != null) {
            this.encName.clear();
        }
        if (this.standalone.firstBuffer != null) {
            this.standalone.clear();
        }
        this.fCleanupFlags &= 0xFFFFFFFC;
        if (this.rootElementType.firstBuffer != null) {
            this.rootElementType.clear();
        }
    }

    public final QName currentAttributeName() {
        return this.fAttributeNames[this.attrCount];
    }

    public final XMLString currentAttributeValue() {
        return this.fAttributeValues[this.attrCount];
    }

    protected final void setupCurrentAttribute(boolean bl, String string2) {
        if (this.attrCount == this.fAttributeNames.length) {
            this.growAttributes();
        }
        this.fAttributeTypes[this.attrCount] = string2;
        this.fAttributeValueNormalized[this.attrCount] = bl;
        this.fAttributeSpecified[this.attrCount] = bl;
    }

    protected final void setCurrentAttributeType(String string2) {
        this.fAttributeTypes[this.attrCount] = string2;
    }

    protected void growAttributes() {
        int n2;
        int n3 = this.fAttributeNames.length;
        int n4 = n3 << 1;
        this.fAttributeNames = ArrayAllocator.resizeObjectArray(QName.class, this.fAttributeNames, n4);
        for (n2 = n4 - 1; n2 >= n3; --n2) {
            this.fAttributeNames[n2] = new QName();
        }
        this.fAttributeValues = ArrayAllocator.resizeObjectArray(XMLString.class, this.fAttributeValues, n4);
        for (n2 = n4 - 1; n2 >= n3; --n2) {
            this.fAttributeValues[n2] = new XMLString();
        }
        this.fAttributeTypes = ArrayAllocator.resizeStringArray(this.fAttributeTypes, n4);
        this.fAttributeValueNormalized = ArrayAllocator.resizeBooleanArray(this.fAttributeValueNormalized, n4);
        this.fAttributeSpecified = ArrayAllocator.resizeBooleanArray(this.fAttributeSpecified, n4);
    }

    public final void setAttributeType(int n2, String string2) {
        this.fAttributeTypes[n2] = string2;
    }

    protected final boolean finishElement() {
        if (this.fHasDefaultAttributes && !this.addDefaultAttributes(this.fIsNamespaceAware)) {
            return false;
        }
        if (this.fIsNamespaceAware) {
            if (!this.resolveNamespaceURIs()) {
                return false;
            }
            if (this.fElementInfoStack.nsMappingsCount() > 1 && !this.checkDuplicateNamespaces(this.elementQName)) {
                return false;
            }
        }
        return this.attrCount <= 1 || this.checkDuplicateAttrs();
    }

    protected final String resolveAttrListNamespaceURIs() {
        for (int i = 0; i < this.attrCount; ++i) {
            QName qName = this.fAttributeNames[i];
            String string2 = qName.prefix;
            if (string2 == "" || string2 == "xmlns") continue;
            String string3 = this.prefixMapping(string2);
            if (string3 != null && string3 != "") {
                qName.nsURI = string3;
                continue;
            }
            return string2;
        }
        return null;
    }

    protected final boolean checkDuplicateAttrs() {
        QName qName = this.checkDuplicateAttrs2(this.fAttributeNames, 0);
        if (qName == null) {
            return true;
        }
        return this.duplicateAttribute(qName);
    }

    public final boolean continueAfterEndOfEntity() {
        return true;
    }

    private void setupRootElement() {
        this.fHasElementContentElements = this.hasElementContentElements();
        this.fHasDefaultAttributes = this.hasDefaultAttributes();
        this.fCopyAttValuesToBuffer = this.copyAttValuesToStringBuffer();
        this.fAttValueStringBuffer = null;
    }

    public final void setupStartElement() {
        if (this.elementDepth == 0) {
            this.setupRootElement();
        }
        this.attrCount = 0;
        this.fSeenAttrWithPrefix = false;
        this.fSeenNSDecl = false;
        this.elementValue = null;
    }

    private int scanElementType() {
        this.setupStartElement();
        int n2 = this.fIsNamespaceAware ? this.scanQName(this.elementQName) : this.scanName(this.elementQName);
        this.fElementInfoStack.setElementSymbol(this.fLastQNameSymbol);
        return n2;
    }

    private int scanAttributeName() {
        this.setupCurrentAttribute(true, "");
        if (this.fIsNamespaceAware) {
            return this.scanQName(this.fAttributeNames[this.attrCount]);
        }
        return this.scanName(this.fAttributeNames[this.attrCount]);
    }

    private void processAttributeName(QName qName) {
        if (this.fIsNamespaceAware) {
            String string2 = qName.prefix;
            String string3 = qName.localName;
            if (string2 != "xmlns") {
                if (string2 == "") {
                    this.fNamespaceDeclPrefix = string3 != "xmlns" ? null : "";
                } else {
                    this.fNamespaceDeclPrefix = null;
                    this.fSeenAttrWithPrefix = true;
                }
            } else {
                this.fNamespaceDeclPrefix = string3;
            }
        } else {
            this.fNamespaceDeclPrefix = null;
        }
    }

    public final boolean scanSpecifiedAttValue(int n2) {
        this.processAttributeName(this.fAttributeNames[this.attrCount]);
        if (this.fNamespaceDeclPrefix == null) {
            if (!this.fCopyAttValuesToBuffer ? this.scanAttValueNoCopy(n2) : this.scanAttValueCopy(n2)) {
                ++this.attrCount;
                return true;
            }
            return false;
        }
        String string2 = this.scanNamespaceURI(n2);
        if (string2 != null) {
            return this.saveNamespaceDecl(this.fAttributeNames[this.attrCount].rawName, string2);
        }
        return false;
    }

    private boolean scanAttValueNoCopy(int n2) {
        XMLString xMLString = this.fAttributeValues[this.attrCount];
        switch (this.fCurrentEntity.scanSimpleAttValue(xMLString, n2)) {
            case 0: {
                this.fCurrentEntity.nextByte();
                return true;
            }
            case 1: {
                this.fCurrentEntity.nextByte();
                NullDataBufferFactory.setEmptyStringValues(xMLString);
                return true;
            }
        }
        return this.scanRemainingAttValueNoCopy(n2);
    }

    private boolean scanRemainingAttValueNoCopy(int n2) {
        XMLString xMLString = this.fAttributeValues[this.attrCount];
        if (this.fAttValueStringBuffer == null) {
            this.fAttValueStringBuffer = this.getAttValueStringBuffer();
        }
        this.fAttValueOffset = -1;
        if (!this.scanRemainingAttValue(xMLString, n2, this.fDTDSupport.entityDepth())) {
            return false;
        }
        if (this.fAttValueOffset != -1) {
            this.fAttValueStringBuffer.setStringValues(this.fAttValueOffset, this.fAttValueStringBuffer.getOffset(), xMLString);
            this.fAttValueOffset = -1;
        } else if (xMLString.length == 0) {
            NullDataBufferFactory.setEmptyStringValues(xMLString);
        }
        return true;
    }

    private boolean scanAttValueCopy(int n2) {
        XMLString xMLString = this.fAttributeValues[this.attrCount];
        if (this.fAttValueStringBuffer == null) {
            this.fAttValueStringBuffer = this.getAttValueStringBuffer();
        }
        switch (this.fCurrentEntity.scanSimpleAttValue(this.fAttValueChars, n2)) {
            case 0: {
                this.fCurrentEntity.nextByte();
                this.fAttValueStringBuffer.addXMLString(this.fAttValueChars, xMLString);
                return true;
            }
            case 1: {
                this.fCurrentEntity.nextByte();
                this.fAttValueOffset = this.initialAttValueOffset();
                this.fAttValueStringBuffer.setStringValues(this.fAttValueOffset, this.fAttValueOffset, xMLString);
                return true;
            }
        }
        return this.scanRemainingAttValueCopy(n2);
    }

    private boolean scanRemainingAttValueCopy(int n2) {
        this.fAttValueOffset = this.initialAttValueOffset();
        if (this.scanRemainingAttValue(this.fAttValueChars, n2, this.fDTDSupport.entityDepth())) {
            this.fAttValueStringBuffer.setStringValues(this.fAttValueOffset, this.fAttValueStringBuffer.getOffset(), this.fAttributeValues[this.attrCount]);
            return true;
        }
        return false;
    }

    private String scanNamespaceURI(int n2) {
        switch (this.fCurrentEntity.scanSimpleNamespaceURI(this.fAttValueChars, n2)) {
            case 0: {
                this.fCurrentEntity.nextByte();
                return this.fSymbolTable.addSymbol(this.fAttValueChars);
            }
            case 1: {
                this.fCurrentEntity.nextByte();
                return "";
            }
        }
        return this.scanRemainingNamespaceURI(n2);
    }

    private String scanRemainingNamespaceURI(int n2) {
        this.fAttValueOffset = this.getStringBuffer().getOffset();
        if (!this.scanRemainingAttValue(this.fAttValueChars, n2, this.fDTDSupport.entityDepth())) {
            return null;
        }
        int n3 = this.fStringBuffer.getOffset();
        if (this.fAttValueOffset != n3) {
            this.fStringBuffer.setStringValues(this.fAttValueOffset, n3, this.fAttValueChars);
            return this.fSymbolTable.addSymbol(this.fAttValueChars);
        }
        return "";
    }

    protected boolean copyAttValuesToStringBuffer() {
        return false;
    }

    protected int initialAttValueOffset() {
        return -1;
    }

    protected XMLStringBuffer getAttValueStringBuffer() {
        return this.getStringBuffer();
    }

    private void attributeValueCharacters(XMLString xMLString, boolean bl) {
        Object object2;
        if (this.fAttValueOffset == -1) {
            object2 = this.fAttributeValues[this.attrCount];
            if (xMLString == object2) {
                if (bl || xMLString.length == 0) {
                    return;
                }
                this.fAttValueOffset = this.fAttValueStringBuffer.getOffset();
            } else {
                this.fAttValueOffset = this.fAttValueStringBuffer.getOffset();
                if (((XMLString)object2).length != 0) {
                    this.fAttValueStringBuffer.appendXMLString((XMLString)object2);
                }
            }
        }
        Object object3 = object2 = this.fNamespaceDeclPrefix == null ? this.fAttValueStringBuffer : this.fStringBuffer;
        if (xMLString.length > 0) {
            if (bl) {
                ((XMLStringBuffer)object2).appendXMLString(xMLString);
            } else {
                ((XMLStringBuffer)object2).normalizedAppend(xMLString);
            }
        }
    }

    public final void attributeValueCharacter(int n2, boolean bl) {
        if (this.fNamespaceDeclPrefix == null) {
            if (this.fAttValueOffset == -1) {
                this.fAttValueOffset = this.fAttValueStringBuffer.getOffset();
                XMLString xMLString = this.fAttributeValues[this.attrCount];
                if (xMLString.length != 0) {
                    this.fAttValueStringBuffer.appendXMLString(xMLString);
                }
            }
            this.fAttValueStringBuffer.appendChar(n2);
        } else {
            this.fStringBuffer.appendChar(n2);
        }
    }

    protected final boolean saveNamespaceDecl(String string2, String string3) {
        if (this.fNamespaceDeclPrefix == "") {
            this.fSeenDefaultNamespaceMapping = true;
        }
        this.fSeenNSDecl = true;
        return this.createPrefixMapping(this.fNamespaceDeclPrefix, string3, string2, this.fIsXML10);
    }

    public final boolean addDefaultAttribute(QName qName, String string2, XMLString xMLString) {
        this.setupCurrentAttribute(false, string2);
        this.fAttributeNames[this.attrCount].setValues(qName);
        this.processAttributeName(qName);
        this.fAttributeValues[this.attrCount].setValues(xMLString);
        ++this.attrCount;
        return true;
    }

    public final boolean addDefaultNSDecl(QName qName, XMLString xMLString) {
        this.processAttributeName(qName);
        return this.saveNamespaceDecl(qName.rawName, this.fSymbolTable.addSymbol(xMLString));
    }

    protected final boolean resolveNamespaceURIs() {
        String string2;
        QName qName = this.elementQName;
        if (this.fSeenAttrWithPrefix && (string2 = this.resolveAttrListNamespaceURIs()) != null) {
            return this.undeclaredPrefix(string2);
        }
        string2 = qName.prefix;
        if (string2 == "") {
            qName.nsURI = this.fElementInfoStack.defaultNamespace();
        } else {
            String string3 = this.prefixMapping(string2);
            if (string3 != null && string3 != "") {
                qName.nsURI = string3;
            } else {
                return this.undeclaredPrefix(string2);
            }
        }
        return true;
    }

    private boolean undeclaredPrefix(String string2) {
        this.setParameter(0, string2);
        return this.reportFatalError(50);
    }

    protected final boolean duplicateAttribute(QName qName) {
        this.setParameter(0, this.elementQName);
        this.setParameter(1, qName);
        return this.reportFatalError(17);
    }

    protected final QName checkDuplicateAttrs2(QName[] qNameArray, int n2) {
        if (this.attrCount < 16) {
            int n3 = n2 + this.attrCount;
            for (int i = n2; i < n3 - 1; ++i) {
                QName qName = qNameArray[i];
                String string2 = qName.localName;
                for (int j = i + 1; j < n3; ++j) {
                    if (qNameArray[j].localName != string2 || qNameArray[j].nsURI != qNameArray[i].nsURI) continue;
                    return qNameArray[j];
                }
            }
            return null;
        }
        return this.checkManyDuplicateAttrs(qNameArray, n2);
    }

    protected final QName checkManyDuplicateAttrs(QName[] qNameArray, int n2) {
        int n3;
        int n4;
        int n5 = this.attrCount >> 4;
        for (n4 = 1024; n4 < n5; n4 <<= 1) {
        }
        if (this.fAttrHashtable == null) {
            this.fAttrHashtable = ArrayAllocator.newIntArray(n4);
        } else if (n4 > this.fAttrHashtable.length) {
            this.fAttrHashtable = ArrayAllocator.replaceIntArray(this.fAttrHashtable, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.fAttrHashtable[n3] = -1;
        }
        --n4;
        int n6 = qNameArray.length;
        if (this.fNextAttrInBucket == null) {
            this.fNextAttrInBucket = ArrayAllocator.newIntArray(n6);
        } else if (n6 > this.fNextAttrInBucket.length) {
            this.fNextAttrInBucket = ArrayAllocator.replaceIntArray(this.fNextAttrInBucket, n6);
        }
        this.fHashMultipliers = null;
        int n7 = n2 + this.attrCount;
        for (n3 = n2; n3 < n7; ++n3) {
            String string2 = qNameArray[n3].localName;
            String string3 = qNameArray[n3].nsURI;
            int n8 = this.attrHash(string2, string3);
            int n9 = n8 & n4;
            int n10 = 0;
            int n11 = this.fAttrHashtable[n9];
            if (n11 >= 0) {
                int n12 = n11;
                while (n12 >= 0) {
                    if (qNameArray[n12].localName == string2 && qNameArray[n12].nsURI == string3) {
                        return qNameArray[n3];
                    }
                    ++n10;
                    n12 = this.fNextAttrInBucket[n12];
                }
            }
            this.fNextAttrInBucket[n3] = n11;
            this.fAttrHashtable[n9] = n3;
            if (n10 < 640) continue;
            this.rebalanceAttrHashtable(n4, qNameArray, n2, n3 + 1);
        }
        return null;
    }

    private void rebalanceAttrHashtable(int n2, QName[] qNameArray, int n3, int n4) {
        int n5;
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[33];
        }
        int[] nArray = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727};
        Random random = new Random();
        for (n5 = 0; n5 < this.fHashMultipliers.length; ++n5) {
            this.fHashMultipliers[n5] = nArray[random.nextInt(nArray.length)];
        }
        for (n5 = 0; n5 < this.fAttrHashtable.length; ++n5) {
            this.fAttrHashtable[n5] = -1;
        }
        n5 = n3;
        while (n5 < n4) {
            int n6;
            String string2 = qNameArray[n5].localName;
            String string3 = qNameArray[n5].nsURI;
            int n7 = this.attrHash(string2, string3);
            int n8 = n7 & n2;
            this.fNextAttrInBucket[n5] = n6 = this.fAttrHashtable[n8];
            this.fAttrHashtable[n8] = n5++;
        }
    }

    private int attrHash(String string2, String string3) {
        if (this.fHashMultipliers == null) {
            return string2.hashCode() ^ string3.hashCode();
        }
        return this.attrHash0(string2) + this.attrHash0(string3) * this.fHashMultipliers[32];
    }

    private int attrHash0(String string2) {
        int n2 = 0;
        int n3 = string2.length();
        int[] nArray = this.fHashMultipliers;
        for (int i = 0; i < n3; ++i) {
            n2 = n2 * nArray[i & 0x1F] + string2.charAt(i);
        }
        return n2;
    }

    private String toCodePointString(String string2) {
        char c;
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            c = string2.charAt(0);
            if (c >= ' ' && c <= '~') continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        c = string2.charAt(0);
        if (c >= ' ' && c <= '~') {
            stringBuilder.append(c);
        } else {
            stringBuilder.append((int)c);
        }
        for (int i = 1; i < string2.length(); ++i) {
            stringBuilder.append(',');
            c = string2.charAt(i);
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append((int)c);
        }
        return stringBuilder.toString();
    }

    protected final void pushElement() {
        Object object2;
        if (LoggerUtil.isFinestLoggable(logger)) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("\n  element depth " + this.elementDepth);
            this.fElementInfoStack.dumpNSTables((StringBuilder)object2);
            logger.logp(Level.FINEST, cn, "pushElement", this.scannerLabel() + ", " + "\"" + this.toCodePointString(this.elementQName.rawName) + "\"" + ((StringBuilder)object2).toString());
        }
        object2 = this.fElementInfoStack.topOfStack();
        ((ElementInfo)object2).nsURI = this.elementQName.nsURI;
        ((ElementInfo)object2).entityID = this.fCurrentEntityID;
        if (this.fHasElementContentElements) {
            ((ElementInfo)object2).inElementContent = this.inElementContent;
            this.inElementContent = this.hasElementContent(this.elementQName.rawName);
        }
        this.fElementInfoStack.moveToChild();
        ++this.elementDepth;
    }

    public final int elementDepth() {
        return this.elementDepth;
    }

    public final boolean popElement() {
        --this.elementDepth;
        this.fElementInfoStack.moveToParent();
        ElementInfo elementInfo = this.fElementInfoStack.topOfStack();
        elementInfo.elementSymbol.setQNameValues(this.elementQName);
        this.elementQName.nsURI = elementInfo.nsURI;
        if (this.fHasElementContentElements) {
            this.inElementContent = elementInfo.inElementContent;
        }
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n  element depth " + this.elementDepth);
            this.fElementInfoStack.dumpNSTables(stringBuilder);
            logger.logp(Level.FINEST, cn, "popElement", this.scannerLabel() + ", " + "\"" + this.toCodePointString(this.fElementInfoStack.elementSymbol().str) + "\"" + stringBuilder.toString());
        }
        return elementInfo.entityID == this.fCurrentEntityID;
    }

    public final String topElement() {
        return this.fElementInfoStack.elementSymbol().str;
    }

    public final void setInElementContent(boolean bl) {
        this.inElementContent = bl;
    }

    private XMLString getParameter(int n2) {
        if (n2 >= this.errorParamsCount) {
            if (n2 + 1 <= this.errorParamStrings.length) {
                this.errorParamsCount = n2 + 1;
            } else {
                int n3 = this.errorParamStrings.length;
                int n4 = n3 << 1;
                this.errorParamStrings = ArrayAllocator.resizeObjectArray(XMLString.class, this.errorParamStrings, n4);
                for (int i = n4 - 1; i >= n3; --i) {
                    this.errorParamStrings[i] = new XMLString();
                }
                this.errorParamsCount = n2 + 1;
            }
        }
        return this.errorParamStrings[n2];
    }

    public final void setParameter(int n2, XMLString xMLString) {
        this.getParameter(n2).setValues(xMLString);
    }

    public final void setParameter(int n2, String string2) {
        this.getStringBuffer().addString(string2, this.getParameter(n2));
    }

    public final void setInvalidCharParameter(int n2, int n3) {
        if (n3 != -1) {
            this.setParameter(n2, Integer.toHexString(n3));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append('[');
        this.fCurrentEntity.setMark();
        for (int i = 0; i < 4; ++i) {
            int n4 = this.fCurrentEntity.currentByte();
            String string2 = Integer.toHexString(n4).toUpperCase();
            if (string2.length() == 1) {
                stringBuilder.append("0" + string2);
            } else {
                stringBuilder.append(string2);
            }
            if (n4 == 0 || i == 3) break;
            stringBuilder.append(',');
            this.fCurrentEntity.nextByte();
        }
        this.fCurrentEntity.resetToMark();
        stringBuilder.append(']');
        this.setParameter(n2, stringBuilder.toString());
    }

    public final boolean reportWarning(String string2, int n2) {
        this.errorURI = string2;
        this.errorCode = n2;
        return this.produceWarningEvent();
    }

    public final boolean reportRecoverableError(String string2, int n2) {
        this.errorURI = string2;
        this.errorCode = n2;
        return this.produceRecoverableErrorEvent();
    }

    public final boolean reportFatalError(String string2, int n2) {
        this.errorURI = string2;
        this.errorCode = n2;
        return this.produceFatalErrorEvent();
    }

    public final int attributeCount() {
        return this.attrCount;
    }

    private void throwAIOOBException(String string2) {
        throw new ArrayIndexOutOfBoundsException(string2);
    }

    public final QName attributeName(int n2) {
        if (n2 >= 0 && n2 < this.attrCount) {
            return this.fAttributeNames[n2];
        }
        this.throwAIOOBException("attributeName");
        return null;
    }

    public final String attributeType(int n2) {
        if (n2 >= 0 && n2 < this.attrCount) {
            return this.fAttributeTypes[n2];
        }
        this.throwAIOOBException("attributeType");
        return null;
    }

    public final XMLString unnormalizedAttributeValue(int n2) {
        return this.fAttributeValues[n2];
    }

    public final XMLString attributeValue(int n2) {
        if (n2 >= 0 && n2 < this.attrCount) {
            if (!this.fAttributeValueNormalized[n2]) {
                if (this.fAttValueStringBuffer == null) {
                    this.fAttValueStringBuffer = this.getAttValueStringBuffer();
                }
                this.fAttValueStringBuffer.normalizeTextValue(this.fAttributeValues[n2], null);
                this.fAttributeValueNormalized[n2] = true;
            }
            return this.fAttributeValues[n2];
        }
        this.throwAIOOBException("attributeValue");
        return null;
    }

    public final boolean attributeValueNormalized(int n2) {
        return this.fAttributeValueNormalized[n2];
    }

    public final boolean attributeSpecified(int n2) {
        if (n2 >= 0 && n2 < this.attrCount) {
            if (!this.fHasDefaultAttributes) {
                return true;
            }
            return this.fAttributeSpecified[n2];
        }
        this.throwAIOOBException("attributeSpecified");
        return false;
    }

    public final void normalizeAttributeValue(int n2) {
        if (this.fAttValueStringBuffer == null) {
            this.fAttValueStringBuffer = this.getAttValueStringBuffer();
        }
        this.fAttValueStringBuffer.normalizeTextValue(this.fAttributeValues[n2], null);
        this.fAttributeValueNormalized[n2] = true;
    }

    public final void setAttributeValueNormalized(int n2, boolean bl) {
        this.fAttributeValueNormalized[n2] = bl;
    }

    public final int nsDeclCount() {
        return this.fElementInfoStack.nsMappingsCount();
    }

    private NSMapping getLocalMappingAt(int n2) {
        int n3 = this.fElementInfoStack.nsMappingsCount();
        if (n2 >= 0 && n2 < n3) {
            NSMapping nSMapping = this.fElementInfoStack.nsMappings();
            int n4 = n3 - n2;
            while (--n4 > 0) {
                nSMapping = nSMapping.next;
            }
            return nSMapping;
        }
        return null;
    }

    public final String nsDeclPrefix(int n2) {
        NSMapping nSMapping = this.getLocalMappingAt(n2);
        if (nSMapping != null) {
            return nSMapping.prefix;
        }
        this.throwAIOOBException("nsDeclPrefix");
        return null;
    }

    public final String nsDeclURI(int n2) {
        NSMapping nSMapping = this.getLocalMappingAt(n2);
        if (nSMapping != null) {
            return nSMapping.nsURI;
        }
        this.throwAIOOBException("nsDeclURI");
        return null;
    }

    public final void setNSDeclURI(int n2, String string2) {
        NSMapping nSMapping = this.getLocalMappingAt(n2);
        if (nSMapping != null) {
            nSMapping.nsURI = string2;
        } else {
            this.throwAIOOBException("setNSDeclURI");
        }
    }

    public final String nsDeclQName(int n2) {
        NSMapping nSMapping = this.getLocalMappingAt(n2);
        if (nSMapping != null) {
            return nSMapping.rawName;
        }
        this.throwAIOOBException("nsDeclQName");
        return null;
    }

    public final String prefixMapping(String string2) {
        return this.fElementInfoStack.nsMappings().prefixMapping(string2);
    }

    public final int totalMappingsCount() {
        return this.fElementInfoStack.nsMappings().totalMappingsCount();
    }

    public final int inScopeNamespaces(String[] stringArray) {
        return this.fElementInfoStack.nsMappings().inScopeNamespaces(stringArray);
    }

    public final String prefixForNamespaceURI(String string2) {
        int n2 = this.totalMappingsCount();
        String[] stringArray = ArrayAllocator.newStringArray(n2 << 1);
        int n3 = this.inScopeNamespaces(stringArray) << 1;
        for (int i = 0; i < n3; i += 2) {
            if (stringArray[i + 1] != string2) continue;
            return stringArray[i];
        }
        return null;
    }

    public final int prefixesForNamespaceURI(String[] stringArray, String string2) {
        int n2 = 0;
        int n3 = this.totalMappingsCount();
        String[] stringArray2 = ArrayAllocator.newStringArray(n3 << 1);
        int n4 = this.inScopeNamespaces(stringArray2) << 1;
        for (int i = 0; i < n4; i += 2) {
            if (stringArray2[i + 1] != string2) continue;
            stringArray[n2++] = stringArray2[i];
        }
        return n2;
    }

    public final boolean createPrefixMapping(String string2, String string3, String string4, boolean bl) {
        boolean bl2;
        if (string2 != "") {
            if (string3 == "" && bl) {
                return this.namespaceNameEmpty(string2);
            }
            if (string2 == "xmlns") {
                return this.reportFatalError(54);
            }
            bl2 = false;
        } else {
            bl2 = true;
        }
        if (string3 == "http://www.w3.org/XML/1998/namespace") {
            if (string2 != "xml") {
                return this.illegalNamespaceURI(string2, string3);
            }
        } else {
            if (string2 == "xml") {
                return this.reportFatalError(51);
            }
            if (string3 == "http://www.w3.org/2000/xmlns/") {
                return this.illegalNamespaceURI(string2, string3);
            }
        }
        this.fElementInfoStack.createPrefixMapping(string2, string3, string4, bl2);
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n  element depth " + this.elementDepth);
            this.fElementInfoStack.dumpNSTables(stringBuilder);
            logger.logp(Level.FINEST, cn, "createPrefixMapping", this.scannerLabel() + ", " + "mapping table:" + stringBuilder.toString());
        }
        return true;
    }

    private boolean namespaceNameEmpty(String string2) {
        this.setParameter(0, string2);
        return this.reportFatalError(52);
    }

    private boolean illegalNamespaceURI(String string2, String string3) {
        this.setParameter(0, string2);
        this.setParameter(1, string3);
        return this.reportFatalError(53);
    }

    public final boolean checkDuplicateNamespaces(QName qName) {
        NSMapping nSMapping = this.fElementInfoStack.parentMappings();
        assert (nSMapping != null);
        NSMapping nSMapping2 = this.fElementInfoStack.nsMappings();
        while (nSMapping2.next != nSMapping) {
            assert (nSMapping2 != null);
            String string2 = nSMapping2.prefix;
            NSMapping nSMapping3 = nSMapping2.next;
            while (nSMapping3 != nSMapping) {
                assert (nSMapping3 != null);
                if (nSMapping3.prefix == string2) {
                    return this.duplicateNSDecl(qName, nSMapping2.rawName);
                }
                nSMapping3 = nSMapping3.next;
            }
            nSMapping2 = nSMapping2.next;
        }
        return true;
    }

    private boolean duplicateNSDecl(QName qName, String string2) {
        this.setParameter(0, qName);
        this.setParameter(1, string2);
        return this.reportFatalError(17);
    }

    public Object saveFragment() {
        DocumentScannerFragment documentScannerFragment = new DocumentScannerFragment();
        assert (this.fNeedPushElement);
        documentScannerFragment.sCurrentEvent = this.fCurrentEvent;
        documentScannerFragment.sCurrentState = this.fCurrentState;
        documentScannerFragment.sElementDepth = 1;
        documentScannerFragment.sElementQName = new QName(this.elementQName);
        documentScannerFragment.sIsNamespaceAware = this.fIsNamespaceAware;
        documentScannerFragment.sElementInfoStack = this.fElementInfoStack.createCopyForFragment();
        return documentScannerFragment;
    }

    public boolean loadFragment(Object object2) {
        DocumentScannerFragment documentScannerFragment = (DocumentScannerFragment)object2;
        this.setDocumentEntity(documentScannerFragment.sFragmentEntity);
        this.fIsNamespaceAware = documentScannerFragment.sIsNamespaceAware;
        this.fCurrentEvent = documentScannerFragment.sCurrentEvent;
        this.fCurrentState = documentScannerFragment.sCurrentState;
        this.fElementInfoStack = documentScannerFragment.sElementInfoStack;
        this.elementDepth = documentScannerFragment.sElementDepth;
        this.elementQName.setValues(documentScannerFragment.sElementQName);
        this.fCurrentEntityID = documentScannerFragment.sElementInfoStack.topOfStack().entityID;
        this.fNeedPushElement = true;
        this.setupRootElement();
        return true;
    }

    protected XMLStringBuffer getStringBuffer() {
        if (this.fStringBuffer == null) {
            this.fStringBuffer = new XMLStringBuffer();
        }
        return this.fStringBuffer;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class DocumentScannerFragment {
        public boolean sIsNamespaceAware;
        public int sCurrentEvent;
        public int sCurrentState;
        public ElementInfoStack sElementInfoStack;
        public ParsedEntity sFragmentEntity;
        public int sElementDepth;
        public QName sElementQName;

        public void reset() {
            if (this.sFragmentEntity != null) {
                this.sFragmentEntity.clear();
            }
            if (this.sElementQName != null) {
                this.sElementQName.unregister();
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class Referrer
    extends DataBufferReferrer {
        DataBuffer fCurrentEventFirstBuffer;

        private Referrer() {
        }

        public boolean hasReferenceTo(DataBuffer dataBuffer) {
            return dataBuffer == this.fCurrentEventFirstBuffer;
        }

        public void removeReferencesAndUnregister() {
            this.fCurrentEventFirstBuffer = null;
            this.factory.removeReferrer(this);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class ElementInfo {
        private final ElementInfoStack fStack;
        private final ElementInfo fParent;
        private ElementInfo fChild;
        Symbol elementSymbol;
        String nsURI;
        int entityID;
        boolean inElementContent;
        int nsMappingsCount;
        NSMapping nsMappings;
        String defaultNamespace;

        ElementInfo(ElementInfoStack elementInfoStack, ElementInfo elementInfo) {
            this.fStack = elementInfoStack;
            this.fParent = elementInfo;
        }

        ElementInfo moveToRoot() {
            ElementInfo elementInfo = this;
            while (elementInfo.fParent != null) {
                elementInfo = elementInfo.moveToParent();
            }
            elementInfo = elementInfo.moveToChild();
            return elementInfo;
        }

        ElementInfo moveToChild() {
            if (this.fChild == null) {
                this.fChild = new ElementInfo(this.fStack, this);
            } else {
                this.fChild.elementSymbol = null;
                this.fChild.nsURI = null;
                this.fChild.entityID = 0;
                this.fChild.inElementContent = false;
            }
            this.fChild.resetNamespacesScope();
            return this.fChild;
        }

        ElementInfo moveToParent() {
            while (this.nsMappingsCount > 0) {
                NSMapping nSMapping = this.nsMappings;
                this.nsMappings = nSMapping.next;
                --this.nsMappingsCount;
                this.fStack.deallocateNSMapping(nSMapping);
            }
            assert (this.nsMappings != null);
            assert (this.nsMappings == this.fParent.nsMappings);
            return this.fParent;
        }

        void resetNamespacesScope() {
            this.nsMappingsCount = 0;
            this.nsMappings = this.fParent.nsMappings;
            this.defaultNamespace = this.fParent.defaultNamespace;
        }

        NSMapping createPrefixMapping(String string2, String string3, String string4, boolean bl) {
            NSMapping nSMapping = this.internalCreateMapping(null, string2, string3, string4, bl);
            return nSMapping;
        }

        void copyNSMappings(NSMapping nSMapping) {
            assert (this.nsMappings.prefix == "xml");
            NSMapping nSMapping2 = null;
            while (nSMapping.prefix != "xml") {
                nSMapping2 = this.internalCreateMapping(nSMapping2, nSMapping.prefix, nSMapping.nsURI, nSMapping.rawName, false);
                nSMapping = nSMapping.next;
            }
        }

        private NSMapping internalCreateMapping(NSMapping nSMapping, String string2, String string3, String string4, boolean bl) {
            NSMapping nSMapping2 = this.fStack.allocateNSMapping();
            nSMapping2.prefix = string2;
            nSMapping2.nsURI = string3;
            nSMapping2.rawName = string4;
            if (nSMapping == null) {
                nSMapping2.next = this.nsMappings;
                this.nsMappings = nSMapping2;
            } else {
                nSMapping2.next = nSMapping.next;
                nSMapping.next = nSMapping2;
            }
            assert (nSMapping2.next != null);
            ++this.nsMappingsCount;
            if (bl) {
                this.defaultNamespace = string3;
            }
            return nSMapping2;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class ElementInfoStack {
        private ElementInfo fTop;
        private NSMapping fFreeNSMappings;

        ElementInfoStack() {
            ElementInfo elementInfo = new ElementInfo(this, null);
            elementInfo.nsMappingsCount = 1;
            elementInfo.nsMappings = NSMapping.createRootMappings();
            elementInfo.defaultNamespace = "";
            this.fTop = elementInfo.moveToChild();
        }

        ElementInfo topOfStack() {
            return this.fTop;
        }

        void moveToRoot() {
            this.fTop = this.fTop.moveToRoot();
        }

        void moveToChild() {
            this.fTop = this.fTop.moveToChild();
        }

        void moveToParent() {
            this.fTop = this.fTop.moveToParent();
        }

        void resetNamespacesScope() {
            this.fTop.resetNamespacesScope();
        }

        Symbol elementSymbol() {
            return this.fTop.elementSymbol;
        }

        void setElementSymbol(Symbol symbol) {
            this.fTop.elementSymbol = symbol;
        }

        int nsMappingsCount() {
            return this.fTop.nsMappingsCount;
        }

        NSMapping nsMappings() {
            return this.fTop.nsMappings;
        }

        NSMapping parentMappings() {
            return ((ElementInfo)this.fTop).fParent.nsMappings;
        }

        String defaultNamespace() {
            return this.fTop.defaultNamespace;
        }

        NSMapping createPrefixMapping(String string2, String string3, String string4, boolean bl) {
            return this.fTop.createPrefixMapping(string2, string3, string4, bl);
        }

        protected void deallocateNSMapping(NSMapping nSMapping) {
            nSMapping.rawName = null;
            nSMapping.nsURI = null;
            nSMapping.prefix = null;
            nSMapping.next = this.fFreeNSMappings;
            this.fFreeNSMappings = nSMapping;
        }

        protected NSMapping allocateNSMapping() {
            NSMapping nSMapping = this.fFreeNSMappings;
            if (nSMapping != null) {
                this.fFreeNSMappings = nSMapping.next;
                nSMapping.next = null;
                return nSMapping;
            }
            return new NSMapping();
        }

        private String symbolString(String string2) {
            if (string2 == null) {
                return "null";
            }
            return "\"" + string2 + "\"";
        }

        void dumpNSTables(StringBuilder stringBuilder) {
            ElementInfo elementInfo = this.fTop;
            while (elementInfo.fParent != null) {
                String string2 = elementInfo.elementSymbol != null ? elementInfo.elementSymbol.str : "<<unknown>>";
                stringBuilder.append("\n  mappings for " + string2 + ", count " + elementInfo.nsMappingsCount);
                stringBuilder.append("\n    defaultNamespace " + this.symbolString(elementInfo.defaultNamespace));
                NSMapping nSMapping = elementInfo.nsMappings;
                while (nSMapping != ((ElementInfo)elementInfo).fParent.nsMappings) {
                    if (nSMapping == null) {
                        stringBuilder.append("\n    mapping is null");
                        break;
                    }
                    stringBuilder.append("\n    mapping: prefix " + this.symbolString(nSMapping.prefix));
                    stringBuilder.append("\n             nsURI " + this.symbolString(nSMapping.nsURI));
                    stringBuilder.append("\n             rawName " + this.symbolString(nSMapping.rawName));
                    nSMapping = nSMapping.next;
                }
                elementInfo = elementInfo.fParent;
            }
        }

        public ElementInfoStack createCopyForFragment() {
            ElementInfoStack elementInfoStack = new ElementInfoStack();
            ElementInfo elementInfo = elementInfoStack.topOfStack();
            elementInfo.elementSymbol = this.fTop.elementSymbol;
            elementInfo.inElementContent = this.fTop.inElementContent;
            elementInfo.nsURI = this.fTop.nsURI;
            elementInfo.nsMappingsCount = 0;
            elementInfo.defaultNamespace = this.fTop.defaultNamespace;
            elementInfo.copyNSMappings(this.fTop.nsMappings);
            return elementInfoStack;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class NSMapping {
        public NSMapping next;
        public String prefix;
        public String nsURI;
        public String rawName;

        NSMapping() {
        }

        static NSMapping createRootMappings() {
            NSMapping nSMapping = new NSMapping();
            nSMapping.prefix = "xml";
            nSMapping.nsURI = "http://www.w3.org/XML/1998/namespace";
            nSMapping.rawName = null;
            return nSMapping;
        }

        public String prefixMapping(String string2) {
            NSMapping nSMapping = this;
            while (nSMapping != null) {
                if (nSMapping.prefix == string2) {
                    return nSMapping.nsURI;
                }
                nSMapping = nSMapping.next;
            }
            return null;
        }

        public int totalMappingsCount() {
            int n2 = 0;
            NSMapping nSMapping = this;
            while (nSMapping != null) {
                ++n2;
                nSMapping = nSMapping.next;
            }
            return n2;
        }

        public int inScopeNamespaces(String[] stringArray) {
            int n2 = 0;
            NSMapping nSMapping = this;
            while (nSMapping != null) {
                String string2 = nSMapping.prefix;
                boolean bl = false;
                for (int i = 0; i < n2; i += 2) {
                    if (stringArray[i] != string2) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    stringArray[n2++] = string2;
                    stringArray[n2++] = nSMapping.nsURI;
                }
                nSMapping = nSMapping.next;
            }
            return n2 >> 1;
        }
    }
}

