/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.lang.reflect.Array;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class ArrayAllocator {
    private static final String cn = ArrayAllocator.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(ArrayAllocator.class);

    public static boolean[] newBooleanArray(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newBooleanArray", Integer.toString(n2));
        }
        return new boolean[n2];
    }

    public static byte[] newByteArray(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newByteArray", Integer.toString(n2));
        }
        return new byte[n2];
    }

    public static char[] newCharArray(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newCharArray", Integer.toString(n2));
        }
        return new char[n2];
    }

    public static char[][] newCharArray2(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newCharArray2", Integer.toString(n2));
        }
        return new char[n2][];
    }

    public static int[] newIntArray(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newIntArray", Integer.toString(n2));
        }
        return new int[n2];
    }

    public static int[][] newIntArray2(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newIntArray2", Integer.toString(n2));
        }
        return new int[n2][];
    }

    public static String[] newStringArray(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newStringArray", Integer.toString(n2));
        }
        return new String[n2];
    }

    public static String[][] newStringArray2(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newStringArray2", Integer.toString(n2));
        }
        return new String[n2][];
    }

    public static Object[] newObjectArray(int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "newObjectArray", Integer.toString(n2));
        }
        return new Object[n2];
    }

    public static <T> T[] newObjectArray(Class<T> clazz, int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            Object[] objectArray = new Object[]{clazz.getName(), Integer.toString(n2)};
            logger.entering(cn, "newObjectArray", objectArray);
        }
        return (Object[])Array.newInstance(clazz, n2);
    }

    public static void freeByteArray(byte[] byArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "freeByteArray", "byte[] array");
        }
    }

    public static void freeIntArray(int[] nArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "freeIntArray", "int[] array");
        }
    }

    public static <T> void freeObjectArray(Class<T> clazz, T[] TArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            Object[] objectArray = new Object[]{clazz.getName(), "T[] array"};
            logger.entering(cn, "freeObjectArray", objectArray);
        }
    }

    public static int[] copyIntArray(int[] nArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "copyIntArray", "int[] array");
        }
        return (int[])nArray.clone();
    }

    public static String[] copyStringArray(String[] stringArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "copyStringArray", "String[] array");
        }
        return (String[])stringArray.clone();
    }

    public static byte[] replaceByteArray(byte[] byArray, int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            Object[] objectArray = new Object[]{"byte[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "replaceByteArray", objectArray);
        }
        return new byte[n2];
    }

    public static char[] replaceCharArray(char[] cArray, int n2) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            Object[] objectArray = new Object[]{"char[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "replaceCharArray", objectArray);
        }
        return new char[n2];
    }

    public static int[] replaceIntArray(int[] nArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{"int[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "replaceIntArray", objectArray);
        }
        objectArray = new int[n2];
        return objectArray;
    }

    public static boolean[] resizeBooleanArray(boolean[] blArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{"boolean[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeBooleanArray", objectArray);
        }
        objectArray = new boolean[n2];
        System.arraycopy(blArray, 0, objectArray, 0, blArray.length);
        return objectArray;
    }

    public static byte[] resizeByteArray(byte[] byArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{"byte[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeByteArray", objectArray);
        }
        objectArray = new byte[n2];
        System.arraycopy(byArray, 0, objectArray, 0, byArray.length);
        return objectArray;
    }

    public static char[] resizeCharArray(char[] cArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{"char[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeCharArray", objectArray);
        }
        objectArray = new char[n2];
        System.arraycopy(cArray, 0, objectArray, 0, cArray.length);
        return objectArray;
    }

    public static int[] resizeIntArray(int[] nArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{"int[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeIntArray", objectArray);
        }
        objectArray = new int[n2];
        System.arraycopy(nArray, 0, objectArray, 0, nArray.length);
        return objectArray;
    }

    public static String[] resizeStringArray(String[] stringArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{"String[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeStringArray", objectArray);
        }
        objectArray = new String[n2];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        return objectArray;
    }

    public static String[][] resizeStringArray2(String[][] stringArray, int n2) {
        String[][] stringArray2;
        if (LoggerUtil.isEntryLoggable(logger)) {
            stringArray2 = new Object[]{"String[][] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeStringArray2", (Object[])stringArray2);
        }
        stringArray2 = new String[n2][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static Object[] resizeObjectArray(Object[] objectArray, int n2) {
        Object[] objectArray2;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray2 = new Object[]{"Object[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeObjectArray", objectArray2);
        }
        objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static <T> T[] resizeObjectArray(Class<T> clazz, T[] TArray, int n2) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{clazz.getName(), "T[] oldArray", Integer.toString(n2)};
            logger.entering(cn, "resizeObjectArray", objectArray);
        }
        objectArray = (Object[])Array.newInstance(clazz, n2);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        return objectArray;
    }

    public static char[] checkCharArray(char[] cArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "checkCharArray", "char[] array");
        }
        return cArray;
    }

    public static Object[] checkObjectArray(Object[] objectArray) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "checkObjectArray", "Object[] array");
        }
        return objectArray;
    }
}

