/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.Pool;
import com.ibm.xml.xlxp.internal.s1.util.XLXPCounters;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ByteArrayPool {
    private static final String cn = ByteArrayPool.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(ByteArrayPool.class);
    private static final String[] counterNames = new String[]{"smallArrayRequests", "smallArrayAllocations", "smallArrayReturns", "largeArrayRequests", "largeArrayAllocations", "largeArrayReturns"};
    private static final XLXPCounters.CounterProvider fgCounterProvider = new XLXPCounters.CounterProvider(cn, counterNames){

        public int[] getCounters(boolean bl) {
            this.counters[0] = fgSmallByteArrayRequestCount;
            this.counters[1] = fgSmallByteArrayAllocationCount;
            this.counters[2] = fgSmallByteArrayReturnCount;
            this.counters[3] = fgLargeByteArrayRequestCount;
            this.counters[4] = fgLargeByteArrayAllocationCount;
            this.counters[5] = fgLargeByteArrayReturnCount;
            if (bl) {
                fgSmallByteArrayRequestCount = 0;
                fgSmallByteArrayAllocationCount = 0;
                fgSmallByteArrayReturnCount = 0;
                fgLargeByteArrayRequestCount = 0;
                fgLargeByteArrayAllocationCount = 0;
                fgLargeByteArrayReturnCount = 0;
            }
            return this.counters;
        }
    };
    private static final int DEFAULT_SMALL_BYTE_ARRAY_SIZE = 8192;
    private static final int DEFAULT_LARGE_BYTE_ARRAY_SIZE = 65536;
    public static final int SMALL_BYTE_ARRAY_SIZE = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            try {
                return Integer.getInteger("com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool.smallByteArraySize", 8192);
            }
            catch (SecurityException securityException) {
                return 8192;
            }
        }
    });
    public static final int LARGE_BYTE_ARRAY_SIZE = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            try {
                return Integer.getInteger("com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool.largeByteArraySize", 65536);
            }
            catch (SecurityException securityException) {
                return 65536;
            }
        }
    });
    private static final Pool<byte[]> fgSmallFreeByteArrayPool = new Pool("byte[]");
    private static final Pool<byte[]> fgLargeFreeByteArrayPool = new Pool("byte[]");
    private static int fgSmallByteArrayRequestCount;
    private static int fgSmallByteArrayAllocationCount;
    private static int fgSmallByteArrayReturnCount;
    private static int fgLargeByteArrayRequestCount;
    private static int fgLargeByteArrayAllocationCount;
    private static int fgLargeByteArrayReturnCount;

    private static String xlxpThreadLabel() {
        return "***XLXP[" + Thread.currentThread().getId() + "]*** ";
    }

    public static byte[] allocateSmallByteArray() {
        boolean bl;
        boolean bl2;
        ++fgSmallByteArrayRequestCount;
        byte[] byArray = fgSmallFreeByteArrayPool.get();
        boolean bl3 = bl2 = byArray != null;
        if (bl2) {
            bl = LoggerUtil.isFinerLoggable(logger);
        } else {
            bl = LoggerUtil.isFineLoggable(logger);
            ++fgSmallByteArrayAllocationCount;
            byArray = ArrayAllocator.newByteArray(SMALL_BYTE_ARRAY_SIZE + 1);
        }
        if (bl) {
            logger.logp(Level.FINE, cn, "allocateSmallByteArray", ByteArrayPool.xlxpThreadLabel() + "[" + fgSmallByteArrayAllocationCount + "/" + fgSmallByteArrayRequestCount + "] " + (bl2 ? "recycled" : "created") + " instance " + LoggerUtil.getUniqueString(byArray));
        }
        return byArray;
    }

    public static byte[] allocateLargeByteArray() {
        boolean bl;
        boolean bl2;
        ++fgLargeByteArrayRequestCount;
        byte[] byArray = fgLargeFreeByteArrayPool.get();
        boolean bl3 = bl2 = byArray != null;
        if (bl2) {
            bl = LoggerUtil.isFinerLoggable(logger);
        } else {
            bl = LoggerUtil.isFineLoggable(logger);
            ++fgLargeByteArrayAllocationCount;
            byArray = ArrayAllocator.newByteArray(LARGE_BYTE_ARRAY_SIZE + 1);
        }
        if (bl) {
            logger.logp(Level.FINE, cn, "allocateLargeByteArray", ByteArrayPool.xlxpThreadLabel() + "[" + fgLargeByteArrayAllocationCount + "/" + fgLargeByteArrayRequestCount + "] " + (bl2 ? "recycled" : "created") + " instance " + LoggerUtil.getUniqueString(byArray));
        }
        return byArray;
    }

    public static void deallocateSmallByteArray(byte[] byArray) {
        fgSmallFreeByteArrayPool.put(byArray);
        ++fgSmallByteArrayReturnCount;
    }

    public static void deallocateLargeByteArray(byte[] byArray) {
        fgLargeFreeByteArrayPool.put(byArray);
        ++fgLargeByteArrayReturnCount;
    }

    private ByteArrayPool() {
    }
}

