/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public interface ByteConversionHandler {
    public void receiveByte(byte var1);

    public void receiveBytes(byte[] var1, int var2, int var3, boolean var4);

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class ByteBufferHandler
    implements ByteConversionHandler {
        private final ByteBuffer bb;

        public ByteBufferHandler(ByteBuffer byteBuffer) {
            this.bb = byteBuffer;
        }

        public void receiveByte(byte by2) {
            this.bb.put(by2);
        }

        public void receiveBytes(byte[] byArray, int n2, int n3, boolean bl) {
            this.bb.put(byArray, n2, n3);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class FixedLengthByteArrayHandler
    implements ByteConversionHandler {
        private final byte[] bytes;
        private int offset;

        public FixedLengthByteArrayHandler(byte[] byArray) {
            this(byArray, 0);
        }

        public FixedLengthByteArrayHandler(byte[] byArray, int n2) {
            this.bytes = byArray;
            this.offset = n2;
        }

        public void receiveByte(byte by2) {
            this.bytes[this.offset++] = by2;
        }

        public void receiveBytes(byte[] byArray, int n2, int n3, boolean bl) {
            System.arraycopy(byArray, n2, this.bytes, this.offset, n3);
            this.offset += n3;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class OutputStreamHandler
    implements ByteConversionHandler {
        private final OutputStream os;

        public OutputStreamHandler(OutputStream outputStream) {
            this.os = outputStream;
        }

        public void receiveByte(byte by2) {
            try {
                this.os.write(by2);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }

        public void receiveBytes(byte[] byArray, int n2, int n3, boolean bl) {
            try {
                this.os.write(byArray, n2, n3);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }
    }
}

