/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProvider;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProviderRegistry;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class CharConversionError {
    private static final String cn = CharConversionError.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(CharConversionError.class);
    private final int errorCode;
    private final int[] errorArgs;
    private final IOException exception;

    public CharConversionException asCharConversionException() {
        if (this.exception == null) {
            return new CharConversionException(this.formatErrorMessage());
        }
        if (this.exception instanceof CharConversionException) {
            return (CharConversionException)this.exception;
        }
        CharConversionException charConversionException = new CharConversionException(this.exception.getMessage());
        charConversionException.initCause(this.exception);
        return charConversionException;
    }

    public String formatErrorMessage() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider("http://w3.xml.ibm.com/#XLXP");
        int n2 = this.errorArgs == null ? 0 : this.errorArgs.length;
        Object[] objectArray = this.errorArgs == null ? null : new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = Integer.toHexString(this.errorArgs[i]);
        }
        return messageProvider.createMessage(null, this.errorCode, objectArray);
    }

    public static CharConversionError unableToConvertOutOfRangeUnicodeCharacter() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "unableToConvertOutOfRangeUnicodeCharacter");
        }
        return new CharConversionError(0);
    }

    public static CharConversionError insufficientInputToDecodeCharacter() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "insufficientInputToDecodeCharacter");
        }
        return new CharConversionError(1);
    }

    public static CharConversionError missingSecondHalfOfSurrogatePair() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "missingSecondHalfOfSurrogatePair");
        }
        return new CharConversionError(2);
    }

    public static CharConversionError invalidSecondHalfOfSurrogatePair() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "invalidSecondHalfOfSurrogatePair");
        }
        return new CharConversionError(3);
    }

    public static CharConversionError invalidFirstHalfOfSurrogatePair() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "invalidFirstHalfOfSurrogatePair");
        }
        return new CharConversionError(4);
    }

    public static CharConversionError byteOrderMarkRequired() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "byteOrderMarkRequired");
        }
        return new CharConversionError(5);
    }

    public static CharConversionError invalidUTF8SurrogateEncoding() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "invalidUTF8SurrogateEncoding");
        }
        return new CharConversionError(6);
    }

    public static CharConversionError partialMultiPartCharacterSequence() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "partialMultiPartCharacterSequence");
        }
        return new CharConversionError(7);
    }

    public static CharConversionError inconsistentEncoding() {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "inconsistentEncoding");
        }
        return new CharConversionError(8);
    }

    public static CharConversionError runtimeIOError(IOException iOException) {
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "runtimeIOError", iOException);
        }
        return new CharConversionError(10, null, iOException);
    }

    public static CharConversionError invalidUTF8CharacterEncoding(int n2, int n3, int n4, int n5, int n6) {
        Object[] objectArray;
        if (LoggerUtil.isEntryLoggable(logger)) {
            objectArray = new Object[]{n2, n3, n4, n5, n6};
            logger.entering(cn, "invalidUTF8CharacterEncoding", objectArray);
        }
        objectArray = new int[]{n2, n3, n4, n5, n6};
        return new CharConversionError(9, (int[])objectArray, null);
    }

    private CharConversionError(int n2) {
        this.errorCode = n2;
        this.errorArgs = null;
        this.exception = null;
    }

    private CharConversionError(int n2, int[] nArray, IOException iOException) {
        this.errorCode = n2;
        this.errorArgs = nArray;
        this.exception = iOException;
    }
}

