/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public interface CharConversionHandler {
    public void receiveChar(char var1);

    public void receiveChars(char[] var1, int var2, int var3, boolean var4);

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class AppendableHandler
    implements CharConversionHandler {
        private final Appendable a;

        public AppendableHandler(Appendable appendable) {
            this.a = appendable;
        }

        public void receiveChar(char c) {
            try {
                this.a.append(c);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }

        public void receiveChars(char[] cArray, int n2, int n3, boolean bl) {
            try {
                this.a.append(CharBuffer.wrap(cArray, n2, n3));
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class FixedLengthCharArrayHandler
    implements CharConversionHandler {
        private final char[] chars;
        private int offset;

        public FixedLengthCharArrayHandler(char[] cArray) {
            this(cArray, 0);
        }

        public FixedLengthCharArrayHandler(char[] cArray, int n2) {
            this.chars = cArray;
            this.offset = n2;
        }

        public void receiveChar(char c) {
            this.chars[this.offset++] = c;
        }

        public void receiveChars(char[] cArray, int n2, int n3, boolean bl) {
            System.arraycopy(cArray, n2, this.chars, this.offset, n3);
            this.offset += n3;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class StringBuilderHandler
    implements CharConversionHandler {
        private final StringBuilder sb;

        public StringBuilderHandler(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        public void receiveChar(char c) {
            this.sb.append(c);
        }

        public void receiveChars(char[] cArray, int n2, int n3, boolean bl) {
            this.sb.append(cArray, n2, n3);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class WriterHandler
    implements CharConversionHandler {
        private final Writer w;

        public WriterHandler(Writer writer) {
            this.w = writer;
        }

        public void receiveChar(char c) {
            try {
                this.w.write(c);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }

        public void receiveChars(char[] cArray, int n2, int n3, boolean bl) {
            try {
                this.w.write(cArray, n2, n3);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class StringHandler
    implements CharConversionHandler {
        private String string;
        private StringBuilder builder;
        private int builderLength;

        public StringHandler() {
        }

        public StringHandler(int n2) {
            this.initialize(n2);
        }

        public void initialize(int n2) {
            this.builderLength = n2;
            this.string = null;
            this.builder = null;
        }

        public void receiveChar(char c) {
            if (this.builder == null) {
                this.builder = new StringBuilder(Math.max(this.builderLength, 16));
            }
            this.builder.append(c);
        }

        public void receiveChars(char[] cArray, int n2, int n3, boolean bl) {
            if (this.builder == null) {
                if (this.string == null && bl) {
                    this.string = new String(cArray, n2, n3);
                    return;
                }
                this.builder = new StringBuilder(Math.max(this.builderLength, n3));
                if (this.string != null) {
                    this.builder.append(this.string);
                    this.string = null;
                }
            }
            this.builder.append(cArray, n2, n3);
        }

        public String toString() {
            if (this.string != null) {
                return this.string;
            }
            if (this.builder != null) {
                return this.builder.toString();
            }
            return null;
        }
    }
}

