/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.DTDGrammarCache;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.ErrorReporter;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DTDGrammar {
    protected SymbolTable fSymbolTable;
    private XMLStringBuffer fStringBuffer;
    protected EntityDeclPool fEntityDeclPool;
    protected XMLString fTempString;
    protected ArrayList<String> fEnumerationTypeList;
    private boolean fHaveAttDefs;
    private HashMap<String, List<AttDef>> fAttDefs;
    private boolean fHaveElementContentElements;
    private HashSet<String> fElementContentElements;

    public DTDGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fStringBuffer = new XMLStringBuffer();
        this.fEntityDeclPool = new EntityDeclPool(this.fSymbolTable, this.fStringBuffer);
        this.fTempString = new XMLString();
    }

    public void reset(boolean bl) {
        this.fEntityDeclPool.reset(bl);
        this.fStringBuffer.reset(bl);
        if (this.fHaveElementContentElements) {
            this.fElementContentElements.clear();
            this.fHaveElementContentElements = false;
            if (!bl) {
                this.fElementContentElements = null;
            }
        }
        if (this.fHaveAttDefs) {
            Collection<List<AttDef>> collection2 = this.fAttDefs.values();
            for (List<AttDef> list : collection2) {
                for (AttDef attDef : list) {
                    attDef.attrName.unregister();
                    if (attDef.attValue == null) continue;
                    attDef.attValue.unregister();
                }
            }
            this.fAttDefs.clear();
            this.fHaveAttDefs = false;
        }
    }

    public EntityDeclPool getEntityDeclPool() {
        return this.fEntityDeclPool;
    }

    public XMLStringBuffer getStringBuffer() {
        return this.fStringBuffer;
    }

    public void addGrammarToCache(DTDGrammarCache dTDGrammarCache, XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        dTDGrammarCache.addGrammar(this, xMLString, xMLString2, xMLString3);
    }

    public boolean hasElementContentElements() {
        return this.fHaveElementContentElements;
    }

    public boolean hasElementContent(String string2) {
        return this.fElementContentElements.contains(string2);
    }

    public void setElementContentElement(String string2) {
        if (this.fElementContentElements == null) {
            this.fElementContentElements = new HashSet();
        }
        this.fElementContentElements.add(string2);
        this.fHaveElementContentElements = true;
    }

    public boolean hasAttDefs() {
        return this.fHaveAttDefs;
    }

    public boolean addDefaultAttributes(DocumentScanner documentScanner, boolean bl, boolean bl2) {
        List<AttDef> list = this.getAttDefs(documentScanner.elementQName.rawName);
        if (list == null) {
            return true;
        }
        String string2 = "xmlns";
        int n2 = documentScanner.attributeCount();
        int n3 = bl ? documentScanner.nsDeclCount() : 0;
        for (AttDef attDef : list) {
            XMLString xMLString;
            Object object2;
            int n4;
            boolean bl3;
            String string3 = attDef.attType;
            String string4 = attDef.defaultType;
            XMLString xMLString2 = attDef.attValue;
            boolean bl4 = xMLString2 != null;
            boolean bl5 = string3 != "CDATA";
            boolean bl6 = bl3 = string4 == "#REQUIRED";
            if (!bl4 && !bl5 && !bl3) continue;
            QName qName = attDef.attrName;
            boolean bl7 = false;
            if (bl && (qName.localName == string2 || qName.prefix == string2)) {
                for (n4 = 0; n4 < n3; ++n4) {
                    object2 = documentScanner.nsDeclQName(n4);
                    if (qName.rawName != object2) continue;
                    if (bl5) {
                        this.normalizeNSDeclURI(documentScanner, n4);
                    }
                    if (string4 == "#FIXED") {
                        xMLString = xMLString2;
                        this.fSymbolTable.addSymbolSetValues(documentScanner.nsDeclURI(n4), this.fTempString);
                        if (!this.checkFixedAttValue(documentScanner, qName, this.fTempString, xMLString)) {
                            return false;
                        }
                    }
                    bl7 = true;
                    break;
                }
                if (bl7) continue;
                if (bl3 && !this.requiredAttributeNotSpecified(documentScanner, qName)) {
                    return false;
                }
                if (!bl4 || this.addDefaultNSDecl(documentScanner, qName, xMLString2, attDef, bl2)) continue;
                return false;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (qName.rawName != documentScanner.attributeName((int)n4).rawName) continue;
                if (bl5) {
                    this.normalizeAttributeValue(documentScanner, n4);
                    documentScanner.setAttributeType(n4, string3);
                }
                if (string4 == "#FIXED" && !this.checkFixedAttValue(documentScanner, qName, (XMLString)(object2 = documentScanner.attributeValue(n4)), xMLString = xMLString2)) {
                    return false;
                }
                bl7 = true;
                break;
            }
            if (bl7) continue;
            if (bl3 && !this.requiredAttributeNotSpecified(documentScanner, qName)) {
                return false;
            }
            if (!bl4 || this.addDefaultAttribute(documentScanner, qName, string3, xMLString2, attDef, bl2)) continue;
            return false;
        }
        return true;
    }

    protected void normalizeNSDeclURI(DocumentScanner documentScanner, int n2) {
        this.fStringBuffer.addString(documentScanner.nsDeclURI(n2), this.fTempString);
        this.fStringBuffer.normalizeTextValue(this.fTempString, null);
        documentScanner.setNSDeclURI(n2, this.fSymbolTable.addSymbol(this.fTempString));
    }

    protected void normalizeAttributeValue(DocumentScanner documentScanner, int n2) {
        documentScanner.setAttributeValueNormalized(n2, false);
    }

    protected boolean checkFixedAttValue(DocumentScanner documentScanner, QName qName, XMLString xMLString, XMLString xMLString2) {
        return true;
    }

    protected boolean requiredAttributeNotSpecified(DocumentScanner documentScanner, QName qName) {
        return true;
    }

    protected boolean addDefaultNSDecl(DocumentScanner documentScanner, QName qName, XMLString xMLString, AttDef attDef, boolean bl) {
        return documentScanner.addDefaultNSDecl(qName, xMLString);
    }

    protected boolean addDefaultAttribute(DocumentScanner documentScanner, QName qName, String string2, XMLString xMLString, AttDef attDef, boolean bl) {
        return documentScanner.addDefaultAttribute(qName, string2, xMLString);
    }

    protected List<AttDef> getAttDefs(String string2) {
        if (this.fHaveAttDefs) {
            return this.fAttDefs.get(string2);
        }
        return null;
    }

    public AttDef lookupAttDef(QName qName, QName qName2) {
        List<AttDef> list;
        if (this.fHaveAttDefs && (list = this.fAttDefs.get(qName.rawName)) != null) {
            String string2 = qName2.rawName;
            for (AttDef attDef : list) {
                if (string2 != attDef.attrName.rawName) continue;
                return attDef;
            }
        }
        return null;
    }

    public void startAttDef(QName qName, XMLString xMLString) {
        this.fEnumerationTypeList = new ArrayList();
    }

    public void enumerationType(String string2, ErrorReporter errorReporter) {
        this.fEnumerationTypeList.add(string2);
    }

    private void shareQNameValues(QName qName, QName qName2) {
        if (qName.rawName != null) {
            this.fSymbolTable.addSymbolSetValues(qName.rawName, (XMLString)qName2);
            qName2.rawName = qName.rawName;
            qName2.prefix = qName.prefix;
            qName2.nsURI = qName.nsURI;
            qName2.localName = qName.localName;
        } else {
            qName2.clear();
        }
    }

    public void saveAttDef(QName qName, QName qName2, XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl, ErrorReporter errorReporter, boolean bl2) {
        List<AttDef> list;
        AttDef attDef = new AttDef();
        attDef.attrName = new QName();
        this.shareQNameValues(qName2, attDef.attrName);
        attDef.attType = xMLString != null ? this.fSymbolTable.addSymbol(xMLString) : null;
        attDef.defaultType = xMLString2 != null ? this.fSymbolTable.addSymbol(xMLString2) : null;
        attDef.enumTypeList = this.fEnumerationTypeList;
        this.fEnumerationTypeList = null;
        if (xMLString3 != null) {
            if (attDef.attType != "CDATA") {
                this.normalizeDefaultAttValue(qName2, xMLString3, attDef.attType, attDef, errorReporter, bl2);
            }
            attDef.attValue = new XMLString();
            this.fStringBuffer.addXMLString(xMLString3, attDef.attValue);
        } else {
            attDef.attValue = null;
        }
        attDef.external = bl;
        List<AttDef> list2 = list = this.fHaveAttDefs ? this.fAttDefs.get(qName.rawName) : null;
        if (list == null) {
            list = new ArrayList<AttDef>();
            if (this.fAttDefs == null) {
                this.fAttDefs = new HashMap();
            }
            this.fAttDefs.put(qName.rawName, list);
            this.fHaveAttDefs = true;
        }
        list.add(attDef);
    }

    protected void normalizeDefaultAttValue(QName qName, XMLString xMLString, String string2, AttDef attDef, ErrorReporter errorReporter, boolean bl) {
        this.fStringBuffer.normalizeTextValue(xMLString, null);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class AttDef {
        public QName attrName;
        public String attType;
        public String defaultType;
        public ArrayList<String> enumTypeList;
        public XMLString attValue;
        public boolean external;
    }
}

