/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import java.io.CharConversionException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class DataBuffer {
    public final DataBufferFactory factory;
    public final byte[] bytes;
    public int startOffset;
    public int endOffset;
    public DataBuffer next;
    public int lineNumber = 1;
    public int columnNumber = 1;
    public int byteOffset = -1;
    public int startPosIncrement = 0;
    public final int id;
    private static int fgBufferIdCounter;

    public DataBuffer(DataBufferFactory dataBufferFactory, int n2) {
        this(dataBufferFactory, ArrayAllocator.newByteArray(n2));
    }

    public DataBuffer(DataBufferFactory dataBufferFactory, byte[] byArray) {
        this.factory = dataBufferFactory;
        this.id = ++fgBufferIdCounter;
        this.bytes = byArray;
    }

    public int lengthToEndPosition(int n2, DataBuffer dataBuffer, int n3) {
        if (dataBuffer == this) {
            return n3 - n2;
        }
        int n4 = this.endOffset - n2;
        DataBuffer dataBuffer2 = this.next;
        while (dataBuffer2 != dataBuffer) {
            n4 += dataBuffer2.endOffset - dataBuffer2.startOffset;
            dataBuffer2 = dataBuffer2.next;
        }
        return n4 += n3 - dataBuffer2.startOffset;
    }

    public final int convertToChars(int n2, int n3, int n4, CharConversionHandler charConversionHandler) throws CharConversionException {
        return UTF8Support.convertBytesToChars(this, n2, n3, n4, charConversionHandler);
    }

    public final String toString(int n2, int n3, int n4) throws CharConversionException {
        String string2 = UTF8Support.toString(this, n2, n3, n4);
        return string2;
    }
}

