/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.api.util.DataBufferHelper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataSource;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DataBufferInputStream
extends InputStream
implements DataSource {
    private DataBuffer fBuffers;
    private DataBuffer fCurrentBuffer;
    private int fOffset;
    private int fEndOffset;
    private DataBuffer fMarkBuffer;
    private int fMarkOffset;
    private InputStream fStream;
    private DataBuffer fLastBuffer;

    public DataBufferInputStream(DataBuffer dataBuffer) {
        this.fCurrentBuffer = this.fBuffers = dataBuffer;
        this.fOffset = this.fCurrentBuffer.startOffset;
        this.fEndOffset = this.fCurrentBuffer.endOffset;
    }

    public DataBufferInputStream(InputStream inputStream, boolean bl) throws IOException {
        if (bl) {
            this.loadStreamIntoBuffers(inputStream);
        } else {
            this.fStream = inputStream;
            this.loadStreamIntoNextBuffer();
        }
        if (this.fBuffers != null) {
            this.fCurrentBuffer = this.fBuffers;
            this.fOffset = this.fCurrentBuffer.startOffset;
            this.fEndOffset = this.fCurrentBuffer.endOffset;
        } else {
            this.fCurrentBuffer = this.fBuffers = NullDataBufferFactory.EMPTY_BUFFER;
            this.fEndOffset = 0;
            this.fOffset = 0;
        }
    }

    public void removeBOM() {
        this.fCurrentBuffer.startOffset = this.fOffset;
    }

    public void setupParsedEntity(ParsedEntity parsedEntity) {
        if (this.fStream == null) {
            if (parsedEntity.isCoordinatesAware) {
                DataBuffer dataBuffer = this.fBuffers;
                dataBuffer.byteOffset = 0;
                while (dataBuffer.next != null) {
                    if (parsedEntity.isXML10) {
                        DataBufferHelper.computeCoords10(dataBuffer, dataBuffer.next);
                    } else {
                        DataBufferHelper.computeCoords11(dataBuffer, dataBuffer.next);
                    }
                    dataBuffer.next.byteOffset = dataBuffer.byteOffset + dataBuffer.endOffset - dataBuffer.startOffset;
                }
            }
            parsedEntity.setContent(this.fBuffers);
        } else {
            if (parsedEntity.isCoordinatesAware) {
                this.fBuffers.byteOffset = 0;
            }
            parsedEntity.setValues(this.fBuffers, this.fBuffers.startOffset, this.fBuffers.endOffset, this);
        }
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        try {
            if (this.loadStreamIntoNextBuffer()) {
                if (parsedEntity.isCoordinatesAware) {
                    if (parsedEntity.isXML10) {
                        DataBufferHelper.computeCoords10(this.fCurrentBuffer, this.fCurrentBuffer.next);
                    } else {
                        DataBufferHelper.computeCoords11(this.fCurrentBuffer, this.fCurrentBuffer.next);
                    }
                    this.fCurrentBuffer.next.byteOffset = this.fCurrentBuffer.byteOffset + this.fCurrentBuffer.endOffset - this.fCurrentBuffer.startOffset;
                }
                this.fCurrentBuffer = this.fCurrentBuffer.next;
                parsedEntity.setValues(this.fCurrentBuffer, this.fCurrentBuffer.startOffset, this.fCurrentBuffer.endOffset, this.fStream != null ? this : null);
            } else {
                parsedEntity.setAtEndOfEntity();
            }
            return null;
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
    }

    public void release() {
        if (this.fStream != null) {
            this.fStream = null;
        }
    }

    public int read() throws IOException {
        while (true) {
            if (this.fOffset < this.fEndOffset) {
                return this.fCurrentBuffer.bytes[this.fOffset++] & 0xFF;
            }
            if (this.fCurrentBuffer.next != null) {
                this.fCurrentBuffer = this.fCurrentBuffer.next;
                this.fOffset = this.fCurrentBuffer.startOffset;
                this.fEndOffset = this.fCurrentBuffer.endOffset;
                continue;
            }
            if (this.fStream == null || !this.loadStreamIntoNextBuffer()) break;
        }
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block6: {
            assert (n3 >= 0);
            n4 = n3;
            while (true) {
                if (this.fOffset < this.fEndOffset) {
                    int n5 = Math.min(n3, this.fEndOffset - this.fOffset);
                    System.arraycopy(this.fCurrentBuffer.bytes, this.fOffset, byArray, n2, n5);
                    n2 += n5;
                    n3 -= n5;
                    this.fOffset += n5;
                }
                if (n3 == 0) break block6;
                assert (this.fOffset == this.fEndOffset);
                if (this.fCurrentBuffer.next != null) {
                    this.fCurrentBuffer = this.fCurrentBuffer.next;
                    this.fOffset = this.fCurrentBuffer.startOffset;
                    this.fEndOffset = this.fCurrentBuffer.endOffset;
                    continue;
                }
                if (this.fStream == null || !this.loadStreamIntoNextBuffer()) break;
                this.fCurrentBuffer = this.fCurrentBuffer.next;
                this.fOffset = this.fCurrentBuffer.startOffset;
                this.fEndOffset = this.fCurrentBuffer.endOffset;
            }
            if (n3 >= n4) {
                return -1;
            }
        }
        return n4 - n3;
    }

    public void mark(int n2) {
        this.fMarkBuffer = this.fCurrentBuffer;
        this.fMarkOffset = this.fOffset;
    }

    public void reset() throws IOException {
        if (this.fMarkBuffer != null) {
            this.fCurrentBuffer = this.fMarkBuffer;
            this.fOffset = this.fMarkOffset;
            this.fEndOffset = this.fCurrentBuffer.endOffset;
            this.fMarkBuffer = null;
        } else {
            this.rewind();
        }
    }

    public void rewind() {
        this.fCurrentBuffer = this.fBuffers;
        this.fOffset = this.fCurrentBuffer.startOffset;
        this.fEndOffset = this.fCurrentBuffer.endOffset;
    }

    public boolean markSupported() {
        return true;
    }

    public int available() throws IOException {
        int n2 = 0;
        int n3 = this.fOffset;
        DataBuffer dataBuffer = this.fCurrentBuffer;
        while (true) {
            n2 += dataBuffer.endOffset - n3;
            dataBuffer = dataBuffer.next;
            if (dataBuffer == null) break;
            n3 = dataBuffer.startOffset;
        }
        return n2;
    }

    private boolean loadStreamIntoNextBuffer() throws IOException {
        int n2;
        byte[] byArray = this.fStream.available() <= ByteArrayPool.SMALL_BYTE_ARRAY_SIZE ? ByteArrayPool.allocateSmallByteArray() : ByteArrayPool.allocateLargeByteArray();
        int n3 = 0;
        int n4 = byArray.length - 1;
        do {
            if ((n2 = this.fStream.read(byArray, n3, n4 - n3)) != -1) continue;
            this.fStream.close();
            this.fStream = null;
            if (n3 <= 0) {
                if (byArray.length == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE + 1) {
                    ByteArrayPool.deallocateSmallByteArray(byArray);
                } else {
                    ByteArrayPool.deallocateLargeByteArray(byArray);
                }
                return false;
            }
            break;
        } while ((n3 += n2) != n4);
        byArray[n3] = 0;
        DataBuffer dataBuffer = NullDataBufferFactory.createNewBuffer(byArray);
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = n3;
        if (this.fLastBuffer == null) {
            this.fLastBuffer = this.fBuffers = dataBuffer;
        } else {
            this.fLastBuffer.next = dataBuffer;
            this.fLastBuffer = dataBuffer;
        }
        if (this.fStream == null) {
            this.fLastBuffer = null;
        }
        return true;
    }

    private void loadStreamIntoBuffers(InputStream inputStream) throws IOException {
        while (this.loadStreamIntoNextBuffer()) {
        }
    }
}

