/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferInputStream;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class DataBufferOutputStream
extends OutputStream {
    private DataBuffer fBuffers;
    private DataBuffer fLastBuffer;
    private byte[] fData = null;
    private int fOffset = 0;
    private int fEndOffset = 0;

    public InputStream createInputStream() {
        if (this.fData != null) {
            this.moveDataToBuffer();
            this.fLastBuffer = null;
        }
        return new DataBufferInputStream(this.fBuffers);
    }

    public void write(int n2) throws IOException {
        if (this.fOffset == this.fEndOffset) {
            if (this.fOffset == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE) {
                byte[] byArray = this.fData;
                this.fData = ByteArrayPool.allocateLargeByteArray();
                System.arraycopy(byArray, 0, this.fData, 0, this.fOffset);
                ByteArrayPool.deallocateSmallByteArray(byArray);
            } else {
                if (this.fData != null) {
                    this.moveDataToBuffer();
                }
                this.fData = ByteArrayPool.allocateSmallByteArray();
                this.fOffset = 0;
            }
            this.fEndOffset = this.fData.length - 1;
        }
        this.fData[this.fOffset++] = (byte)n2;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        assert (n3 >= 0);
        while (n3 > 0) {
            if (this.fOffset == this.fEndOffset) {
                if (this.fOffset == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE) {
                    byte[] byArray2 = this.fData;
                    this.fData = ByteArrayPool.allocateLargeByteArray();
                    System.arraycopy(byArray2, 0, this.fData, 0, this.fOffset);
                    ByteArrayPool.deallocateSmallByteArray(byArray2);
                } else {
                    if (this.fData != null) {
                        this.moveDataToBuffer();
                    }
                    this.fData = n3 <= ByteArrayPool.SMALL_BYTE_ARRAY_SIZE ? ByteArrayPool.allocateSmallByteArray() : ByteArrayPool.allocateLargeByteArray();
                }
                this.fEndOffset = this.fData.length - 1;
            }
            int n4 = Math.min(n3, this.fEndOffset - this.fOffset);
            System.arraycopy(byArray, n2, this.fData, this.fOffset, n4);
            n2 += n4;
            n3 -= n4;
            this.fOffset += n4;
        }
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void close() throws IOException {
        super.close();
    }

    private void moveDataToBuffer() {
        this.fData[this.fOffset] = 0;
        DataBuffer dataBuffer = NullDataBufferFactory.createNewBuffer(this.fData);
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = this.fOffset;
        if (this.fLastBuffer == null) {
            this.fBuffers = this.fLastBuffer = dataBuffer;
        } else {
            this.fLastBuffer.next = dataBuffer;
            this.fLastBuffer = dataBuffer;
        }
        this.fData = null;
        this.fOffset = 0;
        this.fEndOffset = 0;
    }
}

