/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class DataBufferReferrer {
    private static final boolean SAVE_REFERRER_STACKS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("save.referrer.stacks");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private static final int RETAINED_STACK_FRAMES = 5;
    public DataBufferFactory factory;
    public DataBufferReferrer prev;
    public DataBufferReferrer next;
    public boolean active;
    public int hits;
    public final int id = ++fgIdCounter;
    public final StackTraceElement[] stackTrace;
    private static int fgIdCounter;

    public abstract boolean hasReferenceTo(DataBuffer var1);

    public abstract void removeReferencesAndUnregister();

    protected DataBufferReferrer() {
        if (SAVE_REFERRER_STACKS) {
            this.stackTrace = ArrayAllocator.newObjectArray(StackTraceElement.class, 5);
            StackTraceElement[] stackTraceElementArray = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                @Override
                public StackTraceElement[] run() {
                    return Thread.currentThread().getStackTrace();
                }
            });
            for (int i = 0; i < 5; ++i) {
                this.stackTrace[i] = stackTraceElementArray[i + 3];
            }
        } else {
            this.stackTrace = null;
        }
    }

    public void removeFromQueue() {
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }
}

