/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.UnsynchronizedPool;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class Pool<E>
extends UnsynchronizedPool<E> {
    static final String cn = Pool.class.getName();
    static final Logger logger = LoggerUtil.getLogger(Pool.class);
    private final ThreadLocal<UnsynchronizedPool<E>> localPool = new ThreadLocal<UnsynchronizedPool<E>>(){

        @Override
        public UnsynchronizedPool<E> initialValue() {
            UnsynchronizedPool unsynchronizedPool = new UnsynchronizedPool(Pool.this.id, Pool.this.genericType, false);
            return unsynchronizedPool;
        }
    };
    private static int fgInstanceCounter;

    private static synchronized int assignNextId() {
        return ++fgInstanceCounter;
    }

    public Pool(String string2) {
        super(Pool.assignNextId(), string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get() {
        Object object2;
        UnsynchronizedPool<E> unsynchronizedPool = this.localPool.get();
        if (unsynchronizedPool != null) {
            object2 = unsynchronizedPool.get();
            if (object2 != null) {
                return object2;
            }
            if (unsynchronizedPool.switchToSharedPool(this.size)) {
                this.localPool.set(null);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "get", this.idLabel() + "cleared thread local pool");
                }
            }
            if (this.size == 0) {
                return null;
            }
        }
        object2 = this;
        synchronized (object2) {
            return super.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) {
        UnsynchronizedPool<E> unsynchronizedPool = this.localPool.get();
        if (unsynchronizedPool != null) {
            if (!unsynchronizedPool.clearLocalPool) {
                unsynchronizedPool.put(e);
            } else {
                this.localPool.set(null);
                if (LoggerUtil.isFineLoggable(logger)) {
                    logger.logp(Level.FINE, cn, "put", this.idLabel() + "cleared thread local pool");
                }
                Pool pool = this;
                synchronized (pool) {
                    super.put(e);
                    while ((e = unsynchronizedPool.get()) != null) {
                        super.put(e);
                    }
                }
            }
            return;
        }
        Pool pool = this;
        synchronized (pool) {
            super.put(e);
        }
    }
}

