/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class SimpleDataBufferFactory
implements DataBufferFactory {
    private static final String cn = SimpleDataBufferFactory.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(SimpleDataBufferFactory.class);
    private static final int DEFAULT_RECLAIM_LIMIT = 524288;
    private static final boolean CHECK_MULTIPLE_THREAD_ACCESS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xlxp.internal.s1.scan.util.SimpleDataBufferFactory.checkMultipleThreadAccess");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private int id;
    private DataBufferReferrerQueue fReferrers;
    private DataBufferActiveQueue fActiveBuffers;
    private int fActiveAllocations;
    private int fReclaimLimit;
    private int fActiveCount;
    private boolean fReclaimInProgress;
    private long fReclaimBuffersCallerThreadId;
    private StackTraceElement[] fReclaimBuffersCallerStack;
    private static int fgFactoryIdCounter;
    private static int fgResetCount;
    private static int fgUnregisterReferrersCount;
    private static int fgOddSizedByteArrayAllocationCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleDataBufferFactory() {
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "SimpleDataBufferFactory");
        }
        this.fReclaimLimit = 524288;
        this.fActiveBuffers = new DataBufferActiveQueue();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.id = ++fgFactoryIdCounter;
        }
        this.fReferrers = new DataBufferReferrerQueue(this.fActiveBuffers, this.id);
        if (bl) {
            logger.exiting(cn, "SimpleDataBufferFactory", "dbf[" + this.id + "]");
        }
    }

    public DataBuffer createBuffer(int n2) {
        byte[] byArray;
        if (CHECK_MULTIPLE_THREAD_ACCESS && this.fReclaimInProgress) {
            this.multiThreadedAccess();
        }
        if (n2 == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE + 1) {
            byArray = ByteArrayPool.allocateSmallByteArray();
        } else if (n2 == ByteArrayPool.LARGE_BYTE_ARRAY_SIZE + 1) {
            byArray = ByteArrayPool.allocateLargeByteArray();
        } else {
            byArray = ArrayAllocator.newByteArray(n2);
            ++fgOddSizedByteArrayAllocationCount;
        }
        return this.internalCreateBuffer(byArray);
    }

    public DataBuffer createBuffer(byte[] byArray) {
        if (CHECK_MULTIPLE_THREAD_ACCESS && this.fReclaimInProgress) {
            this.multiThreadedAccess();
        }
        return this.internalCreateBuffer(byArray);
    }

    private DataBuffer internalCreateBuffer(byte[] byArray) {
        DataBuffer dataBuffer = new DataBuffer((DataBufferFactory)this, byArray);
        DataBufferLink dataBufferLink = new DataBufferLink(dataBuffer);
        if (LoggerUtil.isFinestLoggable(logger)) {
            logger.logp(Level.FINEST, cn, "createBuffer", "dbf[" + this.id + "] allocated db[" + dataBuffer.id + "]");
        }
        this.fActiveBuffers.add(dataBufferLink);
        ++this.fActiveCount;
        this.fActiveAllocations += byArray.length;
        return dataBuffer;
    }

    public void addReferrer(DataBufferReferrer dataBufferReferrer) {
        if (CHECK_MULTIPLE_THREAD_ACCESS && this.fReclaimInProgress) {
            this.multiThreadedAccess();
        }
        if (dataBufferReferrer.next != null || dataBufferReferrer.prev != null) {
            dataBufferReferrer.removeFromQueue();
        }
        this.fReferrers.add(dataBufferReferrer);
        dataBufferReferrer.factory = this;
        if (LoggerUtil.isFinestLoggable(logger)) {
            logger.logp(Level.FINEST, cn, "addReferrer", "dbf[" + this.id + "] added referrer dbr[" + dataBufferReferrer.id + "]");
        }
    }

    public void removeReferrer(DataBufferReferrer dataBufferReferrer) {
        if (CHECK_MULTIPLE_THREAD_ACCESS && this.fReclaimInProgress) {
            this.multiThreadedAccess();
        }
        dataBufferReferrer.removeFromQueue();
        dataBufferReferrer.factory = null;
        if (LoggerUtil.isFinestLoggable(logger)) {
            logger.logp(Level.FINEST, cn, "removeReferrer", "dbf[" + this.id + "] removed referrer dbr[" + dataBufferReferrer.id + "]");
        }
    }

    public boolean isReferenced(DataBuffer dataBuffer) {
        if (CHECK_MULTIPLE_THREAD_ACCESS && this.fReclaimInProgress) {
            this.multiThreadedAccess();
        }
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = this.fReferrers.isReferenced(dataBuffer, null, stringBuilder);
            logger.logp(Level.FINEST, cn, "isReferenced", stringBuilder.toString());
            return bl;
        }
        return this.fReferrers.isReferenced(dataBuffer, null, null);
    }

    public void reset(boolean bl) {
        if (CHECK_MULTIPLE_THREAD_ACCESS && this.fReclaimInProgress) {
            this.multiThreadedAccess();
        }
        this.reclaimBuffers(true);
        ++fgResetCount;
    }

    public void setReclaimLimit(int n2) {
        this.fReclaimLimit = n2;
    }

    public int activeAllocations() {
        assert (this.fActiveAllocations == this.fActiveBuffers.totalAllocations());
        return this.fActiveAllocations;
    }

    public void reclaimBuffers(boolean bl) {
        if (bl) {
            this.internalReclaimBuffers();
        } else if (this.activeAllocations() >= this.fReclaimLimit) {
            this.internalReclaimBuffers();
        }
    }

    private void internalReclaimBuffers() {
        StringBuilder stringBuilder;
        if (CHECK_MULTIPLE_THREAD_ACCESS) {
            this.fReclaimBuffersCallerThreadId = Thread.currentThread().getId();
            this.fReclaimBuffersCallerStack = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                @Override
                public StackTraceElement[] run() {
                    return Thread.currentThread().getStackTrace();
                }
            });
            this.fReclaimInProgress = true;
        }
        StringBuilder stringBuilder2 = stringBuilder = LoggerUtil.isFinestLoggable(logger) ? new StringBuilder() : null;
        if (stringBuilder != null) {
            stringBuilder.append("dbf[" + this.id + "] reclaimBuffers: activeCount was " + this.fActiveCount + "\n");
            this.fReferrers.append(stringBuilder);
        }
        if (this.fActiveCount > 0) {
            DataBufferReferrer dataBufferReferrer = this.fReferrers.firstActiveReferrer();
            DataBufferLink dataBufferLink = this.fActiveBuffers.first();
            while (dataBufferLink != null) {
                if (dataBufferReferrer == null || !this.fReferrers.isReferenced(dataBufferLink.db, dataBufferReferrer, stringBuilder)) {
                    if (dataBufferLink.prev.db != null && dataBufferLink.prev.db.next == dataBufferLink.db) {
                        dataBufferLink.prev.db.next = null;
                    }
                    DataBufferLink dataBufferLink2 = this.fActiveBuffers.remove(dataBufferLink);
                    if (stringBuilder != null) {
                        stringBuilder.append("dbf[" + this.id + "] reclaimBuffers reclaiming buffer " + dataBufferLink.db.id + "\n");
                    }
                    byte[] byArray = dataBufferLink.db.bytes;
                    int n2 = byArray.length;
                    dataBufferLink.db.next = null;
                    if (n2 == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE + 1) {
                        ByteArrayPool.deallocateSmallByteArray(byArray);
                    } else if (n2 == ByteArrayPool.LARGE_BYTE_ARRAY_SIZE + 1) {
                        ByteArrayPool.deallocateLargeByteArray(byArray);
                    } else if (stringBuilder != null) {
                        stringBuilder.append("  db[" + dataBufferLink.db.id + "]  non-standard size: " + n2 + "\n");
                    }
                    --this.fActiveCount;
                    this.fActiveAllocations -= n2;
                    dataBufferLink = dataBufferLink2;
                    continue;
                }
                dataBufferLink = this.fActiveBuffers.next(dataBufferLink);
            }
            if (stringBuilder != null) {
                stringBuilder.append("dbf[" + this.id + "] reclaimBuffers: activeCount now " + this.fActiveCount);
                logger.logp(Level.FINEST, cn, "reclaimBuffers", stringBuilder.toString());
            }
        }
        if (CHECK_MULTIPLE_THREAD_ACCESS) {
            this.fReclaimInProgress = false;
        }
    }

    private void multiThreadedAccess() {
        if (CHECK_MULTIPLE_THREAD_ACCESS) {
            System.err.println("***XLXP[" + Thread.currentThread().getId() + "]*** reclaimBuffers thread " + this.fReclaimBuffersCallerThreadId);
            System.err.println("  reclaimBuffers call stack:");
            for (int i = 0; i < this.fReclaimBuffersCallerStack.length; ++i) {
                System.err.println("    " + this.fReclaimBuffersCallerStack[i].toString());
            }
            throw new RuntimeException("Access to SimpleDataBufferFactory while reclaimBuffers was in progress.");
        }
    }

    public void orphanBuffer(DataBuffer dataBuffer) {
        if (this.fActiveCount > 0) {
            DataBufferLink dataBufferLink = this.fActiveBuffers.first();
            while (dataBufferLink != null) {
                if (dataBufferLink.db == dataBuffer) {
                    this.fActiveBuffers.remove(dataBufferLink);
                    --this.fActiveCount;
                    this.fActiveAllocations -= dataBuffer.bytes.length;
                    return;
                }
                dataBufferLink = this.fActiveBuffers.next(dataBufferLink);
            }
        }
    }

    public void unregisterReferrers() {
        StringBuilder stringBuilder;
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.entering(cn, "unregisterReferrers", "fActiveCount=" + this.fActiveCount);
        }
        StringBuilder stringBuilder2 = stringBuilder = LoggerUtil.isFinestLoggable(logger) ? new StringBuilder() : null;
        if (stringBuilder != null) {
            stringBuilder.append("dbf[" + this.id + "] unregisterReferrers: activeCount was " + this.fActiveCount + "\n");
            this.fReferrers.append(stringBuilder);
        }
        this.fReferrers.unregisterReferrers(stringBuilder);
        if (this.fActiveCount > 0) {
            this.reclaimBuffers(true);
        }
        if (stringBuilder != null) {
            stringBuilder.append("dbf[" + this.id + "] unregisterReferrers: activeCount now " + this.fActiveCount);
            logger.logp(Level.FINEST, cn, "unregisterReferrers", stringBuilder.toString());
        }
        if (this.fActiveAllocations == -1) {
            this.fActiveAllocations = this.fActiveCount > 0 ? this.fActiveBuffers.totalAllocations() : 0;
        }
        if (LoggerUtil.isEntryLoggable(logger)) {
            logger.exiting(cn, "unregisterReferrers", "fActiveCount=" + this.fActiveCount);
        }
        ++fgUnregisterReferrersCount;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class DataBufferActiveQueue {
        DataBufferLink head;

        DataBufferActiveQueue() {
            this.head.prev = this.head.next = (this.head = new DataBufferLink(null));
        }

        void add(DataBufferLink dataBufferLink) {
            DataBufferLink dataBufferLink2 = this.head.prev;
            dataBufferLink.next = dataBufferLink2.next;
            dataBufferLink.prev = dataBufferLink2;
            dataBufferLink2.next = dataBufferLink;
            this.head.prev = dataBufferLink;
        }

        DataBufferLink remove(DataBufferLink dataBufferLink) {
            DataBufferLink dataBufferLink2;
            dataBufferLink.prev.next = dataBufferLink2 = dataBufferLink.next;
            dataBufferLink2.prev = dataBufferLink.prev;
            dataBufferLink.next = null;
            dataBufferLink.prev = null;
            return dataBufferLink2 != this.head ? dataBufferLink2 : null;
        }

        DataBufferLink first() {
            return this.head.next != this.head ? this.head.next : null;
        }

        DataBufferLink next(DataBufferLink dataBufferLink) {
            return dataBufferLink.next != this.head ? dataBufferLink.next : null;
        }

        int totalAllocations() {
            int n2 = 0;
            DataBufferLink dataBufferLink = this.first();
            while (dataBufferLink != null) {
                n2 += dataBufferLink.db.bytes != null ? dataBufferLink.db.bytes.length : 0;
                dataBufferLink = this.next(dataBufferLink);
            }
            return n2;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class DataBufferLink {
        DataBufferLink next;
        DataBufferLink prev;
        final DataBuffer db;

        DataBufferLink(DataBuffer dataBuffer) {
            this.db = dataBuffer;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class DataBufferReferrerQueue {
        final DataBufferActiveQueue activeBuffers;
        final int factoryID;
        final DataBufferReferrer head;
        private StringBuilder sb;

        DataBufferReferrerQueue(DataBufferActiveQueue dataBufferActiveQueue, int n2) {
            this.activeBuffers = dataBufferActiveQueue;
            this.factoryID = n2;
            this.head.prev = this.head.next = (this.head = new DataBufferReferrer(){

                public boolean hasReferenceTo(DataBuffer dataBuffer) {
                    return false;
                }

                public void removeReferencesAndUnregister() {
                }
            });
        }

        DataBufferReferrer firstActiveReferrer() {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            while (dataBufferReferrer != this.head) {
                if (dataBufferReferrer.active) {
                    return dataBufferReferrer;
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            return null;
        }

        boolean isReferenced(DataBuffer dataBuffer, DataBufferReferrer dataBufferReferrer, StringBuilder stringBuilder) {
            if (dataBufferReferrer == null) {
                dataBufferReferrer = this.head.next;
            }
            boolean bl = false;
            while (dataBufferReferrer != this.head) {
                DataBufferReferrer dataBufferReferrer2 = dataBufferReferrer.next;
                if (dataBufferReferrer.active && dataBufferReferrer.hasReferenceTo(dataBuffer)) {
                    if (stringBuilder != null) {
                        if (!bl) {
                            stringBuilder.append("dbf[" + this.factoryID + "] has db[" + dataBuffer.id + "] references\n");
                        }
                        stringBuilder.append("    referred to by dbr[" + dataBufferReferrer.id + "] " + DataBufferReferrerQueue.shortClassName(dataBufferReferrer) + "\n");
                        bl = true;
                    }
                    ++dataBufferReferrer.hits;
                    if (dataBufferReferrer != this.head.next && dataBufferReferrer.hits > dataBufferReferrer.prev.hits) {
                        this.moveToFront(dataBufferReferrer);
                    }
                    if (stringBuilder == null) {
                        return true;
                    }
                }
                dataBufferReferrer = dataBufferReferrer2;
            }
            if (stringBuilder != null) {
                if (!bl) {
                    stringBuilder.append("dbf[" + this.factoryID + "] has no db[" + dataBuffer.id + "] references\n");
                }
                return bl;
            }
            return false;
        }

        void moveToFront(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2;
            dataBufferReferrer.removeFromQueue();
            dataBufferReferrer.next = dataBufferReferrer2 = this.head.next;
            dataBufferReferrer.prev = this.head;
            dataBufferReferrer2.prev = dataBufferReferrer;
            this.head.next = dataBufferReferrer;
        }

        void add(DataBufferReferrer dataBufferReferrer) {
            DataBufferReferrer dataBufferReferrer2 = this.head.prev;
            dataBufferReferrer.next = this.head;
            dataBufferReferrer.prev = dataBufferReferrer2;
            dataBufferReferrer2.next = dataBufferReferrer;
            this.head.prev = dataBufferReferrer;
        }

        void unregisterReferrers(StringBuilder stringBuilder) {
            DataBufferReferrer dataBufferReferrer = this.head.next;
            while (dataBufferReferrer != this.head) {
                DataBufferReferrer dataBufferReferrer2 = dataBufferReferrer.next;
                if (dataBufferReferrer.active) {
                    if (stringBuilder != null) {
                        stringBuilder.append("dbf[" + this.factoryID + "] active dbr[" + dataBufferReferrer.id + "] " + DataBufferReferrerQueue.shortClassName(dataBufferReferrer) + " removed\n");
                    }
                    dataBufferReferrer.removeReferencesAndUnregister();
                } else {
                    if (stringBuilder != null) {
                        stringBuilder.append("dbf[" + this.factoryID + "] inactive dbr[" + dataBufferReferrer.id + "] " + DataBufferReferrerQueue.shortClassName(dataBufferReferrer) + " removed\n");
                    }
                    dataBufferReferrer.removeReferencesAndUnregister();
                }
                dataBufferReferrer = dataBufferReferrer2;
            }
        }

        public String toString() {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            } else {
                this.sb.setLength(0);
            }
            this.append(this.sb);
            return this.sb.toString();
        }

        static String shortClassName(Object object2) {
            String string2 = object2.getClass().getName();
            return string2.substring(string2.lastIndexOf(46) + 1);
        }

        void append(StringBuilder stringBuilder) {
            stringBuilder.append("dbf[");
            stringBuilder.append(Integer.toString(this.factoryID));
            stringBuilder.append("] referrer queue\n");
            boolean bl = true;
            DataBufferReferrer dataBufferReferrer = this.head.next;
            while (dataBufferReferrer != this.head) {
                if (!dataBufferReferrer.active) {
                    if (bl) {
                        stringBuilder.append("    dbr[");
                        bl = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(Integer.toString(dataBufferReferrer.id));
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
            if (!bl) {
                stringBuilder.append("] inactive\n");
            }
            dataBufferReferrer = this.head.next;
            while (dataBufferReferrer != this.head) {
                if (dataBufferReferrer.active) {
                    stringBuilder.append("    dbr[");
                    stringBuilder.append(Integer.toString(dataBufferReferrer.id));
                    stringBuilder.append("] class ");
                    stringBuilder.append(DataBufferReferrerQueue.shortClassName(dataBufferReferrer));
                    bl = true;
                    DataBufferActiveQueue dataBufferActiveQueue = this.activeBuffers;
                    DataBufferLink dataBufferLink = dataBufferActiveQueue.first();
                    while (dataBufferLink != null) {
                        if (dataBufferReferrer.hasReferenceTo(dataBufferLink.db)) {
                            if (bl) {
                                stringBuilder.append(" db[");
                                bl = false;
                            } else {
                                stringBuilder.append("),[");
                            }
                            stringBuilder.append(Integer.toString(dataBufferLink.db.id));
                            stringBuilder.append("](len ");
                            stringBuilder.append(Integer.toString(dataBufferLink.db.endOffset - dataBufferLink.db.startOffset));
                        }
                        dataBufferLink = dataBufferActiveQueue.next(dataBufferLink);
                    }
                    if (!bl) {
                        stringBuilder.append(")\n");
                    } else {
                        stringBuilder.append(" no buffers\n");
                    }
                    if (dataBufferReferrer.stackTrace != null) {
                        for (int i = 0; i < dataBufferReferrer.stackTrace.length; ++i) {
                            stringBuilder.append("    ");
                            stringBuilder.append(dataBufferReferrer.stackTrace[i].toString());
                            stringBuilder.append('\n');
                        }
                    }
                }
                dataBufferReferrer = dataBufferReferrer.next;
            }
        }
    }
}

