/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Symbol {
    public final String str;
    final DataBuffer nameBuffer;
    final int nameStart;
    final int nameEnd;
    private final String prefix;
    private final String localName;
    int hitCount;
    int noHitsFoundCount;

    Symbol(String string2, DataBuffer dataBuffer, int n2, int n3) {
        this.str = string2;
        this.nameBuffer = dataBuffer;
        this.nameStart = n2;
        this.nameEnd = n3;
        int n4 = this.checkQName(string2);
        if (n4 == -1) {
            this.prefix = null;
            this.localName = null;
        } else if (n4 == 0) {
            this.prefix = "";
            this.localName = this.str;
        } else {
            this.prefix = this.str.substring(0, n4).intern();
            this.localName = this.str.substring(n4 + 1).intern();
        }
    }

    Symbol(Symbol symbol, DataBuffer dataBuffer, int n2, int n3) {
        this.str = symbol.str;
        this.nameBuffer = dataBuffer;
        this.nameStart = n2;
        this.nameEnd = n3;
        this.prefix = symbol.prefix;
        this.localName = symbol.localName;
    }

    String toStringFromBytes() {
        try {
            return new String(this.nameBuffer.bytes, this.nameStart, this.nameEnd - this.nameStart, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        return this.str;
    }

    boolean equalsString(String string2) {
        return this.str.equals(string2);
    }

    void setValues(XMLString xMLString) {
        xMLString.setValues(this.nameBuffer, this.nameStart, this.nameEnd);
    }

    boolean setValuesIfKnownQName(QName qName) {
        if (this.prefix != null) {
            this.setQNameValues(qName);
            return true;
        }
        return false;
    }

    public void setQNameValues(QName qName) {
        qName.rawName = this.str;
        qName.nsURI = "";
        qName.localName = this.localName;
        qName.prefix = this.prefix;
    }

    public boolean skippedMatchingQName(ParsedEntity parsedEntity, QName qName) {
        return parsedEntity.skippedBytesInRangeForXMLString(this.nameBuffer.bytes, this.nameStart, this.nameEnd, qName);
    }

    private int checkQName(String string2) {
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        block0: while (true) {
            char c;
            int n5;
            if (n3 == n2) {
                return -1;
            }
            if ((n5 = string2.charAt(n3++)) >= 55296 && n5 < 57344) {
                if (n3 == n2) {
                    return -1;
                }
                if ((c = string2.charAt(n3++)) >= '\udc00' && c < '\ue000') {
                    n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
                } else {
                    return -1;
                }
            }
            if (!bl || !XMLCharacterProperties.nameStartChar10(n5)) {
                if (XMLCharacterProperties.nameStartChar11(n5)) {
                    bl = false;
                } else {
                    return -1;
                }
            }
            while (true) {
                if (n3 == n2) {
                    return n4;
                }
                if ((n5 = string2.charAt(n3++)) == 58) {
                    if (n4 == 0) {
                        n4 = n3 - 1;
                        continue block0;
                    }
                    return -1;
                }
                if (n5 >= 55296 && n5 < 57344) {
                    if (n3 == n2) {
                        return -1;
                    }
                    if ((c = string2.charAt(n3++)) >= '\udc00' && c < '\ue000') {
                        n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
                    } else {
                        return -1;
                    }
                }
                if (bl && XMLCharacterProperties.nameChar10(n5)) continue;
                if (!XMLCharacterProperties.nameChar11(n5)) break block0;
                bl = false;
            }
            break;
        }
        return -1;
    }
}

