/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionResources;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.CharConversionException;
import java.lang.ref.SoftReference;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8Support {
    private static final int DEFAULT_CHAR_BUFFER_LENGTH = 8192;
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};
    private static final ThreadLocal<SoftReference<ConversionResources>> fgResources = new ThreadLocal();

    public static String toString(DataBuffer dataBuffer, int n2, int n3, int n4) throws CharConversionException {
        CharConversionHandler.StringHandler stringHandler;
        ConversionResources conversionResources;
        SoftReference<ConversionResources> softReference = fgResources.get();
        ConversionResources conversionResources2 = conversionResources = softReference != null ? softReference.get() : null;
        if (conversionResources == null) {
            conversionResources = new ConversionResources();
            fgResources.set(new SoftReference<ConversionResources>(conversionResources));
        }
        if ((stringHandler = conversionResources.stringReceiver) == null) {
            stringHandler = conversionResources.stringReceiver = new CharConversionHandler.StringHandler();
        }
        stringHandler.initialize(n3);
        UTF8Support.convertBytesToChars(dataBuffer, n2, n3, n4, stringHandler, conversionResources);
        String string2 = stringHandler.toString();
        return string2;
    }

    public static int convertBytesToChars(DataBuffer dataBuffer, int n2, int n3, int n4, CharConversionResources charConversionResources) throws CharConversionException {
        assert (charConversionResources.keepContiguous);
        if (charConversionResources.charBuffer == null || charConversionResources.charBuffer.length < n3) {
            int n5;
            int n6 = n5 = charConversionResources.charBuffer == null ? 16 : charConversionResources.charBuffer.length << 1;
            while (n5 < n3) {
                n5 <<= 1;
            }
            charConversionResources.charBuffer = new char[n5];
        }
        return UTF8Support.convertBytesToChars(dataBuffer, n2, n3, n4, null, charConversionResources);
    }

    public static int convertBytesToChars(DataBuffer dataBuffer, int n2, int n3, int n4, CharConversionHandler charConversionHandler) throws CharConversionException {
        ConversionResources conversionResources;
        SoftReference<ConversionResources> softReference = fgResources.get();
        ConversionResources conversionResources2 = conversionResources = softReference != null ? softReference.get() : null;
        if (conversionResources == null) {
            conversionResources = new ConversionResources();
            fgResources.set(new SoftReference<ConversionResources>(conversionResources));
        }
        return UTF8Support.convertBytesToChars(dataBuffer, n2, n3, n4, charConversionHandler, conversionResources);
    }

    private static int convertBytesToChars(DataBuffer dataBuffer, int n2, int n3, int n4, CharConversionHandler charConversionHandler, CharConversionResources charConversionResources) throws CharConversionException {
        if ((n4 & 0xC) != 0) {
            return UTF8Support.normalizeBytesToChars(dataBuffer, n2, n3, (n4 & 8) != 0, charConversionHandler, charConversionResources);
        }
        return UTF8Support.convertBytesToChars(dataBuffer, n2, n3, charConversionHandler, charConversionResources);
    }

    private static int convertBytesToChars(DataBuffer dataBuffer, int n2, int n3, CharConversionHandler charConversionHandler, CharConversionResources charConversionResources) throws CharConversionException {
        int n4 = n2 + n3;
        byte[] byArray = dataBuffer.bytes;
        int n5 = n2;
        char[] cArray = charConversionResources.charBuffer;
        int n6 = 0;
        if (n4 <= dataBuffer.endOffset && n3 <= cArray.length) {
            while (n5 < n4 && byArray[n5] >= 0) {
                cArray[n6++] = (char)byArray[n5++];
            }
            if (n5 == n4) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, 0, n6, true);
                }
                return n6;
            }
        }
        return UTF8Support.convertBytesToChars2(dataBuffer, n5, n4 - n5, charConversionResources, n6, charConversionHandler);
    }

    private static int convertBytesToChars2(DataBuffer dataBuffer, int n2, int n3, CharConversionResources charConversionResources, int n4, CharConversionHandler charConversionHandler) throws CharConversionException {
        int n5 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n6 = n2;
        int n7 = Math.min(n5, dataBuffer2.endOffset);
        char[] cArray = charConversionResources.charBuffer;
        int n8 = cArray.length;
        int n9 = 0;
        int n10 = 0;
        while (true) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16 = Math.min(n7, n6 + (n8 - n4));
            while (n6 < n16 && (n15 = byArray[n6]) >= 0) {
                ++n6;
                cArray[n4++] = (char)n15;
            }
            if (n6 == n5) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, n10, n4 - n10, true);
                }
                return n9 + n4;
            }
            if (n6 == n7) {
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
                continue;
            }
            if (n4 == n8) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                }
                if (charConversionResources.keepContiguous) {
                    n10 = n4;
                    charConversionResources.charBuffer = cArray = UTF8Support.resize(cArray);
                    n8 <<= 1;
                    continue;
                }
                n9 += n4;
                n4 = 0;
                continue;
            }
            if ((n14 = fgMultiByteLength[(n15 = byArray[n6++] & 0xFF) >> 3]) == 0) {
                throw UTF8Support.charConversionFailure(1, n15, 0, 0, 0).asCharConversionException();
            }
            int n17 = n15 & fgFirstByteValueMask[n14];
            if (n6 == n7) {
                if (n6 == n5) {
                    if (charConversionHandler != null) {
                        charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                    }
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n13 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(2, n15, n13, 0, 0).asCharConversionException();
            }
            if (n14 == 2) {
                n17 = (n17 << 6) + (0x3F & n13);
                cArray[n4++] = (char)n17;
                continue;
            }
            if (n6 == n7) {
                if (n6 == n5) {
                    if (charConversionHandler != null) {
                        charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                    }
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n12 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(3, n15, n13, n12, 0).asCharConversionException();
            }
            if (n14 == 3) {
                if ((n17 = (n17 << 12) + ((0x3F & n13) << 6) + (0x3F & n12)) >= 55296 && n17 < 57344) {
                    throw UTF8Support.charConversionFailure(1, n15, n13, n12, 0).asCharConversionException();
                }
                cArray[n4++] = (char)n17;
                continue;
            }
            if (n6 == n7) {
                if (n6 == n5) {
                    if (charConversionHandler != null) {
                        charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                    }
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n11 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(4, n15, n13, n12, n11).asCharConversionException();
            }
            int n18 = (n17 << 8) + ((0x30 & n13) << 2);
            if (n18 > 1024 || n18 == 0) {
                throw CharConversionError.invalidUTF8SurrogateEncoding().asCharConversionException();
            }
            int n19 = n18 - 64;
            int n20 = 55296 + n19 + ((0xF & n13) << 2) + ((0x30 & n12) >> 4);
            int n21 = 56320 + ((0xF & n12) << 6) + (0x3F & n11);
            cArray[n4++] = (char)n20;
            if (n4 == n8) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                }
                if (charConversionResources.keepContiguous) {
                    n10 = n4;
                    charConversionResources.charBuffer = cArray = UTF8Support.resize(cArray);
                    n8 <<= 1;
                } else {
                    n9 += n4;
                    n4 = 0;
                }
            }
            cArray[n4++] = (char)n21;
        }
    }

    private static int normalizeBytesToChars(DataBuffer dataBuffer, int n2, int n3, boolean bl, CharConversionHandler charConversionHandler, CharConversionResources charConversionResources) throws CharConversionException {
        int n4;
        int n5;
        int n6;
        block6: {
            n6 = n2 + n3;
            byte[] byArray = dataBuffer.bytes;
            n5 = n2;
            char[] cArray = charConversionResources.charBuffer;
            n4 = 0;
            if (n6 <= dataBuffer.endOffset && n3 <= cArray.length) {
                while (n5 < n6) {
                    if (byArray[n5] != 13) {
                        if (byArray[n5] >= 0) {
                            cArray[n4++] = (char)byArray[n5++];
                            continue;
                        }
                        break block6;
                    }
                    cArray[n4++] = 10;
                    if (++n5 < n6 && byArray[n5] == 10) {
                        ++n5;
                        continue;
                    }
                    if (!bl || n5 + 1 >= n6 || (byArray[n5] & 0xFF) != 194 || (byArray[n5 + 1] & 0xFF) != 133) continue;
                    n5 += 2;
                }
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, 0, n4, true);
                }
                return n4;
            }
        }
        return UTF8Support.normalizeBytesToChars2(dataBuffer, n5, n6 - n5, bl, charConversionResources, n4, charConversionHandler);
    }

    private static int normalizeBytesToChars2(DataBuffer dataBuffer, int n2, int n3, boolean bl, CharConversionResources charConversionResources, int n4, CharConversionHandler charConversionHandler) throws CharConversionException {
        int n5 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n6 = n2;
        int n7 = Math.min(n5, dataBuffer2.endOffset);
        char[] cArray = charConversionResources.charBuffer;
        int n8 = cArray.length;
        boolean bl2 = false;
        int n9 = 0;
        int n10 = 0;
        while (true) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16 = Math.min(n7, n6 + (n8 - n4));
            while (n6 < n16 && (n15 = byArray[n6]) >= 0) {
                ++n6;
                if (n15 != 13) {
                    cArray[n4++] = (char)n15;
                    continue;
                }
                cArray[n4++] = 10;
                if (n6 < n7) {
                    n15 = byArray[n6];
                    if (n15 == 10) {
                        ++n6;
                        continue;
                    }
                    if (n15 >= 0) continue;
                }
                bl2 = true;
                break;
            }
            if (n6 == n5) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, n10, n4 - n10, true);
                }
                return n9 + n4;
            }
            if (n6 >= n7) {
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset + (n6 - n7);
                n7 = Math.min(n5 -= n7 - dataBuffer2.startOffset, dataBuffer2.endOffset);
                if (!bl2 || n6 >= n7) continue;
                n15 = byArray[n6];
                if (n15 == 10) {
                    ++n6;
                    bl2 = false;
                    continue;
                }
                if (n15 >= 0) {
                    bl2 = false;
                    continue;
                }
            }
            if (n4 == n8) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                }
                if (charConversionResources.keepContiguous) {
                    n10 = n4;
                    charConversionResources.charBuffer = cArray = UTF8Support.resize(cArray);
                    n8 <<= 1;
                } else {
                    n9 += n4;
                    n4 = 0;
                }
                if (!bl2) continue;
                n15 = byArray[n6];
                if (n15 == 10) {
                    ++n6;
                    bl2 = false;
                    continue;
                }
                if (n15 >= 0) {
                    bl2 = false;
                    continue;
                }
            }
            if (!bl2 && n6 >= n16) continue;
            if ((n14 = fgMultiByteLength[(n15 = byArray[n6++] & 0xFF) >> 3]) == 0) {
                throw UTF8Support.charConversionFailure(1, n15, 0, 0, 0).asCharConversionException();
            }
            int n17 = n15 & fgFirstByteValueMask[n14];
            if (n6 == n7) {
                if (n6 == n5) {
                    if (charConversionHandler != null) {
                        charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                    }
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n13 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(2, n15, n13, 0, 0).asCharConversionException();
            }
            if (n14 == 2) {
                n17 = (n17 << 6) + (0x3F & n13);
                if (bl && n17 == 133) {
                    if (!bl2) {
                        cArray[n4++] = 10;
                    }
                } else {
                    cArray[n4++] = (char)n17;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
            if (n6 == n7) {
                if (n6 == n5) {
                    if (charConversionHandler != null) {
                        charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                    }
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n12 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(3, n15, n13, n12, 0).asCharConversionException();
            }
            if (n14 == 3) {
                if ((n17 = (n17 << 12) + ((0x3F & n13) << 6) + (0x3F & n12)) >= 55296 && n17 < 57344) {
                    throw UTF8Support.charConversionFailure(1, n15, n13, n12, 0).asCharConversionException();
                }
                if (bl && n17 == 8232) {
                    cArray[n4++] = 10;
                    continue;
                }
                cArray[n4++] = (char)n17;
                continue;
            }
            if (n6 == n7) {
                if (n6 == n5) {
                    if (charConversionHandler != null) {
                        charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                    }
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n11 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(4, n15, n13, n12, n11).asCharConversionException();
            }
            int n18 = (n17 << 8) + ((0x30 & n13) << 2);
            if (n18 > 1024 || n18 == 0) {
                throw CharConversionError.invalidUTF8SurrogateEncoding().asCharConversionException();
            }
            int n19 = n18 - 64;
            int n20 = 55296 + n19 + ((0xF & n13) << 2) + ((0x30 & n12) >> 4);
            int n21 = 56320 + ((0xF & n12) << 6) + (0x3F & n11);
            cArray[n4++] = (char)n20;
            if (n4 == n8) {
                if (charConversionHandler != null) {
                    charConversionHandler.receiveChars(cArray, n10, n4 - n10, false);
                }
                if (charConversionResources.keepContiguous) {
                    n10 = n4;
                    charConversionResources.charBuffer = cArray = UTF8Support.resize(cArray);
                    n8 <<= 1;
                } else {
                    n9 += n4;
                    n4 = 0;
                }
            }
            cArray[n4++] = (char)n21;
        }
    }

    public static int decodeBytesToCharacter(DataBuffer dataBuffer, int n2, int n3, int[] nArray) throws CharConversionException {
        int n4;
        byte[] byArray;
        int n5;
        block11: {
            n5 = n2 + n3;
            byArray = dataBuffer.bytes;
            n4 = Math.min(n5, dataBuffer.endOffset);
            nArray[0] = 0;
            while (true) {
                if (n2 < n4) break block11;
                if (n2 >= n5) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n2 = dataBuffer.startOffset;
                n4 = Math.min(n5 -= n4 - n2, dataBuffer.endOffset);
            }
            throw CharConversionError.insufficientInputToDecodeCharacter().asCharConversionException();
        }
        int n6 = byArray[n2++];
        if (n6 >= 0) {
            nArray[0] = n6;
            return 1;
        }
        int n7 = fgMultiByteLength[(n6 &= 0xFF) >> 3];
        if (n7 > 1) {
            int n8;
            int n9;
            int n10;
            block14: {
                block13: {
                    block12: {
                        n10 = n6 & fgFirstByteValueMask[n7];
                        while (true) {
                            if (n2 < n4) break block12;
                            if (n2 >= n5) break;
                            dataBuffer = dataBuffer.next;
                            byArray = dataBuffer.bytes;
                            n2 = dataBuffer.startOffset;
                            n4 = Math.min(n5 -= n4 - n2, dataBuffer.endOffset);
                        }
                        throw CharConversionError.insufficientInputToDecodeCharacter().asCharConversionException();
                    }
                    n9 = byArray[n2++] & 0xFF;
                    if ((0xC0 & n9) != 128) {
                        throw UTF8Support.charConversionFailure(2, n6, n9, 0, 0).asCharConversionException();
                    }
                    if (n7 == 2) {
                        nArray[0] = n10 = (n10 << 6) + (0x3F & n9);
                        return 2;
                    }
                    while (true) {
                        if (n2 < n4) break block13;
                        if (n2 >= n5) break;
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n2 = dataBuffer.startOffset;
                        n4 = Math.min(n5 -= n4 - n2, dataBuffer.endOffset);
                    }
                    throw CharConversionError.insufficientInputToDecodeCharacter().asCharConversionException();
                }
                n8 = byArray[n2++] & 0xFF;
                if ((0xC0 & n8) != 128) {
                    throw UTF8Support.charConversionFailure(3, n6, n9, n8, 0).asCharConversionException();
                }
                if (n7 == 3) {
                    nArray[0] = n10 = (n10 << 12) + ((0x3F & n9) << 6) + (0x3F & n8);
                    return 3;
                }
                while (true) {
                    if (n2 < n4) break block14;
                    if (n2 >= n5) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n2 = dataBuffer.startOffset;
                    n4 = Math.min(n5 -= n4 - n2, dataBuffer.endOffset);
                }
                throw CharConversionError.insufficientInputToDecodeCharacter().asCharConversionException();
            }
            int n11 = byArray[n2++] & 0xFF;
            if ((0xC0 & n11) != 128) {
                throw UTF8Support.charConversionFailure(4, n6, n9, n8, n11).asCharConversionException();
            }
            nArray[0] = n10 = (n10 << 18) + ((0x3F & n9) << 12) + ((0x3F & n8) << 6) + (0x3F & n11);
            return 4;
        }
        throw UTF8Support.charConversionFailure(1, n6, 0, 0, 0).asCharConversionException();
    }

    public static boolean decodeCharacter(ParsedEntity parsedEntity, int[] nArray) {
        int n2;
        int n3;
        byte[] byArray;
        boolean bl;
        block26: {
            bl = false;
            do {
                byArray = parsedEntity.bytes;
                n3 = parsedEntity.offset;
                n2 = parsedEntity.endOffset;
                if (n3 < n2) break block26;
                if (bl) continue;
                parsedEntity.setMark();
                bl = true;
            } while (parsedEntity.loadMore() != 0);
            if (parsedEntity.atEndOfEntity()) {
                parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
            }
            parsedEntity.resetToMark();
            return parsedEntity.error == null;
        }
        int n4 = byArray[n3++];
        if (n4 >= 0) {
            nArray[0] = n4;
            nArray[1] = 1;
            if (bl) {
                parsedEntity.resetToMark();
            }
            return true;
        }
        int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
        if (n5 > 1) {
            int n6;
            int n7;
            int n8;
            block29: {
                block28: {
                    block27: {
                        nArray[1] = n5;
                        n8 = n4 & fgFirstByteValueMask[n5];
                        while (true) {
                            if (n3 < n2) break block27;
                            if (!bl) {
                                parsedEntity.setMark();
                                bl = true;
                            }
                            if (parsedEntity.loadMore() == 0) break;
                            byArray = parsedEntity.bytes;
                            n3 = parsedEntity.offset;
                            n2 = parsedEntity.endOffset;
                        }
                        if (parsedEntity.atEndOfEntity()) {
                            parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                        }
                        parsedEntity.resetToMark();
                        return parsedEntity.error == null;
                    }
                    n7 = byArray[n3++] & 0xFF;
                    if ((0xC0 & n7) != 128) {
                        parsedEntity.error = UTF8Support.charConversionFailure(2, n4, n7, 0, 0);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return false;
                    }
                    if (n5 == 2) {
                        nArray[0] = n8 = (n8 << 6) + (0x3F & n7);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return true;
                    }
                    while (true) {
                        if (n3 < n2) break block28;
                        if (!bl) {
                            parsedEntity.setMark();
                            bl = true;
                        }
                        if (parsedEntity.loadMore() == 0) break;
                        byArray = parsedEntity.bytes;
                        n3 = parsedEntity.offset;
                        n2 = parsedEntity.endOffset;
                    }
                    if (parsedEntity.atEndOfEntity()) {
                        parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    parsedEntity.resetToMark();
                    return parsedEntity.error == null;
                }
                n6 = byArray[n3++] & 0xFF;
                if ((0xC0 & n6) != 128) {
                    parsedEntity.error = UTF8Support.charConversionFailure(3, n4, n7, n6, 0);
                    if (bl) {
                        parsedEntity.resetToMark();
                    }
                    return false;
                }
                if (n5 == 3) {
                    nArray[0] = n8 = (n8 << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                    if (bl) {
                        parsedEntity.resetToMark();
                    }
                    return true;
                }
                while (true) {
                    if (n3 < n2) break block29;
                    if (!bl) {
                        parsedEntity.setMark();
                        bl = true;
                    }
                    if (parsedEntity.loadMore() == 0) break;
                    byArray = parsedEntity.bytes;
                    n3 = parsedEntity.offset;
                    n2 = parsedEntity.endOffset;
                }
                if (parsedEntity.atEndOfEntity()) {
                    parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                }
                parsedEntity.resetToMark();
                return parsedEntity.error == null;
            }
            int n9 = byArray[n3++] & 0xFF;
            if ((0xC0 & n9) != 128) {
                parsedEntity.error = UTF8Support.charConversionFailure(4, n4, n7, n6, n9);
                if (bl) {
                    parsedEntity.resetToMark();
                }
                return false;
            }
            nArray[0] = n8 = (n8 << 18) + ((0x3F & n7) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
            if (bl) {
                parsedEntity.resetToMark();
            }
            return true;
        }
        parsedEntity.error = UTF8Support.charConversionFailure(1, n4, 0, 0, 0);
        if (bl) {
            parsedEntity.resetToMark();
        }
        return false;
    }

    public static int lengthAsCharacters(DataBuffer dataBuffer, int n2, int n3, int n4, int[] nArray) throws CharConversionException {
        boolean bl;
        int n5 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = (n4 & 8) != 0;
        boolean bl4 = bl = bl3 || (n4 & 4) != 0;
        if (nArray != null) {
            nArray[0] = 0;
        }
        while (true) {
            byte[] byArray = dataBuffer2.bytes;
            int n7 = Math.min(n5, dataBuffer2.endOffset);
            block7: while (n2 < n7) {
                int n8;
                ++n6;
                if ((n8 = byArray[n2++]) >= 0) {
                    if (!bl) continue;
                    if (!bl2) {
                        if (n8 != 13) continue;
                        if (n2 < n7) {
                            n8 = byArray[n2];
                            if (n8 == 10) {
                                ++n2;
                                continue;
                            }
                            if (n8 >= 0) continue;
                            bl2 = true;
                            continue;
                        }
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    if (n8 != 10) continue;
                    --n6;
                    continue;
                }
                switch (fgMultiByteLength[(n8 &= 0xFF) >> 3]) {
                    default: {
                        throw UTF8Support.charConversionFailure(1, n8, 0, 0, 0).asCharConversionException();
                    }
                    case 1: {
                        continue block7;
                    }
                    case 2: {
                        if (bl2 && bl3 && n8 == 194) {
                            if (n2 < n7) {
                                if ((byArray[n2] & 0xFF) == 133) {
                                    --n6;
                                    bl2 = false;
                                }
                            } else if (n7 != n5 && (dataBuffer2.next.bytes[dataBuffer2.next.startOffset] & 0xFF) == 133) {
                                --n6;
                                bl2 = false;
                            }
                        }
                        ++n2;
                        continue block7;
                    }
                    case 3: {
                        n2 += 2;
                        continue block7;
                    }
                    case 4: 
                }
                n2 += 3;
                if (nArray == null) continue;
                nArray[0] = nArray[0] + 1;
            }
            if (n2 == n5) break;
            dataBuffer2 = dataBuffer2.next;
            n2 = dataBuffer2.startOffset + (n2 - n7);
            n5 -= n7 - dataBuffer2.startOffset;
        }
        return n6;
    }

    public static int hashCode(String string2) {
        int n2 = string2.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 * 31 + string2.charAt(i);
        }
        assert (n3 == string2.hashCode());
        return n3;
    }

    public static int hashCode(DataBuffer dataBuffer, int n2, int n3) throws CharConversionException {
        int n4 = n2 + n3;
        byte[] byArray = dataBuffer.bytes;
        int n5 = n2;
        int n6 = 0;
        if (n4 <= dataBuffer.endOffset) {
            while (n5 < n4 && byArray[n5] >= 0) {
                n6 = n6 * 31 + byArray[n5++];
            }
            if (n5 == n4) {
                return n6;
            }
            n2 = n5;
            n3 = n4 - n2;
        }
        return UTF8Support.hashCode2(dataBuffer, n2, n3, n6);
    }

    private static int hashCode2(DataBuffer dataBuffer, int n2, int n3, int n4) throws CharConversionException {
        int n5 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n6 = n2;
        int n7 = Math.min(n5, dataBuffer2.endOffset);
        while (true) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n6 < n7 && (n12 = byArray[n6]) >= 0) {
                ++n6;
                n4 = n4 * 31 + n12;
                continue;
            }
            if (n6 == n5) {
                return n4;
            }
            if (n6 == n7) {
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
                continue;
            }
            if ((n11 = fgMultiByteLength[(n12 = byArray[n6++] & 0xFF) >> 3]) <= 1) {
                throw UTF8Support.charConversionFailure(1, n12, 0, 0, 0).asCharConversionException();
            }
            int n13 = n12 & fgFirstByteValueMask[n11];
            if (n6 == n7) {
                if (n6 == n5) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n10 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(2, n12, n10, 0, 0).asCharConversionException();
            }
            if (n11 == 2) {
                n13 = (n13 << 6) + (0x3F & n10);
                n4 = n4 * 31 + n13;
                continue;
            }
            if (n6 == n7) {
                if (n6 == n5) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n9 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(3, n12, n10, n9, 0).asCharConversionException();
            }
            if (n11 == 3) {
                if ((n13 = (n13 << 12) + ((0x3F & n10) << 6) + (0x3F & n9)) >= 55296 && n13 < 57344) {
                    throw UTF8Support.charConversionFailure(1, n12, n10, n9, 0).asCharConversionException();
                }
                n4 = n4 * 31 + n13;
                continue;
            }
            if (n6 == n7) {
                if (n6 == n5) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n6 = dataBuffer2.startOffset;
                n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n8 = byArray[n6++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(4, n12, n10, n9, n8).asCharConversionException();
            }
            n13 = (n13 << 18) + ((0x3F & n10) << 12) + ((0x3F & n9) << 6) + (0x3F & n8);
            int n14 = n13 - 65536;
            n13 = 55296 + (n14 >> 10);
            n4 = n4 * 31 + n13;
            n13 = 56320 + (n14 & 0x3FF);
            n4 = n4 * 31 + n13;
        }
    }

    public static int hashCode(String string2, int[] nArray, int n2) {
        int n3 = string2.length();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 = n4 * nArray[i & n2] + string2.charAt(i);
        }
        return n4;
    }

    public static int hashCode(XMLString xMLString, int[] nArray, int n2) throws CharConversionException {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        int n3 = xMLString.startOffset;
        int n4 = xMLString.length;
        int n5 = n3 + n4;
        byte[] byArray = dataBuffer.bytes;
        int n6 = n3;
        int n7 = 0;
        int n8 = 0;
        if (n5 <= dataBuffer.endOffset) {
            while (n6 < n5 && byArray[n6] >= 0) {
                n7 = n7 * nArray[n8++ & n2] + byArray[n6++];
            }
            if (n6 == n5) {
                return n7;
            }
            n3 = n6;
            n4 = n5 - n3;
        }
        return UTF8Support.hashCode2(dataBuffer, n3, n4, n7, nArray, n2, n8);
    }

    private static int hashCode2(DataBuffer dataBuffer, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws CharConversionException {
        int n7 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n8 = n2;
        int n9 = Math.min(n7, dataBuffer2.endOffset);
        while (true) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            if (n8 < n9 && (n14 = byArray[n8]) >= 0) {
                ++n8;
                n4 = n4 * nArray[n6++ & n5] + n14;
                continue;
            }
            if (n8 == n7) {
                return n4;
            }
            if (n8 == n9) {
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n8 = dataBuffer2.startOffset;
                n9 = Math.min(n7 -= n9 - n8, dataBuffer2.endOffset);
                continue;
            }
            if ((n13 = fgMultiByteLength[(n14 = byArray[n8++] & 0xFF) >> 3]) <= 1) {
                throw UTF8Support.charConversionFailure(1, n14, 0, 0, 0).asCharConversionException();
            }
            int n15 = n14 & fgFirstByteValueMask[n13];
            if (n8 == n9) {
                if (n8 == n7) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n8 = dataBuffer2.startOffset;
                n9 = Math.min(n7 -= n9 - n8, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n12 = byArray[n8++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(2, n14, n12, 0, 0).asCharConversionException();
            }
            if (n13 == 2) {
                n15 = (n15 << 6) + (0x3F & n12);
                n4 = n4 * nArray[n6++ & n5] + n15;
                continue;
            }
            if (n8 == n9) {
                if (n8 == n7) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n8 = dataBuffer2.startOffset;
                n9 = Math.min(n7 -= n9 - n8, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n11 = byArray[n8++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(3, n14, n12, n11, 0).asCharConversionException();
            }
            if (n13 == 3) {
                if ((n15 = (n15 << 12) + ((0x3F & n12) << 6) + (0x3F & n11)) >= 55296 && n15 < 57344) {
                    throw UTF8Support.charConversionFailure(1, n14, n12, n11, 0).asCharConversionException();
                }
                n4 = n4 * nArray[n6++ & n5] + n15;
                continue;
            }
            if (n8 == n9) {
                if (n8 == n7) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n8 = dataBuffer2.startOffset;
                n9 = Math.min(n7 -= n9 - n8, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n10 = byArray[n8++] & 0xFF)) != 128) {
                throw UTF8Support.charConversionFailure(4, n14, n12, n11, n10).asCharConversionException();
            }
            n15 = (n15 << 18) + ((0x3F & n12) << 12) + ((0x3F & n11) << 6) + (0x3F & n10);
            int n16 = n15 - 65536;
            n15 = 55296 + (n16 >> 10);
            n4 = n4 * nArray[n6++ & n5] + n15;
            n15 = 56320 + (n16 & 0x3FF);
            n4 = n4 * nArray[n6++ & n5] + n15;
        }
    }

    public static boolean isAllWhitespace(DataBuffer dataBuffer, int n2, int n3, int n4) throws CharConversionException {
        boolean bl;
        int n5 = n2 + n3;
        byte[] byArray = dataBuffer.bytes;
        int n6 = n2;
        boolean bl2 = bl = (n4 & 8) != 0;
        if (n5 <= dataBuffer.endOffset) {
            while (n6 < n5) {
                byte by2;
                if ((by2 = byArray[n6++]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) continue;
                if (!bl || (by2 & 0xDF) != 194) {
                    return false;
                }
                if (n6 == n5) {
                    throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                }
                if ((by2 & 0xFF) == 194 && (byArray[n6] & 0xFF) == 133) {
                    ++n6;
                    continue;
                }
                if ((by2 & 0xFF) == 226 && (byArray[n6] & 0xFF) == 128) {
                    if (n6 + 1 == n5) {
                        throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                    }
                    if ((byArray[n6 + 1] & 0xFF) == 168) {
                        n6 += 2;
                        continue;
                    }
                }
                return false;
            }
            return true;
        }
        return UTF8Support.isAllWhitespace2(dataBuffer, n2, n3, n4);
    }

    private static boolean isAllWhitespace2(DataBuffer dataBuffer, int n2, int n3, int n4) throws CharConversionException {
        boolean bl;
        int n5 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n6 = n2;
        int n7 = Math.min(n5, dataBuffer2.endOffset);
        boolean bl2 = bl = (n4 & 8) != 0;
        while (true) {
            if (n6 < n7) {
                byte by2;
                if ((by2 = byArray[n6++]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) continue;
                if (!bl || (by2 & 0xDF) != 194) {
                    return false;
                }
                if (n6 == n7) {
                    if (n6 == n5) {
                        throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                    }
                    dataBuffer2 = dataBuffer2.next;
                    byArray = dataBuffer2.bytes;
                    n6 = dataBuffer2.startOffset;
                    n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
                }
                if ((by2 & 0xFF) == 194 && (byArray[n6] & 0xFF) == 133) {
                    ++n6;
                    continue;
                }
                if ((by2 & 0xFF) != 226 || (byArray[n6] & 0xFF) != 128) {
                    return false;
                }
                if (++n6 == n7) {
                    if (n6 == n5) {
                        throw CharConversionError.partialMultiPartCharacterSequence().asCharConversionException();
                    }
                    dataBuffer2 = dataBuffer2.next;
                    byArray = dataBuffer2.bytes;
                    n6 = dataBuffer2.startOffset;
                    n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
                }
                if ((byArray[n6++] & 0xFF) == 168) continue;
                return false;
            }
            if (n6 == n5) {
                return true;
            }
            dataBuffer2 = dataBuffer2.next;
            byArray = dataBuffer2.bytes;
            n6 = dataBuffer2.startOffset;
            n7 = Math.min(n5 -= n7 - n6, dataBuffer2.endOffset);
        }
    }

    public static int sendBytes(DataBuffer dataBuffer, int n2, int n3, int n4, ByteConversionHandler byteConversionHandler) {
        if ((n4 & 0xC) != 0) {
            return UTF8Support.sendNormalizedBytes(dataBuffer, n2, n3, (n4 & 8) != 0, byteConversionHandler);
        }
        if (byteConversionHandler == null) {
            return n3;
        }
        return UTF8Support.sendBytes(dataBuffer, n2, n3, byteConversionHandler);
    }

    private static int sendBytes(DataBuffer dataBuffer, int n2, int n3, ByteConversionHandler byteConversionHandler) {
        if (n2 + n3 <= dataBuffer.endOffset) {
            byteConversionHandler.receiveBytes(dataBuffer.bytes, n2, n3, true);
            return n3;
        }
        return UTF8Support.sendBytes2(dataBuffer, n2, n3, byteConversionHandler);
    }

    private static int sendBytes2(DataBuffer dataBuffer, int n2, int n3, ByteConversionHandler byteConversionHandler) {
        int n4;
        int n5 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        int n6 = n2;
        do {
            byte[] byArray = dataBuffer2.bytes;
            n4 = dataBuffer2.endOffset;
            byteConversionHandler.receiveBytes(byArray, n6, n4 - n6, false);
            dataBuffer2 = dataBuffer2.next;
        } while ((n5 -= n4 - (n6 = dataBuffer2.startOffset)) > dataBuffer2.endOffset);
        byteConversionHandler.receiveBytes(dataBuffer2.bytes, n6, n5 - n6, true);
        return n3;
    }

    private static int sendNormalizedBytes(DataBuffer dataBuffer, int n2, int n3, boolean bl, ByteConversionHandler byteConversionHandler) {
        int n4;
        int n5;
        int n6;
        int n7;
        block10: {
            n7 = n2 + n3;
            byte[] byArray = dataBuffer.bytes;
            n6 = n2;
            n5 = n2;
            n4 = n3;
            if (n7 <= dataBuffer.endOffset) {
                while (n5 < n7) {
                    if (byArray[n5] != 13) {
                        if (byArray[n5] >= 0) {
                            ++n5;
                            continue;
                        }
                        break block10;
                    }
                    if (n5 > n6 && byteConversionHandler != null) {
                        byteConversionHandler.receiveBytes(byArray, n6, n5 - n6, false);
                    }
                    ++n5;
                    if (byteConversionHandler != null) {
                        byteConversionHandler.receiveByte((byte)10);
                    }
                    if (n5 < n7 && byArray[n5] == 10) {
                        --n4;
                    } else if (bl && n5 + 1 < n7 && (byArray[n5] & 0xFF) == 194 && (byArray[n5 + 1] & 0xFF) == 133) {
                        n5 += 2;
                        n4 -= 2;
                    }
                    n6 = ++n5;
                }
                if (n5 > n6 && byteConversionHandler != null) {
                    byteConversionHandler.receiveBytes(byArray, n6, n5 - n6, true);
                }
                return n4;
            }
        }
        return UTF8Support.sendNormalizedBytes2(dataBuffer, n6, n7 - n6, n5, bl, n4, byteConversionHandler);
    }

    private static int sendNormalizedBytes2(DataBuffer dataBuffer, int n2, int n3, int n4, boolean bl, int n5, ByteConversionHandler byteConversionHandler) {
        int n6 = n2 + n3;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n7 = n2;
        int n8 = Math.min(n6, dataBuffer2.endOffset);
        boolean bl2 = false;
        while (true) {
            boolean bl3;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n4 < n8) {
                n12 = byArray[n4];
                if (!bl || n12 >= 0) {
                    if (n12 != 13) {
                        ++n4;
                        continue;
                    }
                    if (n4 > n7 && byteConversionHandler != null) {
                        byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                    }
                    ++n4;
                    if (byteConversionHandler != null) {
                        byteConversionHandler.receiveByte((byte)10);
                    }
                    if (n4 < n8) {
                        n12 = byArray[n4];
                        if (n12 == 10) {
                            ++n4;
                            --n5;
                            continue;
                        }
                        if (!bl || n12 >= 0) continue;
                    }
                    bl2 = true;
                }
            }
            if (n4 == n6) {
                if (n4 > n7 && byteConversionHandler != null) {
                    byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, true);
                }
                return n5;
            }
            if (n4 == n8) {
                if (n4 > n7 && byteConversionHandler != null) {
                    byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n4 = dataBuffer2.startOffset;
                n7 = n4;
                n8 = Math.min(n6 -= n8 - n4, dataBuffer2.endOffset);
                if (!bl2 || n4 >= n8) continue;
                n12 = byArray[n4];
                if (n12 == 10) {
                    ++n4;
                    --n5;
                    bl2 = false;
                    continue;
                }
                if (!bl || n12 >= 0) {
                    bl2 = false;
                    continue;
                }
            }
            assert (bl);
            n12 = byArray[n4] & 0xFF;
            int n13 = fgMultiByteLength[n12 >> 3];
            if (n13 == 0) {
                throw new IOExceptionWrapper(UTF8Support.charConversionFailure(1, n12, 0, 0, 0).asCharConversionException());
            }
            if ((n12 & 0xDF) != 194) {
                bl2 = false;
                if (n4 + n13 <= n8) {
                    n4 += n13;
                    continue;
                }
                n11 = n4 + n13 - n8;
                n4 = n8;
                if (n4 > n7 && byteConversionHandler != null) {
                    byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n7 = dataBuffer2.startOffset;
                n4 = dataBuffer2.startOffset + n11;
                n8 = Math.min(n6 -= n8 - dataBuffer2.startOffset, dataBuffer2.endOffset);
                continue;
            }
            if (n12 == 194) {
                n11 = n4 + 1 < n8 ? 1 : 0;
                n10 = (n11 != 0 ? byArray[n4 + 1] : dataBuffer2.next.bytes[dataBuffer2.next.startOffset]) & 0xFF;
                int n14 = n9 = n10 == 133 ? 1 : 0;
                if (n9 != 0) {
                    if (n4 > n7 && byteConversionHandler != null) {
                        byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                    }
                    n7 = n8;
                }
                if (n11 != 0) {
                    n4 += 2;
                } else {
                    n4 = n8;
                    if (n4 > n7 && byteConversionHandler != null) {
                        byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                    }
                    dataBuffer2 = dataBuffer2.next;
                    byArray = dataBuffer2.bytes;
                    n4 = dataBuffer2.startOffset + 1;
                    n8 = Math.min(n6 -= n8 - dataBuffer2.startOffset, dataBuffer2.endOffset);
                }
                if (n9 != 0) {
                    if (bl2) {
                        n5 -= 2;
                    } else {
                        byteConversionHandler.receiveByte((byte)10);
                        --n5;
                    }
                    n7 = n4;
                }
                bl2 = false;
                continue;
            }
            if (n12 != 226) continue;
            n11 = n4 + 3 - n8;
            n10 = n11 > 0 ? 1 : 0;
            n9 = (n4 + 1 < n8 ? byArray[n4 + 1] : dataBuffer2.next.bytes[dataBuffer2.next.startOffset]) & 0xFF;
            int n15 = (n10 != 0 ? byArray[n4 + 2] : dataBuffer2.next.bytes[dataBuffer2.next.startOffset + n11 - 1]) & 0xFF;
            boolean bl4 = bl3 = n9 == 128 && n15 == 168;
            if (bl3) {
                if (n4 > n7 && byteConversionHandler != null) {
                    byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                }
                n7 = n8;
            }
            if (n10 != 0) {
                n4 += 3;
            } else {
                n4 = n8;
                if (n4 > n7 && byteConversionHandler != null) {
                    byteConversionHandler.receiveBytes(byArray, n7, n4 - n7, false);
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n4 = dataBuffer2.startOffset + n11;
                n8 = Math.min(n6 -= n8 - dataBuffer2.startOffset, dataBuffer2.endOffset);
            }
            if (bl3) {
                byteConversionHandler.receiveByte((byte)10);
                n5 -= 2;
                n7 = n4;
            }
            bl2 = false;
        }
    }

    private UTF8Support() {
    }

    private static char[] resize(char[] cArray) {
        return ArrayAllocator.resizeCharArray(cArray, cArray.length << 1);
    }

    private static CharConversionError charConversionFailure(int n2, int n3, int n4, int n5, int n6) {
        return CharConversionError.invalidUTF8CharacterEncoding(n2, n3, n4, n5, n6);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class ConversionResources
    extends CharConversionResources {
        public CharConversionHandler.StringHandler stringReceiver;

        public ConversionResources() {
            super(8192, false);
        }
    }
}

