/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.Pool;
import java.lang.ref.SoftReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
class UnsynchronizedPool<E> {
    private static final int MAXIMUM_SIZE = 10;
    public final int id;
    public final String genericType;
    public final String idLabel;
    private final boolean shared;
    private final ReferencePool<E> refPool;
    private final E[] array;
    protected int size;
    private int askCount;
    private int inCount;
    private int outCount;
    protected boolean clearLocalPool;

    public UnsynchronizedPool(int n2, String string2, boolean bl) {
        this.id = n2;
        this.genericType = string2;
        this.shared = bl;
        this.idLabel = "Pool<" + string2 + "> #" + n2 + ": ";
        this.refPool = new ReferencePool();
        this.array = ArrayAllocator.newObjectArray(10);
        this.size = 0;
    }

    protected boolean switchToSharedPool(int n2) {
        return n2 > 0;
    }

    protected static String xlxpThreadLabel() {
        return "***XLXP[" + Thread.currentThread().getId() + "]*** ";
    }

    protected String idLabel() {
        return UnsynchronizedPool.xlxpThreadLabel() + this.idLabel;
    }

    private void checkForDuplicate(E e) {
        for (int i = 0; i < this.size; ++i) {
            if (e != this.array[i]) continue;
            throw new RuntimeException(this.idLabel() + "instance " + e + " is already in the Pool");
        }
        if (this.refPool.checkForDuplicate(e)) {
            throw new RuntimeException(this.idLabel() + "instance " + e + " is already in the Pool");
        }
    }

    private void printStackTrace() {
        if (LoggerUtil.isFinestLoggable(Pool.logger)) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 2; i < Math.min(32, stackTraceElementArray.length); ++i) {
                stringBuilder.append(stackTraceElementArray[i]);
                stringBuilder.append('\n');
            }
            Pool.logger.logp(Level.FINEST, this.getClass().getName(), "printStackTrace", stringBuilder.toString());
        }
    }

    public E get() {
        E e;
        if (this.size > 0) {
            e = this.array[--this.size];
            this.array[this.size] = null;
        } else {
            e = this.refPool.get();
        }
        if (e != null) {
            if (LoggerUtil.isFineLoggable(Pool.logger)) {
                Pool.logger.logp(Level.FINER, this.getClass().getName(), "get", this.idLabel() + "returning instance " + LoggerUtil.getUniqueString(e) + " (" + this.size + " direct references remaining)");
                this.printStackTrace();
            }
            this.checkForDuplicate(e);
            if (!this.shared) {
                ++this.askCount;
                ++this.outCount;
            }
        } else {
            if (LoggerUtil.isFineLoggable(Pool.logger)) {
                Pool.logger.logp(Level.FINER, this.getClass().getName(), "get", this.idLabel() + "returning null");
            }
            if (!this.shared) {
                ++this.askCount;
            }
        }
        return e;
    }

    public void put(E e) {
        if (LoggerUtil.isFineLoggable(Pool.logger)) {
            Pool.logger.logp(Level.FINER, this.getClass().getName(), "put", this.idLabel() + "adding instance " + LoggerUtil.getUniqueString(e));
            this.printStackTrace();
        }
        this.internalPut(e);
        ++this.inCount;
    }

    void internalPut(E e) {
        this.checkForDuplicate(e);
        if (this.size < 10) {
            this.array[this.size++] = e;
        } else {
            this.refPool.put(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class ReferencePool<E> {
        private SoftReference<E>[] array = ArrayAllocator.newObjectArray(SoftReference.class, 8);
        private int size = 0;

        public E get() {
            while (this.size > 0) {
                --this.size;
                E e = this.array[this.size].get();
                this.array[this.size] = null;
                if (e != null) {
                    return e;
                }
                this.removeDeadReferences();
            }
            return null;
        }

        public void put(E e) {
            if (this.size == this.array.length) {
                this.array = ArrayAllocator.resizeObjectArray(SoftReference.class, this.array, this.size * 2);
            }
            this.array[this.size++] = new SoftReference<E>(e);
        }

        public boolean checkForDuplicate(E e) {
            for (int i = 0; i < this.size; ++i) {
                if (e != this.array[i].get()) continue;
                return true;
            }
            return false;
        }

        private void removeDeadReferences() {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.size; ++n2) {
                SoftReference<E> softReference = this.array[n2];
                if (softReference.get() == null) continue;
                this.array[n3++] = softReference;
            }
            for (n2 = n3; n2 < this.size; ++n2) {
                this.array[n2] = null;
            }
            this.size = n3;
        }
    }
}

