/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import java.io.CharConversionException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLCharSequence
implements CharSequence {
    private DataBuffer fFirstBuffer;
    private int fStartOffset;
    private int fLength;
    private char[] fChars;

    public XMLCharSequence() {
    }

    private XMLCharSequence(char[] cArray, int n2, int n3) {
        this.fFirstBuffer = null;
        this.fStartOffset = n2;
        this.fLength = n3;
        this.fChars = cArray;
    }

    private XMLCharSequence(DataBuffer dataBuffer, int n2, int n3) {
        this.fFirstBuffer = dataBuffer;
        this.fStartOffset = n2;
        this.fLength = n3;
        this.fChars = null;
    }

    public void setValues(DataBuffer dataBuffer, int n2, int n3) {
        try {
            int[] nArray = ArrayAllocator.newIntArray(1);
            int n4 = UTF8Support.lengthAsCharacters(dataBuffer, n2, n3, 0, nArray);
            if (n4 == n3) {
                this.fFirstBuffer = dataBuffer;
                this.fStartOffset = n2;
                this.fLength = n3;
                this.fChars = null;
            } else {
                this.fFirstBuffer = null;
                this.fStartOffset = 0;
                this.fChars = ArrayAllocator.newCharArray(n4 += nArray[0]);
                this.fLength = UTF8Support.convertBytesToChars(dataBuffer, n2, n3, 0, new CharConversionHandler.FixedLengthCharArrayHandler(this.fChars));
                assert (n4 == this.fLength);
            }
        }
        catch (CharConversionException charConversionException) {
            FFDCUtil.log(charConversionException, this);
            throw new IOExceptionWrapper(charConversionException);
        }
    }

    public char charAt(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (this.fChars != null) {
            return this.fChars[this.fStartOffset + n2];
        }
        return this.charFromByteAt(n2);
    }

    public int needsEscaping(int n2, int n3, byte[] byArray) {
        char c;
        int n4;
        byte[] byArray2;
        if (n2 < 0 || n2 > this.fLength) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 < n2 || n3 > this.fLength) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (this.fChars != null) {
            int n5 = this.fStartOffset + n3;
            for (int i = this.fStartOffset + n2; i < n5; ++i) {
                char c2 = this.fChars[i];
                if (c2 < byArray.length && byArray[c2] == 0) continue;
                return i - this.fStartOffset;
            }
            return -1;
        }
        int n6 = n2;
        int n7 = n3 - n2;
        DataBuffer dataBuffer = this.fFirstBuffer;
        int n8 = this.fStartOffset;
        int n9 = dataBuffer.endOffset - n8;
        while (n2 >= n9) {
            n2 -= n9;
            dataBuffer = dataBuffer.next;
            n8 = dataBuffer.startOffset;
            n9 = dataBuffer.endOffset - n8;
        }
        n8 += n2;
        n9 -= n2;
        while (n7 > n9) {
            byArray2 = dataBuffer.bytes;
            n4 = dataBuffer.endOffset;
            while (n8 < n4) {
                if ((c = (char)byArray2[n8++]) >= byArray.length || byArray[c] != 0) {
                    return n6;
                }
                ++n6;
            }
            n7 -= n9;
            dataBuffer = dataBuffer.next;
            n8 = dataBuffer.startOffset;
            n9 = dataBuffer.endOffset - n8;
        }
        byArray2 = dataBuffer.bytes;
        n4 = n8 + n7;
        while (n8 < n4) {
            if ((c = (char)byArray2[n8++]) >= byArray.length || byArray[c] != 0) {
                return n6;
            }
            ++n6;
        }
        return -1;
    }

    private char charFromByteAt(int n2) {
        DataBuffer dataBuffer = this.fFirstBuffer;
        int n3 = this.fStartOffset;
        while (n3 + n2 >= dataBuffer.endOffset) {
            n2 -= dataBuffer.endOffset - n3;
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
        }
        return (char)dataBuffer.bytes[n3 + n2];
    }

    public int length() {
        return this.fLength;
    }

    public CharSequence subSequence(int n2, int n3) {
        if (n2 < 0 || n2 > this.fLength) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 < n2 || n3 > this.fLength) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        int n4 = n3 - n2;
        if (n4 == 0) {
            return new XMLCharSequence();
        }
        if (this.fChars != null) {
            return new XMLCharSequence(this.fChars, this.fStartOffset + n2, n4);
        }
        DataBuffer dataBuffer = this.fFirstBuffer;
        int n5 = this.fStartOffset;
        while (n5 + n2 >= dataBuffer.endOffset) {
            n2 -= dataBuffer.endOffset - n5;
            dataBuffer = dataBuffer.next;
            n5 = dataBuffer.startOffset;
        }
        return new XMLCharSequence(dataBuffer, n5 + n2, n4);
    }

    public String toString() {
        if (this.fChars != null) {
            return new String(this.fChars, this.fStartOffset, this.fLength);
        }
        if (this.fFirstBuffer != null) {
            int n2;
            byte[] byArray;
            StringBuilder stringBuilder = new StringBuilder(this.fLength);
            DataBuffer dataBuffer = this.fFirstBuffer;
            int n3 = this.fStartOffset;
            int n4 = this.fLength;
            while (n3 + n4 > dataBuffer.endOffset) {
                byArray = dataBuffer.bytes;
                n2 = dataBuffer.endOffset;
                n4 -= n2 - n3;
                while (n3 < n2) {
                    stringBuilder.append((char)byArray[n3++]);
                }
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
            }
            byArray = dataBuffer.bytes;
            n2 = n3 + n4;
            while (n3 < n2) {
                stringBuilder.append((char)byArray[n3++]);
            }
            return stringBuilder.toString();
        }
        return new String();
    }
}

