/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionHandler;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionResources;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharIterator;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import java.io.CharConversionException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLString
extends DataBufferReferrer {
    private static final Logger logger = LoggerUtil.getLogger(XMLString.class);
    public static final short FLAGS_NOTWHITESPACE = 1;
    public static final short FLAGS_ALLWHITESPACE = 2;
    public static final short FLAGS_NORMALIZE_EOL = 4;
    public static final short FLAGS_NORMALIZE_EOL11 = 8;
    public static final short FLAGS_NORMALIZE_EOL_MASK = 12;
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public short flags;
    public short encodeFlags;
    public int hashcode;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;

    public XMLString() {
    }

    public boolean hasReferenceTo(DataBuffer dataBuffer) {
        if (this.firstBuffer == dataBuffer) {
            return true;
        }
        if (this.bytes != null || this.firstBuffer == null) {
            return false;
        }
        if (this.lastBuffer != null) {
            DataBuffer dataBuffer2 = this.firstBuffer.next;
            while (true) {
                if (dataBuffer2 == dataBuffer) {
                    return true;
                }
                if (dataBuffer2 == this.lastBuffer) {
                    return false;
                }
                dataBuffer2 = dataBuffer2.next;
            }
        }
        if (this.firstBuffer.next == null) {
            return false;
        }
        DataBuffer dataBuffer3 = this.firstBuffer.next;
        while (dataBuffer3 != dataBuffer) {
            if (dataBuffer3 == null) {
                return false;
            }
            dataBuffer3 = dataBuffer3.next;
        }
        return true;
    }

    public void removeReferencesAndUnregister() {
        this.unregister();
    }

    public XMLString(XMLString xMLString) {
        this();
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.flags = xMLString.flags;
        this.encodeFlags = xMLString.encodeFlags;
        this.hashcode = xMLString.hashcode;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
        if (xMLString.factory != null) {
            xMLString.factory.addReferrer(this);
            assert (this.factory != null);
        }
        this.active = this.firstBuffer != null;
    }

    public XMLCharIterator createXMLCharIterator() {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "createXMLCharIterator", "Creating an iterator for data[" + this.toString() + "]");
        }
        return new XMLCharIteratorImpl(this.firstBuffer, this.startOffset, this.length);
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.flags = 0;
            this.encodeFlags = 0;
            this.hashcode = 0;
            this.firstBuffer = null;
            this.lastBuffer = null;
            this.active = false;
        }
    }

    public void unregister() {
        this.clear();
        if (this.factory != null) {
            this.factory.removeReferrer(this);
            assert (this.factory == null);
        }
    }

    public final void setValuesUsingLength(DataBuffer dataBuffer, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= dataBuffer.endOffset) {
            this.setValues(dataBuffer, n2, n4);
        } else {
            this.setStartPos(dataBuffer, n2);
            DataBuffer dataBuffer2 = dataBuffer;
            do {
                dataBuffer2 = dataBuffer2.next;
            } while ((n4 -= dataBuffer2.endOffset - dataBuffer2.next.startOffset) > dataBuffer2.endOffset);
            this.setEndPos(dataBuffer2, n4);
        }
    }

    public final void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3) {
        if (dataBuffer2 == null) {
            this.setValues(dataBuffer, n2, n3);
        } else {
            this.setStartPos(dataBuffer, n2);
            this.setEndPos(dataBuffer2, n3);
        }
    }

    public final void setValues(DataBuffer dataBuffer, int n2, int n3) {
        if (this.lastBuffer == null && n2 < dataBuffer.endOffset) {
            this.startOffset = n2;
            this.endOffset = n3;
            this.length = n3 - n2;
            this.bytes = dataBuffer.bytes;
            this.flags = 0;
            this.encodeFlags = 0;
            this.hashcode = 0;
            if (this.firstBuffer != dataBuffer) {
                this.firstBuffer = dataBuffer;
                if (this.factory != this.firstBuffer.factory) {
                    if (this.factory != null) {
                        this.factory.removeReferrer(this);
                        assert (this.factory == null);
                    }
                    this.firstBuffer.factory.addReferrer(this);
                    assert (this.factory != null);
                }
                this.active = true;
            }
        } else {
            this.setStartPos(dataBuffer, n2);
            this.setEndPos(dataBuffer, n3);
        }
    }

    public final void setStartPos(DataBuffer dataBuffer, int n2) {
        this.startOffset = n2;
        this.endOffset = 0;
        this.length = 0;
        this.bytes = null;
        this.flags = 0;
        this.encodeFlags = 0;
        this.hashcode = 0;
        this.firstBuffer = dataBuffer;
        this.lastBuffer = null;
        if (this.factory != this.firstBuffer.factory) {
            if (this.factory != null) {
                this.factory.removeReferrer(this);
                assert (this.factory == null);
            }
            this.firstBuffer.factory.addReferrer(this);
            assert (this.factory != null);
        }
        this.active = true;
    }

    public final void setEndPos(DataBuffer dataBuffer, int n2) {
        while (dataBuffer != this.firstBuffer) {
            if (this.startOffset < this.firstBuffer.endOffset) {
                if (n2 > dataBuffer.startOffset) {
                    this.setEndPosAcrossBuffers(dataBuffer, n2);
                    return;
                }
                dataBuffer = this.fixEndPos(dataBuffer);
                n2 = dataBuffer.endOffset;
                continue;
            }
            this.fixStartPos();
        }
        this.endOffset = n2;
        this.length = n2 - this.startOffset;
        this.bytes = dataBuffer.bytes;
        this.lastBuffer = null;
    }

    public void clearEndPos() {
        this.bytes = null;
        this.lastBuffer = null;
    }

    private final void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n2) {
        this.bytes = null;
        DataBuffer dataBuffer2 = this.firstBuffer;
        this.length = dataBuffer2.endOffset - this.startOffset;
        while ((dataBuffer2 = dataBuffer2.next) != dataBuffer) {
            this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
        }
        this.length += n2 - dataBuffer2.startOffset;
        this.lastBuffer = dataBuffer2;
        this.endOffset = n2;
    }

    private final void fixStartPos() {
        this.firstBuffer = this.firstBuffer.next;
        this.startOffset = this.firstBuffer.startOffset;
    }

    private final DataBuffer fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        return dataBuffer2;
    }

    public void setValues(XMLString xMLString) {
        if (xMLString != null && xMLString.firstBuffer != null) {
            this.bytes = xMLString.bytes;
            this.startOffset = xMLString.startOffset;
            this.endOffset = xMLString.endOffset;
            this.length = xMLString.length;
            this.flags = xMLString.flags;
            this.encodeFlags = xMLString.encodeFlags;
            this.hashcode = xMLString.hashcode;
            this.firstBuffer = xMLString.firstBuffer;
            this.lastBuffer = xMLString.lastBuffer;
            if (this.factory != this.firstBuffer.factory) {
                if (this.factory != null) {
                    this.factory.removeReferrer(this);
                    assert (this.factory == null);
                }
                this.firstBuffer.factory.addReferrer(this);
                assert (this.factory != null);
            }
            this.active = true;
        } else {
            this.clear();
        }
    }

    public final boolean isAllWhitespace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        if (this.length > 0) {
            try {
                if (UTF8Support.isAllWhitespace(this.firstBuffer, this.startOffset, this.length, this.flags)) {
                    this.flags = (short)(this.flags | 2);
                    return true;
                }
                this.flags = (short)(this.flags | 1);
                return false;
            }
            catch (CharConversionException charConversionException) {
                FFDCUtil.log(charConversionException, this);
                throw new IOExceptionWrapper(charConversionException);
            }
        }
        this.flags = (short)(this.flags | 2);
        return true;
    }

    public final boolean isNormalized() {
        byte by2;
        if (this.length == 0) {
            return true;
        }
        if (this.bytes != null) {
            int n2 = this.startOffset;
            while (n2 < this.endOffset) {
                byte by3 = this.bytes[n2];
                if (by3 < 0 || by3 > 32) {
                    while ((by3 < 0 || by3 > 32) && ++n2 < this.endOffset) {
                        by3 = this.bytes[n2];
                    }
                    if (n2 >= this.endOffset || by3 >= 32 && ++n2 != this.endOffset) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n3 = this.startOffset;
        int n4 = dataBuffer.endOffset;
        while ((by2 = byArray[n3]) < 0 || by2 > 32) {
            while (by2 < 0 || by2 > 32) {
                if (++n3 < n4) {
                    by2 = byArray[n3];
                    continue;
                }
                if (dataBuffer == this.lastBuffer) {
                    return true;
                }
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                by2 = byArray[n3];
            }
            if (by2 < 32) {
                return false;
            }
            if (++n3 != n4) continue;
            if (dataBuffer == this.lastBuffer) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.startOffset;
            if (dataBuffer == this.lastBuffer) {
                n4 = this.endOffset;
                continue;
            }
            n4 = dataBuffer.endOffset;
        }
        return false;
    }

    public final boolean equalsXMLString(XMLString xMLString) {
        if (xMLString == this) {
            return true;
        }
        if (this.length > 0 && this.length == xMLString.length) {
            if (this.bytes != null && xMLString.bytes != null) {
                int n2 = this.length;
                if (this.bytes[this.startOffset] != xMLString.bytes[xMLString.startOffset]) {
                    return false;
                }
                while (--n2 > 0) {
                    if (this.bytes[this.startOffset + n2] == xMLString.bytes[xMLString.startOffset + n2]) continue;
                    return false;
                }
                return true;
            }
            DataBuffer dataBuffer = this.firstBuffer;
            DataBuffer dataBuffer2 = xMLString.firstBuffer;
            byte[] byArray = dataBuffer.bytes;
            int n3 = this.startOffset;
            byte[] byArray2 = dataBuffer2.bytes;
            int n4 = xMLString.startOffset;
            if (byArray[n3] != byArray2[n4]) {
                return false;
            }
            DataBuffer dataBuffer3 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
            DataBuffer dataBuffer4 = xMLString.lastBuffer != null ? xMLString.lastBuffer : dataBuffer2;
            int n5 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
            int n6 = xMLString.lastBuffer != null ? dataBuffer2.endOffset : xMLString.endOffset;
            int n7 = this.length;
            while (--n7 > 0) {
                if (++n3 == n5) {
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n3 = dataBuffer.startOffset;
                    int n8 = n5 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : this.endOffset;
                }
                if (++n4 == n6) {
                    dataBuffer2 = dataBuffer2.next;
                    byArray2 = dataBuffer2.bytes;
                    n4 = dataBuffer2.startOffset;
                    int n9 = n6 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLString.endOffset;
                }
                if (byArray[n3] == byArray2[n4]) continue;
                return false;
            }
            return true;
        }
        return this.length == xMLString.length;
    }

    protected final boolean equalsString(String string2) {
        int n2 = this.startOffset;
        if (this.bytes != null) {
            int n3 = string2.length();
            for (int i = 0; i < n3; ++i) {
                char c = string2.charAt(i);
                if (c == this.bytes[n2]) {
                    ++n2;
                    continue;
                }
                if (c < '\u0080') {
                    return false;
                }
                return this.toString().equals(string2);
            }
            return n2 == this.endOffset;
        }
        return this.toString().equals(string2);
    }

    public final boolean equalsString(byte[] byArray, int n2, int n3) {
        if (n2 + this.length == n3) {
            if (this.length > 0) {
                int n4 = this.startOffset;
                if (this.bytes != null) {
                    while (this.bytes[n4++] == byArray[n2] && ++n2 < n3 && this.bytes[n4++] == byArray[n2] && ++n2 < n3 && this.bytes[n4++] == byArray[n2] && ++n2 < n3) {
                    }
                    return n2 == n3;
                }
                DataBuffer dataBuffer = this.firstBuffer;
                while (true) {
                    int n5;
                    byte[] byArray2 = dataBuffer.bytes;
                    int n6 = n5 = dataBuffer != this.lastBuffer ? dataBuffer.endOffset : this.endOffset;
                    while (byArray2[n4] == byArray[n2++] && ++n4 < n5) {
                    }
                    if (n4 != n5) break;
                    if (dataBuffer == this.lastBuffer) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    n4 = dataBuffer.startOffset;
                }
                return false;
            }
            return n2 == n3;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        this.hashcode = this.computeHashcode();
        assert (this.hashcode == this.toString().hashCode());
        return this.hashcode;
    }

    private int computeHashcode() {
        try {
            return UTF8Support.hashCode(this.firstBuffer, this.startOffset, this.length);
        }
        catch (CharConversionException charConversionException) {
            FFDCUtil.log(charConversionException, this);
            throw new IOExceptionWrapper(charConversionException);
        }
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof XMLString) {
            return this.equalsXMLString((XMLString)object2);
        }
        return false;
    }

    public int compare(XMLString xMLString) {
        if (xMLString.length == this.length) {
            return this.compare2(xMLString, this.length, 0);
        }
        if (xMLString.length < this.length) {
            return this.compare2(xMLString, xMLString.length, 1);
        }
        return this.compare2(xMLString, this.length, -1);
    }

    private int compare2(XMLString xMLString, int n2, int n3) {
        if (n2 == 0) {
            return n3;
        }
        if (this.bytes != null && xMLString.bytes != null) {
            return this.compare2Unbuffered(xMLString, n2, n3);
        }
        return this.compare2Buffered(xMLString, n2, n3);
    }

    private int compare2Unbuffered(XMLString xMLString, int n2, int n3) {
        byte[] byArray = this.bytes;
        byte[] byArray2 = xMLString.bytes;
        int n4 = this.startOffset;
        int n5 = xMLString.startOffset;
        int n6 = n4 + n2;
        while (n4 < n6) {
            byte by2;
            byte by3;
            if ((by3 = byArray[n4++]) > (by2 = byArray2[n5++])) {
                return 1;
            }
            if (by3 >= by2) continue;
            return -1;
        }
        return n3;
    }

    private int compare2Buffered(XMLString xMLString, int n2, int n3) {
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n4 = this.startOffset;
        byte by2 = byArray[n4];
        DataBuffer dataBuffer2 = xMLString.firstBuffer;
        byte[] byArray2 = dataBuffer2.bytes;
        int n5 = xMLString.startOffset;
        byte by3 = byArray2[n5];
        if (by2 > by3) {
            return 1;
        }
        if (by2 < by3) {
            return -1;
        }
        DataBuffer dataBuffer3 = this.lastBuffer;
        int n6 = dataBuffer.endOffset;
        if (dataBuffer3 == null) {
            dataBuffer3 = dataBuffer;
            n6 = this.endOffset;
        }
        DataBuffer dataBuffer4 = xMLString.lastBuffer;
        int n7 = dataBuffer2.endOffset;
        if (dataBuffer4 == null) {
            dataBuffer4 = dataBuffer2;
            n7 = xMLString.endOffset;
        }
        int n8 = 0;
        while (++n8 < n2) {
            if (++n4 == n6) {
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n4 = dataBuffer.startOffset;
                n6 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : this.endOffset;
            }
            by2 = byArray[n4];
            if (++n5 == n7) {
                dataBuffer2 = dataBuffer2.next;
                byArray2 = dataBuffer2.bytes;
                n5 = dataBuffer2.startOffset;
                int n9 = n7 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLString.endOffset;
            }
            if (by2 > (by3 = byArray2[n5])) {
                return 1;
            }
            if (by2 >= by3) continue;
            return -1;
        }
        return n3;
    }

    public XMLString normalizeLineBreaks(XMLStringBuffer xMLStringBuffer, XMLString xMLString) {
        if (this.firstBuffer != null && (this.flags & 0xC) != 0) {
            return xMLStringBuffer.addXMLString(this, xMLString);
        }
        return this;
    }

    public final int convertToChars(CharConversionHandler charConversionHandler) throws CharConversionException {
        return UTF8Support.convertBytesToChars(this.firstBuffer, this.startOffset, this.length, (int)this.flags, charConversionHandler);
    }

    public final int getChars(CharConversionResources charConversionResources) throws CharConversionException {
        return UTF8Support.convertBytesToChars(this.firstBuffer, this.startOffset, this.length, (int)this.flags, charConversionResources);
    }

    public final int lengthAsCharacters(int[] nArray) {
        try {
            return UTF8Support.lengthAsCharacters(this.firstBuffer, this.startOffset, this.length, this.flags, nArray);
        }
        catch (CharConversionException charConversionException) {
            FFDCUtil.log(charConversionException, this);
            throw new IOExceptionWrapper(charConversionException);
        }
    }

    public final String toString() {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            try {
                String string2 = UTF8Support.toString(this.firstBuffer, this.startOffset, this.length, this.flags);
                return string2;
            }
            catch (CharConversionException charConversionException) {
                FFDCUtil.log(charConversionException, this);
                throw new IOExceptionWrapper(charConversionException);
            }
        }
        return null;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class XMLCharIteratorImpl
    implements XMLCharIterator {
        private DataBuffer buffer;
        private int offset;
        private int endOffset;
        private int limit;
        private int xmlChar;
        private int xmlCharLen;
        private int[] mbCharInfo;

        XMLCharIteratorImpl(DataBuffer dataBuffer, int n2, int n3) {
            this.buffer = dataBuffer;
            this.offset = n2;
            this.endOffset = this.offset + n3;
            this.limit = Math.min(this.endOffset, this.buffer.endOffset);
            this.xmlCharLen = 0;
        }

        public int nextXMLChar() throws CharConversionException {
            this.offset += this.xmlCharLen;
            if (this.offset < this.limit && (this.xmlChar = this.buffer.bytes[this.offset]) >= 0) {
                this.xmlCharLen = 1;
                return this.xmlChar;
            }
            if (this.offset == this.endOffset) {
                this.limit = -1;
                this.xmlCharLen = 0;
                this.xmlChar = -1;
                return -1;
            }
            if (this.offset >= this.limit) {
                this.buffer = this.buffer.next;
                this.offset = this.buffer.startOffset + (this.offset - this.limit);
                this.endOffset -= this.limit - this.buffer.startOffset;
                this.limit = Math.min(this.endOffset, this.buffer.endOffset);
            }
            this.xmlChar = this.buffer.bytes[this.offset];
            if (this.xmlChar >= 0) {
                this.xmlCharLen = 1;
                return this.xmlChar;
            }
            if (this.mbCharInfo == null) {
                this.mbCharInfo = ArrayAllocator.newIntArray(1);
            }
            this.xmlCharLen = 0;
            this.xmlCharLen = UTF8Support.decodeBytesToCharacter(this.buffer, this.offset, this.endOffset - this.offset, this.mbCharInfo);
            this.xmlChar = this.mbCharInfo[0];
            return this.xmlChar;
        }

        public void setStartPos(XMLString xMLString) {
            xMLString.setStartPos(this.buffer, this.offset);
        }

        public void setEndPos(XMLString xMLString) {
            xMLString.setEndPos(this.buffer, this.offset);
        }
    }
}

