/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.xlxp.internal.s1.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.ByteArrayPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharSequence;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.CharConversionException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStringBuffer
implements DataBufferFactory {
    private static final int CHUNK_SHIFT = 13;
    private static final int CHUNK_SIZE = 8192;
    private static final int CHUNK_MASK = 8191;
    private static final int INITIAL_CHUNK_COUNT = 8;
    protected DataBuffer[] fBuffers;
    protected final DataBuffer fBuffer0 = this.createBuffer(8193);
    private byte[] fData;
    protected int fChunk;
    private int fOffset;

    public XMLStringBuffer() {
        this.fData = this.fBuffer0.bytes;
        this.fBuffer0.startOffset = 0;
        this.fBuffer0.endOffset = 8192;
        this.fBuffers = ArrayAllocator.newObjectArray(DataBuffer.class, 8);
        this.fBuffers[0] = this.fBuffer0;
        this.fData[0] = 0;
        this.fData[8192] = 0;
        this.fChunk = 0;
        this.fOffset = 1;
    }

    public void reset(boolean bl) {
        this.fData = this.fBuffer0.bytes;
        this.fChunk = 0;
        this.fOffset = 1;
        if (!bl) {
            for (int i = 1; i < this.fBuffers.length; ++i) {
                if (this.fBuffers[i] == null) continue;
                byte[] byArray = this.fBuffers[i].bytes;
                if (byArray.length == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE + 1) {
                    ByteArrayPool.deallocateSmallByteArray(byArray);
                }
                this.fBuffers[i] = null;
            }
        }
    }

    public int getOffset() {
        return this.fChunk == 0 ? this.fOffset : this.fChunk << 13 | this.fOffset;
    }

    public CharConversionError appendString(String string2) {
        int n2;
        int n3 = string2.length();
        int n4 = 0;
        if (this.fOffset + n3 < 8192) {
            while (n4 < n3 && (n2 = string2.charAt(n4)) < 128) {
                ++n4;
                this.fData[this.fOffset] = (byte)n2;
                ++this.fOffset;
            }
            if (n4 == n3) {
                return null;
            }
        }
        while (n4 < n3) {
            n2 = string2.charAt(n4);
            ++n4;
            if (n2 < 55296 || n2 >= 57344) {
                this.appendChar(n2);
                continue;
            }
            if (n2 < 56320) {
                if (n4 == n3) {
                    return CharConversionError.missingSecondHalfOfSurrogatePair();
                }
                char c = string2.charAt(n4);
                ++n4;
                if (c < '\udc00' || c >= '\ue000') {
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n2 = 65536 + (n2 - 55296 << 10) + (c - 56320);
                this.appendChar(n2);
                continue;
            }
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        return null;
    }

    public void appendChar(int n2) {
        if (n2 < 128) {
            this.appendByte((byte)n2);
        } else {
            this.appendMultibyteChar(n2);
        }
    }

    private void appendMultibyteChar(int n2) {
        if (n2 < 2048) {
            this.appendByte((byte)(0xC0 | n2 >> 6));
            this.appendByte((byte)(0x80 | 0x3F & n2));
        } else if (n2 < 65536) {
            this.appendByte((byte)(0xE0 | n2 >> 12));
            this.appendByte((byte)(0x80 | 0x3F & n2 >> 6));
            this.appendByte((byte)(0x80 | 0x3F & n2));
        } else {
            this.appendByte((byte)(0xF0 | n2 >> 18));
            this.appendByte((byte)(0x80 | 0x3F & n2 >> 12));
            this.appendByte((byte)(0x80 | 0x3F & n2 >> 6));
            this.appendByte((byte)(0x80 | 0x3F & n2));
        }
    }

    public void appendBytes(byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        while (true) {
            if (n4 < 8192 - this.fOffset) {
                System.arraycopy(byArray, n2, this.fData, this.fOffset, n4);
                this.fOffset += n4;
                return;
            }
            int n5 = 8192 - this.fOffset;
            System.arraycopy(byArray, n2, this.fData, this.fOffset, n5);
            n2 += n5;
            n4 -= n5;
            this.extend();
        }
    }

    private void normalizeXMLString(XMLString xMLString) {
        int n2;
        DataBuffer dataBuffer;
        boolean bl = false;
        boolean bl2 = (xMLString.flags & 8) != 0;
        DataBuffer dataBuffer2 = xMLString.firstBuffer;
        int n3 = xMLString.startOffset;
        byte[] byArray = dataBuffer2.bytes;
        int n4 = 8192 - this.fOffset;
        if (xMLString.bytes == null) {
            dataBuffer = xMLString.lastBuffer;
            n2 = dataBuffer2.endOffset;
        } else {
            dataBuffer = dataBuffer2;
            n2 = xMLString.endOffset;
        }
        while (true) {
            int n5 = n2 - n3 > n4 ? n3 + n4 : n2;
            while (n3 < n5) {
                int n6;
                if ((n6 = byArray[n3++]) >= 0) {
                    if (bl) {
                        bl = false;
                        if (n6 == 10) continue;
                    }
                    if (n6 == 13) {
                        bl = true;
                        n6 = 10;
                    }
                } else {
                    if (bl2 && (n6 & 0xDF) == 194) {
                        if (n3 == n2) {
                            if (dataBuffer2 == dataBuffer) {
                                this.fData[this.fOffset++] = n6;
                                return;
                            }
                            dataBuffer2 = dataBuffer2.next;
                            byArray = dataBuffer2.bytes;
                            n3 = dataBuffer2.startOffset;
                            n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                            n5 = 0;
                        }
                        if ((n6 & 0xFF) == 194 && (byArray[n3] & 0xFF) == 133) {
                            ++n3;
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            n6 = 10;
                        } else if ((n6 & 0xFF) == 226 && (byArray[n3] & 0xFF) == 128) {
                            if (n3 + 1 < n2) {
                                if ((byArray[n3 + 1] & 0xFF) == 168) {
                                    n3 += 2;
                                    n6 = 10;
                                }
                            } else if (dataBuffer2 != dataBuffer && (dataBuffer2.next.bytes[dataBuffer2.next.startOffset] & 0xFF) == 168) {
                                dataBuffer2 = dataBuffer2.next;
                                byArray = dataBuffer2.bytes;
                                n3 = dataBuffer2.startOffset + 1;
                                n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
                                n5 = 0;
                                n6 = 10;
                            }
                        }
                    }
                    bl = false;
                }
                this.fData[this.fOffset++] = n6;
            }
            if (this.fOffset == 8192) {
                this.extend();
            }
            n4 = 8192 - this.fOffset;
            if (n3 != n2) continue;
            if (dataBuffer2 == dataBuffer) break;
            dataBuffer2 = dataBuffer2.next;
            byArray = dataBuffer2.bytes;
            n3 = dataBuffer2.startOffset;
            n2 = dataBuffer2 == dataBuffer ? xMLString.endOffset : dataBuffer2.endOffset;
        }
    }

    private void appendNormalizedXMLString(XMLString xMLString) {
        if (xMLString.bytes != null) {
            this.appendBytes(xMLString.bytes, xMLString.startOffset, xMLString.endOffset);
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            this.appendBytes(dataBuffer.bytes, xMLString.startOffset, dataBuffer.endOffset);
            while ((dataBuffer = dataBuffer.next) != xMLString.lastBuffer) {
                this.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset);
            }
            this.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, xMLString.endOffset);
        }
    }

    public void appendXMLString(XMLString xMLString) {
        if ((xMLString.flags & 0xC) == 0) {
            this.appendNormalizedXMLString(xMLString);
        } else {
            this.normalizeXMLString(xMLString);
        }
    }

    public void appendQName(QName qName) {
        this.appendNormalizedXMLString(qName);
    }

    public void appendToBuffer(int n2, int n3, XMLStringBuffer xMLStringBuffer) {
        if (n3 < 8192) {
            xMLStringBuffer.appendBytes(this.fBuffer0.bytes, n2, n3);
        } else {
            int n4 = n3 - n2;
            int n5 = n2 >>> 13;
            int n6 = n2 & 0x1FFF;
            if (n6 + n4 <= 8192) {
                xMLStringBuffer.appendBytes(this.fBuffers[n5].bytes, n6, n6 + n4);
            } else {
                DataBuffer dataBuffer = this.fBuffers[n5];
                int n7 = n3 >>> 13;
                xMLStringBuffer.appendBytes(dataBuffer.bytes, n6, dataBuffer.endOffset);
                dataBuffer = this.fBuffers[++n5];
                while (n5 < n7) {
                    xMLStringBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, dataBuffer.endOffset);
                    dataBuffer = this.fBuffers[++n5];
                }
                xMLStringBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n3 & 0x1FFF);
            }
        }
    }

    public CharSequence toCharSequence(int n2, int n3) {
        XMLCharSequence xMLCharSequence = new XMLCharSequence();
        this.setCharSequence(n2, n3, xMLCharSequence);
        return xMLCharSequence;
    }

    public void setCharSequence(int n2, int n3, XMLCharSequence xMLCharSequence) {
        int n4 = n3 - n2;
        if (n3 < 8192) {
            xMLCharSequence.setValues(this.fBuffer0, n2, n4);
        } else {
            DataBuffer dataBuffer = this.fBuffers[n2 >>> 13];
            xMLCharSequence.setValues(dataBuffer, n2 & 0x1FFF, n4);
        }
    }

    public String toString(int n2, int n3) {
        int n4 = n3 - n2;
        try {
            String string2;
            if (n3 < 8192) {
                string2 = this.fBuffer0.toString(n2, n4, 0);
            } else {
                DataBuffer dataBuffer = this.fBuffers[n2 >>> 13];
                string2 = dataBuffer.toString(n2 & 0x1FFF, n4, 0);
            }
            return string2;
        }
        catch (CharConversionException charConversionException) {
            FFDCUtil.log(charConversionException, this);
            throw new IOExceptionWrapper(charConversionException);
        }
    }

    public void setStringValues(int n2, int n3, XMLString xMLString) {
        if (n3 < 8192) {
            xMLString.setValues(this.fBuffer0, n2, n3);
        } else {
            int n4 = n3 - n2;
            int n5 = n2 >>> 13;
            int n6 = n2 & 0x1FFF;
            if (n6 + n4 <= 8192) {
                xMLString.setValues(this.fBuffers[n5], n6, n6 + n4);
            } else {
                xMLString.setStartPos(this.fBuffers[n5], n6);
                n5 = n3 >>> 13;
                n6 = n3 & 0x1FFF;
                if (n6 == 0) {
                    --n5;
                    n6 = 8192;
                }
                xMLString.setEndPos(this.fBuffers[n5], n6);
            }
        }
    }

    public void setQNameValues(int n2, int n3, QName qName) {
        if (n3 < 8192) {
            qName.setValues(this.fBuffer0, n2, n3);
        } else {
            int n4 = n3 - n2;
            int n5 = n2 >>> 13;
            int n6 = n2 & 0x1FFF;
            if (n6 + n4 <= 8192) {
                qName.setValues(this.fBuffers[n5], n6, n6 + n4);
            } else {
                qName.setStartPos(this.fBuffers[n5], n6);
                n5 = n3 >>> 13;
                n6 = n3 & 0x1FFF;
                if (n6 == 0) {
                    --n5;
                    n6 = 8192;
                }
                qName.setEndPos(this.fBuffers[n5], n6);
            }
        }
    }

    public void normalizedAppend(XMLString xMLString) {
        int n2 = this.fOffset;
        this.appendXMLString(xMLString);
        int n3 = this.fChunk;
        int n4 = this.fOffset;
        for (int i = this.fChunk; i <= n3; ++i) {
            byte[] byArray = this.fBuffers[i].bytes;
            int n5 = i < n3 ? 8192 : n4;
            for (int j = n2; j < n5; ++j) {
                byte by2 = byArray[j];
                if (by2 != 10 && by2 != 9 && by2 != 13) continue;
                byArray[j] = 32;
            }
            n2 = 0;
        }
    }

    public CharConversionError normalizeTextValue(XMLString xMLString, XMLString xMLString2) {
        if (xMLString.isNormalized()) {
            return null;
        }
        byte[] byArray = xMLString.bytes;
        if (xMLString2 != null) {
            xMLString2.setValues(xMLString);
        }
        if (byArray != null) {
            boolean bl = true;
            int n2 = this.getOffset();
            int n3 = xMLString.startOffset;
            int n4 = xMLString.endOffset;
            int n5 = xMLString.length;
            int n6 = 8192 - this.fOffset;
            int n7 = 0;
            while (n5 > 0) {
                int n8 = n5 >= n6 ? n3 + n6 : n4;
                block1: while (n3 < n8) {
                    byte by2;
                    if (n7 == 0) {
                        while (n3 < n8) {
                            by2 = byArray[n3];
                            if (by2 != 32) {
                                n7 = 1;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (n7 == 1) {
                        if (!bl) {
                            this.fData[this.fOffset++] = 32;
                            n5 = n4 - n3;
                            n6 = 8192 - this.fOffset;
                            n8 = n5 >= n6 ? n3 + n6 : n4;
                        }
                        bl = false;
                        n7 = 2;
                    }
                    if (n7 != 2) continue;
                    while (n3 < n8) {
                        by2 = byArray[n3];
                        if (by2 != 32) {
                            this.fData[this.fOffset++] = by2;
                            ++n3;
                            continue;
                        }
                        n7 = 0;
                        continue block1;
                    }
                }
                n6 = 8192 - this.fOffset;
                if (n6 == 0) {
                    this.extend();
                    n6 = 8192 - this.fOffset;
                }
                n5 = n4 - n3;
            }
            this.setStringValues(n2, this.getOffset(), xMLString);
            return null;
        }
        boolean bl = true;
        int n9 = this.getOffset();
        int n10 = xMLString.startOffset;
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer;
        int n11 = xMLString.length;
        int n12 = 8192 - this.fOffset;
        int n13 = 0;
        byArray = dataBuffer.bytes;
        int n14 = dataBuffer.endOffset;
        while (n11 > 0) {
            int n15 = n14 >= n10 + n12 ? n10 + n12 : n14;
            block5: while (n10 < n15) {
                byte by3;
                if (n13 == 0) {
                    while (n10 < n15) {
                        by3 = byArray[n10];
                        if (by3 != 32) {
                            n13 = 1;
                            break;
                        }
                        ++n10;
                        --n11;
                    }
                }
                if (n13 == 1) {
                    if (!bl) {
                        this.fData[this.fOffset++] = 32;
                        n12 = 8192 - this.fOffset;
                        n15 = n14 >= n10 + n12 ? n10 + n12 : n14;
                    }
                    bl = false;
                    n13 = 2;
                }
                if (n13 != 2) continue;
                while (n10 < n15) {
                    by3 = byArray[n10];
                    if (by3 != 32) {
                        this.fData[this.fOffset++] = by3;
                        ++n10;
                        --n11;
                        continue;
                    }
                    n13 = 0;
                    continue block5;
                }
            }
            n12 = 8192 - this.fOffset;
            if (n12 == 0) {
                this.extend();
                n12 = 8192 - this.fOffset;
            }
            if (n10 != n14) continue;
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n10 = dataBuffer.startOffset;
            n14 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : xMLString.endOffset;
        }
        this.setStringValues(n9, this.getOffset(), xMLString);
        return null;
    }

    public void normalizePublicID(XMLString xMLString) {
        if (xMLString.isNormalized()) {
            return;
        }
        byte[] byArray = xMLString.bytes;
        if (byArray != null) {
            boolean bl = true;
            int n2 = this.getOffset();
            int n3 = xMLString.startOffset;
            int n4 = xMLString.endOffset;
            int n5 = xMLString.length;
            int n6 = 8192 - this.fOffset;
            int n7 = 0;
            while (n5 > 0) {
                int n8 = n5 >= n6 ? n3 + n6 : n4;
                block1: while (n3 < n8) {
                    byte by2;
                    if (n7 == 0) {
                        while (n3 < n8) {
                            by2 = byArray[n3];
                            if (by2 < 0 || by2 > 32) {
                                n7 = 1;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (n7 == 1) {
                        if (!bl) {
                            this.fData[this.fOffset++] = 32;
                            n5 = n4 - n3;
                            n6 = 8192 - this.fOffset;
                            n8 = n5 >= n6 ? n3 + n6 : n4;
                        }
                        bl = false;
                        n7 = 2;
                    }
                    if (n7 != 2) continue;
                    while (n3 < n8) {
                        by2 = byArray[n3];
                        if (by2 < 0 || by2 > 32) {
                            this.fData[this.fOffset++] = by2;
                            ++n3;
                            continue;
                        }
                        n7 = 0;
                        continue block1;
                    }
                }
                n6 = 8192 - this.fOffset;
                if (n6 == 0) {
                    this.extend();
                    n6 = 8192 - this.fOffset;
                }
                n5 = n4 - n3;
            }
            this.setStringValues(n2, this.getOffset(), xMLString);
        } else {
            boolean bl = true;
            int n9 = this.getOffset();
            int n10 = xMLString.startOffset;
            DataBuffer dataBuffer = xMLString.firstBuffer;
            DataBuffer dataBuffer2 = xMLString.lastBuffer;
            int n11 = xMLString.length;
            int n12 = 8192 - this.fOffset;
            int n13 = 0;
            byArray = dataBuffer.bytes;
            int n14 = dataBuffer.endOffset;
            while (n11 > 0) {
                int n15 = n14 >= n10 + n12 ? n10 + n12 : n14;
                block5: while (n10 < n15) {
                    byte by3;
                    if (n13 == 0) {
                        while (n10 < n15) {
                            by3 = byArray[n10];
                            if (by3 < 0 || by3 > 32) {
                                n13 = 1;
                                break;
                            }
                            ++n10;
                            --n11;
                        }
                    }
                    if (n13 == 1) {
                        if (!bl) {
                            this.fData[this.fOffset++] = 32;
                            n12 = 8192 - this.fOffset;
                            n15 = n14 >= n10 + n12 ? n10 + n12 : n14;
                        }
                        bl = false;
                        n13 = 2;
                    }
                    if (n13 != 2) continue;
                    while (n10 < n15) {
                        by3 = byArray[n10];
                        if (by3 < 0 || by3 > 32) {
                            this.fData[this.fOffset++] = by3;
                            ++n10;
                            --n11;
                            continue;
                        }
                        n13 = 0;
                        continue block5;
                    }
                }
                n12 = 8192 - this.fOffset;
                if (n12 == 0) {
                    this.extend();
                    n12 = 8192 - this.fOffset;
                }
                if (n10 != n14) continue;
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n10 = dataBuffer.startOffset;
                n14 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : xMLString.endOffset;
            }
            this.setStringValues(n9, this.getOffset(), xMLString);
        }
    }

    public XMLString addString(String string2, XMLString xMLString) {
        int n2 = this.getOffset();
        this.appendString(string2);
        this.setStringValues(n2, this.getOffset(), xMLString);
        this.appendByte((byte)0);
        return xMLString;
    }

    public XMLString addXMLString(XMLString xMLString, XMLString xMLString2) {
        int n2 = this.getOffset();
        this.appendXMLString(xMLString);
        this.setStringValues(n2, this.getOffset(), xMLString2);
        return xMLString2;
    }

    public boolean contains(XMLString xMLString) {
        if (xMLString.firstBuffer != null) {
            for (int i = 0; i <= this.fChunk; ++i) {
                int n2;
                if (this.fBuffers[i] != xMLString.firstBuffer) continue;
                int n3 = n2 = i == this.fChunk ? this.fOffset : 8192;
                if (xMLString.startOffset > n2) continue;
                if (xMLString.lastBuffer == null) {
                    return xMLString.endOffset <= n2;
                }
                while (++i <= this.fChunk) {
                    if (xMLString.lastBuffer != this.fBuffers[i]) continue;
                    n2 = i == this.fChunk ? this.fOffset : 8192;
                    return xMLString.endOffset <= n2;
                }
            }
        }
        return false;
    }

    public boolean getOffsets(XMLString xMLString, int[] nArray) {
        if (xMLString.firstBuffer == this.fBuffer0) {
            int n2;
            int n3 = n2 = this.fChunk == 0 ? this.fOffset : 8192;
            if (xMLString.startOffset <= n2) {
                nArray[0] = xMLString.startOffset;
                if (xMLString.lastBuffer == null) {
                    if (xMLString.endOffset <= n2) {
                        nArray[1] = xMLString.endOffset;
                        return true;
                    }
                } else {
                    for (int i = 1; i <= this.fChunk; ++i) {
                        if (xMLString.lastBuffer != this.fBuffers[i]) continue;
                        int n4 = n2 = i == this.fChunk ? this.fOffset : 8192;
                        if (xMLString.endOffset <= n2) {
                            nArray[1] = i * 8192 + xMLString.endOffset;
                            return true;
                        }
                        break;
                    }
                }
            }
        } else if (xMLString.firstBuffer != null) {
            block1: for (int i = 1; i <= this.fChunk; ++i) {
                int n5;
                if (this.fBuffers[i] != xMLString.firstBuffer) continue;
                int n6 = n5 = i == this.fChunk ? this.fOffset : 8192;
                if (xMLString.startOffset > n5) continue;
                nArray[0] = i * 8192 + xMLString.startOffset;
                if (xMLString.lastBuffer == null) {
                    if (xMLString.endOffset > n5) continue;
                    nArray[1] = i * 8192 + xMLString.endOffset;
                    return true;
                }
                while (++i <= this.fChunk) {
                    if (xMLString.lastBuffer != this.fBuffers[i]) continue;
                    int n7 = n5 = i == this.fChunk ? this.fOffset : 8192;
                    if (xMLString.endOffset > n5) continue block1;
                    nArray[1] = i * 8192 + xMLString.endOffset;
                    return true;
                }
            }
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return false;
    }

    public DataBuffer createBuffer(int n2) {
        return new DataBuffer((DataBufferFactory)this, n2);
    }

    public DataBuffer createBuffer(byte[] byArray) {
        return new DataBuffer((DataBufferFactory)this, byArray);
    }

    public void addReferrer(DataBufferReferrer dataBufferReferrer) {
        assert (dataBufferReferrer.factory == null);
        dataBufferReferrer.factory = this;
    }

    public void removeReferrer(DataBufferReferrer dataBufferReferrer) {
        assert (dataBufferReferrer.factory == this);
        dataBufferReferrer.factory = null;
    }

    public boolean isReferenced(DataBuffer dataBuffer) {
        return true;
    }

    public void setReclaimLimit(int n2) {
    }

    public void reclaimBuffers(boolean bl) {
    }

    public void orphanBuffer(DataBuffer dataBuffer) {
    }

    public void unregisterReferrers() {
    }

    private void extend() {
        DataBuffer dataBuffer;
        DataBuffer dataBuffer2 = this.fBuffers[this.fChunk];
        if (++this.fChunk == this.fBuffers.length) {
            this.fBuffers = ArrayAllocator.resizeObjectArray(DataBuffer.class, this.fBuffers, this.fChunk << 1);
        }
        if ((dataBuffer = this.fBuffers[this.fChunk]) == null) {
            byte[] byArray = 8192 == ByteArrayPool.SMALL_BYTE_ARRAY_SIZE ? ByteArrayPool.allocateSmallByteArray() : ArrayAllocator.newByteArray(8193);
            dataBuffer = this.fBuffers[this.fChunk] = this.createBuffer(byArray);
        }
        dataBuffer2.next = dataBuffer;
        this.fData = dataBuffer.bytes;
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = 8192;
        this.fData[8192] = 0;
        this.fOffset = 0;
    }

    private void appendByte(byte by2) {
        this.fData[this.fOffset++] = by2;
        if (this.fOffset == 8192) {
            this.extend();
        }
    }
}

