/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.AttrList;
import com.ibm.xml.xlxp.internal.s1.scan.util.NSDeclList;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLTracer {
    public static String traceStartDocument(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "startDocument");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "version", xMLString);
        XMLTracer.printParameter(stringBuilder, "encName", xMLString2);
        XMLTracer.printParameter(stringBuilder, "standalone", xMLString3);
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n2;
        return stringBuilder.toString();
    }

    public static String traceEndDocument() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printEmptyElementTag(stringBuilder, n2, "endDocument");
        return stringBuilder.toString();
    }

    protected static void traceNSDecls(StringBuilder stringBuilder, int n2, NSDeclList nSDeclList) {
        int n3 = nSDeclList.nsDeclCount();
        if (n3 > 0) {
            XMLTracer.printOpenStartTag(stringBuilder, n2, "nsDecls");
            ++n2;
            XMLTracer.printParameter(stringBuilder, "count", n3);
            XMLTracer.finishStartTagEnd(stringBuilder, true);
            for (int i = 0; i < n3; ++i) {
                XMLTracer.printOpenStartTag(stringBuilder, n2, "nsDecl");
                ++n2;
                XMLTracer.printParameter(stringBuilder, "rawName", nSDeclList.nsDeclQName(i));
                XMLTracer.printParameter(stringBuilder, "prefix", nSDeclList.nsDeclPrefix(i));
                XMLTracer.finishStartTagEnd(stringBuilder, false);
                XMLTracer.printValue(stringBuilder, nSDeclList.nsDeclURI(i));
                --n2;
                XMLTracer.printEndTag(stringBuilder, "nsDecl");
            }
            XMLTracer.printIndent(stringBuilder, --n2);
            XMLTracer.printEndTag(stringBuilder, "nsDecls");
        }
    }

    protected static void traceAttrs(StringBuilder stringBuilder, int n2, AttrList attrList) {
        int n3 = attrList.attributeCount();
        if (n3 > 0) {
            XMLTracer.printOpenStartTag(stringBuilder, n2, "attributes");
            ++n2;
            XMLTracer.printParameter(stringBuilder, "count", n3);
            XMLTracer.finishStartTagEnd(stringBuilder, true);
            for (int i = 0; i < n3; ++i) {
                String string2 = attrList.attributeType(i);
                if (string2 == "") {
                    string2 = "CDATA";
                }
                XMLTracer.printOpenStartTag(stringBuilder, n2, "attribute");
                ++n2;
                XMLTracer.printParameter(stringBuilder, "rawName", attrList.attributeName((int)i).rawName);
                XMLTracer.printParameter(stringBuilder, "type", string2);
                XMLTracer.finishStartTagEnd(stringBuilder, true);
                QName qName = attrList.attributeName(i);
                String string3 = qName.prefix;
                String string4 = qName.nsURI;
                String string5 = qName.localName;
                XMLTracer.printQName(stringBuilder, n2, string3, string4, string5);
                XMLTracer.printOpenStartTag(stringBuilder, n2, "value");
                ++n2;
                XMLTracer.finishStartTagEnd(stringBuilder, false);
                XMLTracer.printValue(stringBuilder, attrList.attributeValue(i).toString());
                --n2;
                XMLTracer.printEndTag(stringBuilder, "value");
                XMLTracer.printIndent(stringBuilder, --n2);
                XMLTracer.printEndTag(stringBuilder, "attribute");
            }
            XMLTracer.printIndent(stringBuilder, --n2);
            XMLTracer.printEndTag(stringBuilder, "attributes");
        }
    }

    public static String traceLeafElement(QName qName, NSDeclList nSDeclList, AttrList attrList, XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "leafElement");
        XMLTracer.printParameter(stringBuilder, "rawName", qName.rawName);
        XMLTracer.finishStartTagEnd(stringBuilder, true);
        XMLTracer.printQName(stringBuilder, ++n2, qName.prefix, qName.nsURI, qName.localName);
        XMLTracer.traceNSDecls(stringBuilder, n2, nSDeclList);
        XMLTracer.traceAttrs(stringBuilder, n2, attrList);
        XMLTracer.printOpenStartTag(stringBuilder, n2, "elementValue");
        ++n2;
        if (xMLString != null) {
            XMLTracer.finishStartTagEnd(stringBuilder, false);
            XMLTracer.printParameter(stringBuilder, "content", xMLString);
            --n2;
            XMLTracer.printEndTag(stringBuilder, "elementValue");
        } else {
            XMLTracer.printParameter(stringBuilder, "empty", "true");
            XMLTracer.finishEmptyElementTag(stringBuilder);
            --n2;
        }
        XMLTracer.printIndent(stringBuilder, --n2);
        XMLTracer.printEndTag(stringBuilder, "leafElement");
        return stringBuilder.toString();
    }

    public static String traceStartElement(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "startElement");
        XMLTracer.printParameter(stringBuilder, "rawName", qName.rawName);
        XMLTracer.finishStartTagEnd(stringBuilder, true);
        XMLTracer.printQName(stringBuilder, ++n2, qName.prefix, qName.nsURI, qName.localName);
        XMLTracer.traceNSDecls(stringBuilder, n2, nSDeclList);
        XMLTracer.traceAttrs(stringBuilder, n2, attrList);
        XMLTracer.printIndent(stringBuilder, --n2);
        XMLTracer.printEndTag(stringBuilder, "startElement");
        return stringBuilder.toString();
    }

    public static String traceEndElement(QName qName, NSDeclList nSDeclList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "endElement");
        XMLTracer.printParameter(stringBuilder, "rawName", qName.rawName);
        XMLTracer.finishStartTagEnd(stringBuilder, true);
        XMLTracer.printQName(stringBuilder, ++n2, qName.prefix, qName.nsURI, qName.localName);
        XMLTracer.traceNSDecls(stringBuilder, n2, nSDeclList);
        XMLTracer.printIndent(stringBuilder, --n2);
        XMLTracer.printEndTag(stringBuilder, "endElement");
        return stringBuilder.toString();
    }

    public static String traceCharacters(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "characters");
        ++n2;
        XMLTracer.finishStartTagEnd(stringBuilder, false);
        XMLTracer.printValue(stringBuilder, xMLString.toString());
        --n2;
        XMLTracer.printEndTag(stringBuilder, "characters");
        return stringBuilder.toString();
    }

    public static String traceCDATASection(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "CDATASection");
        ++n2;
        XMLTracer.finishStartTagEnd(stringBuilder, false);
        XMLTracer.printValue(stringBuilder, xMLString.toString());
        --n2;
        XMLTracer.printEndTag(stringBuilder, "CDATASection");
        return stringBuilder.toString();
    }

    public static String traceWhitespace(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "whitespace");
        ++n2;
        XMLTracer.finishStartTagEnd(stringBuilder, false);
        XMLTracer.printValue(stringBuilder, xMLString.toString());
        --n2;
        XMLTracer.printEndTag(stringBuilder, "whitespace");
        return stringBuilder.toString();
    }

    public static String traceCharacter(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n3, "character");
        ++n3;
        XMLTracer.printParameter(stringBuilder, "value", Integer.toString(n2, 10));
        XMLTracer.printParameter(stringBuilder, "hexValue", Integer.toString(n2, 16));
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n3;
        return stringBuilder.toString();
    }

    public static String tracePredefinedEntity(XMLString xMLString, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n3, "predefinedEntity");
        ++n3;
        XMLTracer.printParameter(stringBuilder, "name", xMLString.toString());
        XMLTracer.printParameter(stringBuilder, "value", Integer.toString(n2, 10));
        XMLTracer.printParameter(stringBuilder, "hexValue", Integer.toString(n2, 16));
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n3;
        return stringBuilder.toString();
    }

    public static String traceProcessingInstruction(XMLString xMLString, XMLString xMLString2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "processingInstruction");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "target", xMLString.toString());
        XMLTracer.finishStartTagEnd(stringBuilder, false);
        XMLTracer.printValue(stringBuilder, xMLString2.toString());
        --n2;
        XMLTracer.printEndTag(stringBuilder, "processingInstruction");
        return stringBuilder.toString();
    }

    public static String traceComment(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "comment");
        ++n2;
        XMLTracer.finishStartTagEnd(stringBuilder, false);
        XMLTracer.printValue(stringBuilder, xMLString.toString());
        --n2;
        XMLTracer.printEndTag(stringBuilder, "comment");
        return stringBuilder.toString();
    }

    public static String traceDoctype(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "doctype");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "rootElementType", xMLString.toString());
        XMLTracer.printParameter(stringBuilder, "publicID", xMLString2.toString());
        XMLTracer.printParameter(stringBuilder, "systemID", xMLString3.toString());
        XMLTracer.printParameter(stringBuilder, "internalSubset", String.valueOf(bl));
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n2;
        return stringBuilder.toString();
    }

    public static String traceStartEntity(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "startEntity");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "name", xMLString.toString());
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n2;
        return stringBuilder.toString();
    }

    public static String traceEndEntity(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "endEntity");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "name", xMLString.toString());
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n2;
        return stringBuilder.toString();
    }

    public static String traceEntityReference(XMLString xMLString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n2, "entityReference");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "name", xMLString.toString());
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n2;
        return stringBuilder.toString();
    }

    public static String traceWarning(String string2, int n2, int n3, XMLString[] xMLStringArray, int n4, long l) {
        return XMLTracer.traceErrorCommon(string2, n2, n3, xMLStringArray, n4, l, "warning");
    }

    public static String traceRecoverableError(String string2, int n2, int n3, XMLString[] xMLStringArray, int n4, long l) {
        return XMLTracer.traceErrorCommon(string2, n2, n3, xMLStringArray, n4, l, "recoverableError");
    }

    public static String traceFatalError(String string2, int n2, int n3, XMLString[] xMLStringArray, int n4, long l) {
        return XMLTracer.traceErrorCommon(string2, n2, n3, xMLStringArray, n4, l, "fatalError");
    }

    private static String traceErrorCommon(String string2, int n2, int n3, XMLString[] xMLStringArray, int n4, long l, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = 0;
        XMLTracer.printOpenStartTag(stringBuilder, n5, string3);
        ++n5;
        XMLTracer.printParameter(stringBuilder, "errorURI", string2);
        XMLTracer.printParameter(stringBuilder, "errorCode", n2);
        XMLTracer.printParameter(stringBuilder, "errorOffset", Long.toString(l));
        if (n3 == 0) {
            XMLTracer.finishEmptyElementTag(stringBuilder);
            --n5;
        } else {
            XMLTracer.printParameter(stringBuilder, "errorParamsCount", n3);
            XMLTracer.finishStartTagEnd(stringBuilder, true);
            int n6 = n4 + n3;
            for (int i = n4; i < n6; ++i) {
                XMLTracer.printOpenStartTag(stringBuilder, n5, "errorParam");
                ++n5;
                XMLTracer.finishStartTagEnd(stringBuilder, false);
                XMLTracer.printValue(stringBuilder, xMLStringArray[i].toString());
                --n5;
                XMLTracer.printEndTag(stringBuilder, "errorParam");
            }
            XMLTracer.printIndent(stringBuilder, --n5);
            XMLTracer.printEndTag(stringBuilder, string3);
        }
        return stringBuilder.toString();
    }

    private static void printEmptyElementTag(StringBuilder stringBuilder, int n2, String string2) {
        XMLTracer.printIndent(stringBuilder, n2);
        stringBuilder.append("<" + string2 + "/>\n");
    }

    private static void printOpenStartTag(StringBuilder stringBuilder, int n2, String string2) {
        XMLTracer.printIndent(stringBuilder, n2);
        stringBuilder.append("<" + string2);
    }

    private static void printParameter(StringBuilder stringBuilder, String string2, int n2) {
        XMLTracer.printParameter(stringBuilder, string2, Integer.toString(n2));
    }

    private static void printParameter(StringBuilder stringBuilder, String string2, XMLString xMLString) {
        XMLTracer.printParameter(stringBuilder, string2, xMLString.toString());
    }

    private static void printParameter(StringBuilder stringBuilder, String string2, String string3) {
        if (string3 != null) {
            stringBuilder.append(" " + string2 + "=\"");
            XMLTracer.quote(stringBuilder, string3);
            stringBuilder.append('\"');
        }
    }

    private static void printQName(StringBuilder stringBuilder, int n2, String string2, String string3, String string4) {
        XMLTracer.printOpenStartTag(stringBuilder, n2, "qName");
        ++n2;
        XMLTracer.printParameter(stringBuilder, "prefix", string2);
        XMLTracer.printParameter(stringBuilder, "uri", string3);
        XMLTracer.printParameter(stringBuilder, "localName", string4);
        XMLTracer.finishEmptyElementTag(stringBuilder);
        --n2;
    }

    private static void printValue(StringBuilder stringBuilder, String string2) {
        if (string2 != null) {
            XMLTracer.quote(stringBuilder, string2);
        } else {
            stringBuilder.append("null");
        }
    }

    private static void printIndent(StringBuilder stringBuilder, int n2) {
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void finishStartTagEnd(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(">\n");
        } else {
            stringBuilder.append(">");
        }
    }

    private static void printEndTag(StringBuilder stringBuilder, String string2) {
        stringBuilder.append("</" + string2 + ">\n");
    }

    private static void finishEmptyElementTag(StringBuilder stringBuilder) {
        stringBuilder.append("/>\n");
    }

    private static void quote(StringBuilder stringBuilder, String string2) {
        int n2 = string2.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    if (c < ' ' || c >= '\u0080') {
                        stringBuilder.append("&#");
                        stringBuilder.append((int)c);
                        stringBuilder.append(';');
                        continue block6;
                    }
                    stringBuilder.append(c);
                }
            }
        }
    }
}

