/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class BitSet
implements Cloneable {
    private static final boolean DEBUG = false;
    private int fBitLength;
    private long fBitVector1;
    private int[] fBitVector2;
    private int fBitVector2Length;
    private int fHash = -1;

    public BitSet(BitSet bitSet) {
        this.fBitLength = bitSet.fBitLength;
        this.setBits(bitSet);
    }

    public BitSet(int n2) {
        this.setLength(n2);
    }

    public int hashCode() {
        if (this.fBitLength <= 64) {
            return this.fBitLength;
        }
        if (this.fHash == -1) {
            this.fHash = 0;
            for (int i = 0; i < this.fBitVector2Length; ++i) {
                this.fHash += this.fBitVector2[i] * 31;
            }
        }
        return this.fHash;
    }

    public Object clone() {
        BitSet bitSet = null;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        bitSet.fBitVector2 = null;
        bitSet.setLength(this.fBitLength);
        bitSet.setBits(this);
        return bitSet;
    }

    private void checkIndexValidity(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index value cannot be negative");
        }
        if (n2 > this.fBitLength - 1) {
            throw new IndexOutOfBoundsException("Index value cannot exceed vector length");
        }
    }

    public void clearBit(int n2) {
        this.fHash = -1;
        if (this.fBitLength <= 64) {
            long l = 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.fBitVector1 &= l;
        } else {
            int n3 = n2 / 32;
            int n4 = n2 % 32;
            int n5 = ~(1 << n4);
            int n6 = n3;
            this.fBitVector2[n6] = this.fBitVector2[n6] & n5;
        }
    }

    public boolean containsSet(BitSet bitSet) {
        if (this.fBitLength == bitSet.fBitLength) {
            if (this.fBitLength <= 64) {
                return (this.fBitVector1 & bitSet.fBitVector1) == bitSet.fBitVector1;
            }
            for (int i = 0; i < this.fBitVector2Length; ++i) {
                if ((this.fBitVector2[i] & bitSet.fBitVector2[i]) == bitSet.fBitVector2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean intersectsWith(BitSet bitSet) {
        if (this.fBitLength == bitSet.fBitLength) {
            if (this.fBitLength <= 64) {
                return (this.fBitVector1 & bitSet.fBitVector1) != 0L;
            }
            for (int i = 0; i < this.fBitVector2Length; ++i) {
                if ((this.fBitVector2[i] & bitSet.fBitVector2[i]) == 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean equals(BitSet bitSet) {
        if (this.fBitLength == bitSet.fBitLength) {
            if (this.fBitLength <= 64) {
                return this.fBitVector1 == bitSet.fBitVector1;
            }
            if (this.fHash == bitSet.fHash || this.fHash == -1 || bitSet.fHash == -1) {
                for (int i = 0; i < this.fBitVector2Length; ++i) {
                    if (this.fBitVector2[i] == bitSet.fBitVector2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object2) {
        if (object2 != null && object2 instanceof BitSet) {
            return this.equals((BitSet)object2);
        }
        return false;
    }

    public boolean getBit(int n2) {
        if (this.fBitLength <= 64) {
            long l = this.fBitVector1 >> n2;
            return (l & 1L) != 0L;
        }
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        int n5 = this.fBitVector2[n3] >> n4;
        return (n5 & 1) != 0;
    }

    public boolean isSuperSetOf(BitSet bitSet) {
        if (this.fBitLength == bitSet.fBitLength) {
            if (this.fBitLength <= 64) {
                return (this.fBitVector1 | bitSet.fBitVector1) == this.fBitVector1;
            }
            for (int i = 0; i < this.fBitVector2Length; ++i) {
                if ((this.fBitVector2[i] | bitSet.fBitVector2[i]) == this.fBitVector2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isZero() {
        if (this.fBitLength <= 64) {
            return this.fBitVector1 == 0L;
        }
        for (int i = 0; i < this.fBitVector2Length; ++i) {
            if (this.fBitVector2[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void setBit(int n2) {
        if (this.fBitLength <= 64) {
            long l = 1L << n2;
            this.fBitVector1 |= l;
        } else {
            int n3 = n2 / 32;
            int n4 = n2 % 32;
            int n5 = 1 << n4;
            int n6 = n3;
            this.fBitVector2[n6] = this.fBitVector2[n6] | n5;
            this.fHash = -1;
        }
    }

    public boolean setBits(BitSet bitSet) {
        if (this.fBitLength < bitSet.fBitLength) {
            return false;
        }
        if (this.fBitLength <= 64) {
            this.fBitVector1 |= bitSet.fBitVector1;
        } else {
            for (int i = 0; i < this.fBitVector2Length; ++i) {
                int n2 = i;
                this.fBitVector2[n2] = this.fBitVector2[n2] | bitSet.fBitVector2[i];
            }
            this.fHash = -1;
        }
        return true;
    }

    public boolean getAndSetBit(int n2) {
        if (this.fBitLength <= 64) {
            long l = 1L << n2;
            boolean bl = (this.fBitVector1 & l) != 0L;
            this.fBitVector1 |= l;
            return bl;
        }
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        int n5 = 1 << n4;
        boolean bl = (this.fBitVector2[n3] & n5) != 0;
        int n6 = n3;
        this.fBitVector2[n6] = this.fBitVector2[n6] | n5;
        this.fHash = -1;
        return bl;
    }

    public void setLength(int n2) {
        this.fBitLength = n2;
        if (n2 <= 64) {
            this.fBitVector1 = 0L;
        } else {
            this.fBitVector2Length = n2 / 32 + (n2 % 32 == 0 ? 0 : 1);
            if (this.fBitVector2 == null || this.fBitVector2Length > this.fBitVector2.length) {
                this.fBitVector2 = new int[this.fBitVector2Length];
            } else {
                for (int i = 0; i < this.fBitVector2Length; ++i) {
                    this.fBitVector2[i] = 0;
                }
            }
            this.fHash = -1;
        }
    }

    public void growSize(int n2) {
        if (n2 == this.fBitLength) {
            return;
        }
        if (n2 > 64) {
            int n3 = n2 / 32 + (n2 % 32 == 0 ? 0 : 1);
            if (this.fBitVector2 == null) {
                int[] nArray = new int[n3];
                this.fBitVector2 = nArray;
            } else if (n3 > this.fBitVector2.length) {
                int[] nArray = new int[n3];
                System.arraycopy(this.fBitVector2, 0, nArray, 0, this.fBitVector2.length);
                this.fBitVector2 = nArray;
            } else {
                for (int i = this.fBitVector2.length + 1; i < n3; ++i) {
                    this.fBitVector2[i] = 0;
                }
            }
        }
        this.fBitLength = n2;
        this.fHash = -1;
    }

    public void clearAll() {
        if (this.fBitLength <= 64) {
            this.fBitVector1 = 0L;
        } else {
            for (int i = 0; i < this.fBitVector2Length; ++i) {
                this.fBitVector2[i] = 0;
            }
            this.fHash = -1;
        }
    }

    public int getLength() {
        return this.fBitLength;
    }

    public void copyTo(BitSet bitSet) {
        if (this.fBitLength <= 64) {
            bitSet.fBitVector1 = this.fBitVector1;
        } else {
            if (bitSet.fBitVector2 == null || this.fBitVector2Length > bitSet.fBitVector2.length) {
                bitSet.fBitVector2Length = this.fBitVector2Length;
                bitSet.fBitVector2 = new int[this.fBitVector2Length];
            }
            System.arraycopy(this.fBitVector2, 0, bitSet.fBitVector2, 0, this.fBitVector2Length);
            bitSet.fHash = this.fHash;
        }
        bitSet.fBitLength = this.fBitLength;
    }

    public int toList(int[] nArray) {
        int n2;
        int n3 = 0;
        if (this.fBitLength <= 64) {
            long l = 1L;
            for (n2 = 0; n2 < 64; ++n2) {
                if ((this.fBitVector1 & l) != 0L) {
                    nArray[n3++] = n2;
                }
                l <<= 1;
            }
        } else {
            int n4 = 0;
            while (n2 < this.fBitVector2Length) {
                int n5 = this.fBitVector2[n2];
                if (n5 != 0) {
                    int n6 = 1;
                    for (int i = 0; i < 32; ++i) {
                        if ((n5 & n6) != 0) {
                            nArray[n3++] = n4 + i;
                        }
                        n6 <<= 1;
                    }
                }
                n4 += 32;
                ++n2;
            }
        }
        return n3;
    }
}

