/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.validation.idc;

import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.XBinary;
import com.ibm.xml.xlxp.internal.s1.datatype.XByte;
import com.ibm.xml.xlxp.internal.s1.datatype.XDateTime;
import com.ibm.xml.xlxp.internal.s1.datatype.XDecimal;
import com.ibm.xml.xlxp.internal.s1.datatype.XDouble;
import com.ibm.xml.xlxp.internal.s1.datatype.XFloat;
import com.ibm.xml.xlxp.internal.s1.datatype.XInt;
import com.ibm.xml.xlxp.internal.s1.datatype.XList;
import com.ibm.xml.xlxp.internal.s1.datatype.XLong;
import com.ibm.xml.xlxp.internal.s1.datatype.XShort;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.runtime.VMContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.AttrList;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.validation.idc.IValue;
import com.ibm.xml.xlxp.internal.s1.validation.idc.IValueContainer;
import com.ibm.xml.xlxp.internal.s1.validation.idc.QNameKey;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XMLStringKey;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XPathAction;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XPathAttribute;
import com.ibm.xml.xlxp.internal.s1.validation.idc.XPathDFA;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IDCContext {
    final VMContext vmContext;
    public int idcCount;
    public int xpathCount;
    public IValueContainer[][] idcContainers;
    public int[] idcContainerListLengths;
    public int[][] idcKeyContext;
    public int[] idcCurrentContext;
    public IValue[][] idcIValues4ActiveFields;
    public int[] idcIValuesListLengths;
    public IValuePool[] idcActiveIValuePools;
    public FValuePool[] idcActiveFValuePools;
    public Grammar ir;
    public int[][] idcXPathStates;
    private int[] idcStateChangeHistory = new int[24];
    private int idcStateChangeHistorySize;
    private int[] idcStateChangeHistoryContext = new int[8];
    private int idcStateChangeHistoryCurrentContext;
    public Object[][] idcFValues;
    public int[][] idcFTypes;
    public int[][][] idcFItemTypes;
    public int[] idcFValueListLengths;
    public int[] emptyArray;
    private static final int INITIAL_POOL_SIZE = 4;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int INITIAL_LIST_SIZE = 8;
    IValueContainer fIVCPool = null;
    IValuePool fIVPoolPool = null;
    FValuePool fFVPoolPool = null;

    public IDCContext(VMContext vMContext) {
        this.vmContext = vMContext;
    }

    public void initialize(int n2, Grammar grammar) {
        this.idcCount = n2;
        this.xpathCount = grammar.numXpathDFAs();
        if (this.idcCount == 0) {
            this.idcContainers = null;
            this.idcContainerListLengths = null;
            this.idcKeyContext = null;
            this.idcCurrentContext = null;
            this.idcIValues4ActiveFields = null;
            this.idcIValuesListLengths = null;
            this.idcActiveIValuePools = null;
            this.idcActiveFValuePools = null;
            this.ir = null;
            this.idcXPathStates = null;
            this.idcFValues = null;
            this.idcFItemTypes = null;
            this.idcFValueListLengths = null;
            this.emptyArray = null;
            return;
        }
        this.idcContainers = new IValueContainer[this.idcCount][1];
        this.idcContainerListLengths = new int[this.idcCount];
        this.idcKeyContext = new int[this.idcCount][1];
        this.idcCurrentContext = new int[this.idcCount];
        this.idcIValues4ActiveFields = new IValue[this.idcCount][2];
        this.idcIValuesListLengths = new int[this.idcCount];
        this.idcActiveIValuePools = new IValuePool[this.idcCount];
        this.idcActiveFValuePools = new FValuePool[this.idcCount];
        this.ir = grammar;
        this.idcXPathStates = new int[this.xpathCount][4];
        this.idcFValues = new Object[this.idcCount][8];
        this.idcFTypes = new int[this.idcCount][8];
        this.idcFItemTypes = new int[this.idcCount][8][];
        this.idcFValueListLengths = new int[this.idcCount];
        this.emptyArray = new int[this.idcCount];
        this.reset();
    }

    void startSelectorXPaths(XPathAction[] xPathActionArray) {
        for (int i = 0; i < xPathActionArray.length; ++i) {
            XPathAction xPathAction = xPathActionArray[i];
            IValueContainer iValueContainer = this.startIDCSelectorXPathState(xPathAction);
            if (xPathAction.newState >= 0) continue;
            int n2 = this.getIValueHandle(iValueContainer);
            IValue iValue = this.idcIValues4ActiveFields[xPathAction.idcID][n2];
            this.saveIDCStateHistory(-1, xPathAction.idcID, n2);
            this.startFieldXPaths(xPathAction.startFieldActions, iValue.startOffset);
        }
    }

    void startFieldXPaths(XPathAction[] xPathActionArray, int n2) {
        for (int i = 0; i < xPathActionArray.length; ++i) {
            XPathAction xPathAction = xPathActionArray[i];
            int n3 = this.startIDCFieldXPathState(xPathAction, n2);
            if (xPathAction.newState >= 0 && xPathAction.finalAttrDecls == null) continue;
            this.matchedField(xPathAction, n3);
        }
    }

    public void processActiveXPaths() {
        int n2 = this.vmContext.getElementDepth();
        for (int i = 0; i < this.idcXPathStates.length; ++i) {
            XPathDFA xPathDFA = this.ir.getXpathDFA(i);
            int[] nArray = this.idcXPathStates[i];
            int n3 = nArray[0];
            for (int j = 1; j < n3; j += 3) {
                if (nArray[j + 1] != n2) continue;
                this.matchXPathDFA(xPathDFA, nArray, j);
            }
        }
    }

    boolean matchXPathDFA(XPathDFA xPathDFA, int[] nArray, int n2) {
        int n3 = xPathDFA.transition(nArray[n2], this.vmContext.elementQName.nsURI, this.vmContext.elementQName.localName);
        if (n3 != 0) {
            XPathAttribute[] xPathAttributeArray = xPathDFA.getFinalAttrDecls(n3);
            if (n3 < 0 || xPathAttributeArray != null) {
                if (!xPathDFA.isSelector) {
                    this.matchedField(xPathDFA, n3, xPathAttributeArray, nArray[n2 + 2]);
                } else {
                    IValueContainer iValueContainer = this.idcContainers[xPathDFA.idcID][nArray[n2 + 2]];
                    int n4 = this.getIValueHandle(iValueContainer);
                    IValue iValue = this.idcIValues4ActiveFields[xPathDFA.idcID][n4];
                    this.saveIDCStateHistory(-1, xPathDFA.idcID, n4);
                    this.startFieldXPaths(xPathDFA.startFieldActions, iValue.startOffset);
                }
                this.saveIDCStateHistory(xPathDFA.xpathID, n2, nArray[n2]);
                nArray[n2] = n3;
                if (xPathDFA.allowMoreInput(n3)) {
                    int n5 = n2 + 1;
                    nArray[n5] = nArray[n5] + 1;
                }
            } else {
                this.saveIDCStateHistory(xPathDFA.xpathID, n2, nArray[n2]);
                nArray[n2] = n3;
                int n6 = n2 + 1;
                nArray[n6] = nArray[n6] + 1;
            }
            return true;
        }
        return false;
    }

    void matchedField(XPathAction xPathAction, int n2) {
        XPathAttribute[] xPathAttributeArray;
        boolean bl = false;
        if (xPathAction.newState < 0) {
            bl = true;
            if (xPathAction.idcCategory == 1 && this.vmContext.eDecl != null && this.vmContext.eDecl.nillable) {
                this.vmContext.generateError(37, this.vmContext.elementQName.localName);
            }
        }
        if ((xPathAttributeArray = xPathAction.finalAttrDecls) != null) {
            if (xPathAction.finalAttrs != null) {
                if (this.vmContext.attsSpecified.intersectsWith(xPathAction.finalAttrs)) {
                    this.matchAttributeFieldNoWC(xPathAttributeArray, xPathAction.idcID, n2, bl);
                }
            } else {
                this.matchAttributeFieldWithWC(xPathAttributeArray, xPathAction.idcID, n2, bl);
            }
        }
    }

    private void matchedField(XPathDFA xPathDFA, int n2, XPathAttribute[] xPathAttributeArray, int n3) {
        boolean bl = false;
        if (n2 < 0) {
            bl = true;
            if (xPathDFA.idcCategory == 1 && this.vmContext.eDecl != null && this.vmContext.eDecl.nillable) {
                this.vmContext.generateError(37, this.vmContext.elementQName.localName);
            }
        }
        if (xPathAttributeArray != null) {
            this.matchAttributeFieldWithWC(xPathAttributeArray, xPathDFA.idcID, n3, bl);
        }
    }

    private void matchAttributeFieldNoWC(XPathAttribute[] xPathAttributeArray, int n2, int n3, boolean bl) {
        VMContext vMContext = this.vmContext;
        for (int i = 0; i < xPathAttributeArray.length; ++i) {
            XPathAttribute xPathAttribute = xPathAttributeArray[i];
            if (!this.vmContext.attsSpecified.getBit(xPathAttribute.index)) continue;
            if (!bl) {
                int n4 = this.findAttribute(xPathAttribute, this.vmContext.aDecls, vMContext.attributeCount());
                ValidatedInfo validatedInfo = this.vmContext.actualAttributeValue(n4);
                if (this.idcFValues[n2][n3] == null) {
                    this.idcFValues[n2][n3] = this.copyFValue(n2, validatedInfo.actualValue, validatedInfo.typeValidator.builtInKind, validatedInfo.itemBuiltinKinds);
                    this.idcFTypes[n2][n3] = validatedInfo.typeValidator.builtInKind;
                    this.idcFItemTypes[n2][n3] = validatedInfo.itemBuiltinKinds;
                } else {
                    this.vmContext.generateError(33);
                }
                bl = true;
                continue;
            }
            this.vmContext.generateError(33);
        }
    }

    private void matchAttributeFieldWithWC(XPathAttribute[] xPathAttributeArray, int n2, int n3, boolean bl) {
        VMContext vMContext = this.vmContext;
        for (int i = 0; i < xPathAttributeArray.length; ++i) {
            int n4 = this.findAttribute(xPathAttributeArray[i], vMContext);
            if (n4 < 0) continue;
            if (!bl) {
                ValidatedInfo validatedInfo = this.vmContext.actualAttributeValue(n4);
                if (this.idcFValues[n2][n3] == null) {
                    this.idcFValues[n2][n3] = this.copyFValue(n2, validatedInfo.actualValue, validatedInfo.typeValidator.builtInKind, validatedInfo.itemBuiltinKinds);
                    this.idcFTypes[n2][n3] = validatedInfo.typeValidator.builtInKind;
                    this.idcFItemTypes[n2][n3] = validatedInfo.itemBuiltinKinds;
                } else {
                    this.vmContext.generateError(33);
                }
                bl = true;
                continue;
            }
            this.vmContext.generateError(33);
        }
    }

    private int findAttribute(XPathAttribute xPathAttribute, Attribute[] attributeArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            Attribute attribute2 = attributeArray[i];
            if (attribute2 == null || attribute2.localName != xPathAttribute.localName || attribute2.nsURI != xPathAttribute.nsURI) continue;
            return i;
        }
        return -1;
    }

    private int findAttribute(XPathAttribute xPathAttribute, AttrList attrList) {
        if (xPathAttribute.localName != null) {
            int n2 = attrList.attributeCount();
            for (int i = 0; i < n2; ++i) {
                QName qName = attrList.attributeName(i);
                if (qName.localName != xPathAttribute.localName || qName.nsURI != xPathAttribute.nsURI) continue;
                return i;
            }
            return -1;
        }
        if (xPathAttribute.nsURI != null) {
            return this.matchRestrictedAttrWC(xPathAttribute, attrList);
        }
        return this.matchUnrestrictedAttrWC(xPathAttribute, attrList);
    }

    private int matchRestrictedAttrWC(XPathAttribute xPathAttribute, AttrList attrList) {
        int n2 = attrList.attributeCount();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            QName qName = attrList.attributeName(i);
            if (qName.nsURI != xPathAttribute.nsURI) continue;
            if (n3 < 0) {
                n3 = i;
                continue;
            }
            this.vmContext.generateError(33);
        }
        return n3;
    }

    private int matchUnrestrictedAttrWC(XPathAttribute xPathAttribute, AttrList attrList) {
        int n2 = attrList.attributeCount();
        if (n2 == 0) {
            return -1;
        }
        for (int i = 1; i < n2; ++i) {
            this.vmContext.generateError(33);
        }
        return 0;
    }

    int getIValueHandle(IValueContainer iValueContainer) {
        int n2;
        int n3;
        IValue iValue = this.idcActiveIValuePools[iValueContainer.idcID].getIValue();
        IValue[] iValueArray = this.idcIValues4ActiveFields[iValueContainer.idcID];
        int n4 = iValueContainer.idcID;
        int n5 = this.idcIValuesListLengths[n4];
        this.idcIValuesListLengths[n4] = n5 + 1;
        int n6 = n5;
        if (n6 >= iValueArray.length) {
            IValue[] iValueArray2 = new IValue[iValueArray.length << 1];
            System.arraycopy(iValueArray, 0, iValueArray2, 0, iValueArray.length);
            iValueArray = iValueArray2;
            this.idcIValues4ActiveFields[iValueContainer.idcID] = iValueArray2;
        }
        iValueArray[n6] = iValue;
        iValue.startOffset = this.idcFValueListLengths[iValueContainer.idcID];
        this.idcFValueListLengths[iValueContainer.idcID] = n3 = iValue.startOffset + iValueContainer.fieldCount;
        Object[] objectArray = this.idcFValues[iValueContainer.idcID];
        if (n3 > objectArray.length) {
            n2 = objectArray.length;
            int n7 = n2 << 1;
            if (n3 > n7) {
                n7 = n3;
            }
            Object[] objectArray2 = new Object[n7];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            objectArray = objectArray2;
            this.idcFValues[iValueContainer.idcID] = objectArray2;
            int[] nArray = new int[n7];
            System.arraycopy(this.idcFTypes[iValueContainer.idcID], 0, nArray, 0, n2);
            this.idcFTypes[iValueContainer.idcID] = nArray;
            int[][] nArrayArray = new int[n7][];
            System.arraycopy(this.idcFItemTypes[iValueContainer.idcID], 0, nArrayArray, 0, n2);
            this.idcFItemTypes[iValueContainer.idcID] = nArrayArray;
        }
        for (n2 = iValueContainer.fieldCount; n2 > 0; --n2) {
            objectArray[--n3] = null;
        }
        iValue.container = iValueContainer;
        return n6;
    }

    IValueContainer startIDCSelectorXPathState(XPathAction xPathAction) {
        Object object2;
        int[] nArray = this.idcXPathStates[xPathAction.xpathID];
        int n2 = nArray[0];
        Object object3 = this.idcContainers[xPathAction.idcID];
        int n3 = xPathAction.idcID;
        int n4 = this.idcContainerListLengths[n3];
        this.idcContainerListLengths[n3] = n4 + 1;
        int n5 = n4;
        int[] nArray2 = this.idcKeyContext[xPathAction.idcID];
        int n6 = xPathAction.idcID;
        int n7 = this.idcCurrentContext[n6];
        this.idcCurrentContext[n6] = n7 + 1;
        int n8 = n7;
        if (n5 == 0) {
            this.idcActiveIValuePools[xPathAction.idcID] = this.getIVPool();
            this.idcActiveFValuePools[xPathAction.idcID] = this.getFVPool();
        }
        if (n2 + 2 >= nArray.length) {
            object2 = new int[nArray.length << 1];
            System.arraycopy(nArray, 0, object2, 0, nArray.length);
            nArray = object2;
            this.idcXPathStates[xPathAction.xpathID] = object2;
        }
        this.saveIDCStateHistory(xPathAction.xpathID, n2, 0);
        nArray[n2++] = xPathAction.newState;
        nArray[n2++] = this.vmContext.getElementDepth() + xPathAction.depthIncrement;
        nArray[n2++] = n5;
        nArray[0] = n2;
        if (xPathAction.idcCategory != 2) {
            if (n8 >= nArray2.length) {
                object2 = new int[nArray2.length << 1];
                System.arraycopy(nArray2, 0, object2, 0, nArray2.length);
                nArray2 = object2;
                this.idcKeyContext[xPathAction.idcID] = object2;
            }
            nArray2[n8] = n5;
        }
        if (n5 >= ((IValueContainer[])object3).length) {
            object2 = new IValueContainer[((IValueContainer[])object3).length << 1];
            System.arraycopy(object3, 0, object2, 0, ((IValueContainer[])object3).length);
            object3 = object2;
            this.idcContainers[xPathAction.idcID] = (IValueContainer[])object2;
        }
        object2 = this.getIVContainer();
        object2.idcID = xPathAction.idcID;
        object2.idcCategory = xPathAction.idcCategory;
        object2.keyID = xPathAction.idcID4Key;
        object2.fieldCount = xPathAction.fieldCount;
        object3[n5] = object2;
        return object2;
    }

    int startIDCFieldXPathState(XPathAction xPathAction, int n2) {
        int[] nArray = this.idcXPathStates[xPathAction.xpathID];
        int n3 = nArray[0];
        int n4 = xPathAction.fieldIndex + n2;
        if (n3 + 2 >= nArray.length) {
            int[] nArray2 = new int[nArray.length << 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            this.idcXPathStates[xPathAction.xpathID] = nArray2;
        }
        this.saveIDCStateHistory(xPathAction.xpathID, n3, 0);
        nArray[n3++] = xPathAction.newState;
        nArray[n3++] = this.vmContext.getElementDepth() + xPathAction.depthIncrement;
        nArray[n3++] = n4;
        nArray[0] = n3;
        return n4;
    }

    void saveIDCStateHistory(int n2, int n3, int n4) {
        if (this.idcStateChangeHistorySize + 2 >= this.idcStateChangeHistory.length) {
            int[] nArray = new int[this.idcStateChangeHistory.length << 1];
            System.arraycopy(this.idcStateChangeHistory, 0, nArray, 0, this.idcStateChangeHistory.length);
            this.idcStateChangeHistory = nArray;
        }
        this.idcStateChangeHistory[this.idcStateChangeHistorySize++] = n2;
        this.idcStateChangeHistory[this.idcStateChangeHistorySize++] = n3;
        this.idcStateChangeHistory[this.idcStateChangeHistorySize++] = n4;
    }

    public void startIDCStateHistoryContext() {
        if (this.idcStateChangeHistoryContext.length == ++this.idcStateChangeHistoryCurrentContext) {
            int[] nArray = new int[this.idcStateChangeHistoryContext.length << 1];
            System.arraycopy(this.idcStateChangeHistoryContext, 0, nArray, 0, this.idcStateChangeHistoryContext.length);
            this.idcStateChangeHistoryContext = nArray;
        }
        this.idcStateChangeHistoryContext[this.idcStateChangeHistoryCurrentContext] = this.idcStateChangeHistorySize;
    }

    public final void endIDCStateHistoryContext(int n2) {
        for (int i = 0; i < n2; ++i) {
            this.endIDCStateHistoryContext();
        }
    }

    public final void endIDCStateHistoryContext() {
        int n2 = this.idcStateChangeHistorySize;
        int n3 = this.vmContext.getElementDepth();
        this.idcStateChangeHistorySize = this.idcStateChangeHistoryContext[this.idcStateChangeHistoryCurrentContext--];
        while (n2 > this.idcStateChangeHistorySize) {
            Object object2;
            int n4;
            int n5 = this.idcStateChangeHistory[--n2];
            int n6 = this.idcStateChangeHistory[--n2];
            if ((n4 = this.idcStateChangeHistory[--n2]) >= 0) {
                int n7;
                object2 = this.idcXPathStates[n4];
                if (n4 >= this.idcIValues4ActiveFields.length && object2[n6] < 0) {
                    if (!this.vmContext.currentElementHasSimpleContent()) {
                        this.vmContext.generateError(36, this.vmContext.elementQName.localName);
                    } else {
                        ValidatedInfo validatedInfo = this.vmContext.currentElementActualValue();
                        int n8 = this.ir.getXpathDFA((int)n4).idcID;
                        n7 = object2[n6 + 2];
                        if (this.idcFValues[n8][n7] == null) {
                            this.idcFValues[n8][n7] = this.copyFValue(n8, validatedInfo.actualValue, validatedInfo.typeValidator.builtInKind, validatedInfo.itemBuiltinKinds);
                            this.idcFTypes[n8][n7] = validatedInfo.typeValidator.builtInKind;
                            this.idcFItemTypes[n8][n7] = validatedInfo.itemBuiltinKinds;
                        } else {
                            this.vmContext.generateError(33);
                        }
                    }
                }
                if (n5 != 0) {
                    object2[n6] = n5;
                    object2[n6 + 1] = n3;
                    continue;
                }
                if (n4 < this.idcIValues4ActiveFields.length) {
                    int n9 = this.idcContainerListLengths[n4] - 1;
                    IValueContainer iValueContainer = this.idcContainers[n4][n9];
                    if (iValueContainer.idcCategory == 2) {
                        n7 = this.idcCurrentContext[iValueContainer.keyID];
                        if (!iValueContainer.resolveKeyref(this.idcContainers[iValueContainer.keyID], this.idcContainerListLengths[iValueContainer.keyID], this.idcKeyContext[iValueContainer.keyID][n7])) {
                            this.vmContext.generateError(35);
                        }
                        int n10 = n4;
                        this.idcContainerListLengths[n10] = this.idcContainerListLengths[n10] - 1;
                        this.returnIVContainer(iValueContainer);
                        if (n9 == 0) {
                            this.returnIVPool(this.idcActiveIValuePools[n4]);
                            this.returnFVPool(this.idcActiveFValuePools[n4]);
                        }
                    } else {
                        int n11;
                        int n12 = n4;
                        int n13 = this.idcCurrentContext[n12] - 1;
                        this.idcCurrentContext[n12] = n13;
                        n7 = n13;
                        int n14 = this.idcKeyContext[n4][n7];
                        iValueContainer = this.idcContainers[n4][n14];
                        for (n11 = n14 + 1; n11 < n9; ++n11) {
                            iValueContainer.removeConflictKeys(this.idcContainers[n4][n11], true);
                        }
                        n11 = this.idcCurrentContext[n4] - 1;
                        if (n11 >= 0) {
                            int n15 = this.idcKeyContext[n4][n11] + 1;
                            for (int i = n14; i < n9; ++i) {
                                for (int j = n15; j < n14; ++j) {
                                    this.idcContainers[n4][i].removeConflictKeys(this.idcContainers[n4][j], false);
                                }
                            }
                        }
                    }
                }
                object2[0] = object2[0] - 3;
                continue;
            }
            object2 = this.idcIValues4ActiveFields[n6][n5];
            object2.container.add((IValue)object2);
        }
    }

    Object copyFValue(int n2, Object object2, int n3, int[] nArray) {
        switch (n3) {
            case 1: 
            case 2: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                XMLStringKey xMLStringKey = this.idcActiveFValuePools[n2].getXMLString();
                xMLStringKey.fill((XMLString)object2);
                return xMLStringKey;
            }
            case 3: {
                return object2;
            }
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: {
                if (object2 == XDecimal.ZERO) {
                    return object2;
                }
                XDecimal xDecimal = this.idcActiveFValuePools[n2].getXDecimal();
                XDecimal xDecimal2 = (XDecimal)object2;
                xDecimal.sign = xDecimal2.sign;
                xDecimal.totalDigits = xDecimal2.totalDigits;
                xDecimal.intDigits = xDecimal2.intDigits;
                xDecimal.fracDigits = xDecimal2.fracDigits;
                xDecimal.rawData.setValues(xDecimal2.rawData);
                return xDecimal;
            }
            case 16: 
            case 17: {
                XBinary xBinary = this.idcActiveFValuePools[n2].getXBinary();
                XBinary xBinary2 = (XBinary)object2;
                xBinary.length = xBinary2.length;
                if (xBinary.value.length < xBinary.length) {
                    xBinary.value = new byte[xBinary.length];
                }
                System.arraycopy(xBinary2.value, 0, xBinary.value, 0, xBinary.length);
                return xBinary;
            }
            case 33: 
            case 39: {
                return this.idcActiveFValuePools[n2].getXLong(((XLong)object2).value);
            }
            case 34: 
            case 40: {
                return this.idcActiveFValuePools[n2].getXInt(((XInt)object2).value);
            }
            case 35: 
            case 41: {
                return this.idcActiveFValuePools[n2].getXShort(((XShort)object2).value);
            }
            case 36: {
                return this.idcActiveFValuePools[n2].getXByte(((XByte)object2).value);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                XDateTime xDateTime = this.idcActiveFValuePools[n2].getXDateTime();
                XDateTime xDateTime2 = (XDateTime)object2;
                xDateTime.year = xDateTime2.year;
                xDateTime.month = xDateTime2.month;
                xDateTime.day = xDateTime2.day;
                xDateTime.hour = xDateTime2.hour;
                xDateTime.minute = xDateTime2.minute;
                xDateTime.utc = xDateTime2.utc;
                xDateTime.second = xDateTime2.second;
                xDateTime.timezoneHr = xDateTime2.timezoneHr;
                xDateTime.timezoneMin = xDateTime2.timezoneMin;
                xDateTime.position = xDateTime2.position;
                xDateTime.type = xDateTime2.type;
                return xDateTime;
            }
            case 5: {
                return this.idcActiveFValuePools[n2].getXFloat(((XFloat)object2).value);
            }
            case 6: {
                return this.idcActiveFValuePools[n2].getXDouble(((XDouble)object2).value);
            }
            case 19: {
                QNameKey qNameKey = this.idcActiveFValuePools[n2].getQName();
                QName qName = (QName)object2;
                qNameKey.fill(qName.nsURI, qName.localName);
                return qNameKey;
            }
            case 44: {
                XList xList = this.idcActiveFValuePools[n2].getXList();
                XList xList2 = (XList)object2;
                if (xList2.length > xList.value.length) {
                    xList2.value = new Object[xList2.length << 1];
                }
                for (int i = 0; i < xList2.length; ++i) {
                    xList.value[i] = this.copyFValue(n2, xList2.value[i], nArray[i], null);
                }
                xList.length = xList2.length;
                return xList;
            }
        }
        return null;
    }

    public void reset() {
        if (this.idcCount == 0) {
            return;
        }
        this.idcStateChangeHistoryCurrentContext = -1;
        this.idcStateChangeHistorySize = 0;
        for (int i = 0; i < this.xpathCount; ++i) {
            this.idcXPathStates[i][0] = 1;
        }
        System.arraycopy(this.emptyArray, 0, this.idcContainerListLengths, 0, this.idcCount);
        System.arraycopy(this.emptyArray, 0, this.idcIValuesListLengths, 0, this.idcCount);
        System.arraycopy(this.emptyArray, 0, this.idcFValueListLengths, 0, this.idcCount);
    }

    IValueContainer getIVContainer() {
        if (this.fIVCPool == null) {
            return new IValueContainer(this);
        }
        IValueContainer iValueContainer = this.fIVCPool;
        this.fIVCPool = this.fIVCPool.nextInPool;
        iValueContainer.clear();
        return iValueContainer;
    }

    void returnIVContainer(IValueContainer iValueContainer) {
        iValueContainer.nextInPool = this.fIVCPool;
        this.fIVCPool = iValueContainer;
    }

    IValuePool getIVPool() {
        if (this.fIVPoolPool == null) {
            return new IValuePool();
        }
        IValuePool iValuePool = this.fIVPoolPool;
        this.fIVPoolPool = this.fIVPoolPool.nextInPool;
        return iValuePool;
    }

    void returnIVPool(IValuePool iValuePool) {
        iValuePool.resetIVPool(true);
        iValuePool.nextInPool = this.fIVPoolPool;
        this.fIVPoolPool = iValuePool;
    }

    FValuePool getFVPool() {
        if (this.fFVPoolPool == null) {
            return new FValuePool();
        }
        FValuePool fValuePool = this.fFVPoolPool;
        this.fFVPoolPool = this.fFVPoolPool.nextInPool;
        return fValuePool;
    }

    void returnFVPool(FValuePool fValuePool) {
        fValuePool.resetFVPools();
        fValuePool.nextInPool = this.fFVPoolPool;
        this.fFVPoolPool = fValuePool;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class FValuePool {
        FValuePool nextInPool;
        private XByte[] idcXBytePool;
        private int idcXBytePoolResetCount = 0;
        private int idcXBytePoolOffset = 0;
        private XMLStringKey[] idcXMLStringPool;
        private int idcXMLStringPoolResetCount = 0;
        private int idcXMLStringPoolOffset = 0;
        private QNameKey[] idcQNamePool;
        private int idcQNamePoolResetCount = 0;
        private int idcQNamePoolOffset = 0;
        private XList[] idcXListPool;
        private int idcXListPoolResetCount = 0;
        private int idcXListPoolOffset;
        private XDateTime[] idcXDateTimePool;
        private int idcXDateTimePoolResetCount = 0;
        private int idcXDateTimePoolOffset = 0;
        private XBinary[] idcXBinaryPool;
        private int idcXBinaryPoolResetCount = 0;
        private int idcXBinaryPoolOffset = 0;
        private XShort[] idcXShortPool;
        private int idcXShortPoolResetCount = 0;
        private int idcXShortPoolOffset = 0;
        private XInt[] idcXIntPool;
        private int idcXIntPoolResetCount = 0;
        private int idcXIntPoolOffset = 0;
        private XLong[] idcXLongPool;
        private int idcXLongPoolResetCount = 0;
        private int idcXLongPoolOffset = 0;
        private XFloat[] idcXFloatPool;
        private int idcXFloatPoolResetCount = 0;
        private int idcXFloatPoolOffset = 0;
        private XDouble[] idcXDoublePool;
        private int idcXDoublePoolResetCount = 0;
        private int idcXDoublePoolOffset = 0;
        private XDecimal[] idcXDecimalPool;
        private int idcXDecimalPoolResetCount = 0;
        private int idcXDecimalPoolOffset = 0;
        private int idcObjectPoolsResetCount = 0;

        FValuePool() {
            this.createObjectPools();
        }

        private void createObjectPools() {
            int n2;
            this.idcXBytePool = new XByte[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXBytePool[n2] = new XByte();
            }
            this.idcXMLStringPool = new XMLStringKey[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXMLStringPool[n2] = new XMLStringKey();
            }
            this.idcQNamePool = new QNameKey[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcQNamePool[n2] = new QNameKey();
            }
            this.idcXListPool = new XList[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXListPool[n2] = new XList();
                this.idcXListPool[n2].value = new Object[8];
            }
            this.idcXDateTimePool = new XDateTime[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXDateTimePool[n2] = new XDateTime();
            }
            this.idcXBinaryPool = new XBinary[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXBinaryPool[n2] = new XBinary();
                this.idcXBinaryPool[n2].value = new byte[1024];
            }
            this.idcXShortPool = new XShort[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXShortPool[n2] = new XShort();
            }
            this.idcXIntPool = new XInt[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXIntPool[n2] = new XInt();
            }
            this.idcXLongPool = new XLong[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXLongPool[n2] = new XLong();
            }
            this.idcXFloatPool = new XFloat[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXFloatPool[n2] = new XFloat();
            }
            this.idcXDoublePool = new XDouble[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXDoublePool[n2] = new XDouble();
            }
            this.idcXDecimalPool = new XDecimal[4];
            for (n2 = 0; n2 < 4; ++n2) {
                this.idcXDecimalPool[n2] = new XDecimal();
                this.idcXDecimalPool[n2].rawData = new XMLString();
            }
        }

        XByte getXByte(byte by2) {
            if (this.idcXBytePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXBytePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXBytePoolOffset = 0;
            } else if (++this.idcXBytePoolOffset == this.idcXBytePool.length) {
                this.growXBytePool();
            }
            XByte xByte = this.idcXBytePool[this.idcXBytePoolOffset];
            xByte.value = by2;
            return xByte;
        }

        private void growXBytePool() {
            int n2 = this.idcXBytePool.length;
            int n3 = n2 << 1;
            XByte[] xByteArray = new XByte[n3];
            System.arraycopy(this.idcXBytePool, 0, xByteArray, 0, n2);
            this.idcXBytePool = xByteArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXBytePool[i] = new XByte();
            }
        }

        XMLStringKey getXMLString() {
            if (this.idcXMLStringPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXMLStringPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXMLStringPoolOffset = 0;
            } else if (++this.idcXMLStringPoolOffset == this.idcXMLStringPool.length) {
                this.growXMLStringPool();
            }
            XMLStringKey xMLStringKey = this.idcXMLStringPool[this.idcXMLStringPoolOffset];
            return xMLStringKey;
        }

        private void growXMLStringPool() {
            int n2 = this.idcXMLStringPool.length;
            int n3 = n2 << 1;
            XMLStringKey[] xMLStringKeyArray = new XMLStringKey[n3];
            System.arraycopy(this.idcXMLStringPool, 0, xMLStringKeyArray, 0, n2);
            this.idcXMLStringPool = xMLStringKeyArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXMLStringPool[i] = new XMLStringKey();
            }
        }

        QNameKey getQName() {
            if (this.idcQNamePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcQNamePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcQNamePoolOffset = 0;
            } else if (++this.idcQNamePoolOffset == this.idcQNamePool.length) {
                this.growQNamePool();
            }
            QNameKey qNameKey = this.idcQNamePool[this.idcQNamePoolOffset];
            return qNameKey;
        }

        private void growQNamePool() {
            int n2 = this.idcQNamePool.length;
            int n3 = n2 << 1;
            QNameKey[] qNameKeyArray = new QNameKey[n3];
            System.arraycopy(this.idcQNamePool, 0, qNameKeyArray, 0, n2);
            this.idcQNamePool = qNameKeyArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcQNamePool[i] = new QNameKey();
            }
        }

        XList getXList() {
            if (this.idcXListPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXListPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXListPoolOffset = 0;
            } else if (++this.idcXListPoolOffset == this.idcXListPool.length) {
                this.growXListPool();
            }
            XList xList = this.idcXListPool[this.idcXListPoolOffset];
            return xList;
        }

        private void growXListPool() {
            int n2 = this.idcXListPool.length;
            int n3 = n2 << 1;
            XList[] xListArray = new XList[n3];
            System.arraycopy(this.idcXListPool, 0, xListArray, 0, n2);
            this.idcXListPool = xListArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXListPool[i] = new XList();
                this.idcXListPool[i].value = new Object[8];
            }
        }

        XDateTime getXDateTime() {
            if (this.idcXDateTimePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXDateTimePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXDateTimePoolOffset = 0;
            } else if (++this.idcXDateTimePoolOffset == this.idcXDateTimePool.length) {
                this.growXDateTimePool();
            }
            XDateTime xDateTime = this.idcXDateTimePool[this.idcXDateTimePoolOffset];
            return xDateTime;
        }

        private void growXDateTimePool() {
            int n2 = this.idcXDateTimePool.length;
            int n3 = n2 << 1;
            XDateTime[] xDateTimeArray = new XDateTime[n3];
            System.arraycopy(this.idcXDateTimePool, 0, xDateTimeArray, 0, n2);
            this.idcXDateTimePool = xDateTimeArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXDateTimePool[i] = new XDateTime();
            }
        }

        XBinary getXBinary() {
            if (this.idcXBinaryPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXBinaryPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXBinaryPoolOffset = 0;
            } else if (++this.idcXBinaryPoolOffset == this.idcXBinaryPool.length) {
                this.growXBinaryPool();
            }
            XBinary xBinary = this.idcXBinaryPool[this.idcXBinaryPoolOffset];
            return xBinary;
        }

        private void growXBinaryPool() {
            int n2 = this.idcXBinaryPool.length;
            int n3 = n2 << 1;
            XBinary[] xBinaryArray = new XBinary[n3];
            System.arraycopy(this.idcXBinaryPool, 0, xBinaryArray, 0, n2);
            this.idcXBinaryPool = xBinaryArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXBinaryPool[i] = new XBinary();
                this.idcXBinaryPool[i].value = new byte[1024];
            }
        }

        XShort getXShort(short s) {
            if (this.idcXShortPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXShortPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXShortPoolOffset = 0;
            } else if (++this.idcXShortPoolOffset == this.idcXShortPool.length) {
                this.growXShortPool();
            }
            XShort xShort = this.idcXShortPool[this.idcXShortPoolOffset];
            xShort.value = s;
            return xShort;
        }

        private void growXShortPool() {
            int n2 = this.idcXShortPool.length;
            int n3 = n2 << 1;
            XShort[] xShortArray = new XShort[n3];
            System.arraycopy(this.idcXShortPool, 0, xShortArray, 0, n2);
            this.idcXShortPool = xShortArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXShortPool[i] = new XShort();
            }
        }

        XInt getXInt(int n2) {
            if (this.idcXIntPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXIntPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXIntPoolOffset = 0;
            } else if (++this.idcXIntPoolOffset == this.idcXIntPool.length) {
                this.growXIntPool();
            }
            XInt xInt = this.idcXIntPool[this.idcXIntPoolOffset];
            xInt.value = n2;
            return xInt;
        }

        private void growXIntPool() {
            int n2 = this.idcXIntPool.length;
            int n3 = n2 << 1;
            XInt[] xIntArray = new XInt[n3];
            System.arraycopy(this.idcXIntPool, 0, xIntArray, 0, n2);
            this.idcXIntPool = xIntArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXIntPool[i] = new XInt();
            }
        }

        XLong getXLong(long l) {
            if (this.idcXLongPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXLongPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXLongPoolOffset = 0;
            } else if (++this.idcXLongPoolOffset == this.idcXLongPool.length) {
                this.growXLongPool();
            }
            XLong xLong = this.idcXLongPool[this.idcXLongPoolOffset];
            xLong.value = l;
            return xLong;
        }

        private void growXLongPool() {
            int n2 = this.idcXLongPool.length;
            int n3 = n2 << 1;
            XLong[] xLongArray = new XLong[n3];
            System.arraycopy(this.idcXLongPool, 0, xLongArray, 0, n2);
            this.idcXLongPool = xLongArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXLongPool[i] = new XLong();
            }
        }

        XFloat getXFloat(float f2) {
            if (this.idcXFloatPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXFloatPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXFloatPoolOffset = 0;
            } else if (++this.idcXFloatPoolOffset == this.idcXFloatPool.length) {
                this.growXFloatPool();
            }
            XFloat xFloat = this.idcXFloatPool[this.idcXFloatPoolOffset];
            xFloat.value = f2;
            return xFloat;
        }

        private void growXFloatPool() {
            int n2 = this.idcXFloatPool.length;
            int n3 = n2 << 1;
            XFloat[] xFloatArray = new XFloat[n3];
            System.arraycopy(this.idcXFloatPool, 0, xFloatArray, 0, n2);
            this.idcXFloatPool = xFloatArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXFloatPool[i] = new XFloat();
            }
        }

        XDouble getXDouble(double d) {
            if (this.idcXDoublePoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXDoublePoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXDoublePoolOffset = 0;
            } else if (++this.idcXDoublePoolOffset == this.idcXDoublePool.length) {
                this.growXDoublePool();
            }
            XDouble xDouble = this.idcXDoublePool[this.idcXDoublePoolOffset];
            xDouble.value = d;
            return xDouble;
        }

        private void growXDoublePool() {
            int n2 = this.idcXDoublePool.length;
            int n3 = n2 << 1;
            XDouble[] xDoubleArray = new XDouble[n3];
            System.arraycopy(this.idcXDoublePool, 0, xDoubleArray, 0, n2);
            this.idcXDoublePool = xDoubleArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXDoublePool[i] = new XDouble();
            }
        }

        XDecimal getXDecimal() {
            if (this.idcXDecimalPoolResetCount != this.idcObjectPoolsResetCount) {
                this.idcXDecimalPoolResetCount = this.idcObjectPoolsResetCount;
                this.idcXDecimalPoolOffset = 0;
            } else if (++this.idcXDecimalPoolOffset == this.idcXDecimalPool.length) {
                this.growXDecimalPool();
            }
            return this.idcXDecimalPool[this.idcXDecimalPoolOffset];
        }

        private void growXDecimalPool() {
            int n2 = this.idcXDecimalPool.length;
            int n3 = n2 << 1;
            XDecimal[] xDecimalArray = new XDecimal[n3];
            System.arraycopy(this.idcXDecimalPool, 0, xDecimalArray, 0, n2);
            this.idcXDecimalPool = xDecimalArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.idcXDecimalPool[i] = new XDecimal();
                this.idcXDecimalPool[i].rawData = new XMLString();
            }
        }

        void resetFVPools() {
            if (++this.idcObjectPoolsResetCount < 0) {
                this.resetObjectPoolResetCounts();
            }
        }

        private void resetObjectPoolResetCounts() {
            this.idcObjectPoolsResetCount = 1;
            this.idcXBytePoolResetCount = 0;
            this.idcXMLStringPoolResetCount = 0;
            this.idcQNamePoolResetCount = 0;
            this.idcXListPoolResetCount = 0;
            this.idcXDateTimePoolResetCount = 0;
            this.idcXBinaryPoolResetCount = 0;
            this.idcXShortPoolResetCount = 0;
            this.idcXIntPoolResetCount = 0;
            this.idcXLongPoolResetCount = 0;
            this.idcXFloatPoolResetCount = 0;
            this.idcXDoublePoolResetCount = 0;
            this.idcXDecimalPoolResetCount = 0;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    static final class IValuePool {
        IValuePool nextInPool;
        private IValue[] fIVPool = new IValue[4];
        private int fIVPoolOffset = 0;

        IValuePool() {
            for (int i = 0; i < 4; ++i) {
                this.fIVPool[i] = new IValue();
            }
        }

        IValue getIValue() {
            if (++this.fIVPoolOffset == this.fIVPool.length) {
                this.growIValuePool();
            }
            return this.fIVPool[this.fIVPoolOffset];
        }

        private void growIValuePool() {
            int n2 = this.fIVPool.length;
            int n3 = n2 << 1;
            IValue[] iValueArray = new IValue[n3];
            System.arraycopy(this.fIVPool, 0, iValueArray, 0, n2);
            this.fIVPool = iValueArray;
            for (int i = n3 - 1; i >= n2; --i) {
                this.fIVPool[i] = new IValue();
            }
        }

        void resetIVPool(boolean bl) {
            this.fIVPoolOffset = 0;
            if (!bl && this.fIVPool.length > 4) {
                IValue[] iValueArray = new IValue[4];
                System.arraycopy(this.fIVPool, 0, iValueArray, 0, 4);
                this.fIVPool = iValueArray;
            }
        }
    }
}

