/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.util;

import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.BitSetImpl;
import com.ibm.xml.xlxp.util.MemberIterator;
import com.ibm.xml.xlxp.util.SparseBitSet;
import com.ibm.xml.xlxp.util.Symbol;
import com.ibm.xml.xlxp.util.SymbolTable;
import java.util.ArrayList;
import java.util.Iterator;

public class SymbolTableImpl
implements SymbolTable {
    protected static final int INITIAL_TABLE_SIZE = 1024;
    protected final ArrayList fIdArray;
    protected final boolean fUseSparseBitsets;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SymbolTableImpl() {
        this(1024, false);
    }

    public SymbolTableImpl(int n2, boolean bl) {
        this.fIdArray = new ArrayList(n2);
        this.fUseSparseBitsets = bl;
    }

    public int nextId() {
        int n2 = this.fIdArray.size();
        this.fIdArray.add(null);
        return n2;
    }

    public Object[] newTable() {
        Object[] objectArray = new Object[this.maxId() + 1];
        int n2 = 0;
        while (n2 <= this.maxId()) {
            objectArray[n2] = null;
            ++n2;
        }
        return objectArray;
    }

    public int maxId() {
        return this.fIdArray.size() - 1;
    }

    public void resizeBitSet(BitSet bitSet) {
        bitSet.setLength(this.maxId() + 1);
    }

    public BitSet newBitSet() {
        if (this.fUseSparseBitsets) {
            return new SparseBitSet(this.maxId() + 1);
        }
        return new BitSetImpl(this.maxId() + 1);
    }

    public Symbol get(int n2) {
        return (Symbol)this.fIdArray.get(n2);
    }

    public Iterator memberIterator(BitSet bitSet, int[] nArray) {
        return new MemberIterator(bitSet, nArray, this);
    }

    public void saveXref(Symbol symbol) {
        symbol.saveInArray(this.fIdArray);
    }
}

