/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.util;

public class Unicode {
    private static final boolean[] latinExtendedBUppercaseLetters = new boolean[255];
    private static final int[][] mathHash;
    private static final int[][] currencyHash;
    private static final int[][] modifierHash;
    private static final int[][] formatHash;
    public static String staticCopyrightString;

    private static boolean member(int n2, int[][] nArray) {
        int[] nArray2 = nArray[n2 & 0xF];
        int n3 = 0;
        while (n3 <= nArray2.length) {
            if (nArray2[n3] == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean isOdd(int n2) {
        return (n2 & 1) == 1;
    }

    public static boolean isLetter(int n2) {
        if (n2 <= 90) {
            return n2 >= 65;
        }
        if (n2 <= 122) {
            return n2 >= 97;
        }
        if (n2 >= 5121) {
            if (Unicode.isOtherLetterGreaterEqualTo0x1401(n2)) {
                return true;
            }
            if (n2 >= 119808) {
                if (n2 <= 120777) {
                    if (n2 >= 120488) {
                        return n2 != 120513 && n2 != 120539 && n2 != 120571 && n2 != 120597 && n2 != 120629 && n2 != 120655 && n2 != 120687 && n2 != 120713 && n2 != 120745 && n2 != 120771;
                    }
                    if (n2 >= 120146) {
                        return n2 <= 120483;
                    }
                    if (n2 >= 120138) {
                        return n2 <= 120144;
                    }
                    if (n2 >= 120077) {
                        return n2 <= 120134 && n2 != 120085 && n2 != 120093 && n2 != 120122 && n2 != 120127 && n2 != 120133;
                    }
                    if (n2 >= 119977) {
                        return n2 <= 120074 && n2 != 119981 && n2 != 119994 && n2 != 119996 && n2 != 120004 && n2 != 120070;
                    }
                    return n2 <= 119974 && n2 != 119893 && n2 != 119965 && n2 != 119968 && n2 != 119969 && n2 != 119971 && n2 != 119972;
                }
                return false;
            }
            if (n2 >= 66560) {
                return n2 <= 66639;
            }
            if (n2 >= 65313) {
                if (n2 <= 65338) {
                    return true;
                }
                if (n2 >= 65345) {
                    if (n2 <= 65370) {
                        return true;
                    }
                    if (n2 <= 65439) {
                        return n2 >= 65438 || n2 == 65392;
                    }
                }
                return false;
            }
            if (n2 >= 64256 && n2 <= 64279) {
                return n2 >= 64275 || n2 <= 64262;
            }
            return false;
        }
        switch (n2 & 0xFF00) {
            case 0: {
                if (n2 >= 248) {
                    return true;
                }
                if (n2 >= 192) {
                    return n2 <= 246 && n2 != 215;
                }
                return n2 == 170 || n2 == 181 || n2 == 186;
            }
            case 256: {
                return true;
            }
            case 512: {
                if (n2 <= 566) {
                    return true;
                }
                if (n2 <= 705) {
                    return n2 >= 592;
                }
                return n2 >= 710 && n2 <= 721 || n2 <= 740 && n2 >= 736 || n2 == 750;
            }
            case 768: {
                return n2 >= 902 && n2 <= 1019 && n2 != 903 && n2 != 907 && n2 != 909 && n2 != 930 && n2 != 975 && n2 != 1014 || n2 == 890;
            }
            case 1024: {
                if (n2 <= 1153) {
                    return true;
                }
                if (n2 < 1269) {
                    return n2 >= 1162 && n2 != 1231;
                }
                return n2 <= 1273 && n2 >= 1272;
            }
            case 1280: {
                if (n2 >= 1488) {
                    return n2 <= 1522;
                }
                if (n2 >= 1377) {
                    return n2 <= 1415;
                }
                if (n2 >= 1329) {
                    return n2 <= 1366 || n2 == 1369;
                }
                return n2 <= 1295;
            }
            case 1536: {
                if (n2 >= 1649) {
                    if (n2 <= 1747) {
                        return true;
                    }
                    if (n2 >= 1786) {
                        return n2 <= 1788 || n2 == 1791;
                    }
                    if (n2 >= 1765) {
                        return n2 <= 1766 || n2 >= 1774 && n2 <= 1775;
                    }
                    return n2 == 1749;
                }
                return n2 >= 1569 && n2 <= 1610;
            }
            case 1792: {
                if (n2 >= 1920) {
                    return n2 <= 1957 || n2 == 1969;
                }
                if (n2 >= 1869) {
                    return n2 <= 1871;
                }
                if (n2 >= 1810) {
                    return n2 <= 1839;
                }
                return n2 == 1808;
            }
            case 2048: {
                return false;
            }
            case 2304: {
                if (n2 <= 2361) {
                    return n2 >= 2308;
                }
                if (n2 <= 2401) {
                    return n2 >= 2392 || n2 == 2365 || n2 == 2384;
                }
                if (n2 <= 2444) {
                    return n2 >= 2437;
                }
                if (n2 <= 2448) {
                    return n2 >= 2447;
                }
                if (n2 <= 2480) {
                    return n2 >= 2451 && n2 != 2473;
                }
                if (n2 <= 2489) {
                    return n2 >= 2486 || n2 == 2482;
                }
                if (n2 <= 2529) {
                    return n2 >= 2524 && n2 != 2526;
                }
                return n2 >= 2544 && n2 <= 2545;
            }
            case 2560: {
                if (n2 >= 2693) {
                    if (n2 <= 2701) {
                        return true;
                    }
                    if (n2 <= 2745) {
                        return n2 >= 2703 && n2 != 2706 && n2 != 2729 && n2 != 2737 && n2 != 2740;
                    }
                    return n2 <= 2785 && n2 >= 2784 || n2 == 2749 || n2 == 2768;
                }
                if (n2 >= 2649) {
                    if (n2 <= 2652) {
                        return true;
                    }
                    if (n2 >= 2674) {
                        return n2 <= 2676;
                    }
                    return n2 == 2654;
                }
                if (n2 >= 2579) {
                    return n2 <= 2617 && n2 != 2601 && n2 != 2609 && n2 != 2612 && n2 != 2615;
                }
                if (n2 <= 2570) {
                    return n2 >= 2565;
                }
                return n2 >= 2575 && n2 <= 2576;
            }
            case 2816: {
                if (n2 >= 2947) {
                    if (n2 >= 2990) {
                        return n2 <= 3001 && n2 != 2998;
                    }
                    if (n2 >= 2984) {
                        return n2 <= 2986;
                    }
                    if (n2 >= 2979) {
                        return n2 <= 2980;
                    }
                    if (n2 >= 2969) {
                        return n2 <= 3007 && n2 != 2971 && n2 != 2973;
                    }
                    if (n2 >= 2958) {
                        return n2 <= 2965 && n2 != 2961;
                    }
                    return n2 >= 2949 && n2 <= 2954 || n2 == 2947;
                }
                if (n2 <= 2873) {
                    if (n2 >= 2835) {
                        return n2 != 2857 && n2 != 2865 && n2 != 2868;
                    }
                    if (n2 >= 2831) {
                        return n2 <= 2832;
                    }
                    return n2 >= 2821 && n2 <= 2828;
                }
                if (n2 >= 2911) {
                    return n2 <= 2913 || n2 == 2929;
                }
                return n2 == 2877 || n2 >= 2908 && n2 <= 2909;
            }
            case 3072: {
                int n3 = n2 & 0xC7F;
                if (n3 <= 3129) {
                    return n3 >= 3077 && n2 != 3085 && n2 != 3089 && n2 != 3113 && n2 != 3124;
                }
                if (n3 >= 3168) {
                    return n3 <= 3169;
                }
                return n2 == 3261 || n2 == 3294;
            }
            case 3328: {
                if (n2 >= 3461) {
                    if (n2 <= 3478) {
                        return true;
                    }
                    if (n2 <= 3515) {
                        return n2 >= 3482 && n2 != 3506;
                    }
                    return n2 <= 3526 && n2 >= 3520 || n2 == 3517;
                }
                if (n2 <= 3385) {
                    return n2 >= 3333 && n2 != 3341 && n2 != 3345 && n2 != 3369;
                }
                return n2 >= 3424 && n2 <= 3425;
            }
            case 3584: {
                if (n2 >= 3713) {
                    if (n2 >= 3754) {
                        if (n2 <= 3763) {
                            return n2 != 3756 && n2 != 3761;
                        }
                        if (n2 >= 3776) {
                            if (n2 <= 3780 || n2 == 3782) {
                                return true;
                            }
                            return n2 <= 3805 && n2 >= 3804;
                        }
                        return n2 == 3773;
                    }
                    if (n2 >= 3732) {
                        if (n2 <= 3735) {
                            return true;
                        }
                        if (n2 <= 3743) {
                            return n2 >= 3737;
                        }
                        return n2 <= 3751 && n2 != 3750 && n2 != 3748 && n2 != 3744;
                    }
                    return n2 <= 3714 || n2 == 3716 || n2 <= 3720 && n2 >= 3719 || n2 == 3722 || n2 == 3725;
                }
                if (n2 <= 3632) {
                    return n2 >= 3585;
                }
                return n2 <= 3654 && n2 >= 3648 || n2 <= 3635 && n2 >= 3634;
            }
            case 3840: {
                if (n2 <= 3946) {
                    if (n2 >= 3913) {
                        return true;
                    }
                    return n2 >= 3904 && n2 <= 3911 || n2 == 3840;
                }
                return n2 <= 3979 && n2 >= 3976;
            }
            case 4096: {
                if (n2 >= 4256) {
                    if (n2 <= 4293) {
                        return true;
                    }
                    return n2 >= 4304 && n2 <= 4344;
                }
                if (n2 <= 4138) {
                    return n2 != 4130 && n2 != 4136;
                }
                return n2 <= 4181 && n2 >= 4176;
            }
            case 4352: {
                if (n2 <= 4441) {
                    return true;
                }
                if (n2 >= 4520) {
                    return n2 <= 4601;
                }
                return n2 >= 4447 && n2 <= 4514;
            }
            case 4608: {
                if (n2 <= 4678) {
                    return n2 != 4615;
                }
                int n4 = n2 & 0xF;
                if (n4 <= 5) {
                    if (n4 == 1) {
                        return n2 != 4785 && n2 != 4801;
                    }
                    return true;
                }
                if (n4 >= 10 && n4 <= 13 || n4 == 8) {
                    return true;
                }
                if (n2 <= 4742) {
                    return n2 >= 4704 || n4 == 6;
                }
                if (n4 <= 7) {
                    return n2 >= 4838 || n2 <= 4775 || n2 == 4822;
                }
                if (n4 == 14) {
                    return n2 != 4750;
                }
                return n2 == 4767 || n2 == 4831 || n2 == 4863;
            }
        }
        if (n2 >= 5024) {
            return n2 <= 5108;
        }
        if (n2 >= 4896) {
            return n2 <= 4954 && n2 != 4935;
        }
        if (n2 <= 4878) {
            return true;
        }
        return n2 == 4880 || n2 <= 4885 && n2 >= 4882 || n2 >= 4888 && n2 <= 4894;
    }

    private static boolean isLatinExtendedABUppercaseLetter(int n2) {
        if (n2 <= 311) {
            return !Unicode.isOdd(n2);
        }
        if (n2 <= 328) {
            return Unicode.isOdd(n2);
        }
        if (n2 <= 376) {
            return !Unicode.isOdd(n2);
        }
        if (n2 <= 383) {
            return Unicode.isOdd(n2) && n2 != 383;
        }
        return latinExtendedBUppercaseLetters[n2 - 384];
    }

    public static boolean isUppercaseLetter(int n2) {
        switch (n2 & 0xFF00) {
            case 0: {
                if (n2 <= 90) {
                    return n2 >= 65;
                }
                if (n2 <= 222) {
                    return n2 >= 192 && n2 != 215;
                }
                return false;
            }
            case 256: {
                return Unicode.isLatinExtendedABUppercaseLetter(n2);
            }
            case 512: {
                return n2 <= 562 && !Unicode.isOdd(n2);
            }
            case 768: {
                if (n2 <= 911) {
                    return n2 >= 902 && n2 != 903 && n2 != 907 && n2 != 909;
                }
                if (n2 <= 939) {
                    return n2 != 912 && n2 != 930;
                }
                if (n2 <= 983) {
                    return n2 >= 978 && n2 <= 980;
                }
                if (n2 <= 1007) {
                    return !Unicode.isOdd(n2);
                }
                return n2 == 1012 || n2 == 1015 || n2 == 1017 || n2 == 1018;
            }
            case 1024: {
                if (n2 <= 1071) {
                    return true;
                }
                if (n2 <= 1153) {
                    return n2 >= 1120 && !Unicode.isOdd(n2);
                }
                if (n2 <= 1216) {
                    return n2 >= 1162 && !Unicode.isOdd(n2);
                }
                if (n2 <= 1230) {
                    return Unicode.isOdd(n2);
                }
                if (n2 <= 1269) {
                    return n2 != 1231 && !Unicode.isOdd(n2);
                }
                return n2 == 1272 || n2 <= 66599 && n2 >= 66560;
            }
            case 1280: {
                if (n2 <= 1294) {
                    return !Unicode.isOdd(n2);
                }
                return n2 <= 1366 && n2 >= 1329;
            }
            case 4096: {
                return n2 <= 4293 && n2 >= 4256;
            }
            case 7680: {
                if (n2 <= 7829) {
                    return n2 >= 7680 && !Unicode.isOdd(n2);
                }
                if (n2 <= 7929) {
                    return n2 >= 7840 && !Unicode.isOdd(n2);
                }
                return false;
            }
            case 7936: {
                int n3 = n2 & 0xF;
                if (n3 <= 7) {
                    return false;
                }
                if (n2 <= 7951) {
                    return true;
                }
                if (n2 <= 7965) {
                    return true;
                }
                if (n2 <= 8013) {
                    return n2 >= 7976;
                }
                if (n2 <= 8031) {
                    return Unicode.isOdd(n2);
                }
                if (n2 <= 8047) {
                    return true;
                }
                if (n2 <= 8119) {
                    return false;
                }
                if (n3 <= 11) {
                    return true;
                }
                return n2 == 8172;
            }
            case 8448: {
                if (n2 > 8517) {
                    return false;
                }
                if (n2 <= 8461) {
                    return n2 == 8450 || n2 == 8455 || n2 >= 8459;
                }
                if (n2 <= 8466) {
                    return n2 >= 8464;
                }
                if (n2 <= 8477) {
                    return n2 == 8469 || n2 >= 8473;
                }
                if (n2 <= 8493) {
                    return n2 >= 8484 && !Unicode.isOdd(n2) || n2 >= 8490;
                }
                return n2 == 8496 || n2 == 8497 || n2 == 8499 || n2 == 8510 || n2 == 8511 || n2 == 8517;
            }
            case 212: {
                if (n2 <= 119833) {
                    return n2 >= 119808;
                }
                if (n2 <= 119885) {
                    return n2 >= 119860;
                }
                if (n2 <= 119937) {
                    return n2 >= 119912;
                }
                if (n2 <= 119989) {
                    if (n2 >= 119964) {
                        switch (n2) {
                            case 119965: 
                            case 119968: 
                            case 119969: 
                            case 119971: 
                            case 119972: 
                            case 119975: 
                            case 119976: 
                            case 119981: {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                return n2 <= 120041 && n2 >= 120016;
            }
            case 54528: {
                if (n2 <= 120092) {
                    return n2 >= 120068 && n2 != 120070 && n2 != 120075 && n2 != 120076 && n2 != 120085;
                }
                if (n2 <= 120132) {
                    return n2 >= 120120 && n2 != 120122 && n2 != 120127;
                }
                if (n2 <= 120144) {
                    return n2 == 120134 || n2 >= 120138;
                }
                if (n2 <= 120197) {
                    return n2 >= 120172;
                }
                if (n2 <= 120249) {
                    return n2 >= 120224;
                }
                return n2 <= 120301 && n2 >= 120276;
            }
            case 54784: {
                if (n2 <= 120353) {
                    return n2 >= 120328;
                }
                if (n2 <= 120405) {
                    return n2 >= 120380;
                }
                if (n2 <= 120457) {
                    return n2 >= 120432;
                }
                if (n2 <= 120512) {
                    return n2 >= 120488;
                }
                return n2 <= 120570 && n2 >= 120546;
            }
            case 55040: {
                if (n2 <= 120628) {
                    return n2 >= 120604;
                }
                if (n2 <= 120686) {
                    return n2 >= 120662;
                }
                return n2 <= 120744 && n2 >= 120720;
            }
            case 65280: {
                return n2 <= 65338 && n2 >= 65313;
            }
        }
        return false;
    }

    public static boolean isLowercaseLetter(int n2) {
        switch (n2 & 0xFF00) {
            case 0: {
                if (n2 <= 122) {
                    return n2 >= 97;
                }
                if (n2 >= 223) {
                    return n2 != 247;
                }
                return n2 == 170 || n2 == 181 || n2 == 186;
            }
            case 256: {
                if (n2 >= 448 && n2 <= 451 || n2 == 453 || n2 == 443 || n2 == 459) {
                    return false;
                }
                return !Unicode.isLatinExtendedABUppercaseLetter(n2);
            }
            case 512: {
                if (n2 <= 566) {
                    return Unicode.isOdd(n2) || n2 >= 564;
                }
                return n2 <= 687 && n2 >= 592;
            }
            case 768: {
                if (n2 <= 977) {
                    return n2 >= 940 || n2 == 912;
                }
                if (n2 <= 1007) {
                    return n2 >= 981 && (Unicode.isOdd(n2) || n2 == 982);
                }
                return n2 <= 1011 || n2 == 1013 || n2 == 1016 || n2 == 1019;
            }
            case 1024: {
                if (n2 <= 1119) {
                    return n2 >= 1072;
                }
                if (n2 <= 1154) {
                    return Unicode.isOdd(n2);
                }
                if (n2 <= 1216) {
                    return n2 >= 1163 && Unicode.isOdd(n2);
                }
                if (n2 <= 1231) {
                    return !Unicode.isOdd(n2);
                }
                if (n2 <= 1270) {
                    return Unicode.isOdd(n2);
                }
                return n2 == 1273 || n2 <= 66639 && n2 >= 66600;
            }
            case 1280: {
                if (n2 <= 95) {
                    return Unicode.isOdd(n2);
                }
                return n2 <= 1415 && n2 >= 1377;
            }
            case 7424: {
                if (n2 <= 7467) {
                    return true;
                }
                return n2 <= 7531 && n2 >= 7522;
            }
            case 7680: {
                return n2 <= 7930 && Unicode.isOdd(n2) || n2 == 7830 || n2 == 7832 || n2 == 7834;
            }
            case 7936: {
                if (n2 <= 8183) {
                    int n3 = n2 & 0xF;
                    if (n3 <= 7) {
                        if (n2 <= 7957) {
                            return true;
                        }
                        if (n2 <= 8005) {
                            return n2 >= 7968;
                        }
                        if (n2 <= 8116) {
                            return n2 >= 8016;
                        }
                        if (n3 >= 6) {
                            return true;
                        }
                        if (n3 == 5) {
                            return n2 == 8165;
                        }
                        if (n2 <= 8147) {
                            return n2 >= 8130;
                        }
                        return n2 <= 8164 || n2 >= 8178;
                    }
                    return n2 >= 8056 && n2 <= 8061 || n2 == 8126;
                }
            }
            case 8192: {
                return n2 == 8305 || n2 == 8319;
            }
            case 8448: {
                return n2 == 8458 || n2 == 8462 || n2 == 8463 || n2 == 8467 || n2 == 8495 || n2 == 8500 || n2 == 8505 || n2 == 8509 || n2 >= 8518 && n2 <= 8521;
            }
            case 54272: {
                if (n2 <= 119859) {
                    return n2 >= 119834;
                }
                if (n2 <= 119892) {
                    return n2 >= 119886;
                }
                if (n2 <= 119911) {
                    return n2 >= 119894;
                }
                if (n2 <= 119963) {
                    return n2 >= 119938;
                }
                if (n2 <= 119993) {
                    return n2 >= 119990;
                }
                if (n2 <= 120003) {
                    return n2 >= 119997 || n2 == 119995;
                }
                if (n2 <= 120015) {
                    return n2 >= 120005;
                }
                return n2 <= 120063 && n2 >= 120042;
            }
            case 54528: {
                if (n2 <= 120067) {
                    return n2 >= 120064;
                }
                if (n2 <= 120119) {
                    return n2 >= 120094;
                }
                if (n2 <= 120171) {
                    return n2 >= 120146;
                }
                if (n2 <= 120223) {
                    return n2 >= 120198;
                }
                if (n2 <= 120275) {
                    return n2 >= 120250;
                }
                return n2 <= 120319 && n2 >= 120302;
            }
            case 54784: {
                if (n2 <= 120327) {
                    return n2 >= 120320;
                }
                if (n2 <= 120379) {
                    return n2 >= 120354;
                }
                if (n2 <= 120431) {
                    return n2 >= 120406;
                }
                if (n2 <= 120483) {
                    return n2 >= 120458;
                }
                if (n2 <= 120538) {
                    return n2 >= 120514;
                }
                if (n2 <= 120545) {
                    return n2 >= 120540;
                }
                return n2 <= 120575 && n2 >= 120572;
            }
            case 55040: {
                if (n2 <= 120596) {
                    return n2 >= 120576;
                }
                if (n2 <= 120603) {
                    return n2 >= 120598;
                }
                if (n2 <= 120654) {
                    return n2 >= 120630;
                }
                if (n2 <= 120661) {
                    return n2 >= 120656;
                }
                if (n2 <= 120712) {
                    return n2 >= 120688;
                }
                if (n2 <= 120719) {
                    return n2 >= 120714;
                }
                if (n2 <= 120770) {
                    return n2 >= 120746;
                }
                return n2 <= 120777 && n2 >= 120772;
            }
            case 64256: {
                if (n2 <= 64262) {
                    return n2 >= 64256;
                }
                return n2 <= 64279 && n2 >= 64275;
            }
            case 65280: {
                return n2 <= 65370 && n2 >= 65345;
            }
        }
        return false;
    }

    public static boolean isTitlecaseLetter(int n2) {
        if (n2 == 453 || n2 == 456 || n2 == 459 || n2 == 498) {
            return true;
        }
        if (n2 <= 8111 && n2 >= 8072) {
            return (n2 & 0xF) >= 8;
        }
        return n2 == 8124 || n2 == 8140 || n2 == 8188;
    }

    public static boolean isModifierLetter(int n2) {
        if (n2 <= 740) {
            if (n2 <= 705) {
                return n2 >= 688;
            }
            if (n2 <= 721) {
                return n2 >= 710;
            }
            return n2 >= 736;
        }
        return n2 == 750 || n2 == 890 || n2 == 1369 || n2 == 1600 || n2 == 1765 || n2 == 1766 || n2 == 3654 || n2 == 3782 || n2 == 6103 || n2 == 6211 || n2 <= 7521 && n2 >= 7468 || n2 == 12293 || n2 <= 12341 && n2 >= 12337 || n2 == 12347 || n2 == 12445 || n2 == 12446 || n2 >= 12540 && n2 <= 12542 || n2 == 65392 || n2 == 65438 || n2 == 65439;
    }

    private static boolean isOtherLetterGreaterEqualTo0x1401(int n2) {
        if (n2 >= 19968) {
            if (n2 <= 40869) {
                return true;
            }
            if (n2 >= 44032) {
                if (n2 <= 55203) {
                    return true;
                }
                if (n2 >= 131072) {
                    if (n2 <= 173782) {
                        return true;
                    }
                    if (n2 >= 194560) {
                        return n2 <= 195101;
                    }
                    return false;
                }
                if (n2 >= 65536) {
                    if (n2 <= 65574) {
                        return n2 != 65548;
                    }
                    if (n2 <= 65594) {
                        return n2 >= 65576;
                    }
                    if (n2 <= 65613) {
                        return n2 >= 65596 && n2 != 65598;
                    }
                    if (n2 <= 65629) {
                        return n2 >= 65616;
                    }
                    if (n2 <= 65786) {
                        return n2 >= 65664;
                    }
                    if (n2 <= 66334) {
                        return n2 >= 66304;
                    }
                    if (n2 <= 66377) {
                        return n2 >= 66352;
                    }
                    if (n2 <= 66461) {
                        return n2 >= 66432;
                    }
                    if (n2 <= 66717) {
                        return n2 >= 66640;
                    }
                    if (n2 <= 67589) {
                        return n2 >= 67584;
                    }
                    if (n2 <= 67637) {
                        return n2 >= 67594 || n2 == 67592;
                    }
                    return n2 == 67639 || n2 == 67640 || n2 == 67644 || n2 == 67647;
                }
                if (n2 >= 65382) {
                    if (n2 <= 65437 && n2 != 65392) {
                        return true;
                    }
                    if (n2 <= 65470) {
                        return n2 >= 65440;
                    }
                    if (n2 <= 65479) {
                        return n2 >= 65474;
                    }
                    if (n2 <= 65487) {
                        return n2 >= 65482;
                    }
                    if (n2 <= 65495) {
                        return n2 >= 65490;
                    }
                    return n2 <= 65500 && n2 >= 65498;
                }
                if (n2 >= 65136) {
                    return n2 <= 65276 && n2 != 65141;
                }
                if (n2 >= 64467) {
                    if (n2 <= 64829) {
                        return true;
                    }
                    if (n2 <= 64911) {
                        return n2 >= 64848;
                    }
                    if (n2 <= 64967) {
                        return n2 >= 64914;
                    }
                    return n2 <= 65019 && n2 >= 65008;
                }
                if (n2 >= 64285) {
                    if (n2 <= 64296) {
                        return n2 != 64286;
                    }
                    if (n2 <= 64310) {
                        return n2 >= 64298;
                    }
                    if (n2 <= 64316) {
                        return n2 >= 64312;
                    }
                    return n2 <= 64433 && n2 != 64317 && n2 != 64319 && n2 != 64322 && n2 != 64325;
                }
                if (n2 >= 63744) {
                    if (n2 <= 64045) {
                        return true;
                    }
                    return n2 <= 64106 && n2 >= 64048;
                }
            }
            if (n2 >= 40960) {
                return n2 <= 42124;
            }
        }
        if (n2 >= 13312) {
            return n2 <= 19893;
        }
        if (n2 <= 5740) {
            return true;
        }
        if (n2 <= 5750) {
            return n2 >= 5743;
        }
        if (n2 <= 5786) {
            return n2 >= 5761;
        }
        if (n2 <= 5866) {
            return n2 >= 5792;
        }
        if (n2 <= 6067) {
            if (n2 >= 6016) {
                return true;
            }
            switch (n2 & 0xF0) {
                case 0: 
                case 96: {
                    return (n2 & 0xF) != 13;
                }
                case 16: 
                case 48: 
                case 80: {
                    return (n2 & 0xF) <= 1;
                }
                case 32: 
                case 64: {
                    return true;
                }
            }
            return n2 == 6000;
        }
        if ((float)n2 <= 181.0f) {
            return n2 == 6108;
        }
        if (n2 <= 6263) {
            return n2 != 6211;
        }
        if (n2 <= 6312) {
            return n2 >= 6272;
        }
        if (n2 <= 6428) {
            return n2 >= 6400;
        }
        if (n2 <= 6516) {
            return n2 >= 6480;
        }
        if (n2 <= 8504) {
            return n2 >= 8501;
        }
        if (n2 <= 12438) {
            return n2 >= 12353 || n2 == 12294 || n2 == 12348;
        }
        if (n2 <= 12538) {
            return n2 >= 12449 || n2 == 12447;
        }
        if (n2 <= 12588) {
            return n2 >= 12549 || n2 == 12543;
        }
        if (n2 <= 12686) {
            return n2 >= 12593;
        }
        if (n2 <= 12727) {
            return n2 >= 12704;
        }
        return n2 >= 12784 && n2 <= 12799;
    }

    public static boolean isOtherLetter(int n2) {
        if (n2 >= 5121) {
            return Unicode.isOtherLetterGreaterEqualTo0x1401(n2);
        }
        if (n2 <= 451) {
            return n2 >= 448 || n2 == 443;
        }
        if (n2 <= 1514) {
            return n2 >= 1488;
        }
        if (n2 <= 1522) {
            return n2 >= 1520;
        }
        if (n2 <= 1791) {
            if (n2 <= 1594) {
                return n2 >= 1569;
            }
            if (n2 <= 1610) {
                return n2 >= 1601;
            }
            if (n2 <= 1647) {
                return n2 >= 1646;
            }
            if (n2 <= 1747) {
                return n2 >= 1649;
            }
            if (n2 <= 1775) {
                return n2 >= 1774 || n2 == 1749;
            }
            if (n2 <= 1788) {
                return n2 >= 1786;
            }
            return n2 == 1791;
        }
        if (n2 <= 1969) {
            if (n2 <= 1839) {
                return n2 >= 1808 && n2 != 1809;
            }
            if (n2 <= 1871) {
                return n2 >= 1869;
            }
            if (n2 <= 1957) {
                return n2 >= 1920;
            }
            return n2 == 1969;
        }
        if (n2 <= 2545) {
            if (n2 >= 2544) {
                return true;
            }
            if (n2 >= 2524) {
                return n2 <= 2529 && n2 != 2526;
            }
            if (n2 >= 2486) {
                return n2 <= 2489 || n2 == 2493;
            }
            if (n2 >= 2451) {
                return n2 <= 2480 && n2 != 2473 || n2 == 2482;
            }
            if (n2 >= 2437) {
                return n2 <= 2444 || n2 == 2447 || n2 == 2448;
            }
            if (n2 >= 2392) {
                return n2 <= 2401;
            }
            return n2 <= 2361 && n2 >= 2308 || n2 == 2384 || n2 == 2381;
        }
        if (n2 <= 2785) {
            if (n2 >= 2741) {
                return n2 <= 2744 || n2 == 2749 || n2 == 2768 || n2 == 2784 || n2 == 2785;
            }
            if (n2 >= 2730) {
                return n2 <= 2745 && n2 != 2737 && n2 != 2740;
            }
            if (n2 >= 2707) {
                return n2 <= 2728;
            }
            if (n2 >= 2693) {
                return n2 <= 2705;
            }
            if (n2 >= 2674) {
                return n2 <= 2676;
            }
            if (n2 >= 2649) {
                return n2 <= 2652 || n2 == 2654;
            }
            if (n2 >= 2579) {
                return n2 < 2617 && n2 != 2601 && n2 != 2609 && n2 != 2615;
            }
            return n2 >= 2565 && n2 <= 2570 || n2 == 2575 || n2 == 2576;
        }
        if (n2 <= 3001) {
            if (n2 >= 2990) {
                return n2 <= 3001 && n2 != 2998;
            }
            if (n2 >= 2984) {
                return n2 <= 2986;
            }
            if (n2 >= 2969) {
                if (n2 <= 2975) {
                    return n2 != 2971 && n2 != 2973;
                }
                return n2 == 2979 || n2 == 2980;
            }
            if (n2 >= 2958) {
                return n2 <= 2965 && n2 != 2961;
            }
            if (n2 >= 2947) {
                return n2 <= 2954 && n2 != 2948;
            }
            if (n2 >= 2874) {
                return n2 == 2877 || n2 == 2908 || n2 == 2909 || n2 == 2911 || n2 == 2912 || n2 == 2913 || n2 == 2929;
            }
            if (n2 >= 2835) {
                return n2 != 2857 && n2 != 2865 && n2 != 2868;
            }
            return n2 >= 2821 && n2 <= 2828 || n2 == 2831 || n2 == 2832;
        }
        if (n2 <= 3297) {
            int n3 = n2 & 0xFFFFFF7F;
            if (n3 >= 3077) {
                return n3 <= 3129 && n3 != 3085 && n3 != 3089 && n3 != 3113 && n3 != 3124;
            }
            if (n3 >= 3168) {
                return n3 <= 3169;
            }
            return n2 == 3261 || n2 == 3294;
        }
        if (n2 <= 3526) {
            if (n2 >= 3520) {
                return true;
            }
            if (n2 >= 3482) {
                return n2 <= 3517 && n2 != 3506 && n2 != 3516;
            }
            if (n2 >= 3461) {
                return n2 <= 3478;
            }
            if (n2 >= 3424) {
                return n2 <= 3425;
            }
            return n2 >= 3333 && n2 <= 3385 && n2 != 3341 && n2 != 3345 && n2 != 3369;
        }
        if (n2 <= 3805) {
            if (n2 >= 3804) {
                return true;
            }
            if (n2 >= 3776) {
                return n2 <= 3789;
            }
            if (n2 >= 3754) {
                return n2 <= 3763 && n2 != 3756 && n2 != 3761 || n2 == 3773;
            }
            if (n2 >= 3732) {
                return n2 <= 3751 && n2 != 3736 && n2 != 3744 && n2 != 3748 && n2 != 3750;
            }
            if (n2 >= 3713) {
                return n2 == 3713 || n2 == 3714 || n2 == 3716 || n2 == 3719 || n2 == 3720 || n2 == 3722 || n2 == 3725;
            }
            return n2 >= 3585 && n2 <= 3632 || n2 <= 3635 && n2 >= 3634 || n2 <= 3653 && n2 >= 3648;
        }
        if (n2 <= 3979) {
            if (n2 >= 3976) {
                return true;
            }
            if (n2 >= 3904) {
                return n2 <= 3946 && n2 != 3912;
            }
            return n2 == 3840;
        }
        if (n2 <= 4344) {
            if (n2 >= 4304) {
                return true;
            }
            if (n2 >= 4176) {
                return n2 <= 4181;
            }
            return n2 >= 4096 && n2 <= 4138 && n2 != 4130 && n2 != 4136;
        }
        if (n2 <= 4601) {
            if (n2 >= 4520) {
                return true;
            }
            if (n2 >= 4447) {
                return n2 <= 4515;
            }
            return n2 >= 4352 && n2 <= 4441;
        }
        if (n2 <= 4863) {
            // empty if block
        }
        if (n2 <= 5108) {
            if (n2 >= 5024) {
                return true;
            }
            if (n2 >= 4896) {
                return n2 <= 4954 && n2 != 4935;
            }
            return n2 > 4864 && (n2 & 0xF) != 15 && n2 != 4881 && n2 != 4886 && n2 != 4887;
        }
        return false;
    }

    public static boolean isMark(int n2) {
        return false;
    }

    public static boolean isNonspacingMark(int n2) {
        return false;
    }

    public static boolean isSpaceCombiningMark(int n2) {
        return false;
    }

    public static boolean isEnclosingMark(int n2) {
        return false;
    }

    public static boolean isNumber(int n2) {
        return false;
    }

    public static boolean isDecimalDigit(int n2) {
        return false;
    }

    public static boolean isLetterNumber(int n2) {
        return false;
    }

    public static boolean isOtherNumber(int n2) {
        return false;
    }

    public static boolean isPunctuation(int n2) {
        return false;
    }

    public static boolean isConnectorPunctuation(int n2) {
        return false;
    }

    public static boolean isDashPunctuation(int n2) {
        return false;
    }

    public static boolean isOpenPunctuation(int n2) {
        return false;
    }

    public static boolean isClosePunctuation(int n2) {
        return false;
    }

    public static boolean isInitialQuotePunctuation(int n2) {
        return false;
    }

    public static boolean isFinalQuotePunctuation(int n2) {
        return false;
    }

    public static boolean isOtherPunctuation(int n2) {
        return false;
    }

    public static boolean isSeparator(int n2) {
        return false;
    }

    public static boolean isSpaceSeparator(int n2) {
        return false;
    }

    public static boolean isLineSeparator(int n2) {
        return false;
    }

    public static boolean isParagraphSeparator(int n2) {
        return false;
    }

    public static boolean isSymbol(int n2) {
        return false;
    }

    public static boolean isMathSymbol(int n2) {
        if (Unicode.member(n2, mathHash)) {
            return true;
        }
        if (n2 <= 8959) {
            return n2 >= 8692;
        }
        if (n2 <= 9139) {
            return n2 >= 9115;
        }
        if (n2 <= 10213) {
            return n2 >= 10192;
        }
        if (n2 <= 10239) {
            return n2 >= 10224;
        }
        if (n2 <= 10626) {
            return n2 >= 10496;
        }
        if (n2 <= 10711) {
            return n2 >= 10649;
        }
        if (n2 <= 10747) {
            return n2 >= 10716;
        }
        return n2 >= 10750 && n2 <= 11007;
    }

    public static boolean isCurrencySymbol(int n2) {
        return Unicode.member(n2, currencyHash) || n2 >= 8352 && n2 <= 8369;
    }

    public static boolean isModifierSymbol(int n2) {
        if (Unicode.member(n2, modifierHash)) {
            return true;
        }
        if (n2 <= 735) {
            return n2 >= 722;
        }
        if (n2 <= 749) {
            return n2 >= 741;
        }
        return n2 >= 751 && n2 <= 767;
    }

    public static boolean isOtherSymbol(int n2) {
        return false;
    }

    public static boolean isOther(int n2) {
        return Unicode.isControlOther(n2) || Unicode.isFormatOther(n2) || Unicode.isPrivateUseOther(n2) || Unicode.isNotAssignedOther(n2);
    }

    public static boolean isControlOther(int n2) {
        return n2 <= 31 || n2 >= 127 && (float)n2 <= 9.0f;
    }

    public static boolean isFormatOther(int n2) {
        if (Unicode.member(n2, formatHash)) {
            return true;
        }
        return n2 >= 917536 && n2 <= 917631;
    }

    public static boolean isPrivateUseOther(int n2) {
        return false;
    }

    public static boolean isNotAssignedOther(int n2) {
        return false;
    }

    static {
        Unicode.latinExtendedBUppercaseLetters[0] = false;
        Unicode.latinExtendedBUppercaseLetters[1] = true;
        Unicode.latinExtendedBUppercaseLetters[2] = true;
        Unicode.latinExtendedBUppercaseLetters[3] = false;
        Unicode.latinExtendedBUppercaseLetters[4] = true;
        Unicode.latinExtendedBUppercaseLetters[5] = false;
        Unicode.latinExtendedBUppercaseLetters[6] = true;
        Unicode.latinExtendedBUppercaseLetters[7] = true;
        Unicode.latinExtendedBUppercaseLetters[8] = false;
        Unicode.latinExtendedBUppercaseLetters[9] = true;
        Unicode.latinExtendedBUppercaseLetters[10] = true;
        Unicode.latinExtendedBUppercaseLetters[11] = true;
        Unicode.latinExtendedBUppercaseLetters[12] = false;
        Unicode.latinExtendedBUppercaseLetters[13] = false;
        Unicode.latinExtendedBUppercaseLetters[14] = true;
        Unicode.latinExtendedBUppercaseLetters[15] = true;
        Unicode.latinExtendedBUppercaseLetters[16] = true;
        Unicode.latinExtendedBUppercaseLetters[17] = true;
        Unicode.latinExtendedBUppercaseLetters[18] = false;
        Unicode.latinExtendedBUppercaseLetters[19] = true;
        Unicode.latinExtendedBUppercaseLetters[20] = true;
        Unicode.latinExtendedBUppercaseLetters[21] = false;
        Unicode.latinExtendedBUppercaseLetters[22] = true;
        Unicode.latinExtendedBUppercaseLetters[23] = true;
        Unicode.latinExtendedBUppercaseLetters[24] = true;
        Unicode.latinExtendedBUppercaseLetters[25] = false;
        Unicode.latinExtendedBUppercaseLetters[26] = false;
        Unicode.latinExtendedBUppercaseLetters[27] = false;
        Unicode.latinExtendedBUppercaseLetters[28] = true;
        Unicode.latinExtendedBUppercaseLetters[29] = true;
        Unicode.latinExtendedBUppercaseLetters[30] = false;
        Unicode.latinExtendedBUppercaseLetters[31] = true;
        Unicode.latinExtendedBUppercaseLetters[32] = true;
        Unicode.latinExtendedBUppercaseLetters[33] = false;
        Unicode.latinExtendedBUppercaseLetters[34] = true;
        Unicode.latinExtendedBUppercaseLetters[35] = false;
        Unicode.latinExtendedBUppercaseLetters[36] = true;
        Unicode.latinExtendedBUppercaseLetters[37] = false;
        Unicode.latinExtendedBUppercaseLetters[38] = true;
        Unicode.latinExtendedBUppercaseLetters[39] = true;
        Unicode.latinExtendedBUppercaseLetters[40] = false;
        Unicode.latinExtendedBUppercaseLetters[41] = true;
        Unicode.latinExtendedBUppercaseLetters[42] = false;
        Unicode.latinExtendedBUppercaseLetters[43] = false;
        Unicode.latinExtendedBUppercaseLetters[44] = true;
        Unicode.latinExtendedBUppercaseLetters[45] = false;
        Unicode.latinExtendedBUppercaseLetters[46] = true;
        Unicode.latinExtendedBUppercaseLetters[47] = true;
        Unicode.latinExtendedBUppercaseLetters[48] = false;
        Unicode.latinExtendedBUppercaseLetters[49] = true;
        Unicode.latinExtendedBUppercaseLetters[50] = true;
        Unicode.latinExtendedBUppercaseLetters[51] = true;
        Unicode.latinExtendedBUppercaseLetters[52] = false;
        Unicode.latinExtendedBUppercaseLetters[53] = true;
        Unicode.latinExtendedBUppercaseLetters[54] = false;
        Unicode.latinExtendedBUppercaseLetters[55] = true;
        Unicode.latinExtendedBUppercaseLetters[56] = true;
        Unicode.latinExtendedBUppercaseLetters[57] = false;
        Unicode.latinExtendedBUppercaseLetters[58] = false;
        Unicode.latinExtendedBUppercaseLetters[59] = false;
        Unicode.latinExtendedBUppercaseLetters[60] = true;
        Unicode.latinExtendedBUppercaseLetters[61] = false;
        Unicode.latinExtendedBUppercaseLetters[62] = false;
        Unicode.latinExtendedBUppercaseLetters[63] = false;
        Unicode.latinExtendedBUppercaseLetters[64] = false;
        Unicode.latinExtendedBUppercaseLetters[65] = false;
        Unicode.latinExtendedBUppercaseLetters[66] = false;
        Unicode.latinExtendedBUppercaseLetters[67] = false;
        Unicode.latinExtendedBUppercaseLetters[68] = true;
        Unicode.latinExtendedBUppercaseLetters[69] = false;
        Unicode.latinExtendedBUppercaseLetters[70] = false;
        Unicode.latinExtendedBUppercaseLetters[71] = true;
        Unicode.latinExtendedBUppercaseLetters[72] = false;
        Unicode.latinExtendedBUppercaseLetters[73] = false;
        Unicode.latinExtendedBUppercaseLetters[74] = true;
        Unicode.latinExtendedBUppercaseLetters[75] = false;
        Unicode.latinExtendedBUppercaseLetters[76] = false;
        Unicode.latinExtendedBUppercaseLetters[77] = true;
        Unicode.latinExtendedBUppercaseLetters[78] = false;
        Unicode.latinExtendedBUppercaseLetters[79] = true;
        Unicode.latinExtendedBUppercaseLetters[80] = false;
        Unicode.latinExtendedBUppercaseLetters[81] = true;
        Unicode.latinExtendedBUppercaseLetters[82] = false;
        Unicode.latinExtendedBUppercaseLetters[83] = true;
        Unicode.latinExtendedBUppercaseLetters[84] = false;
        Unicode.latinExtendedBUppercaseLetters[85] = true;
        Unicode.latinExtendedBUppercaseLetters[86] = false;
        Unicode.latinExtendedBUppercaseLetters[87] = true;
        Unicode.latinExtendedBUppercaseLetters[88] = false;
        Unicode.latinExtendedBUppercaseLetters[89] = true;
        Unicode.latinExtendedBUppercaseLetters[90] = false;
        Unicode.latinExtendedBUppercaseLetters[91] = true;
        Unicode.latinExtendedBUppercaseLetters[92] = false;
        Unicode.latinExtendedBUppercaseLetters[93] = false;
        Unicode.latinExtendedBUppercaseLetters[94] = true;
        Unicode.latinExtendedBUppercaseLetters[95] = false;
        Unicode.latinExtendedBUppercaseLetters[96] = true;
        Unicode.latinExtendedBUppercaseLetters[97] = false;
        Unicode.latinExtendedBUppercaseLetters[98] = true;
        Unicode.latinExtendedBUppercaseLetters[99] = false;
        Unicode.latinExtendedBUppercaseLetters[100] = true;
        Unicode.latinExtendedBUppercaseLetters[101] = false;
        Unicode.latinExtendedBUppercaseLetters[102] = true;
        Unicode.latinExtendedBUppercaseLetters[103] = false;
        Unicode.latinExtendedBUppercaseLetters[104] = true;
        Unicode.latinExtendedBUppercaseLetters[105] = false;
        Unicode.latinExtendedBUppercaseLetters[106] = true;
        Unicode.latinExtendedBUppercaseLetters[107] = false;
        Unicode.latinExtendedBUppercaseLetters[108] = true;
        Unicode.latinExtendedBUppercaseLetters[109] = false;
        Unicode.latinExtendedBUppercaseLetters[110] = true;
        Unicode.latinExtendedBUppercaseLetters[111] = false;
        Unicode.latinExtendedBUppercaseLetters[112] = false;
        Unicode.latinExtendedBUppercaseLetters[113] = true;
        Unicode.latinExtendedBUppercaseLetters[114] = false;
        Unicode.latinExtendedBUppercaseLetters[115] = false;
        Unicode.latinExtendedBUppercaseLetters[116] = true;
        Unicode.latinExtendedBUppercaseLetters[117] = false;
        Unicode.latinExtendedBUppercaseLetters[118] = true;
        Unicode.latinExtendedBUppercaseLetters[119] = true;
        Unicode.latinExtendedBUppercaseLetters[120] = true;
        Unicode.latinExtendedBUppercaseLetters[121] = false;
        Unicode.latinExtendedBUppercaseLetters[122] = true;
        Unicode.latinExtendedBUppercaseLetters[123] = false;
        Unicode.latinExtendedBUppercaseLetters[124] = true;
        Unicode.latinExtendedBUppercaseLetters[125] = false;
        Unicode.latinExtendedBUppercaseLetters[126] = true;
        Unicode.latinExtendedBUppercaseLetters[127] = false;
        mathHash = new int[16][];
        Unicode.mathHash[0] = new int[4];
        Unicode.mathHash[0][0] = 8512;
        Unicode.mathHash[0][1] = 8592;
        Unicode.mathHash[0][2] = 8608;
        Unicode.mathHash[0][3] = 8992;
        Unicode.mathHash[1] = new int[6];
        Unicode.mathHash[1][0] = 177;
        Unicode.mathHash[1][1] = 8513;
        Unicode.mathHash[1][2] = 8593;
        Unicode.mathHash[1][3] = 8993;
        Unicode.mathHash[1][4] = 9665;
        Unicode.mathHash[1][5] = 120513;
        Unicode.mathHash[0] = new int[6];
        Unicode.mathHash[2][0] = 8274;
        Unicode.mathHash[2][1] = 8514;
        Unicode.mathHash[2][2] = 8594;
        Unicode.mathHash[2][3] = 8658;
        Unicode.mathHash[2][4] = 64354;
        Unicode.mathHash[2][5] = 65506;
        Unicode.mathHash[3] = new int[4];
        Unicode.mathHash[3][0] = 8515;
        Unicode.mathHash[3][1] = 8595;
        Unicode.mathHash[3][2] = 8611;
        Unicode.mathHash[3][3] = 120771;
        Unicode.mathHash[4] = new int[5];
        Unicode.mathHash[4][0] = 8260;
        Unicode.mathHash[4][1] = 8516;
        Unicode.mathHash[4][2] = 8596;
        Unicode.mathHash[4][3] = 8660;
        Unicode.mathHash[4][4] = 64356;
        Unicode.mathHash[5] = new int[3];
        Unicode.mathHash[5][0] = 64357;
        Unicode.mathHash[5][1] = 120597;
        Unicode.mathHash[5][2] = 120629;
        Unicode.mathHash[6] = new int[3];
        Unicode.mathHash[6][0] = 64358;
        Unicode.mathHash[6][1] = 1014;
        Unicode.mathHash[6][2] = 8614;
        Unicode.mathHash[0] = new int[3];
        Unicode.mathHash[7][0] = 215;
        Unicode.mathHash[7][1] = 247;
        Unicode.mathHash[7][2] = 9655;
        Unicode.mathHash[8] = new int[2];
        Unicode.mathHash[8][0] = 8968;
        Unicode.mathHash[8][1] = 9720;
        Unicode.mathHash[9] = new int[6];
        Unicode.mathHash[9][0] = 8969;
        Unicode.mathHash[9][1] = 9721;
        Unicode.mathHash[9][2] = 64297;
        Unicode.mathHash[9][3] = 65513;
        Unicode.mathHash[9][4] = 120713;
        Unicode.mathHash[9][5] = 120745;
        Unicode.mathHash[10] = new int[6];
        Unicode.mathHash[10][0] = 8314;
        Unicode.mathHash[10][1] = 8330;
        Unicode.mathHash[10][2] = 8602;
        Unicode.mathHash[10][3] = 8970;
        Unicode.mathHash[10][4] = 9722;
        Unicode.mathHash[10][5] = 65514;
        Unicode.mathHash[11] = new int[11];
        Unicode.mathHash[11][0] = 43;
        Unicode.mathHash[11][1] = 8315;
        Unicode.mathHash[11][2] = 8331;
        Unicode.mathHash[11][3] = 8523;
        Unicode.mathHash[11][4] = 8603;
        Unicode.mathHash[11][5] = 8971;
        Unicode.mathHash[11][6] = 9723;
        Unicode.mathHash[11][7] = 65291;
        Unicode.mathHash[11][8] = 65515;
        Unicode.mathHash[11][9] = 120539;
        Unicode.mathHash[11][10] = 120571;
        Unicode.mathHash[12] = new int[10];
        Unicode.mathHash[12][0] = 60;
        Unicode.mathHash[12][1] = 124;
        Unicode.mathHash[12][2] = 172;
        Unicode.mathHash[12][3] = 8316;
        Unicode.mathHash[12][4] = 8332;
        Unicode.mathHash[12][5] = 9084;
        Unicode.mathHash[12][6] = 9724;
        Unicode.mathHash[12][7] = 65308;
        Unicode.mathHash[12][8] = 65372;
        Unicode.mathHash[12][9] = 65516;
        Unicode.mathHash[13] = new int[3];
        Unicode.mathHash[13][0] = 61;
        Unicode.mathHash[13][1] = 9725;
        Unicode.mathHash[13][2] = 65309;
        Unicode.mathHash[14] = new int[7];
        Unicode.mathHash[14][0] = 62;
        Unicode.mathHash[14][1] = 126;
        Unicode.mathHash[14][2] = 8622;
        Unicode.mathHash[14][3] = 8654;
        Unicode.mathHash[14][4] = 9726;
        Unicode.mathHash[14][5] = 65310;
        Unicode.mathHash[14][6] = 65374;
        Unicode.mathHash[15] = new int[5];
        Unicode.mathHash[15][0] = 8655;
        Unicode.mathHash[15][1] = 9727;
        Unicode.mathHash[15][2] = 9839;
        Unicode.mathHash[15][3] = 120655;
        Unicode.mathHash[15][4] = 120687;
        currencyHash = new int[16][];
        Unicode.currencyHash[0] = new int[1];
        Unicode.currencyHash[0][0] = 65504;
        Unicode.currencyHash[1] = new int[2];
        Unicode.currencyHash[1][0] = 2801;
        Unicode.currencyHash[1][1] = 65505;
        Unicode.currencyHash[0] = new int[2];
        Unicode.currencyHash[2][0] = 162;
        Unicode.currencyHash[2][1] = 2546;
        Unicode.currencyHash[3] = new int[2];
        Unicode.currencyHash[3][0] = 163;
        Unicode.currencyHash[3][1] = 2547;
        Unicode.currencyHash[4] = new int[3];
        Unicode.currencyHash[4][0] = 36;
        Unicode.currencyHash[4][1] = 164;
        Unicode.currencyHash[4][2] = 65284;
        Unicode.currencyHash[5] = new int[3];
        Unicode.currencyHash[5][0] = 165;
        Unicode.currencyHash[5][1] = 65509;
        Unicode.currencyHash[5][2] = 65510;
        Unicode.currencyHash[6] = new int[0];
        Unicode.currencyHash[0] = new int[0];
        Unicode.currencyHash[8] = new int[0];
        Unicode.currencyHash[9] = new int[2];
        Unicode.currencyHash[9][0] = 3065;
        Unicode.currencyHash[9][1] = 65129;
        Unicode.currencyHash[10] = new int[0];
        Unicode.currencyHash[11] = new int[1];
        Unicode.currencyHash[11][0] = 6107;
        Unicode.currencyHash[12] = new int[1];
        Unicode.currencyHash[12][0] = 65020;
        Unicode.currencyHash[13] = new int[0];
        Unicode.currencyHash[14] = new int[0];
        Unicode.currencyHash[15] = new int[1];
        Unicode.currencyHash[15][0] = 3647;
        modifierHash = new int[16][];
        Unicode.modifierHash[0] = new int[3];
        Unicode.modifierHash[0][0] = 96;
        Unicode.modifierHash[0][1] = 8128;
        Unicode.modifierHash[0][2] = 65344;
        Unicode.modifierHash[1] = new int[1];
        Unicode.modifierHash[1][0] = 8129;
        Unicode.modifierHash[0] = new int[1];
        Unicode.modifierHash[2][0] = 706;
        Unicode.modifierHash[3] = new int[2];
        Unicode.modifierHash[3][0] = 707;
        Unicode.modifierHash[3][1] = 65507;
        Unicode.modifierHash[4] = new int[4];
        Unicode.modifierHash[4][0] = 180;
        Unicode.modifierHash[4][1] = 708;
        Unicode.modifierHash[4][2] = 884;
        Unicode.modifierHash[4][3] = 900;
        Unicode.modifierHash[5] = new int[3];
        Unicode.modifierHash[5][0] = 709;
        Unicode.modifierHash[5][1] = 885;
        Unicode.modifierHash[5][2] = 901;
        Unicode.modifierHash[6] = new int[0];
        Unicode.modifierHash[0] = new int[0];
        Unicode.modifierHash[8] = new int[2];
        Unicode.modifierHash[8][0] = 168;
        Unicode.modifierHash[8][1] = 184;
        Unicode.modifierHash[9] = new int[0];
        Unicode.modifierHash[10] = new int[0];
        Unicode.modifierHash[11] = new int[1];
        Unicode.modifierHash[11][0] = 12443;
        Unicode.modifierHash[12] = new int[1];
        Unicode.modifierHash[12][0] = 12444;
        Unicode.modifierHash[13] = new int[5];
        Unicode.modifierHash[13][0] = 8125;
        Unicode.modifierHash[13][1] = 8141;
        Unicode.modifierHash[13][2] = 8157;
        Unicode.modifierHash[13][3] = 8173;
        Unicode.modifierHash[13][4] = 8189;
        Unicode.modifierHash[14] = new int[6];
        Unicode.modifierHash[14][0] = 110;
        Unicode.modifierHash[14][1] = 8142;
        Unicode.modifierHash[14][2] = 8158;
        Unicode.modifierHash[14][3] = 8174;
        Unicode.modifierHash[14][4] = 8190;
        Unicode.modifierHash[14][5] = 65342;
        Unicode.modifierHash[15] = new int[5];
        Unicode.modifierHash[15][0] = 175;
        Unicode.modifierHash[15][1] = 8127;
        Unicode.modifierHash[15][2] = 8143;
        Unicode.modifierHash[15][3] = 8159;
        Unicode.modifierHash[15][4] = 8175;
        formatHash = new int[16][];
        Unicode.formatHash[0] = new int[2];
        Unicode.formatHash[0][0] = 1536;
        Unicode.formatHash[0][1] = 8288;
        Unicode.formatHash[1] = new int[3];
        Unicode.formatHash[1][0] = 1537;
        Unicode.formatHash[1][1] = 8289;
        Unicode.formatHash[1][2] = 917505;
        Unicode.formatHash[2] = new int[2];
        Unicode.formatHash[2][0] = 1538;
        Unicode.formatHash[2][1] = 8290;
        Unicode.formatHash[3] = new int[3];
        Unicode.formatHash[3][0] = 1539;
        Unicode.formatHash[3][1] = 8291;
        Unicode.formatHash[3][2] = 119155;
        Unicode.formatHash[4] = new int[1];
        Unicode.formatHash[4][0] = 119156;
        Unicode.formatHash[5] = new int[2];
        Unicode.formatHash[5][0] = 6069;
        Unicode.formatHash[5][1] = 119157;
        Unicode.formatHash[6] = new int[1];
        Unicode.formatHash[6][0] = 119158;
        Unicode.formatHash[7] = new int[1];
        Unicode.formatHash[7][0] = 119159;
        Unicode.formatHash[8] = new int[1];
        Unicode.formatHash[8][0] = 119160;
        Unicode.formatHash[9] = new int[2];
        Unicode.formatHash[9][0] = 65529;
        Unicode.formatHash[9][1] = 119161;
        Unicode.formatHash[10] = new int[4];
        Unicode.formatHash[10][0] = 8234;
        Unicode.formatHash[10][1] = 8298;
        Unicode.formatHash[10][2] = 65530;
        Unicode.formatHash[10][3] = 119162;
        Unicode.formatHash[11] = new int[4];
        Unicode.formatHash[11][0] = 8203;
        Unicode.formatHash[11][1] = 8235;
        Unicode.formatHash[11][2] = 8299;
        Unicode.formatHash[11][3] = 65531;
        Unicode.formatHash[12] = new int[3];
        Unicode.formatHash[12][0] = 8204;
        Unicode.formatHash[12][1] = 8236;
        Unicode.formatHash[12][2] = 8300;
        Unicode.formatHash[13] = new int[5];
        Unicode.formatHash[13][0] = 173;
        Unicode.formatHash[13][1] = 1757;
        Unicode.formatHash[13][2] = 8205;
        Unicode.formatHash[13][3] = 8237;
        Unicode.formatHash[13][4] = 8301;
        Unicode.formatHash[14] = new int[3];
        Unicode.formatHash[14][0] = 8206;
        Unicode.formatHash[14][1] = 8238;
        Unicode.formatHash[14][2] = 8302;
        Unicode.formatHash[15] = new int[4];
        Unicode.formatHash[15][0] = 1807;
        Unicode.formatHash[15][1] = 8207;
        Unicode.formatHash[15][2] = 8303;
        Unicode.formatHash[15][3] = 65279;
        staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    }
}

