/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.dom;

import com.ibm.xml.xml4j.internal.s1.dom.AttrImpl;
import com.ibm.xml.xml4j.internal.s1.dom.AttrNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.AttributeMap;
import com.ibm.xml.xml4j.internal.s1.dom.ChildNode;
import com.ibm.xml.xml4j.internal.s1.dom.CoreDocumentImpl;
import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.dom.DeepNodeListImpl;
import com.ibm.xml.xml4j.internal.s1.dom.DocumentTypeImpl;
import com.ibm.xml.xml4j.internal.s1.dom.ElementDefinitionImpl;
import com.ibm.xml.xml4j.internal.s1.dom.NamedNodeMapImpl;
import com.ibm.xml.xml4j.internal.s1.dom.NodeImpl;
import com.ibm.xml.xml4j.internal.s1.dom.ParentNode;
import com.ibm.xml.xml4j.internal.s1.util.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
TypeInfo {
    static final long serialVersionUID = 3717253516652722278L;
    protected String name;
    protected AttributeMap attributes;

    public ElementImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.name = string2;
        this.needsSyncData(true);
    }

    protected ElementImpl() {
    }

    void rename(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string2;
        this.reconcileDefaultAttributes();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NamedNodeMap getAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes;
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        if (this.attributes != null) {
            elementImpl.attributes = (AttributeMap)this.attributes.cloneMap(elementImpl);
        }
        return elementImpl;
    }

    public String getBaseURI() {
        String string2;
        Attr attr2;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes != null && (attr2 = this.getXMLBaseAttribute()) != null && (string2 = attr2.getNodeValue()).length() != 0) {
            try {
                String string3;
                URI uRI = new URI(string2, true);
                if (uRI.isAbsoluteURI()) {
                    return uRI.toString();
                }
                String string4 = string3 = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
                if (string3 != null) {
                    try {
                        URI uRI2 = new URI(string3);
                        uRI.absolutize(uRI2);
                        return uRI.toString();
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        return null;
                    }
                }
                return null;
            }
            catch (URI.MalformedURIException malformedURIException) {
                return null;
            }
        }
        Attr attr3 = attr2 = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
        if (attr2 != null) {
            try {
                return new URI((String)((Object)attr2)).toString();
            }
            catch (URI.MalformedURIException malformedURIException) {
                return null;
            }
        }
        return null;
    }

    protected Attr getXMLBaseAttribute() {
        return (Attr)this.attributes.getNamedItem("xml:base");
    }

    protected void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        super.setOwnerDocument(coreDocumentImpl);
        if (this.attributes != null) {
            this.attributes.setOwnerDocument(coreDocumentImpl);
        }
    }

    public String getAttribute(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr2 = (Attr)this.attributes.getNamedItem(string2);
        return attr2 == null ? "" : attr2.getValue();
    }

    public Attr getAttributeNode(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string2);
    }

    public NodeList getElementsByTagName(String string2) {
        return new DeepNodeListImpl(this, string2);
    }

    public String getTagName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            ChildNode childNode2 = childNode.nextSibling;
            if (childNode.getNodeType() == 3) {
                if (childNode2 != null && childNode2.getNodeType() == 3) {
                    ((Text)((Object)childNode)).appendData(childNode2.getNodeValue());
                    this.removeChild(childNode2);
                    childNode2 = childNode;
                } else if (childNode.getNodeValue() == null || childNode.getNodeValue().length() == 0) {
                    this.removeChild(childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                childNode.normalize();
            }
            childNode = childNode2;
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                Node node2 = this.attributes.item(i);
                node2.normalize();
            }
        }
        this.isNormalized(true);
    }

    public void removeAttribute(String string2) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItem(string2);
    }

    public Attr removeAttributeNode(Attr attr2) throws DOMException {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string2);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string3);
        }
        return (Attr)this.attributes.removeItem(attr2, true);
    }

    public void setAttribute(String string2, String string3) {
        Attr attr2;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr2 = this.getAttributeNode(string2)) == null) {
            attr2 = this.getOwnerDocument().createAttribute(string2);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr2.setNodeValue(string3);
            this.attributes.setNamedItem(attr2);
        } else {
            attr2.setNodeValue(string3);
        }
    }

    public Attr setAttributeNode(Attr attr2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (attr2.getOwnerDocument() != this.ownerDocument) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItem(attr2);
    }

    public String getAttributeNS(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr2 = (Attr)this.attributes.getNamedItemNS(string2, string3);
        return attr2 == null ? "" : attr2.getValue();
    }

    public void setAttributeNS(String string2, String string3, String string4) {
        String string5;
        String string6;
        int n2;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string7);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((n2 = string3.indexOf(58)) < 0) {
            string6 = null;
            string5 = string3;
        } else {
            string6 = string3.substring(0, n2);
            string5 = string3.substring(n2 + 1);
        }
        Attr attr2 = this.getAttributeNodeNS(string2, string5);
        if (attr2 == null) {
            attr2 = this.getOwnerDocument().createAttributeNS(string2, string3);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr2.setNodeValue(string4);
            this.attributes.setNamedItemNS(attr2);
        } else {
            if (attr2 instanceof AttrNSImpl) {
                ((AttrNSImpl)attr2).name = string6 != null ? string6 + ":" + string5 : string5;
            } else {
                attr2 = new AttrNSImpl((CoreDocumentImpl)this.getOwnerDocument(), string2, string3, string5);
                this.attributes.setNamedItemNS(attr2);
            }
            attr2.setNodeValue(string4);
        }
    }

    public void removeAttributeNS(String string2, String string3) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItemNS(string2, string3);
    }

    public Attr getAttributeNodeNS(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string2, string3);
    }

    public Attr setAttributeNodeNS(Attr attr2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (attr2.getOwnerDocument() != this.ownerDocument) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItemNS(attr2);
    }

    protected int setXercesAttributeNode(Attr attr2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes.addItem(attr2);
    }

    protected int getXercesAttribute(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return -1;
        }
        return this.attributes.getNamedItemIndex(string2, string3);
    }

    public boolean hasAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public boolean hasAttribute(String string2) {
        return this.getAttributeNode(string2) != null;
    }

    public boolean hasAttributeNS(String string2, String string3) {
        return this.getAttributeNodeNS(string2, string3) != null;
    }

    public NodeList getElementsByTagNameNS(String string2, String string3) {
        return new DeepNodeListImpl(this, string2, string3);
    }

    public boolean isEqualNode(Node node2) {
        if (!super.isEqualNode(node2)) {
            return false;
        }
        boolean bl = this.hasAttributes();
        if (bl != ((Element)node2).hasAttributes()) {
            return false;
        }
        if (bl) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            NamedNodeMap namedNodeMap2 = ((Element)node2).getAttributes();
            int n2 = namedNodeMap.getLength();
            if (n2 != namedNodeMap2.getLength()) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                Node node3;
                Node node4 = namedNodeMap.item(i);
                if (!(node4.getLocalName() == null ? (node3 = namedNodeMap2.getNamedItem(node4.getNodeName())) == null || !((NodeImpl)node4).isEqualNode(node3) : (node3 = namedNodeMap2.getNamedItemNS(node4.getNamespaceURI(), node4.getLocalName())) == null || !((NodeImpl)node4).isEqualNode(node3))) continue;
                return false;
            }
        }
        return true;
    }

    public void setIdAttributeNode(Attr attr2, boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (attr2.getOwnerElement() != this) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string3);
            }
        }
        ((AttrImpl)attr2).isIdAttribute(bl);
        if (!bl) {
            this.ownerDocument.removeIdentifier(attr2.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr2.getValue(), this);
        }
    }

    public void setIdAttribute(String string2, boolean bl) {
        Attr attr2;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr2 = this.getAttributeNode(string2)) == null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string3);
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string4);
            }
            if (attr2.getOwnerElement() != this) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string5);
            }
        }
        ((AttrImpl)attr2).isIdAttribute(bl);
        if (!bl) {
            this.ownerDocument.removeIdentifier(attr2.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr2.getValue(), this);
        }
    }

    public void setIdAttributeNS(String string2, String string3, boolean bl) {
        Attr attr2;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr2 = this.getAttributeNodeNS(string2, string3)) == null) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string4);
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string5);
            }
            if (attr2.getOwnerElement() != this) {
                String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string6);
            }
        }
        ((AttrImpl)attr2).isIdAttribute(bl);
        if (!bl) {
            this.ownerDocument.removeIdentifier(attr2.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr2.getValue(), this);
        }
    }

    public String getTypeName() {
        return null;
    }

    public String getTypeNamespace() {
        return null;
    }

    public boolean isDerivedFrom(String string2, String string3, int n2) {
        return false;
    }

    public TypeInfo getSchemaTypeInfo() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (this.attributes != null) {
            this.attributes.setReadOnly(bl, true);
        }
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        boolean bl = this.ownerDocument.getMutationEvents();
        this.ownerDocument.setMutationEvents(false);
        this.setupDefaultAttributes();
        this.ownerDocument.setMutationEvents(bl);
    }

    void moveSpecifiedAttributes(ElementImpl elementImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (elementImpl.hasAttributes()) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            this.attributes.moveSpecifiedAttributes(elementImpl.attributes);
        }
    }

    protected void setupDefaultAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
        if (namedNodeMapImpl != null) {
            this.attributes = new AttributeMap(this, namedNodeMapImpl);
        }
    }

    protected void reconcileDefaultAttributes() {
        if (this.attributes != null) {
            NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
            this.attributes.reconcileDefaults(namedNodeMapImpl);
        }
    }

    protected NamedNodeMapImpl getDefaultAttributes() {
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (documentTypeImpl == null) {
            return null;
        }
        ElementDefinitionImpl elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName());
        if (elementDefinitionImpl == null) {
            return null;
        }
        return (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
    }

    public final int getChildElementCount() {
        int n2 = 0;
        Element element2 = this.getFirstElementChild();
        while (element2 != null) {
            ++n2;
            element2 = ((ElementImpl)element2).getNextElementSibling();
        }
        return n2;
    }

    public final Element getFirstElementChild() {
        block4: for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    return (Element)node2;
                }
                case 5: {
                    Element element2 = this.getFirstElementChild(node2);
                    if (element2 == null) continue block4;
                    return element2;
                }
            }
        }
        return null;
    }

    public final Element getLastElementChild() {
        block4: for (Node node2 = this.getLastChild(); node2 != null; node2 = node2.getPreviousSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    return (Element)node2;
                }
                case 5: {
                    Element element2 = this.getLastElementChild(node2);
                    if (element2 == null) continue block4;
                    return element2;
                }
            }
        }
        return null;
    }

    public final Element getNextElementSibling() {
        Node node2 = this.getNextLogicalSibling(this);
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 1: {
                    return (Element)node2;
                }
                case 5: {
                    Element element2 = this.getFirstElementChild(node2);
                    if (element2 == null) break;
                    return element2;
                }
            }
            node2 = this.getNextLogicalSibling(node2);
        }
        return null;
    }

    public final Element getPreviousElementSibling() {
        Node node2 = this.getPreviousLogicalSibling(this);
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 1: {
                    return (Element)node2;
                }
                case 5: {
                    Element element2 = this.getLastElementChild(node2);
                    if (element2 == null) break;
                    return element2;
                }
            }
            node2 = this.getPreviousLogicalSibling(node2);
        }
        return null;
    }

    private Element getFirstElementChild(Node node2) {
        Node node3 = node2;
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                return (Element)node2;
            }
            Node node4 = node2.getFirstChild();
            while (node4 == null && node3 != node2) {
                node4 = node2.getNextSibling();
                if (node4 != null || (node2 = node2.getParentNode()) != null && node3 != node2) continue;
                return null;
            }
            node2 = node4;
        }
        return null;
    }

    private Element getLastElementChild(Node node2) {
        Node node3 = node2;
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                return (Element)node2;
            }
            Node node4 = node2.getLastChild();
            while (node4 == null && node3 != node2) {
                node4 = node2.getPreviousSibling();
                if (node4 != null || (node2 = node2.getParentNode()) != null && node3 != node2) continue;
                return null;
            }
            node2 = node4;
        }
        return null;
    }

    private Node getNextLogicalSibling(Node node2) {
        Node node3 = node2.getNextSibling();
        if (node3 == null) {
            for (Node node4 = node2.getParentNode(); node4 != null && node4.getNodeType() == 5 && (node3 = node4.getNextSibling()) == null; node4 = node4.getParentNode()) {
            }
        }
        return node3;
    }

    private Node getPreviousLogicalSibling(Node node2) {
        Node node3 = node2.getPreviousSibling();
        if (node3 == null) {
            for (Node node4 = node2.getParentNode(); node4 != null && node4.getNodeType() == 5 && (node3 = node4.getPreviousSibling()) == null; node4 = node4.getParentNode()) {
            }
        }
        return node3;
    }
}

