/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.dom;

import com.ibm.xml.xml4j.internal.s1.dom.CoreDocumentImpl;
import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.dom.NodeImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short CHANGED = 2;
    protected static final short HASDEFAULTS = 4;
    protected List nodes;
    protected NodeImpl ownerNode;

    protected NamedNodeMapImpl(NodeImpl nodeImpl) {
        this.ownerNode = nodeImpl;
    }

    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node item(int n2) {
        return this.nodes != null && n2 < this.nodes.size() ? (Node)this.nodes.get(n2) : null;
    }

    public Node getNamedItem(String string2) {
        int n2 = this.findNamePoint(string2, 0);
        return n2 < 0 ? null : (Node)this.nodes.get(n2);
    }

    public Node getNamedItemNS(String string2, String string3) {
        int n2 = this.findNamePoint(string2, string3);
        return n2 < 0 ? null : (Node)this.nodes.get(n2);
    }

    public Node setNamedItem(Node node2) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        if (coreDocumentImpl.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (node2.getOwnerDocument() != coreDocumentImpl) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
        }
        int n2 = this.findNamePoint(node2.getNodeName(), 0);
        NodeImpl nodeImpl = null;
        if (n2 >= 0) {
            nodeImpl = (NodeImpl)this.nodes.get(n2);
            this.nodes.set(n2, node2);
        } else {
            n2 = -1 - n2;
            if (null == this.nodes) {
                this.nodes = new ArrayList(5);
            }
            this.nodes.add(n2, node2);
        }
        return nodeImpl;
    }

    public Node setNamedItemNS(Node node2) throws DOMException {
        CoreDocumentImpl coreDocumentImpl = this.ownerNode.ownerDocument();
        if (coreDocumentImpl.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (node2.getOwnerDocument() != coreDocumentImpl) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
        }
        int n2 = this.findNamePoint(node2.getNamespaceURI(), node2.getLocalName());
        NodeImpl nodeImpl = null;
        if (n2 >= 0) {
            nodeImpl = (NodeImpl)this.nodes.get(n2);
            this.nodes.set(n2, node2);
        } else {
            n2 = this.findNamePoint(node2.getNodeName(), 0);
            if (n2 >= 0) {
                nodeImpl = (NodeImpl)this.nodes.get(n2);
                this.nodes.add(n2, node2);
            } else {
                n2 = -1 - n2;
                if (null == this.nodes) {
                    this.nodes = new ArrayList(5);
                }
                this.nodes.add(n2, node2);
            }
        }
        return nodeImpl;
    }

    public Node removeNamedItem(String string2) throws DOMException {
        if (this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        int n2 = this.findNamePoint(string2, 0);
        if (n2 < 0) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string4);
        }
        NodeImpl nodeImpl = (NodeImpl)this.nodes.get(n2);
        this.nodes.remove(n2);
        return nodeImpl;
    }

    public Node removeNamedItemNS(String string2, String string3) throws DOMException {
        if (this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        int n2 = this.findNamePoint(string2, string3);
        if (n2 < 0) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string5);
        }
        NodeImpl nodeImpl = (NodeImpl)this.nodes.get(n2);
        this.nodes.remove(n2);
        return nodeImpl;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl nodeImpl) {
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(nodeImpl);
        namedNodeMapImpl.cloneContent(this);
        return namedNodeMapImpl;
    }

    protected void cloneContent(NamedNodeMapImpl namedNodeMapImpl) {
        int n2;
        List list = namedNodeMapImpl.nodes;
        if (list != null && (n2 = list.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new ArrayList(n2);
            } else {
                this.nodes.clear();
            }
            for (int i = 0; i < n2; ++i) {
                NodeImpl nodeImpl = (NodeImpl)namedNodeMapImpl.nodes.get(i);
                NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.cloneNode(true);
                nodeImpl2.isSpecified(nodeImpl.isSpecified());
                this.nodes.add(nodeImpl2);
            }
        }
    }

    void setReadOnly(boolean bl, boolean bl2) {
        this.isReadOnly(bl);
        if (bl2 && this.nodes != null) {
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                ((NodeImpl)this.nodes.get(i)).setReadOnly(bl, bl2);
            }
        }
    }

    boolean getReadOnly() {
        return this.isReadOnly();
    }

    protected void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        if (this.nodes != null) {
            int n2 = this.nodes.size();
            for (int i = 0; i < n2; ++i) {
                ((NodeImpl)this.item(i)).setOwnerDocument(coreDocumentImpl);
            }
        }
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean bl) {
        this.flags = (short)(bl ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    final boolean changed() {
        return (this.flags & 2) != 0;
    }

    final void changed(boolean bl) {
        this.flags = (short)(bl ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean hasDefaults() {
        return (this.flags & 4) != 0;
    }

    final void hasDefaults(boolean bl) {
        this.flags = (short)(bl ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    protected int findNamePoint(String string2, int n2) {
        int n3 = 0;
        if (this.nodes != null) {
            int n4 = n2;
            int n5 = this.nodes.size() - 1;
            while (n4 <= n5) {
                n3 = (n4 + n5) / 2;
                int n6 = string2.compareTo(((Node)this.nodes.get(n3)).getNodeName());
                if (n6 == 0) {
                    return n3;
                }
                if (n6 < 0) {
                    n5 = n3 - 1;
                    continue;
                }
                n4 = n3 + 1;
            }
            if (n4 > n3) {
                n3 = n4;
            }
        }
        return -1 - n3;
    }

    protected int findNamePoint(String string2, String string3) {
        if (this.nodes == null) {
            return -1;
        }
        if (string3 == null) {
            return -1;
        }
        int n2 = this.nodes.size();
        for (int i = 0; i < n2; ++i) {
            NodeImpl nodeImpl = (NodeImpl)this.nodes.get(i);
            String string4 = nodeImpl.getNamespaceURI();
            String string5 = nodeImpl.getLocalName();
            if (!(string2 == null ? string4 == null && (string3.equals(string5) || string5 == null && string3.equals(nodeImpl.getNodeName())) : string2.equals(string4) && string3.equals(string5))) continue;
            return i;
        }
        return -1;
    }

    protected boolean precedes(Node node2, Node node3) {
        if (this.nodes != null) {
            int n2 = this.nodes.size();
            for (int i = 0; i < n2; ++i) {
                Node node4 = (Node)this.nodes.get(i);
                if (node4 == node2) {
                    return true;
                }
                if (node4 != node3) continue;
                return false;
            }
        }
        return false;
    }

    protected void removeItem(int n2) {
        if (this.nodes != null && n2 < this.nodes.size()) {
            this.nodes.remove(n2);
        }
    }

    protected Object getItem(int n2) {
        if (this.nodes != null) {
            return this.nodes.get(n2);
        }
        return null;
    }

    protected int addItem(Node node2) {
        int n2 = this.findNamePoint(node2.getNamespaceURI(), node2.getLocalName());
        if (n2 >= 0) {
            this.nodes.set(n2, node2);
        } else {
            n2 = this.findNamePoint(node2.getNodeName(), 0);
            if (n2 >= 0) {
                this.nodes.add(n2, node2);
            } else {
                n2 = -1 - n2;
                if (null == this.nodes) {
                    this.nodes = new ArrayList(5);
                }
                this.nodes.add(n2, node2);
            }
        }
        return n2;
    }

    protected ArrayList cloneMap(ArrayList arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList(5);
        }
        arrayList.clear();
        if (this.nodes != null) {
            int n2 = this.nodes.size();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(this.nodes.get(i));
            }
        }
        return arrayList;
    }

    protected int getNamedItemIndex(String string2, String string3) {
        return this.findNamePoint(string2, string3);
    }

    public void removeAll() {
        if (this.nodes != null) {
            this.nodes.clear();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.nodes != null) {
            this.nodes = new ArrayList(this.nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        List list = this.nodes;
        try {
            if (list != null) {
                this.nodes = new Vector(list);
            }
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.nodes = list;
        }
    }
}

