/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.dom;

import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    private DocumentImpl fDocument;
    private Node fRoot;
    private int fWhatToShow = -1;
    private NodeFilter fNodeFilter;
    private boolean fDetach = false;
    private Node fCurrentNode;
    private boolean fForward = true;
    private boolean fEntityReferenceExpansion;

    public NodeIteratorImpl(DocumentImpl documentImpl, Node node2, int n2, NodeFilter nodeFilter, boolean bl) {
        this.fDocument = documentImpl;
        this.fRoot = node2;
        this.fCurrentNode = null;
        this.fWhatToShow = n2;
        this.fNodeFilter = nodeFilter;
        this.fEntityReferenceExpansion = bl;
    }

    public Node getRoot() {
        return this.fRoot;
    }

    public int getWhatToShow() {
        return this.fWhatToShow;
    }

    public NodeFilter getFilter() {
        return this.fNodeFilter;
    }

    public boolean getExpandEntityReferences() {
        return this.fEntityReferenceExpansion;
    }

    public Node nextNode() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fRoot == null) {
            return null;
        }
        Node node2 = this.fCurrentNode;
        boolean bl = false;
        while (!bl) {
            node2 = !this.fForward && node2 != null ? this.fCurrentNode : (!this.fEntityReferenceExpansion && node2 != null && node2.getNodeType() == 5 ? this.nextNode(node2, false) : this.nextNode(node2, true));
            this.fForward = true;
            if (node2 == null) {
                return null;
            }
            bl = this.acceptNode(node2);
            if (!bl) continue;
            this.fCurrentNode = node2;
            return this.fCurrentNode;
        }
        return null;
    }

    public Node previousNode() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fRoot == null || this.fCurrentNode == null) {
            return null;
        }
        Node node2 = this.fCurrentNode;
        boolean bl = false;
        while (!bl) {
            node2 = this.fForward && node2 != null ? this.fCurrentNode : this.previousNode(node2);
            this.fForward = false;
            if (node2 == null) {
                return null;
            }
            bl = this.acceptNode(node2);
            if (!bl) continue;
            this.fCurrentNode = node2;
            return this.fCurrentNode;
        }
        return null;
    }

    boolean acceptNode(Node node2) {
        if (this.fNodeFilter == null) {
            return (this.fWhatToShow & 1 << node2.getNodeType() - 1) != 0;
        }
        return (this.fWhatToShow & 1 << node2.getNodeType() - 1) != 0 && this.fNodeFilter.acceptNode(node2) == 1;
    }

    Node matchNodeOrParent(Node node2) {
        if (this.fCurrentNode == null) {
            return null;
        }
        for (Node node3 = this.fCurrentNode; node3 != this.fRoot; node3 = node3.getParentNode()) {
            if (node2 != node3) continue;
            return node3;
        }
        return null;
    }

    Node nextNode(Node node2, boolean bl) {
        if (node2 == null) {
            return this.fRoot;
        }
        if (bl && node2.hasChildNodes()) {
            Node node3 = node2.getFirstChild();
            return node3;
        }
        if (node2 == this.fRoot) {
            return null;
        }
        Node node4 = node2.getNextSibling();
        if (node4 != null) {
            return node4;
        }
        for (Node node5 = node2.getParentNode(); node5 != null && node5 != this.fRoot; node5 = node5.getParentNode()) {
            node4 = node5.getNextSibling();
            if (node4 == null) continue;
            return node4;
        }
        return null;
    }

    Node previousNode(Node node2) {
        if (node2 == this.fRoot) {
            return null;
        }
        Node node3 = node2.getPreviousSibling();
        if (node3 == null) {
            node3 = node2.getParentNode();
            return node3;
        }
        if (node3.hasChildNodes() && (this.fEntityReferenceExpansion || node3 == null || node3.getNodeType() != 5)) {
            while (node3.hasChildNodes()) {
                node3 = node3.getLastChild();
            }
        }
        return node3;
    }

    public void removeNode(Node node2) {
        if (node2 == null) {
            return;
        }
        Node node3 = this.matchNodeOrParent(node2);
        if (node3 == null) {
            return;
        }
        if (this.fForward) {
            this.fCurrentNode = this.previousNode(node3);
        } else {
            Node node4 = this.nextNode(node3, false);
            if (node4 != null) {
                this.fCurrentNode = node4;
            } else {
                this.fCurrentNode = this.previousNode(node3);
                this.fForward = true;
            }
        }
    }

    public void detach() {
        this.fDetach = true;
        this.fDocument.removeNodeIterator(this);
    }
}

