/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.dom;

import com.ibm.xml.xml4j.internal.s1.dom.CharacterDataImpl;
import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.dom.DocumentImpl;
import com.ibm.xml.xml4j.internal.s1.dom.RangeExceptionImpl;
import com.ibm.xml.xml4j.internal.s1.dom.TextImpl;
import java.util.ArrayList;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class RangeImpl
implements Range {
    private DocumentImpl fDocument;
    private Node fStartContainer;
    private Node fEndContainer;
    private int fStartOffset;
    private int fEndOffset;
    private boolean fDetach = false;
    private Node fInsertNode = null;
    private Node fDeleteNode = null;
    private Node fSplitNode = null;
    private boolean fInsertedFromRange = false;
    private Node fRemoveChild = null;
    static final int EXTRACT_CONTENTS = 1;
    static final int CLONE_CONTENTS = 2;
    static final int DELETE_CONTENTS = 3;

    public RangeImpl(DocumentImpl documentImpl) {
        this.fDocument = documentImpl;
        this.fStartContainer = documentImpl;
        this.fEndContainer = documentImpl;
        this.fStartOffset = 0;
        this.fEndOffset = 0;
        this.fDetach = false;
    }

    public Node getStartContainer() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fStartContainer;
    }

    public int getStartOffset() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fStartOffset;
    }

    public Node getEndContainer() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fEndContainer;
    }

    public int getEndOffset() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fEndOffset;
    }

    public boolean getCollapsed() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fStartContainer == this.fEndContainer && this.fStartOffset == this.fEndOffset;
    }

    public Node getCommonAncestorContainer() {
        Node node2;
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (node2 = this.fStartContainer; node2 != null; node2 = node2.getParentNode()) {
            arrayList.add(node2);
        }
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        for (node2 = this.fEndContainer; node2 != null; node2 = node2.getParentNode()) {
            arrayList2.add(node2);
        }
        int n2 = arrayList.size() - 1;
        Object var6_6 = null;
        for (int i = arrayList2.size() - 1; n2 >= 0 && i >= 0 && arrayList.get(n2) == arrayList2.get(i); --n2, --i) {
            var6_6 = arrayList.get(n2);
        }
        return var6_6;
    }

    public void setStart(Node node2, int n2) throws RangeException, DOMException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.isLegalContainer(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.checkIndex(node2, n2);
        this.fStartContainer = node2;
        this.fStartOffset = n2;
        if (this.getCommonAncestorContainer() == null || this.fStartContainer == this.fEndContainer && this.fEndOffset < this.fStartOffset) {
            this.collapse(true);
        }
    }

    public void setEnd(Node node2, int n2) throws RangeException, DOMException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.isLegalContainer(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.checkIndex(node2, n2);
        this.fEndContainer = node2;
        this.fEndOffset = n2;
        if (this.getCommonAncestorContainer() == null || this.fStartContainer == this.fEndContainer && this.fEndOffset < this.fStartOffset) {
            this.collapse(false);
        }
    }

    public void setStartBefore(Node node2) throws RangeException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.hasLegalRootContainer(node2) || !this.isLegalContainedNode(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.fStartContainer = node2.getParentNode();
        int n2 = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getPreviousSibling()) {
            ++n2;
        }
        this.fStartOffset = n2 - 1;
        if (this.getCommonAncestorContainer() == null || this.fStartContainer == this.fEndContainer && this.fEndOffset < this.fStartOffset) {
            this.collapse(true);
        }
    }

    public void setStartAfter(Node node2) throws RangeException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.hasLegalRootContainer(node2) || !this.isLegalContainedNode(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.fStartContainer = node2.getParentNode();
        int n2 = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getPreviousSibling()) {
            ++n2;
        }
        this.fStartOffset = n2;
        if (this.getCommonAncestorContainer() == null || this.fStartContainer == this.fEndContainer && this.fEndOffset < this.fStartOffset) {
            this.collapse(true);
        }
    }

    public void setEndBefore(Node node2) throws RangeException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.hasLegalRootContainer(node2) || !this.isLegalContainedNode(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.fEndContainer = node2.getParentNode();
        int n2 = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getPreviousSibling()) {
            ++n2;
        }
        this.fEndOffset = n2 - 1;
        if (this.getCommonAncestorContainer() == null || this.fStartContainer == this.fEndContainer && this.fEndOffset < this.fStartOffset) {
            this.collapse(false);
        }
    }

    public void setEndAfter(Node node2) throws RangeException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.hasLegalRootContainer(node2) || !this.isLegalContainedNode(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.fEndContainer = node2.getParentNode();
        int n2 = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getPreviousSibling()) {
            ++n2;
        }
        this.fEndOffset = n2;
        if (this.getCommonAncestorContainer() == null || this.fStartContainer == this.fEndContainer && this.fEndOffset < this.fStartOffset) {
            this.collapse(false);
        }
    }

    public void collapse(boolean bl) {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (bl) {
            this.fEndContainer = this.fStartContainer;
            this.fEndOffset = this.fStartOffset;
        } else {
            this.fStartContainer = this.fEndContainer;
            this.fStartOffset = this.fEndOffset;
        }
    }

    public void selectNode(Node node2) throws RangeException {
        Node node3;
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.isLegalContainer(node2.getParentNode()) || !this.isLegalContainedNode(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        if ((node3 = node2.getParentNode()) != null) {
            this.fStartContainer = node3;
            this.fEndContainer = node3;
            int n2 = 0;
            for (Node node4 = node2; node4 != null; node4 = node4.getPreviousSibling()) {
                ++n2;
            }
            this.fStartOffset = n2 - 1;
            this.fEndOffset = this.fStartOffset + 1;
        }
    }

    public void selectNodeContents(Node node2) throws RangeException {
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (!this.isLegalContainer(node2)) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument() && this.fDocument != node2) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        this.fStartContainer = node2;
        this.fEndContainer = node2;
        Node node3 = node2.getFirstChild();
        this.fStartOffset = 0;
        if (node3 == null) {
            this.fEndOffset = 0;
        } else {
            int n2 = 0;
            for (Node node4 = node3; node4 != null; node4 = node4.getNextSibling()) {
                ++n2;
            }
            this.fEndOffset = n2;
        }
    }

    public short compareBoundaryPoints(short s, Range range) throws DOMException {
        Node node2;
        int n2;
        int n3;
        Node node3;
        Node node4;
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (this.fDocument != range.getStartContainer().getOwnerDocument() && this.fDocument != range.getStartContainer() && range.getStartContainer() != null || this.fDocument != range.getEndContainer().getOwnerDocument() && this.fDocument != range.getEndContainer() && range.getStartContainer() != null) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
        }
        if (s == 0) {
            node4 = range.getStartContainer();
            node3 = this.fStartContainer;
            n3 = range.getStartOffset();
            n2 = this.fStartOffset;
        } else if (s == 1) {
            node4 = range.getStartContainer();
            node3 = this.fEndContainer;
            n3 = range.getStartOffset();
            n2 = this.fEndOffset;
        } else if (s == 3) {
            node4 = range.getEndContainer();
            node3 = this.fStartContainer;
            n3 = range.getEndOffset();
            n2 = this.fStartOffset;
        } else {
            node4 = range.getEndContainer();
            node3 = this.fEndContainer;
            n3 = range.getEndOffset();
            n2 = this.fEndOffset;
        }
        if (node4 == node3) {
            if (n3 < n2) {
                return 1;
            }
            if (n3 == n2) {
                return 0;
            }
            return -1;
        }
        Node node5 = node3;
        for (node2 = node5.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2 == node4) {
                int n4 = this.indexOf(node5, node4);
                if (n3 <= n4) {
                    return 1;
                }
                return -1;
            }
            node5 = node2;
        }
        node5 = node4;
        for (node2 = node5.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2 == node3) {
                int n5 = this.indexOf(node5, node3);
                if (n5 < n2) {
                    return 1;
                }
                return -1;
            }
            node5 = node2;
        }
        int n6 = 0;
        for (node2 = node4; node2 != null; node2 = node2.getParentNode()) {
            ++n6;
        }
        for (node2 = node3; node2 != null; node2 = node2.getParentNode()) {
            --n6;
        }
        while (n6 > 0) {
            node4 = node4.getParentNode();
            --n6;
        }
        while (n6 < 0) {
            node3 = node3.getParentNode();
            ++n6;
        }
        node2 = node4.getParentNode();
        for (Node node6 = node3.getParentNode(); node2 != node6; node2 = node2.getParentNode(), node6 = node6.getParentNode()) {
            node4 = node2;
            node3 = node6;
        }
        for (node2 = node4.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 != node3) continue;
            return 1;
        }
        return -1;
    }

    public void deleteContents() throws DOMException {
        this.traverseContents(3);
    }

    public DocumentFragment extractContents() throws DOMException {
        return this.traverseContents(1);
    }

    public DocumentFragment cloneContents() throws DOMException {
        return this.traverseContents(2);
    }

    public void insertNode(Node node2) throws DOMException, RangeException {
        if (node2 == null) {
            return;
        }
        short s = node2.getNodeType();
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (this.fDocument != node2.getOwnerDocument()) {
                throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
            }
            if (s == 2 || s == 6 || s == 12 || s == 9) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
        }
        int n2 = 0;
        this.fInsertedFromRange = true;
        if (this.fStartContainer.getNodeType() == 3) {
            Node node3 = this.fStartContainer.getParentNode();
            n2 = node3.getChildNodes().getLength();
            Node node4 = this.fStartContainer.cloneNode(false);
            ((TextImpl)node4).setNodeValueInternal(node4.getNodeValue().substring(this.fStartOffset));
            ((TextImpl)this.fStartContainer).setNodeValueInternal(this.fStartContainer.getNodeValue().substring(0, this.fStartOffset));
            Node node5 = this.fStartContainer.getNextSibling();
            if (node5 != null) {
                if (node3 != null) {
                    node3.insertBefore(node2, node5);
                    node3.insertBefore(node4, node5);
                }
            } else if (node3 != null) {
                node3.appendChild(node2);
                node3.appendChild(node4);
            }
            if (this.fEndContainer == this.fStartContainer) {
                this.fEndContainer = node4;
                this.fEndOffset -= this.fStartOffset;
            } else if (this.fEndContainer == node3) {
                this.fEndOffset += node3.getChildNodes().getLength() - n2;
            }
            this.signalSplitData(this.fStartContainer, node4, this.fStartOffset);
        } else {
            if (this.fEndContainer == this.fStartContainer) {
                n2 = this.fEndContainer.getChildNodes().getLength();
            }
            Node node6 = this.fStartContainer.getFirstChild();
            int n3 = 0;
            for (n3 = 0; n3 < this.fStartOffset && node6 != null; node6 = node6.getNextSibling(), ++n3) {
            }
            if (node6 != null) {
                this.fStartContainer.insertBefore(node2, node6);
            } else {
                this.fStartContainer.appendChild(node2);
            }
            if (this.fEndContainer == this.fStartContainer && this.fEndOffset != 0) {
                this.fEndOffset += this.fEndContainer.getChildNodes().getLength() - n2;
            }
        }
        this.fInsertedFromRange = false;
    }

    public void surroundContents(Node node2) throws DOMException, RangeException {
        if (node2 == null) {
            return;
        }
        short s = node2.getNodeType();
        if (this.fDocument.errorChecking) {
            if (this.fDetach) {
                throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
            }
            if (s == 2 || s == 6 || s == 12 || s == 10 || s == 9 || s == 11) {
                throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
            }
        }
        Node node3 = this.fStartContainer;
        Node node4 = this.fEndContainer;
        if (this.fStartContainer.getNodeType() == 3) {
            node3 = this.fStartContainer.getParentNode();
        }
        if (this.fEndContainer.getNodeType() == 3) {
            node4 = this.fEndContainer.getParentNode();
        }
        if (node3 != node4) {
            throw new RangeExceptionImpl(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "BAD_BOUNDARYPOINTS_ERR", null));
        }
        DocumentFragment documentFragment = this.extractContents();
        this.insertNode(node2);
        node2.appendChild(documentFragment);
        this.selectNode(node2);
    }

    public Range cloneRange() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        Range range = this.fDocument.createRange();
        range.setStart(this.fStartContainer, this.fStartOffset);
        range.setEnd(this.fEndContainer, this.fEndOffset);
        return range;
    }

    public String toString() {
        int n2;
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        Node node2 = this.fStartContainer;
        Node node3 = this.fEndContainer;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fStartContainer.getNodeType() == 3 || this.fStartContainer.getNodeType() == 4) {
            if (this.fStartContainer == this.fEndContainer) {
                stringBuffer.append(this.fStartContainer.getNodeValue().substring(this.fStartOffset, this.fEndOffset));
                return stringBuffer.toString();
            }
            stringBuffer.append(this.fStartContainer.getNodeValue().substring(this.fStartOffset));
            node2 = this.nextNode(node2, true);
        } else {
            node2 = node2.getFirstChild();
            if (this.fStartOffset > 0) {
                for (n2 = 0; n2 < this.fStartOffset && node2 != null; node2 = node2.getNextSibling(), ++n2) {
                }
            }
            if (node2 == null) {
                node2 = this.nextNode(this.fStartContainer, false);
            }
        }
        if (this.fEndContainer.getNodeType() != 3 && this.fEndContainer.getNodeType() != 4) {
            n2 = this.fEndOffset;
            for (node3 = this.fEndContainer.getFirstChild(); n2 > 0 && node3 != null; --n2, node3 = node3.getNextSibling()) {
            }
            if (node3 == null) {
                node3 = this.nextNode(this.fEndContainer, false);
            }
        }
        while (node2 != node3 && node2 != null) {
            if (node2.getNodeType() == 3 || node2.getNodeType() == 4) {
                stringBuffer.append(node2.getNodeValue());
            }
            node2 = this.nextNode(node2, true);
        }
        if (this.fEndContainer.getNodeType() == 3 || this.fEndContainer.getNodeType() == 4) {
            stringBuffer.append(this.fEndContainer.getNodeValue().substring(0, this.fEndOffset));
        }
        return stringBuffer.toString();
    }

    public void detach() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        this.fDetach = true;
        this.fDocument.removeRange(this);
    }

    void signalSplitData(Node node2, Node node3, int n2) {
        this.fSplitNode = node2;
        this.fDocument.splitData(node2, node3, n2);
        this.fSplitNode = null;
    }

    void receiveSplitData(Node node2, Node node3, int n2) {
        if (node2 == null || node3 == null) {
            return;
        }
        if (this.fSplitNode == node2) {
            return;
        }
        if (node2 == this.fStartContainer && this.fStartContainer.getNodeType() == 3 && this.fStartOffset > n2) {
            this.fStartOffset -= n2;
            this.fStartContainer = node3;
        }
        if (node2 == this.fEndContainer && this.fEndContainer.getNodeType() == 3 && this.fEndOffset > n2) {
            this.fEndOffset -= n2;
            this.fEndContainer = node3;
        }
    }

    void deleteData(CharacterData characterData, int n2, int n3) {
        this.fDeleteNode = characterData;
        characterData.deleteData(n2, n3);
        this.fDeleteNode = null;
    }

    void receiveDeletedText(CharacterDataImpl characterDataImpl, int n2, int n3) {
        if (characterDataImpl == null) {
            return;
        }
        if (this.fDeleteNode == characterDataImpl) {
            return;
        }
        if (characterDataImpl == this.fStartContainer) {
            if (this.fStartOffset > n2 + n3) {
                this.fStartOffset = n2 + (this.fStartOffset - (n2 + n3));
            } else if (this.fStartOffset > n2) {
                this.fStartOffset = n2;
            }
        }
        if (characterDataImpl == this.fEndContainer) {
            if (this.fEndOffset > n2 + n3) {
                this.fEndOffset = n2 + (this.fEndOffset - (n2 + n3));
            } else if (this.fEndOffset > n2) {
                this.fEndOffset = n2;
            }
        }
    }

    void insertData(CharacterData characterData, int n2, String string2) {
        this.fInsertNode = characterData;
        characterData.insertData(n2, string2);
        this.fInsertNode = null;
    }

    void receiveInsertedText(CharacterDataImpl characterDataImpl, int n2, int n3) {
        if (characterDataImpl == null) {
            return;
        }
        if (this.fInsertNode == characterDataImpl) {
            return;
        }
        if (characterDataImpl == this.fStartContainer && n2 < this.fStartOffset) {
            this.fStartOffset += n3;
        }
        if (characterDataImpl == this.fEndContainer && n2 < this.fEndOffset) {
            this.fEndOffset += n3;
        }
    }

    void receiveReplacedText(CharacterDataImpl characterDataImpl) {
        if (characterDataImpl == null) {
            return;
        }
        if (characterDataImpl == this.fStartContainer) {
            this.fStartOffset = 0;
        }
        if (characterDataImpl == this.fEndContainer) {
            this.fEndOffset = 0;
        }
    }

    public void insertedNodeFromDOM(Node node2) {
        int n2;
        if (node2 == null) {
            return;
        }
        if (this.fInsertNode == node2) {
            return;
        }
        if (this.fInsertedFromRange) {
            return;
        }
        Node node3 = node2.getParentNode();
        if (node3 == this.fStartContainer && (n2 = this.indexOf(node2, this.fStartContainer)) < this.fStartOffset) {
            ++this.fStartOffset;
        }
        if (node3 == this.fEndContainer && (n2 = this.indexOf(node2, this.fEndContainer)) < this.fEndOffset) {
            ++this.fEndOffset;
        }
    }

    Node removeChild(Node node2, Node node3) {
        this.fRemoveChild = node3;
        Node node4 = node2.removeChild(node3);
        this.fRemoveChild = null;
        return node4;
    }

    void removeNode(Node node2) {
        int n2;
        if (node2 == null) {
            return;
        }
        if (this.fRemoveChild == node2) {
            return;
        }
        Node node3 = node2.getParentNode();
        if (node3 == this.fStartContainer && (n2 = this.indexOf(node2, this.fStartContainer)) < this.fStartOffset) {
            --this.fStartOffset;
        }
        if (node3 == this.fEndContainer && (n2 = this.indexOf(node2, this.fEndContainer)) < this.fEndOffset) {
            --this.fEndOffset;
        }
        if (node3 != this.fStartContainer || node3 != this.fEndContainer) {
            if (this.isAncestorOf(node2, this.fStartContainer)) {
                this.fStartContainer = node3;
                this.fStartOffset = this.indexOf(node2, node3);
            }
            if (this.isAncestorOf(node2, this.fEndContainer)) {
                this.fEndContainer = node3;
                this.fEndOffset = this.indexOf(node2, node3);
            }
        }
    }

    private DocumentFragment traverseContents(int n2) throws DOMException {
        int n3;
        Node node2;
        Node node3;
        if (this.fStartContainer == null || this.fEndContainer == null) {
            return null;
        }
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fStartContainer == this.fEndContainer) {
            return this.traverseSameContainer(n2);
        }
        int n4 = 0;
        Node node4 = this.fEndContainer;
        for (node3 = node4.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3 == this.fStartContainer) {
                return this.traverseCommonStartContainer(node4, n2);
            }
            ++n4;
            node4 = node3;
        }
        int n5 = 0;
        node3 = this.fStartContainer;
        for (node2 = node3.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2 == this.fEndContainer) {
                return this.traverseCommonEndContainer(node3, n2);
            }
            ++n5;
            node3 = node2;
        }
        node2 = this.fStartContainer;
        for (n3 = n5 - n4; n3 > 0; --n3) {
            node2 = node2.getParentNode();
        }
        Node node5 = this.fEndContainer;
        while (n3 < 0) {
            node5 = node5.getParentNode();
            ++n3;
        }
        Node node6 = node2.getParentNode();
        for (Node node7 = node5.getParentNode(); node6 != node7; node6 = node6.getParentNode(), node7 = node7.getParentNode()) {
            node2 = node6;
            node5 = node7;
        }
        return this.traverseCommonAncestors(node2, node5, n2);
    }

    private DocumentFragment traverseSameContainer(int n2) {
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        if (this.fStartOffset == this.fEndOffset) {
            return documentFragment;
        }
        short s = this.fStartContainer.getNodeType();
        if (s == 3 || s == 4 || s == 8 || s == 7) {
            String string2 = this.fStartContainer.getNodeValue();
            String string3 = string2.substring(this.fStartOffset, this.fEndOffset);
            if (n2 != 2) {
                ((CharacterDataImpl)this.fStartContainer).deleteData(this.fStartOffset, this.fEndOffset - this.fStartOffset);
                this.collapse(true);
            }
            if (n2 == 3) {
                return null;
            }
            if (s == 3) {
                documentFragment.appendChild(this.fDocument.createTextNode(string3));
            } else if (s == 4) {
                documentFragment.appendChild(this.fDocument.createCDATASection(string3));
            } else if (s == 8) {
                documentFragment.appendChild(this.fDocument.createComment(string3));
            } else {
                documentFragment.appendChild(this.fDocument.createProcessingInstruction(this.fStartContainer.getNodeName(), string3));
            }
            return documentFragment;
        }
        Node node2 = this.getSelectedNode(this.fStartContainer, this.fStartOffset);
        for (int i = this.fEndOffset - this.fStartOffset; i > 0; --i) {
            Node node3 = node2.getNextSibling();
            Node node4 = this.traverseFullySelected(node2, n2);
            if (documentFragment != null) {
                documentFragment.appendChild(node4);
            }
            node2 = node3;
        }
        if (n2 != 2) {
            this.collapse(true);
        }
        return documentFragment;
    }

    private DocumentFragment traverseCommonStartContainer(Node node2, int n2) {
        int n3;
        int n4;
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        Node node3 = this.traverseRightBoundary(node2, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node3);
        }
        if ((n4 = (n3 = this.indexOf(node2, this.fStartContainer)) - this.fStartOffset) <= 0) {
            if (n2 != 2) {
                this.setEndBefore(node2);
                this.collapse(false);
            }
            return documentFragment;
        }
        node3 = node2.getPreviousSibling();
        while (n4 > 0) {
            Node node4 = node3.getPreviousSibling();
            Node node5 = this.traverseFullySelected(node3, n2);
            if (documentFragment != null) {
                documentFragment.insertBefore(node5, documentFragment.getFirstChild());
            }
            --n4;
            node3 = node4;
        }
        if (n2 != 2) {
            this.setEndBefore(node2);
            this.collapse(false);
        }
        return documentFragment;
    }

    private DocumentFragment traverseCommonEndContainer(Node node2, int n2) {
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        Node node3 = this.traverseLeftBoundary(node2, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node3);
        }
        int n3 = this.indexOf(node2, this.fEndContainer);
        node3 = node2.getNextSibling();
        for (int i = this.fEndOffset - ++n3; i > 0; --i) {
            Node node4 = node3.getNextSibling();
            Node node5 = this.traverseFullySelected(node3, n2);
            if (documentFragment != null) {
                documentFragment.appendChild(node5);
            }
            node3 = node4;
        }
        if (n2 != 2) {
            this.setStartAfter(node2);
            this.collapse(true);
        }
        return documentFragment;
    }

    private DocumentFragment traverseCommonAncestors(Node node2, Node node3, int n2) {
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        Node node4 = this.traverseLeftBoundary(node2, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node4);
        }
        Node node5 = node2.getParentNode();
        int n3 = this.indexOf(node2, node5);
        int n4 = this.indexOf(node3, node5);
        Node node6 = node2.getNextSibling();
        for (int i = n4 - ++n3; i > 0; --i) {
            Node node7 = node6.getNextSibling();
            node4 = this.traverseFullySelected(node6, n2);
            if (documentFragment != null) {
                documentFragment.appendChild(node4);
            }
            node6 = node7;
        }
        node4 = this.traverseRightBoundary(node3, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node4);
        }
        if (n2 != 2) {
            this.setStartAfter(node2);
            this.collapse(true);
        }
        return documentFragment;
    }

    private Node traverseRightBoundary(Node node2, int n2) {
        boolean bl;
        Node node3 = this.getSelectedNode(this.fEndContainer, this.fEndOffset - 1);
        boolean bl2 = bl = node3 != this.fEndContainer;
        if (node3 == node2) {
            return this.traverseNode(node3, bl, false, n2);
        }
        Node node4 = node3.getParentNode();
        Node node5 = this.traverseNode(node4, false, false, n2);
        while (node4 != null) {
            Node node6;
            while (node3 != null) {
                node6 = node3.getPreviousSibling();
                Node node7 = this.traverseNode(node3, bl, false, n2);
                if (n2 != 3) {
                    node5.insertBefore(node7, node5.getFirstChild());
                }
                bl = true;
                node3 = node6;
            }
            if (node4 == node2) {
                return node5;
            }
            node3 = node4.getPreviousSibling();
            node4 = node4.getParentNode();
            node6 = this.traverseNode(node4, false, false, n2);
            if (n2 != 3) {
                node6.appendChild(node5);
            }
            node5 = node6;
        }
        return null;
    }

    private Node traverseLeftBoundary(Node node2, int n2) {
        boolean bl;
        Node node3 = this.getSelectedNode(this.getStartContainer(), this.getStartOffset());
        boolean bl2 = bl = node3 != this.getStartContainer();
        if (node3 == node2) {
            return this.traverseNode(node3, bl, true, n2);
        }
        Node node4 = node3.getParentNode();
        Node node5 = this.traverseNode(node4, false, true, n2);
        while (node4 != null) {
            Node node6;
            while (node3 != null) {
                node6 = node3.getNextSibling();
                Node node7 = this.traverseNode(node3, bl, true, n2);
                if (n2 != 3) {
                    node5.appendChild(node7);
                }
                bl = true;
                node3 = node6;
            }
            if (node4 == node2) {
                return node5;
            }
            node3 = node4.getNextSibling();
            node4 = node4.getParentNode();
            node6 = this.traverseNode(node4, false, true, n2);
            if (n2 != 3) {
                node6.appendChild(node5);
            }
            node5 = node6;
        }
        return null;
    }

    private Node traverseNode(Node node2, boolean bl, boolean bl2, int n2) {
        if (bl) {
            return this.traverseFullySelected(node2, n2);
        }
        short s = node2.getNodeType();
        if (s == 3 || s == 4 || s == 8 || s == 7) {
            return this.traverseCharacterDataNode(node2, bl2, n2);
        }
        return this.traversePartiallySelected(node2, n2);
    }

    private Node traverseFullySelected(Node node2, int n2) {
        switch (n2) {
            case 2: {
                return node2.cloneNode(true);
            }
            case 1: {
                if (node2.getNodeType() == 10) {
                    throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
                }
                return node2;
            }
            case 3: {
                node2.getParentNode().removeChild(node2);
                return null;
            }
        }
        return null;
    }

    private Node traversePartiallySelected(Node node2, int n2) {
        switch (n2) {
            case 3: {
                return null;
            }
            case 1: 
            case 2: {
                return node2.cloneNode(false);
            }
        }
        return null;
    }

    private Node traverseCharacterDataNode(Node node2, boolean bl, int n2) {
        String string2;
        String string3;
        int n3;
        String string4 = node2.getNodeValue();
        if (bl) {
            n3 = this.getStartOffset();
            string3 = string4.substring(n3);
            string2 = string4.substring(0, n3);
        } else {
            n3 = this.getEndOffset();
            string3 = string4.substring(0, n3);
            string2 = string4.substring(n3);
        }
        if (n2 != 2) {
            node2.setNodeValue(string2);
        }
        if (n2 == 3) {
            return null;
        }
        Node node3 = node2.cloneNode(false);
        node3.setNodeValue(string3);
        return node3;
    }

    void checkIndex(Node node2, int n2) throws DOMException {
        if (n2 < 0) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        short s = node2.getNodeType();
        if (s == 3 || s == 4 || s == 8 || s == 7 ? n2 > node2.getNodeValue().length() : n2 > node2.getChildNodes().getLength()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
    }

    private Node getRootContainer(Node node2) {
        if (node2 == null) {
            return null;
        }
        while (node2.getParentNode() != null) {
            node2 = node2.getParentNode();
        }
        return node2;
    }

    private boolean isLegalContainer(Node node2) {
        if (node2 == null) {
            return false;
        }
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 6: 
                case 10: 
                case 12: {
                    return false;
                }
            }
            node2 = node2.getParentNode();
        }
        return true;
    }

    private boolean hasLegalRootContainer(Node node2) {
        if (node2 == null) {
            return false;
        }
        Node node3 = this.getRootContainer(node2);
        switch (node3.getNodeType()) {
            case 2: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private boolean isLegalContainedNode(Node node2) {
        if (node2 == null) {
            return false;
        }
        switch (node2.getNodeType()) {
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return true;
    }

    Node nextNode(Node node2, boolean bl) {
        Node node3;
        if (node2 == null) {
            return null;
        }
        if (bl && (node3 = node2.getFirstChild()) != null) {
            return node3;
        }
        node3 = node2.getNextSibling();
        if (node3 != null) {
            return node3;
        }
        for (Node node4 = node2.getParentNode(); node4 != null && node4 != this.fDocument; node4 = node4.getParentNode()) {
            node3 = node4.getNextSibling();
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    boolean isAncestorOf(Node node2, Node node3) {
        for (Node node4 = node3; node4 != null; node4 = node4.getParentNode()) {
            if (node4 != node2) continue;
            return true;
        }
        return false;
    }

    int indexOf(Node node2, Node node3) {
        if (node2.getParentNode() != node3) {
            return -1;
        }
        int n2 = 0;
        for (Node node4 = node3.getFirstChild(); node4 != node2; node4 = node4.getNextSibling()) {
            ++n2;
        }
        return n2;
    }

    private Node getSelectedNode(Node node2, int n2) {
        Node node3;
        if (node2.getNodeType() == 3) {
            return node2;
        }
        if (n2 < 0) {
            return node2;
        }
        for (node3 = node2.getFirstChild(); node3 != null && n2 > 0; --n2, node3 = node3.getNextSibling()) {
        }
        if (node3 != null) {
            return node3;
        }
        return node2;
    }
}

