/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.html.dom;

import com.ibm.xml.xml4j.internal.s1.html.dom.CollectionIndex;
import com.ibm.xml.xml4j.internal.s1.html.dom.HTMLFormControl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLAppletElement;
import org.w3c.dom.html.HTMLAreaElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLObjectElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

class HTMLCollectionImpl
implements HTMLCollection {
    static final short ANCHOR = 1;
    static final short FORM = 2;
    static final short IMAGE = 3;
    static final short APPLET = 4;
    static final short LINK = 5;
    static final short OPTION = 6;
    static final short ROW = 7;
    static final short ELEMENT = 8;
    static final short AREA = -1;
    static final short TBODY = -2;
    static final short CELL = -3;
    private short _lookingFor;
    private Element _topLevel;

    HTMLCollectionImpl(HTMLElement hTMLElement, short s) {
        if (hTMLElement == null) {
            throw new NullPointerException("HTM011 Argument 'topLevel' is null.");
        }
        this._topLevel = hTMLElement;
        this._lookingFor = s;
    }

    public final int getLength() {
        return this.getLength(this._topLevel);
    }

    public final Node item(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("HTM012 Argument 'index' is negative.");
        }
        return this.item(this._topLevel, new CollectionIndex(n2));
    }

    public final Node namedItem(String string2) {
        if (string2 == null) {
            throw new NullPointerException("HTM013 Argument 'name' is null.");
        }
        return this.namedItem(this._topLevel, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLength(Element element2) {
        int n2;
        Element element3 = element2;
        synchronized (element3) {
            n2 = 0;
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element)) continue;
                if (this.collectionMatch((Element)node2, null)) {
                    ++n2;
                    continue;
                }
                if (!this.recurse()) continue;
                n2 += this.getLength((Element)node2);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node item(Element element2, CollectionIndex collectionIndex) {
        Element element3 = element2;
        synchronized (element3) {
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Node node3;
                if (!(node2 instanceof Element)) continue;
                if (this.collectionMatch((Element)node2, null)) {
                    if (collectionIndex.isZero()) {
                        return node2;
                    }
                    collectionIndex.decrement();
                    continue;
                }
                if (!this.recurse() || (node3 = this.item((Element)node2, collectionIndex)) == null) continue;
                return node3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node namedItem(Element element2, String string2) {
        Element element3 = element2;
        synchronized (element3) {
            Node node2;
            for (node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Node node3;
                if (!(node2 instanceof Element)) continue;
                if (this.collectionMatch((Element)node2, string2)) {
                    return node2;
                }
                if (!this.recurse() || (node3 = this.namedItem((Element)node2, string2)) == null) continue;
                return node3;
            }
            return node2;
        }
    }

    protected boolean recurse() {
        return this._lookingFor > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean collectionMatch(Element element2, String string2) {
        boolean bl;
        Element element3 = element2;
        synchronized (element3) {
            bl = false;
            switch (this._lookingFor) {
                case 1: {
                    bl = element2 instanceof HTMLAnchorElement && element2.getAttribute("name").length() > 0;
                    break;
                }
                case 2: {
                    bl = element2 instanceof HTMLFormElement;
                    break;
                }
                case 3: {
                    bl = element2 instanceof HTMLImageElement;
                    break;
                }
                case 4: {
                    bl = element2 instanceof HTMLAppletElement || element2 instanceof HTMLObjectElement && ("application/java".equals(element2.getAttribute("codetype")) || element2.getAttribute("classid").startsWith("java:"));
                    break;
                }
                case 8: {
                    bl = element2 instanceof HTMLFormControl;
                    break;
                }
                case 5: {
                    bl = (element2 instanceof HTMLAnchorElement || element2 instanceof HTMLAreaElement) && element2.getAttribute("href").length() > 0;
                    break;
                }
                case -1: {
                    bl = element2 instanceof HTMLAreaElement;
                    break;
                }
                case 6: {
                    bl = element2 instanceof HTMLOptionElement;
                    break;
                }
                case 7: {
                    bl = element2 instanceof HTMLTableRowElement;
                    break;
                }
                case -2: {
                    bl = element2 instanceof HTMLTableSectionElement && element2.getTagName().equals("TBODY");
                    break;
                }
                case -3: {
                    bl = element2 instanceof HTMLTableCellElement;
                }
            }
            if (bl && string2 != null) {
                if (element2 instanceof HTMLAnchorElement && string2.equals(element2.getAttribute("name"))) {
                    return true;
                }
                bl = string2.equals(element2.getAttribute("id"));
            }
        }
        return bl;
    }
}

