/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.dv.xs;

import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidationContext;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.TypeValidator;

class PrecisionDecimalDV
extends TypeValidator {
    PrecisionDecimalDV() {
    }

    public short getAllowedFacets() {
        return 4088;
    }

    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XPrecisionDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "precisionDecimal"});
        }
    }

    public int compare(Object object2, Object object3) {
        return ((XPrecisionDecimal)object2).compareTo((XPrecisionDecimal)object3);
    }

    public int getFractionDigits(Object object2) {
        return ((XPrecisionDecimal)object2).fracDigits;
    }

    public int getTotalDigits(Object object2) {
        return ((XPrecisionDecimal)object2).totalDigits;
    }

    public boolean isIdentical(Object object2, Object object3) {
        if (!(object3 instanceof XPrecisionDecimal) || !(object2 instanceof XPrecisionDecimal)) {
            return false;
        }
        return ((XPrecisionDecimal)object2).isIdentical((XPrecisionDecimal)object3);
    }

    static class XPrecisionDecimal {
        int sign = 1;
        int totalDigits = 0;
        int intDigits = 0;
        int fracDigits = 0;
        String ivalue = "";
        String fvalue = "";
        int pvalue = 0;
        private String canonical;

        XPrecisionDecimal(String string2) throws NumberFormatException {
            if (string2.equals("NaN")) {
                this.ivalue = string2;
                this.sign = 0;
            }
            if (string2.equals("+INF") || string2.equals("INF") || string2.equals("-INF")) {
                this.ivalue = string2.charAt(0) == '+' ? string2.substring(1) : string2;
                return;
            }
            this.initD(string2);
        }

        void initD(String string2) throws NumberFormatException {
            int n2;
            int n3 = string2.length();
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (string2.charAt(0) == '+') {
                n4 = 1;
            } else if (string2.charAt(0) == '-') {
                n4 = 1;
                this.sign = -1;
            }
            for (n2 = n4; n2 < n3 && string2.charAt(n2) == '0'; ++n2) {
            }
            for (n5 = n2; n5 < n3 && TypeValidator.isDigit(string2.charAt(n5)); ++n5) {
            }
            if (n5 < n3) {
                if (string2.charAt(n5) != '.' && string2.charAt(n5) != 'E' && string2.charAt(n5) != 'e') {
                    throw new NumberFormatException();
                }
                if (string2.charAt(n5) == '.') {
                    for (n7 = n6 = n5 + 1; n7 < n3 && TypeValidator.isDigit(string2.charAt(n7)); ++n7) {
                    }
                } else {
                    this.pvalue = Integer.parseInt(string2.substring(n5 + 1, n3));
                }
            }
            if (n4 == n5 && n6 == n7) {
                throw new NumberFormatException();
            }
            for (int i = n6; i < n7; ++i) {
                if (TypeValidator.isDigit(string2.charAt(i))) continue;
                throw new NumberFormatException();
            }
            this.intDigits = n5 - n2;
            this.fracDigits = n7 - n6;
            if (this.intDigits > 0) {
                this.ivalue = string2.substring(n2, n5);
            }
            if (this.fracDigits > 0) {
                this.fvalue = string2.substring(n6, n7);
                if (n7 < n3) {
                    this.pvalue = Integer.parseInt(string2.substring(n7 + 1, n3));
                }
            }
            this.totalDigits = this.intDigits + this.fracDigits;
        }

        public boolean equals(Object object2) {
            if (object2 == this) {
                return true;
            }
            if (!(object2 instanceof XPrecisionDecimal)) {
                return false;
            }
            XPrecisionDecimal xPrecisionDecimal = (XPrecisionDecimal)object2;
            return this.compareTo(xPrecisionDecimal) == 0;
        }

        private int compareFractionalPart(XPrecisionDecimal xPrecisionDecimal) {
            if (this.fvalue.equals(xPrecisionDecimal.fvalue)) {
                return 0;
            }
            StringBuffer stringBuffer = new StringBuffer(this.fvalue);
            StringBuffer stringBuffer2 = new StringBuffer(xPrecisionDecimal.fvalue);
            this.truncateTrailingZeros(stringBuffer, stringBuffer2);
            return stringBuffer.toString().compareTo(stringBuffer2.toString());
        }

        private void truncateTrailingZeros(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            int n2;
            for (n2 = stringBuffer.length() - 1; n2 >= 0 && stringBuffer.charAt(n2) == '0'; --n2) {
                stringBuffer.deleteCharAt(n2);
            }
            for (n2 = stringBuffer2.length() - 1; n2 >= 0 && stringBuffer2.charAt(n2) == '0'; --n2) {
                stringBuffer2.deleteCharAt(n2);
            }
        }

        public int compareTo(XPrecisionDecimal xPrecisionDecimal) {
            if (this.sign == 0) {
                return 2;
            }
            if (this.ivalue.equals("INF") || xPrecisionDecimal.ivalue.equals("INF")) {
                if (this.ivalue.equals(xPrecisionDecimal.ivalue)) {
                    return 0;
                }
                if (this.ivalue.equals("INF")) {
                    return 1;
                }
                return -1;
            }
            if (this.ivalue.equals("-INF") || xPrecisionDecimal.ivalue.equals("-INF")) {
                if (this.ivalue.equals(xPrecisionDecimal.ivalue)) {
                    return 0;
                }
                if (this.ivalue.equals("-INF")) {
                    return -1;
                }
                return 1;
            }
            if (this.sign != xPrecisionDecimal.sign) {
                return this.sign > xPrecisionDecimal.sign ? 1 : -1;
            }
            return this.sign * this.compare(xPrecisionDecimal);
        }

        private int compare(XPrecisionDecimal xPrecisionDecimal) {
            if (this.pvalue != 0 || xPrecisionDecimal.pvalue != 0) {
                if (this.pvalue == xPrecisionDecimal.pvalue) {
                    return this.intComp(xPrecisionDecimal);
                }
                if (this.intDigits + this.pvalue != xPrecisionDecimal.intDigits + xPrecisionDecimal.pvalue) {
                    return this.intDigits + this.pvalue > xPrecisionDecimal.intDigits + xPrecisionDecimal.pvalue ? 1 : -1;
                }
                if (this.pvalue > xPrecisionDecimal.pvalue) {
                    int n2 = this.pvalue - xPrecisionDecimal.pvalue;
                    StringBuffer stringBuffer = new StringBuffer(this.ivalue);
                    StringBuffer stringBuffer2 = new StringBuffer(this.fvalue);
                    for (int i = 0; i < n2; ++i) {
                        if (i < this.fracDigits) {
                            stringBuffer.append(this.fvalue.charAt(i));
                            stringBuffer2.deleteCharAt(i);
                            continue;
                        }
                        stringBuffer.append('0');
                    }
                    return this.compareDecimal(stringBuffer.toString(), xPrecisionDecimal.ivalue, stringBuffer2.toString(), xPrecisionDecimal.fvalue);
                }
                int n3 = xPrecisionDecimal.pvalue - this.pvalue;
                StringBuffer stringBuffer = new StringBuffer(xPrecisionDecimal.ivalue);
                StringBuffer stringBuffer3 = new StringBuffer(xPrecisionDecimal.fvalue);
                for (int i = 0; i < n3; ++i) {
                    if (i < xPrecisionDecimal.fracDigits) {
                        stringBuffer.append(xPrecisionDecimal.fvalue.charAt(i));
                        stringBuffer3.deleteCharAt(i);
                        continue;
                    }
                    stringBuffer.append('0');
                }
                return this.compareDecimal(this.ivalue, stringBuffer.toString(), this.fvalue, stringBuffer3.toString());
            }
            return this.intComp(xPrecisionDecimal);
        }

        private int intComp(XPrecisionDecimal xPrecisionDecimal) {
            if (this.intDigits != xPrecisionDecimal.intDigits) {
                return this.intDigits > xPrecisionDecimal.intDigits ? 1 : -1;
            }
            return this.compareDecimal(this.ivalue, xPrecisionDecimal.ivalue, this.fvalue, xPrecisionDecimal.fvalue);
        }

        private int compareDecimal(String string2, String string3, String string4, String string5) {
            int n2 = string2.compareTo(string4);
            if (n2 != 0) {
                return n2 > 0 ? 1 : -1;
            }
            if (string3.equals(string5)) {
                return 0;
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            StringBuffer stringBuffer2 = new StringBuffer(string5);
            this.truncateTrailingZeros(stringBuffer, stringBuffer2);
            n2 = stringBuffer.toString().compareTo(stringBuffer2.toString());
            return n2 == 0 ? 0 : (n2 > 0 ? 1 : -1);
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.makeCanonical();
            }
            return this.canonical;
        }

        private void makeCanonical() {
            this.canonical = "TBD by Working Group";
        }

        public boolean isIdentical(XPrecisionDecimal xPrecisionDecimal) {
            if (this.ivalue.equals(xPrecisionDecimal.ivalue) && (this.ivalue.equals("INF") || this.ivalue.equals("-INF") || this.ivalue.equals("NaN"))) {
                return true;
            }
            return this.sign == xPrecisionDecimal.sign && this.intDigits == xPrecisionDecimal.intDigits && this.fracDigits == xPrecisionDecimal.fracDigits && this.pvalue == xPrecisionDecimal.pvalue && this.ivalue.equals(xPrecisionDecimal.ivalue) && this.fvalue.equals(xPrecisionDecimal.fvalue);
        }
    }
}

