/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.xpath.regex;

final class CaseInsensitiveMap {
    private static int CHUNK_SHIFT = 10;
    private static int CHUNK_SIZE = 1 << CHUNK_SHIFT;
    private static int CHUNK_MASK = CHUNK_SIZE - 1;
    private static int INITIAL_CHUNK_COUNT = 64;
    private static int[][][] caseInsensitiveMap;
    private static int LOWER_CASE_MATCH;
    private static int UPPER_CASE_MATCH;

    CaseInsensitiveMap() {
    }

    public static int[] get(int n2) {
        return n2 < 65536 ? CaseInsensitiveMap.getMapping(n2) : null;
    }

    private static int[] getMapping(int n2) {
        int n3 = n2 >>> CHUNK_SHIFT;
        int n4 = n2 & CHUNK_MASK;
        return caseInsensitiveMap[n3][n4];
    }

    private static void buildCaseInsensitiveMap() {
        caseInsensitiveMap = new int[INITIAL_CHUNK_COUNT][CHUNK_SIZE][];
        for (int i = 0; i < 65536; ++i) {
            int[] nArray;
            char c;
            int n2 = Character.toLowerCase((char)i);
            if (n2 == (c = Character.toUpperCase((char)i)) && n2 == i) continue;
            int[] nArray2 = new int[2];
            int n3 = 0;
            if (n2 != i) {
                nArray2[n3++] = n2;
                nArray2[n3++] = LOWER_CASE_MATCH;
                nArray = CaseInsensitiveMap.getMapping(n2);
                if (nArray != null) {
                    nArray2 = CaseInsensitiveMap.updateMap(i, nArray2, n2, nArray, LOWER_CASE_MATCH);
                }
            }
            if (c != i) {
                if (n3 == nArray2.length) {
                    nArray2 = CaseInsensitiveMap.expandMap(nArray2, 2);
                }
                nArray2[n3++] = c;
                nArray2[n3++] = UPPER_CASE_MATCH;
                nArray = CaseInsensitiveMap.getMapping(c);
                if (nArray != null) {
                    nArray2 = CaseInsensitiveMap.updateMap(i, nArray2, c, nArray, UPPER_CASE_MATCH);
                }
            }
            CaseInsensitiveMap.set(i, nArray2);
        }
    }

    private static int[] expandMap(int[] nArray, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + n2];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private static void set(int n2, int[] nArray) {
        int n3 = n2 >>> CHUNK_SHIFT;
        int n4 = n2 & CHUNK_MASK;
        CaseInsensitiveMap.caseInsensitiveMap[n3][n4] = nArray;
    }

    private static int[] updateMap(int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i = 0; i < nArray2.length; i += 2) {
            int n5 = nArray2[i];
            int[] nArray3 = CaseInsensitiveMap.getMapping(n5);
            if (nArray3 == null || !CaseInsensitiveMap.contains(nArray3, n3, n4)) continue;
            if (!CaseInsensitiveMap.contains(nArray3, n2)) {
                nArray3 = CaseInsensitiveMap.expandAndAdd(nArray3, n2, n4);
                CaseInsensitiveMap.set(n5, nArray3);
            }
            if (CaseInsensitiveMap.contains(nArray, n5)) continue;
            nArray = CaseInsensitiveMap.expandAndAdd(nArray, n5, n4);
        }
        if (!CaseInsensitiveMap.contains(nArray2, n2)) {
            nArray2 = CaseInsensitiveMap.expandAndAdd(nArray2, n2, n4);
            CaseInsensitiveMap.set(n3, nArray2);
        }
        return nArray;
    }

    private static boolean contains(int[] nArray, int n2) {
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] != n2) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(int[] nArray, int n2, int n3) {
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] != n2 || nArray[i + 1] != n3) continue;
            return true;
        }
        return false;
    }

    private static int[] expandAndAdd(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        int[] nArray2 = new int[n4 + 2];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        nArray2[n4] = n2;
        nArray2[n4 + 1] = n3;
        return nArray2;
    }

    static {
        LOWER_CASE_MATCH = 1;
        UPPER_CASE_MATCH = 2;
        CaseInsensitiveMap.buildCaseInsensitiveMap();
    }
}

