/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.xpath.regex;

import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.Token;
import java.io.Serializable;

final class RangeToken
extends Token
implements Serializable {
    private static final long serialVersionUID = -553983121197679934L;
    int[] ranges;
    boolean sorted;
    boolean compacted;
    RangeToken icaseCache = null;
    int[] map = null;
    int nonMapIndex;
    private static final int MAPSIZE = 256;

    RangeToken(int n2) {
        super(n2);
        this.setSorted(false);
    }

    protected void addRange(int n2, int n3) {
        int n4;
        int n5;
        this.icaseCache = null;
        if (n2 <= n3) {
            n5 = n2;
            n4 = n3;
        } else {
            n5 = n3;
            n4 = n2;
        }
        int n6 = 0;
        if (this.ranges == null) {
            this.ranges = new int[2];
            this.ranges[0] = n5;
            this.ranges[1] = n4;
            this.setSorted(true);
        } else {
            n6 = this.ranges.length;
            if (this.ranges[n6 - 1] + 1 == n5) {
                this.ranges[n6 - 1] = n4;
                return;
            }
            int[] nArray = new int[n6 + 2];
            System.arraycopy(this.ranges, 0, nArray, 0, n6);
            this.ranges = nArray;
            if (this.ranges[n6 - 1] >= n5) {
                this.setSorted(false);
            }
            this.ranges[n6++] = n5;
            this.ranges[n6] = n4;
            if (!this.sorted) {
                this.sortRanges();
            }
        }
    }

    private final boolean isSorted() {
        return this.sorted;
    }

    private final void setSorted(boolean bl) {
        this.sorted = bl;
        if (!bl) {
            this.compacted = false;
        }
    }

    private final boolean isCompacted() {
        return this.compacted;
    }

    private final void setCompacted() {
        this.compacted = true;
    }

    protected void sortRanges() {
        if (this.isSorted()) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        for (int i = this.ranges.length - 4; i >= 0; i -= 2) {
            for (int j = 0; j <= i; j += 2) {
                if (this.ranges[j] <= this.ranges[j + 2] && (this.ranges[j] != this.ranges[j + 2] || this.ranges[j + 1] <= this.ranges[j + 3])) continue;
                int n2 = this.ranges[j + 2];
                this.ranges[j + 2] = this.ranges[j];
                this.ranges[j] = n2;
                n2 = this.ranges[j + 3];
                this.ranges[j + 3] = this.ranges[j + 1];
                this.ranges[j + 1] = n2;
            }
        }
        this.setSorted(true);
    }

    protected void compactRanges() {
        boolean bl = false;
        if (this.ranges == null || this.ranges.length <= 2) {
            return;
        }
        if (this.isCompacted()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.ranges.length) {
            if (n2 != n3) {
                this.ranges[n2] = this.ranges[n3++];
                this.ranges[n2 + 1] = this.ranges[n3++];
            } else {
                n3 += 2;
            }
            int n4 = this.ranges[n2 + 1];
            while (n3 < this.ranges.length && n4 + 1 >= this.ranges[n3]) {
                if (n4 + 1 == this.ranges[n3]) {
                    if (bl) {
                        System.err.println("Token#compactRanges(): Compaction: [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "], [" + this.ranges[n3] + ", " + this.ranges[n3 + 1] + "] -> [" + this.ranges[n2] + ", " + this.ranges[n3 + 1] + "]");
                    }
                    this.ranges[n2 + 1] = this.ranges[n3 + 1];
                    n4 = this.ranges[n2 + 1];
                    n3 += 2;
                    continue;
                }
                if (n4 >= this.ranges[n3 + 1]) {
                    if (bl) {
                        System.err.println("Token#compactRanges(): Compaction: [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "], [" + this.ranges[n3] + ", " + this.ranges[n3 + 1] + "] -> [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "]");
                    }
                    n3 += 2;
                    continue;
                }
                if (n4 < this.ranges[n3 + 1]) {
                    if (bl) {
                        System.err.println("Token#compactRanges(): Compaction: [" + this.ranges[n2] + ", " + this.ranges[n2 + 1] + "], [" + this.ranges[n3] + ", " + this.ranges[n3 + 1] + "] -> [" + this.ranges[n2] + ", " + this.ranges[n3 + 1] + "]");
                    }
                    this.ranges[n2 + 1] = this.ranges[n3 + 1];
                    n4 = this.ranges[n2 + 1];
                    n3 += 2;
                    continue;
                }
                throw new RuntimeException("Token#compactRanges(): Internel Error: [" + this.ranges[n2] + "," + this.ranges[n2 + 1] + "] [" + this.ranges[n3] + "," + this.ranges[n3 + 1] + "]");
            }
            n2 += 2;
        }
        if (n2 != this.ranges.length) {
            int[] nArray = new int[n2];
            System.arraycopy(this.ranges, 0, nArray, 0, n2);
            this.ranges = nArray;
        }
        this.setCompacted();
    }

    protected void mergeRanges(Token token) {
        RangeToken rangeToken = (RangeToken)token;
        this.sortRanges();
        rangeToken.sortRanges();
        if (rangeToken.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.setSorted(true);
        if (this.ranges == null) {
            this.ranges = new int[rangeToken.ranges.length];
            System.arraycopy(rangeToken.ranges, 0, this.ranges, 0, rangeToken.ranges.length);
            return;
        }
        int[] nArray = new int[this.ranges.length + rangeToken.ranges.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < this.ranges.length || n3 < rangeToken.ranges.length) {
            if (n2 >= this.ranges.length) {
                nArray[n4++] = rangeToken.ranges[n3++];
                nArray[n4++] = rangeToken.ranges[n3++];
                continue;
            }
            if (n3 >= rangeToken.ranges.length) {
                nArray[n4++] = this.ranges[n2++];
                nArray[n4++] = this.ranges[n2++];
                continue;
            }
            if (rangeToken.ranges[n3] < this.ranges[n2] || rangeToken.ranges[n3] == this.ranges[n2] && rangeToken.ranges[n3 + 1] < this.ranges[n2 + 1]) {
                nArray[n4++] = rangeToken.ranges[n3++];
                nArray[n4++] = rangeToken.ranges[n3++];
                continue;
            }
            nArray[n4++] = this.ranges[n2++];
            nArray[n4++] = this.ranges[n2++];
        }
        this.ranges = nArray;
    }

    protected void subtractRanges(Token token) {
        if (token.type == 5) {
            this.intersectRanges(token);
            return;
        }
        RangeToken rangeToken = (RangeToken)token;
        if (rangeToken.ranges == null || this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        rangeToken.sortRanges();
        rangeToken.compactRanges();
        int[] nArray = new int[this.ranges.length + rangeToken.ranges.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.ranges.length && n4 < rangeToken.ranges.length) {
            int n5 = this.ranges[n3];
            int n6 = this.ranges[n3 + 1];
            int n7 = rangeToken.ranges[n4];
            int n8 = rangeToken.ranges[n4 + 1];
            if (n6 < n7) {
                nArray[n2++] = this.ranges[n3++];
                nArray[n2++] = this.ranges[n3++];
                continue;
            }
            if (n6 >= n7 && n5 <= n8) {
                if (n7 <= n5 && n6 <= n8) {
                    n3 += 2;
                    continue;
                }
                if (n7 <= n5) {
                    this.ranges[n3] = n8 + 1;
                    n4 += 2;
                    continue;
                }
                if (n6 <= n8) {
                    nArray[n2++] = n5;
                    nArray[n2++] = n7 - 1;
                    n3 += 2;
                    continue;
                }
                nArray[n2++] = n5;
                nArray[n2++] = n7 - 1;
                this.ranges[n3] = n8 + 1;
                n4 += 2;
                continue;
            }
            if (n8 < n5) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Token#subtractRanges(): Internal Error: [" + this.ranges[n3] + "," + this.ranges[n3 + 1] + "] - [" + rangeToken.ranges[n4] + "," + rangeToken.ranges[n4 + 1] + "]");
        }
        while (n3 < this.ranges.length) {
            nArray[n2++] = this.ranges[n3++];
            nArray[n2++] = this.ranges[n3++];
        }
        this.ranges = new int[n2];
        System.arraycopy(nArray, 0, this.ranges, 0, n2);
    }

    protected void intersectRanges(Token token) {
        RangeToken rangeToken = (RangeToken)token;
        if (rangeToken.ranges == null || this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        rangeToken.sortRanges();
        rangeToken.compactRanges();
        int[] nArray = new int[this.ranges.length + rangeToken.ranges.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.ranges.length && n4 < rangeToken.ranges.length) {
            int n5 = this.ranges[n3];
            int n6 = this.ranges[n3 + 1];
            int n7 = rangeToken.ranges[n4];
            int n8 = rangeToken.ranges[n4 + 1];
            if (n6 < n7) {
                n3 += 2;
                continue;
            }
            if (n6 >= n7 && n5 <= n8) {
                if (n7 <= n5 && n6 <= n8) {
                    nArray[n2++] = n5;
                    nArray[n2++] = n6;
                    n3 += 2;
                    continue;
                }
                if (n7 <= n5) {
                    nArray[n2++] = n5;
                    nArray[n2++] = n8;
                    this.ranges[n3] = n8 + 1;
                    n4 += 2;
                    continue;
                }
                if (n6 <= n8) {
                    nArray[n2++] = n7;
                    nArray[n2++] = n6;
                    n3 += 2;
                    continue;
                }
                nArray[n2++] = n7;
                nArray[n2++] = n8;
                this.ranges[n3] = n8 + 1;
                continue;
            }
            if (n8 < n5) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Token#intersectRanges(): Internal Error: [" + this.ranges[n3] + "," + this.ranges[n3 + 1] + "] & [" + rangeToken.ranges[n4] + "," + rangeToken.ranges[n4 + 1] + "]");
        }
        while (n3 < this.ranges.length) {
            nArray[n2++] = this.ranges[n3++];
            nArray[n2++] = this.ranges[n3++];
        }
        this.ranges = new int[n2];
        System.arraycopy(nArray, 0, this.ranges, 0, n2);
    }

    static Token complementRanges(Token token) {
        int n2;
        if (token.type != 4 && token.type != 5) {
            throw new IllegalArgumentException("Token#complementRanges(): must be RANGE: " + token.type);
        }
        RangeToken rangeToken = (RangeToken)token;
        rangeToken.sortRanges();
        rangeToken.compactRanges();
        int n3 = rangeToken.ranges.length + 2;
        if (rangeToken.ranges[0] == 0) {
            n3 -= 2;
        }
        if ((n2 = rangeToken.ranges[rangeToken.ranges.length - 1]) == 0x10FFFF) {
            n3 -= 2;
        }
        RangeToken rangeToken2 = Token.createRange();
        rangeToken2.ranges = new int[n3];
        int n4 = 0;
        if (rangeToken.ranges[0] > 0) {
            rangeToken2.ranges[n4++] = 0;
            rangeToken2.ranges[n4++] = rangeToken.ranges[0] - 1;
        }
        for (int i = 1; i < rangeToken.ranges.length - 2; i += 2) {
            rangeToken2.ranges[n4++] = rangeToken.ranges[i] + 1;
            rangeToken2.ranges[n4++] = rangeToken.ranges[i + 1] - 1;
        }
        if (n2 != 0x10FFFF) {
            rangeToken2.ranges[n4++] = n2 + 1;
            rangeToken2.ranges[n4] = 0x10FFFF;
        }
        rangeToken2.setCompacted();
        return rangeToken2;
    }

    synchronized RangeToken getCaseInsensitiveToken() {
        int n2;
        int n3;
        if (this.icaseCache != null) {
            return this.icaseCache;
        }
        RangeToken rangeToken = this.type == 4 ? Token.createRange() : Token.createNRange();
        for (int i = 0; i < this.ranges.length; i += 2) {
            for (n3 = this.ranges[i]; n3 <= this.ranges[i + 1]; ++n3) {
                if (n3 > 65535) {
                    rangeToken.addRange(n3, n3);
                    continue;
                }
                n2 = Character.toUpperCase((char)n3);
                rangeToken.addRange(n2, n2);
            }
        }
        RangeToken rangeToken2 = this.type == 4 ? Token.createRange() : Token.createNRange();
        for (n3 = 0; n3 < rangeToken.ranges.length; n3 += 2) {
            for (n2 = rangeToken.ranges[n3]; n2 <= rangeToken.ranges[n3 + 1]; ++n2) {
                if (n2 > 65535) {
                    rangeToken2.addRange(n2, n2);
                    continue;
                }
                char c = Character.toLowerCase((char)n2);
                rangeToken2.addRange(c, c);
            }
        }
        rangeToken2.mergeRanges(rangeToken);
        rangeToken2.mergeRanges(this);
        rangeToken2.compactRanges();
        this.icaseCache = rangeToken2;
        return rangeToken2;
    }

    void dumpRanges() {
        System.err.print("RANGE: ");
        if (this.ranges == null) {
            System.err.println(" NULL");
        }
        for (int i = 0; i < this.ranges.length; i += 2) {
            System.err.print("[" + this.ranges[i] + "," + this.ranges[i + 1] + "] ");
        }
        System.err.println("");
    }

    boolean match(int n2) {
        boolean bl;
        if (this.map == null) {
            this.createMap();
        }
        if (this.type == 4) {
            if (n2 < 256) {
                return (this.map[n2 / 32] & 1 << (n2 & 0x1F)) != 0;
            }
            bl = false;
            for (int i = this.nonMapIndex; i < this.ranges.length; i += 2) {
                if (this.ranges[i] > n2 || n2 > this.ranges[i + 1]) continue;
                return true;
            }
        } else {
            if (n2 < 256) {
                return (this.map[n2 / 32] & 1 << (n2 & 0x1F)) == 0;
            }
            bl = true;
            for (int i = this.nonMapIndex; i < this.ranges.length; i += 2) {
                if (this.ranges[i] > n2 || n2 > this.ranges[i + 1]) continue;
                return false;
            }
        }
        return bl;
    }

    private void createMap() {
        int n2;
        int n3 = 8;
        int[] nArray = new int[n3];
        int n4 = this.ranges.length;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < this.ranges.length; n2 += 2) {
            int n5 = this.ranges[n2];
            int n6 = this.ranges[n2 + 1];
            if (n5 < 256) {
                for (int i = n5; i <= n6 && i < 256; ++i) {
                    int n7 = i / 32;
                    nArray[n7] = nArray[n7] | 1 << (i & 0x1F);
                }
            } else {
                n4 = n2;
                break;
            }
            if (n6 < 256) continue;
            n4 = n2;
            break;
        }
        this.map = nArray;
        this.nonMapIndex = n4;
    }

    public String toString(int n2) {
        String string2;
        if (this.type == 4) {
            if (this == Token.token_dot) {
                string2 = ".";
            } else if (this == Token.token_0to9) {
                string2 = "\\d";
            } else if (this == Token.token_wordchars) {
                string2 = "\\w";
            } else if (this == Token.token_spaces) {
                string2 = "\\s";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[");
                for (int i = 0; i < this.ranges.length; i += 2) {
                    if ((n2 & 0x400) != 0 && i > 0) {
                        stringBuffer.append(",");
                    }
                    if (this.ranges[i] == this.ranges[i + 1]) {
                        stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i]));
                        continue;
                    }
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i]));
                    stringBuffer.append('-');
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i + 1]));
                }
                stringBuffer.append("]");
                string2 = stringBuffer.toString();
            }
        } else if (this == Token.token_not_0to9) {
            string2 = "\\D";
        } else if (this == Token.token_not_wordchars) {
            string2 = "\\W";
        } else if (this == Token.token_not_spaces) {
            string2 = "\\S";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[^");
            for (int i = 0; i < this.ranges.length; i += 2) {
                if ((n2 & 0x400) != 0 && i > 0) {
                    stringBuffer.append(",");
                }
                if (this.ranges[i] == this.ranges[i + 1]) {
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i]));
                    continue;
                }
                stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i]));
                stringBuffer.append('-');
                stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i + 1]));
            }
            stringBuffer.append("]");
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static String escapeCharInCharClass(int n2) {
        String string2;
        switch (n2) {
            case 44: 
            case 45: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                string2 = "\\" + (char)n2;
                break;
            }
            case 12: {
                string2 = "\\f";
                break;
            }
            case 10: {
                string2 = "\\n";
                break;
            }
            case 13: {
                string2 = "\\r";
                break;
            }
            case 9: {
                string2 = "\\t";
                break;
            }
            case 27: {
                string2 = "\\e";
                break;
            }
            default: {
                if (n2 < 32) {
                    String string3 = "0" + Integer.toHexString(n2);
                    string2 = "\\x" + string3.substring(string3.length() - 2, string3.length());
                    break;
                }
                if (n2 >= 65536) {
                    String string4 = "0" + Integer.toHexString(n2);
                    string2 = "\\v" + string4.substring(string4.length() - 6, string4.length());
                    break;
                }
                string2 = "" + (char)n2;
            }
        }
        return string2;
    }
}

