/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.Duration2;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.AbstractDurationImpl;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.SerializedDuration;
import com.ibm.xml.xml4j.internal.s1.util.DatatypeMessageFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.Duration;

final class DurationImpl
extends AbstractDurationImpl
implements Serializable {
    private static final long serialVersionUID = -2650025807136350131L;
    private final int sign;
    private final BigInteger years;
    private final BigInteger months;
    private final BigInteger days;
    private final BigInteger hours;
    private final BigInteger minutes;
    private final BigDecimal seconds;

    public DurationImpl(int n2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
        this.sign = n2;
        if (bigInteger != null && bigInteger.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{bigInteger}));
        }
        this.years = bigInteger;
        if (bigInteger2 != null && bigInteger2.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{bigInteger2}));
        }
        this.months = bigInteger2;
        if (bigInteger3 != null && bigInteger3.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{bigInteger3}));
        }
        this.days = bigInteger3;
        if (bigInteger4 != null && bigInteger4.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{bigInteger4}));
        }
        this.hours = bigInteger4;
        if (bigInteger5 != null && bigInteger5.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{bigInteger5}));
        }
        this.minutes = bigInteger5;
        if (bigDecimal != null && bigDecimal.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{bigDecimal}));
        }
        this.seconds = bigDecimal;
    }

    public DurationImpl(long l) {
        boolean bl = false;
        if (l == 0L) {
            this.sign = 0;
            this.years = null;
            this.months = null;
            this.days = null;
            this.hours = null;
            this.minutes = null;
            this.seconds = null;
            return;
        }
        if (l < 0L) {
            this.sign = -1;
            if (l == Long.MIN_VALUE) {
                ++l;
                bl = true;
            }
            l *= -1L;
        } else {
            this.sign = 1;
        }
        this.years = null;
        this.months = null;
        long l2 = l / 86400000L;
        this.days = l2 != 0L ? BigInteger.valueOf(l2) : null;
        l -= l2 * 86400000L;
        l2 = l / 3600000L;
        this.hours = l2 != 0L ? BigInteger.valueOf(l2) : null;
        l -= l2 * 3600000L;
        l2 = l / 60000L;
        this.minutes = l2 != 0L ? BigInteger.valueOf(l2) : null;
        l -= l2 * 60000L;
        if (bl) {
            ++l;
        }
        this.seconds = BigDecimal.valueOf(l, 3);
    }

    public DurationImpl(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) throws UnsupportedOperationException, IllegalArgumentException {
        if (bigInteger != null && bigInteger.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{bigInteger}));
        }
        this.years = bigInteger;
        if (bigInteger2 != null && bigInteger2.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{bigInteger2}));
        }
        this.months = bigInteger2;
        if (bigInteger3 != null && bigInteger3.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{bigInteger3}));
        }
        this.days = bigInteger3;
        if (bigInteger4 != null && bigInteger4.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{bigInteger4}));
        }
        this.hours = bigInteger4;
        if (bigInteger5 != null && bigInteger5.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{bigInteger5}));
        }
        this.minutes = bigInteger5;
        if (bigDecimal != null && bigDecimal.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{bigDecimal}));
        }
        this.seconds = bigDecimal;
        this.sign = !(bigInteger != null && bigInteger.signum() != 0 || bigInteger2 != null && bigInteger2.signum() != 0 || bigInteger3 != null && bigInteger3.signum() != 0 || bigInteger4 != null && bigInteger4.signum() != 0 || bigInteger5 != null && bigInteger5.signum() != 0 || bigDecimal != null && bigDecimal.signum() != 0) ? 0 : (bl ? 1 : -1);
    }

    public DurationImpl(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal, boolean bl) throws UnsupportedOperationException, IllegalArgumentException {
        this.years = bigInteger;
        this.months = bigInteger2;
        this.days = bigInteger3;
        this.hours = bigInteger4;
        this.minutes = bigInteger5;
        this.seconds = bigDecimal;
        this.sign = !(bigInteger != null && bigInteger.signum() != 0 || bigInteger2 != null && bigInteger2.signum() != 0 || bigInteger3 != null && bigInteger3.signum() != 0 || bigInteger4 != null && bigInteger4.signum() != 0 || bigInteger5 != null && bigInteger5.signum() != 0 || bigDecimal != null && bigDecimal.signum() != 0) ? 0 : (bl ? 1 : -1);
    }

    public int getSign() {
        return this.sign;
    }

    BigInteger getYearsField() {
        return this.years;
    }

    BigInteger getMonthsField() {
        return this.months;
    }

    BigInteger getDaysField() {
        return this.days;
    }

    BigInteger getHoursField() {
        return this.hours;
    }

    BigInteger getMinutesField() {
        return this.minutes;
    }

    BigDecimal getSecondsField() {
        return this.seconds;
    }

    public int getYears() {
        return this.years != null ? this.years.intValue() : 0;
    }

    public int getMonths() {
        return this.months != null ? this.months.intValue() : 0;
    }

    public int getDays() {
        return this.days != null ? this.days.intValue() : 0;
    }

    public int getHours() {
        return this.hours != null ? this.hours.intValue() : 0;
    }

    public int getMinutes() {
        return this.minutes != null ? this.minutes.intValue() : 0;
    }

    public int getSeconds() {
        return this.seconds != null ? this.seconds.intValue() : 0;
    }

    boolean isYearsSet() {
        return this.years != null;
    }

    boolean isMonthsSet() {
        return this.months != null;
    }

    boolean isDaysSet() {
        return this.days != null;
    }

    boolean isHoursSet() {
        return this.hours != null;
    }

    boolean isMinutesSet() {
        return this.minutes != null;
    }

    boolean isSecondsSet() {
        return this.seconds != null;
    }

    public Duration negate() {
        return new DurationImpl(-1 * this.sign, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public Duration normalizeWith(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, this.sign * this.getYears());
        calendar2.add(2, this.sign * this.getMonths());
        calendar2.add(5, this.sign * this.getDays());
        long l = calendar2.getTime().getTime() - calendar.getTime().getTime();
        int n2 = (int)(l / 86400000L);
        int n3 = 1;
        if (!(n2 != 0 || this.hours != null && this.hours.signum() != 0 || this.minutes != null && this.minutes.signum() != 0 || this.seconds != null && this.seconds.signum() != 0)) {
            n3 = 0;
        } else if (n2 < 0) {
            n3 = -1;
        }
        return new DurationImpl(n3, null, null, BigInteger.valueOf(n2).abs(), this.hours, this.minutes, this.seconds);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.sign == -1) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        if (this.years != null) {
            stringBuilder.append(this.years);
            stringBuilder.append('Y');
        }
        if (this.months != null) {
            stringBuilder.append(this.months);
            stringBuilder.append('M');
        }
        if (this.days != null) {
            stringBuilder.append(this.days);
            stringBuilder.append('D');
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            stringBuilder.append('T');
            if (this.hours != null) {
                stringBuilder.append(this.hours);
                stringBuilder.append('H');
            }
            if (this.minutes != null) {
                stringBuilder.append(this.minutes);
                stringBuilder.append('M');
            }
            if (this.seconds != null) {
                stringBuilder.append(this.toString(this.seconds));
                stringBuilder.append('S');
            }
        }
        return stringBuilder.toString();
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuilder stringBuilder;
        String string2 = bigDecimal.unscaledValue().toString();
        int n2 = bigDecimal.scale();
        if (n2 == 0) {
            return string2;
        }
        int n3 = string2.length() - n2;
        if (n3 == 0) {
            return "0." + string2;
        }
        if (n3 > 0) {
            stringBuilder = new StringBuilder(string2);
            stringBuilder.insert(n3, '.');
        } else {
            stringBuilder = new StringBuilder(3 - n3 + string2.length());
            stringBuilder.append("0.");
            for (int i = 0; i < -n3; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    BigDecimal[] createBigDecimalArray() {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this.years != null ? new BigDecimal(this.years) : ZERO, this.months != null ? new BigDecimal(this.months) : ZERO, this.days != null ? new BigDecimal(this.days) : ZERO, this.hours != null ? new BigDecimal(this.hours) : ZERO, this.minutes != null ? new BigDecimal(this.minutes) : ZERO, this.seconds != null ? this.seconds : ZERO};
        return bigDecimalArray;
    }

    private Object writeReplace() throws IOException {
        return new SerializedDuration(this.toString());
    }

    public boolean areFieldsPrimitive() {
        return false;
    }

    public boolean hasFractionalSeconds() {
        return this.seconds != null && this.seconds.toPlainString().indexOf(46) != -1;
    }

    public Duration2 asDurationYearMonth() {
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return ZERO_MONTHS;
        }
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return this;
        }
        return new DurationImpl(this.sign >= 0, this.years, this.months, null, null, null, null);
    }

    public Duration2 asDurationDayTime() {
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return ZERO_SECONDS;
        }
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return this;
        }
        return new DurationImpl(this.sign >= 0, null, null, this.days, this.hours, this.minutes, this.seconds);
    }

    public String toFOFormat() {
        boolean bl;
        Object object2;
        Object object3;
        Object object4;
        if (this.sign == 0) {
            return this.toZeroDurationFOStringFormat();
        }
        int n2 = 0;
        BigDecimal bigDecimal = ZERO;
        BigInteger bigInteger = I_ZERO;
        if (this.seconds != null) {
            BigInteger bigInteger2 = this.seconds.toBigInteger();
            bigDecimal = bigInteger2.compareTo(I_ZERO) > 0 ? this.seconds.subtract(new BigDecimal(bigInteger2)) : this.seconds;
            object4 = bigInteger2.divideAndRemainder(I_SIXTY);
            n2 = object4[1].intValue();
            bigInteger = object4[0];
        }
        int n3 = 0;
        object4 = I_ZERO;
        if (this.minutes != null) {
            bigInteger = this.minutes.add(bigInteger);
        }
        if (bigInteger.compareTo(I_ZERO) > 0) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(I_SIXTY);
            n3 = bigIntegerArray[1].intValue();
            object4 = bigIntegerArray[0];
        }
        int n4 = 0;
        BigInteger bigInteger3 = I_ZERO;
        if (this.hours != null) {
            object4 = this.hours.add((BigInteger)object4);
        }
        if (object4.compareTo(I_ZERO) > 0) {
            object3 = object4.divideAndRemainder(TWENTY_FOUR);
            n4 = object3[1].intValue();
            bigInteger3 = object3[0];
        }
        object3 = this.days != null ? this.days.add(bigInteger3) : bigInteger3;
        int n5 = 0;
        BigInteger bigInteger4 = I_ZERO;
        if (this.months != null) {
            object2 = this.months.divideAndRemainder(TWELVE);
            n5 = object2[1].intValue();
            bigInteger4 = object2[0];
        }
        object2 = this.years != null ? this.years.add(bigInteger4) : bigInteger4;
        StringBuilder stringBuilder = new StringBuilder(30);
        if (this.sign == -1) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        if (((BigInteger)object2).compareTo(I_ZERO) > 0) {
            stringBuilder.append(object2);
            stringBuilder.append('Y');
        }
        if (n5 > 0) {
            stringBuilder.append(n5);
            stringBuilder.append('M');
        }
        if (((BigInteger)object3).compareTo(I_ZERO) > 0) {
            stringBuilder.append(object3);
            stringBuilder.append('D');
        }
        boolean bl2 = bl = bigDecimal.compareTo(ZERO) > 0;
        if (n4 > 0 || n3 > 0 || n2 > 0 || bl) {
            stringBuilder.append('T');
            if (n4 > 0) {
                stringBuilder.append(n4);
                stringBuilder.append('H');
            }
            if (n3 > 0) {
                stringBuilder.append(n3);
                stringBuilder.append('M');
            }
            if (n2 > 0) {
                stringBuilder.append(n2);
                if (bl) {
                    stringBuilder.append(bigDecimal.stripTrailingZeros().toPlainString().substring(1));
                }
                stringBuilder.append('S');
            } else if (bl) {
                stringBuilder.append(bigDecimal.stripTrailingZeros().toPlainString());
                stringBuilder.append('S');
            }
        }
        return stringBuilder.toString();
    }
}

