/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.jaxp.validation;

import com.ibm.xml.xml4j.internal.s1.impl.xs.XMLSchemaLoader;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.AbstractXMLSchema;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.DraconianErrorHandler;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.EmptyXMLSchema;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.JAXPValidationMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.ReadOnlyGrammarPool;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.SimpleXMLSchema;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.Util;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.WeakReferenceXMLSchema;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.XMLSchema;
import com.ibm.xml.xml4j.internal.s1.util.DOMEntityResolverWrapper;
import com.ibm.xml.xml4j.internal.s1.util.DOMInputSource;
import com.ibm.xml.xml4j.internal.s1.util.ErrorHandlerWrapper;
import com.ibm.xml.xml4j.internal.s1.util.SAXInputSource;
import com.ibm.xml.xml4j.internal.s1.util.SAXMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.util.SecurityManager;
import com.ibm.xml.xml4j.internal.s1.util.StAXInputSource;
import com.ibm.xml.xml4j.internal.s1.util.XMLGrammarPoolImpl;
import com.ibm.xml.xml4j.internal.s1.xni.XNIException;
import com.ibm.xml.xml4j.internal.s1.xni.grammars.Grammar;
import com.ibm.xml.xml4j.internal.s1.xni.grammars.XMLGrammarDescription;
import com.ibm.xml.xml4j.internal.s1.xni.grammars.XMLGrammarPool;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLConfigurationException;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLEventReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public final class XMLSchemaFactory
extends SchemaFactory {
    private static final String JAXP_SOURCE_FEATURE_PREFIX = "http://javax.xml.transform";
    private static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private final XMLSchemaLoader fXMLSchemaLoader = new XMLSchemaLoader();
    private ErrorHandler fErrorHandler;
    private LSResourceResolver fLSResourceResolver;
    private final DOMEntityResolverWrapper fDOMEntityResolverWrapper;
    private final ErrorHandlerWrapper fErrorHandlerWrapper = new ErrorHandlerWrapper(DraconianErrorHandler.getInstance());
    private SecurityManager fSecurityManager;
    private final XMLGrammarPoolWrapper fXMLGrammarPoolWrapper;
    private boolean fUseGrammarPoolOnly;

    public XMLSchemaFactory() {
        this.fDOMEntityResolverWrapper = new DOMEntityResolverWrapper();
        this.fXMLGrammarPoolWrapper = new XMLGrammarPoolWrapper();
        this.fXMLSchemaLoader.setFeature(SCHEMA_FULL_CHECKING, true);
        this.fXMLSchemaLoader.setProperty(XMLGRAMMAR_POOL, this.fXMLGrammarPoolWrapper);
        this.fXMLSchemaLoader.setEntityResolver(this.fDOMEntityResolverWrapper);
        this.fXMLSchemaLoader.setErrorHandler(this.fErrorHandlerWrapper);
        this.fUseGrammarPoolOnly = true;
    }

    public boolean isSchemaLanguageSupported(String string2) {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaLanguageNull", null));
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaLanguageLengthZero", null));
        }
        return string2.equals("http://www.w3.org/2001/XMLSchema");
    }

    public LSResourceResolver getResourceResolver() {
        return this.fLSResourceResolver;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.fLSResourceResolver = lSResourceResolver;
        this.fDOMEntityResolverWrapper.setEntityResolver(lSResourceResolver);
        this.fXMLSchemaLoader.setEntityResolver(this.fDOMEntityResolverWrapper);
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
        this.fErrorHandlerWrapper.setErrorHandler(errorHandler != null ? errorHandler : DraconianErrorHandler.getInstance());
        this.fXMLSchemaLoader.setErrorHandler(this.fErrorHandlerWrapper);
    }

    public Schema newSchema(Source[] sourceArray) throws SAXException {
        Source source;
        Object object2;
        int n2;
        XMLGrammarPoolImplExtension xMLGrammarPoolImplExtension = new XMLGrammarPoolImplExtension();
        this.fXMLGrammarPoolWrapper.setGrammarPool(xMLGrammarPoolImplExtension);
        XMLInputSource[] xMLInputSourceArray = new XMLInputSource[sourceArray.length];
        for (n2 = 0; n2 < sourceArray.length; ++n2) {
            String string2;
            Object object3;
            object2 = sourceArray[n2];
            if (object2 instanceof StreamSource) {
                source = (StreamSource)object2;
                object3 = ((StreamSource)source).getPublicId();
                string2 = ((StreamSource)source).getSystemId();
                InputStream inputStream = ((StreamSource)source).getInputStream();
                Reader reader = ((StreamSource)source).getReader();
                xMLInputSourceArray[n2] = new XMLInputSource((String)object3, string2, null);
                xMLInputSourceArray[n2].setByteStream(inputStream);
                xMLInputSourceArray[n2].setCharacterStream(reader);
                continue;
            }
            if (object2 instanceof SAXSource) {
                source = (SAXSource)object2;
                object3 = ((SAXSource)source).getInputSource();
                if (object3 == null) {
                    throw new SAXException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SAXSourceNullInputSource", null));
                }
                xMLInputSourceArray[n2] = new SAXInputSource(((SAXSource)source).getXMLReader(), (InputSource)object3);
                continue;
            }
            if (object2 instanceof DOMSource) {
                source = (DOMSource)object2;
                object3 = ((DOMSource)source).getNode();
                string2 = ((DOMSource)source).getSystemId();
                xMLInputSourceArray[n2] = new DOMInputSource((Node)object3, string2);
                continue;
            }
            if (object2 instanceof StAXSource) {
                source = (StAXSource)object2;
                object3 = ((StAXSource)source).getXMLEventReader();
                if (object3 != null) {
                    xMLInputSourceArray[n2] = new StAXInputSource((XMLEventReader)object3);
                    continue;
                }
                xMLInputSourceArray[n2] = new StAXInputSource(((StAXSource)source).getXMLStreamReader());
                continue;
            }
            if (object2 == null) {
                throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaSourceArrayMemberNull", null));
            }
            throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "SchemaFactorySourceUnrecognized", new Object[]{object2.getClass().getName()}));
        }
        try {
            this.fXMLSchemaLoader.loadGrammar(xMLInputSourceArray);
        }
        catch (XNIException xNIException) {
            throw Util.toSAXException(xNIException);
        }
        catch (IOException iOException) {
            object2 = new SAXParseException(iOException.getMessage(), null, iOException);
            if (this.fErrorHandler != null) {
                this.fErrorHandler.error((SAXParseException)object2);
            }
            throw object2;
        }
        this.fXMLGrammarPoolWrapper.setGrammarPool(null);
        n2 = xMLGrammarPoolImplExtension.getGrammarCount();
        object2 = null;
        if (this.fUseGrammarPoolOnly) {
            if (n2 > 1) {
                object2 = new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPoolImplExtension));
            } else if (n2 == 1) {
                source = xMLGrammarPoolImplExtension.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
                object2 = new SimpleXMLSchema((Grammar)((Object)source[0]));
            } else {
                object2 = new EmptyXMLSchema();
            }
        } else {
            object2 = new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPoolImplExtension), false);
        }
        this.propagateFeatures((AbstractXMLSchema)object2);
        return object2;
    }

    public Schema newSchema() throws SAXException {
        WeakReferenceXMLSchema weakReferenceXMLSchema = new WeakReferenceXMLSchema();
        this.propagateFeatures(weakReferenceXMLSchema);
        return weakReferenceXMLSchema;
    }

    public Schema newSchema(XMLGrammarPool xMLGrammarPool) throws SAXException {
        XMLSchema xMLSchema = this.fUseGrammarPoolOnly ? new XMLSchema(new ReadOnlyGrammarPool(xMLGrammarPool)) : new XMLSchema(xMLGrammarPool, false);
        this.propagateFeatures(xMLSchema);
        return xMLSchema;
    }

    public boolean getFeature(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "FeatureNameNull", null));
        }
        if (string2.startsWith(JAXP_SOURCE_FEATURE_PREFIX) && (string2.equals("http://javax.xml.transform.stream.StreamSource/feature") || string2.equals("http://javax.xml.transform.sax.SAXSource/feature") || string2.equals("http://javax.xml.transform.dom.DOMSource/feature") || string2.equals("http://javax.xml.transform.stax.StAXSource/feature"))) {
            return true;
        }
        if (string2.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fSecurityManager != null;
        }
        if (string2.equals(USE_GRAMMAR_POOL_ONLY)) {
            return this.fUseGrammarPoolOnly;
        }
        try {
            return this.fXMLSchemaLoader.getFeature(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-supported", new Object[]{string3}));
        }
    }

    public Object getProperty(String string2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "ProperyNameNull", null));
        }
        if (string2.equals(SECURITY_MANAGER)) {
            return this.fSecurityManager;
        }
        if (string2.equals(XMLGRAMMAR_POOL)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string2}));
        }
        try {
            return this.fXMLSchemaLoader.getProperty(string2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string3}));
        }
    }

    public void setFeature(String string2, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "FeatureNameNull", null));
        }
        if (string2.startsWith(JAXP_SOURCE_FEATURE_PREFIX) && (string2.equals("http://javax.xml.transform.stream.StreamSource/feature") || string2.equals("http://javax.xml.transform.sax.SAXSource/feature") || string2.equals("http://javax.xml.transform.dom.DOMSource/feature") || string2.equals("http://javax.xml.transform.stax.StAXSource/feature"))) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-read-only", new Object[]{string2}));
        }
        if (string2.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.fSecurityManager = bl ? new SecurityManager() : null;
            this.fXMLSchemaLoader.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (string2.equals(USE_GRAMMAR_POOL_ONLY)) {
            this.fUseGrammarPoolOnly = bl;
            return;
        }
        try {
            this.fXMLSchemaLoader.setFeature(string2, bl);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "feature-not-supported", new Object[]{string3}));
        }
    }

    public void setProperty(String string2, Object object2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string2 == null) {
            throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "ProperyNameNull", null));
        }
        if (string2.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = (SecurityManager)object2;
            this.fXMLSchemaLoader.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (string2.equals(XMLGRAMMAR_POOL)) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string2}));
        }
        try {
            this.fXMLSchemaLoader.setProperty(string2, object2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string3 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-recognized", new Object[]{string3}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fXMLSchemaLoader.getLocale(), "property-not-supported", new Object[]{string3}));
        }
    }

    private void propagateFeatures(AbstractXMLSchema abstractXMLSchema) {
        abstractXMLSchema.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", this.fSecurityManager != null);
        String[] stringArray = this.fXMLSchemaLoader.getRecognizedFeatures();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = this.fXMLSchemaLoader.getFeature(stringArray[i]);
            abstractXMLSchema.setFeature(stringArray[i], bl);
        }
    }

    static class XMLGrammarPoolWrapper
    implements XMLGrammarPool {
        private XMLGrammarPool fGrammarPool;

        XMLGrammarPoolWrapper() {
        }

        public Grammar[] retrieveInitialGrammarSet(String string2) {
            return this.fGrammarPool.retrieveInitialGrammarSet(string2);
        }

        public void cacheGrammars(String string2, Grammar[] grammarArray) {
            this.fGrammarPool.cacheGrammars(string2, grammarArray);
        }

        public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
            return this.fGrammarPool.retrieveGrammar(xMLGrammarDescription);
        }

        public void lockPool() {
            this.fGrammarPool.lockPool();
        }

        public void unlockPool() {
            this.fGrammarPool.unlockPool();
        }

        public void clear() {
            this.fGrammarPool.clear();
        }

        void setGrammarPool(XMLGrammarPool xMLGrammarPool) {
            this.fGrammarPool = xMLGrammarPool;
        }

        XMLGrammarPool getGrammarPool() {
            return this.fGrammarPool;
        }
    }

    static class XMLGrammarPoolImplExtension
    extends XMLGrammarPoolImpl {
        public XMLGrammarPoolImplExtension() {
        }

        public XMLGrammarPoolImplExtension(int n2) {
            super(n2);
        }

        int getGrammarCount() {
            return this.fGrammarCount;
        }
    }
}

