/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.apps;

import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XParseError
implements ErrorHandler {
    private boolean showErrors = true;
    private boolean showWarnings = false;
    private int maxMessages = 10;
    private int fatalCount = 0;
    private int errorCount = 0;
    private int warningCount = 0;
    private String baseURI = "";

    public XParseError(boolean bl, boolean bl2) {
        this.showErrors = bl;
        this.showWarnings = bl2;
        String string2 = System.getProperty("user.dir");
        String string3 = "";
        string3 = string2.endsWith("/") ? "file:" + string2 + "file" : "file:" + string2 + "/" + string3;
        try {
            URL uRL = new URL(string3);
            this.baseURI = uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalCount() {
        return this.fatalCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int n2) {
        this.maxMessages = n2;
    }

    public void error(SAXParseException sAXParseException) {
        if (this.showErrors) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Error", sAXParseException);
            }
            ++this.errorCount;
        }
    }

    public void fatalError(SAXParseException sAXParseException) {
        if (this.showErrors) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Fatal error", sAXParseException);
            }
            ++this.errorCount;
            ++this.fatalCount;
        }
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.showWarnings) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Warning", sAXParseException);
            }
            ++this.warningCount;
        }
    }

    private void message(String string2, SAXParseException sAXParseException) {
        String string3 = sAXParseException.getSystemId();
        if (string3.startsWith(this.baseURI)) {
            string3 = string3.substring(this.baseURI.length());
        }
        System.out.print(string2 + ":" + string3 + ":" + sAXParseException.getLineNumber());
        if (sAXParseException.getColumnNumber() > 0) {
            System.out.print(":" + sAXParseException.getColumnNumber());
        }
        System.out.println(":" + sAXParseException.getMessage());
    }
}

