/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.helpers;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BootstrapResolver
implements EntityResolver,
URIResolver {
    public static final String xmlCatalogXSD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd";
    public static final String xmlCatalogRNG = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng";
    public static final String xmlCatalogPubId = "-//OASIS//DTD XML Catalogs V1.0//EN";
    public static final String xmlCatalogSysId = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd";
    private Hashtable publicMap = new Hashtable();
    private Hashtable systemMap = new Hashtable();
    private Hashtable uriMap = new Hashtable();

    public BootstrapResolver() {
        URL uRL = this.getClass().getResource("/org/apache/xml/resolver/etc/catalog.dtd");
        if (uRL != null) {
            this.publicMap.put(xmlCatalogPubId, uRL.toString());
            this.systemMap.put(xmlCatalogSysId, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/org/apache/xml/resolver/etc/catalog.rng")) != null) {
            this.uriMap.put(xmlCatalogRNG, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/org/apache/xml/resolver/etc/catalog.xsd")) != null) {
            this.uriMap.put(xmlCatalogXSD, uRL.toString());
        }
    }

    public InputSource resolveEntity(String string2, String string3) {
        String string4 = null;
        if (string3 != null && this.systemMap.containsKey(string3)) {
            string4 = (String)this.systemMap.get(string3);
        } else if (string2 != null && this.publicMap.containsKey(string2)) {
            string4 = (String)this.publicMap.get(string2);
        }
        if (string4 != null) {
            try {
                InputSource inputSource = new InputSource(string4);
                inputSource.setPublicId(string2);
                URL uRL = new URL(string4);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public Source resolve(String string2, String string3) throws TransformerException {
        Object object2;
        String string4 = string2;
        String string5 = null;
        int n2 = string2.indexOf("#");
        if (n2 >= 0) {
            string4 = string2.substring(0, n2);
            string5 = string2.substring(n2 + 1);
        }
        String string6 = null;
        if (string2 != null && this.uriMap.containsKey(string2)) {
            string6 = (String)this.uriMap.get(string2);
        }
        if (string6 == null) {
            try {
                object2 = null;
                if (string3 == null) {
                    object2 = new URL(string4);
                    string6 = ((URL)object2).toString();
                } else {
                    URL uRL = new URL(string3);
                    object2 = string2.length() == 0 ? uRL : new URL(uRL, string4);
                    string6 = ((URL)object2).toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string7 = this.makeAbsolute(string3);
                if (!string7.equals(string3)) {
                    return this.resolve(string2, string7);
                }
                throw new TransformerException("Malformed URL " + string2 + "(base " + string3 + ")", malformedURLException);
            }
        }
        object2 = new SAXSource();
        ((SAXSource)object2).setInputSource(new InputSource(string6));
        return object2;
    }

    private String makeAbsolute(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        try {
            URL uRL = new URL(string2);
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = System.getProperty("user.dir");
            String string4 = "";
            string4 = string3.endsWith("/") ? "file://" + string3 + string2 : "file://" + string3 + "/" + string2;
            try {
                URL uRL = new URL(string4);
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string2;
            }
        }
    }
}

