/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.readers;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogException;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.Namespaces;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.CatalogReader;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.DOMCatalogParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMCatalogReader
implements CatalogReader {
    protected Hashtable namespaceMap = new Hashtable();

    public void setCatalogParser(String string2, String string3, String string4) {
        if (string2 == null) {
            this.namespaceMap.put(string3, string4);
        } else {
            this.namespaceMap.put("{" + string2 + "}" + string3, string4);
        }
    }

    public String getCatalogParser(String string2, String string3) {
        if (string2 == null) {
            return (String)this.namespaceMap.get(string3);
        }
        return (String)this.namespaceMap.get("{" + string2 + "}" + string3);
    }

    public void readCatalog(Catalog catalog, InputStream inputStream) throws IOException, CatalogException {
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CatalogException(6);
        }
        Document document2 = null;
        try {
            document2 = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new CatalogException(5);
        }
        Element element2 = document2.getDocumentElement();
        String string2 = Namespaces.getNamespaceURI(element2);
        String string3 = Namespaces.getLocalName(element2);
        String string4 = this.getCatalogParser(string2, string3);
        if (string4 == null) {
            if (string2 == null) {
                catalog.getCatalogManager().debug.message(1, "No Catalog parser for " + string3);
            } else {
                catalog.getCatalogManager().debug.message(1, "No Catalog parser for {" + string2 + "}" + string3);
            }
            return;
        }
        DOMCatalogParser dOMCatalogParser = null;
        try {
            dOMCatalogParser = (DOMCatalogParser)Class.forName(string4).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            catalog.getCatalogManager().debug.message(1, "Cannot load XML Catalog Parser class", string4);
            throw new CatalogException(6);
        }
        catch (InstantiationException instantiationException) {
            catalog.getCatalogManager().debug.message(1, "Cannot instantiate XML Catalog Parser class", string4);
            throw new CatalogException(6);
        }
        catch (IllegalAccessException illegalAccessException) {
            catalog.getCatalogManager().debug.message(1, "Cannot access XML Catalog Parser class", string4);
            throw new CatalogException(6);
        }
        catch (ClassCastException classCastException) {
            catalog.getCatalogManager().debug.message(1, "Cannot cast XML Catalog Parser class", string4);
            throw new CatalogException(6);
        }
        for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            dOMCatalogParser.parseCatalogEntry(catalog, node2);
        }
    }

    public void readCatalog(Catalog catalog, String string2) throws MalformedURLException, IOException, CatalogException {
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        this.readCatalog(catalog, uRLConnection.getInputStream());
    }
}

