/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.readers;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogEntry;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogException;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.PublicId;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.SAXCatalogParser;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.SAXCatalogReader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OASISXMLCatalogReader
extends SAXCatalogReader
implements SAXCatalogParser {
    protected Catalog catalog = null;
    public static final String namespaceName = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String tr9401NamespaceName = "urn:oasis:names:tc:entity:xmlns:tr9401:catalog";
    protected Stack baseURIStack = new Stack();
    protected Stack overrideStack = new Stack();
    protected Stack namespaceStack = new Stack();

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
        this.debug = catalog.getCatalogManager().debug;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    protected boolean inExtensionNamespace() {
        boolean bl = false;
        Enumeration enumeration = this.namespaceStack.elements();
        while (!bl && enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null) {
                bl = true;
                continue;
            }
            bl = !string2.equals(tr9401NamespaceName) && !string2.equals(namespaceName);
        }
        return bl;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.baseURIStack.push(this.catalog.getCurrentBase());
        this.overrideStack.push(this.catalog.getDefaultOverride());
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        block75: {
            CatalogEntry catalogEntry;
            Object object2;
            boolean bl;
            Vector<String> vector;
            int n2;
            block73: {
                n2 = -1;
                vector = new Vector<String>();
                this.namespaceStack.push(string2);
                bl = this.inExtensionNamespace();
                if (string2 != null && namespaceName.equals(string2) && !bl) {
                    if (attributes2.getValue("xml:base") != null) {
                        block71: {
                            object2 = attributes2.getValue("xml:base");
                            n2 = Catalog.BASE;
                            vector.add((String)object2);
                            this.baseURIStack.push(object2);
                            this.debug.message(4, "xml:base", (String)object2);
                            try {
                                catalogEntry = new CatalogEntry(n2, vector);
                                this.catalog.addEntry(catalogEntry);
                            }
                            catch (CatalogException catalogException) {
                                if (catalogException.getExceptionType() == 3) {
                                    this.debug.message(1, "Invalid catalog entry type", string3);
                                }
                                if (catalogException.getExceptionType() != 2) break block71;
                                this.debug.message(1, "Invalid catalog entry (base)", string3);
                            }
                        }
                        n2 = -1;
                        vector = new Vector();
                    } else {
                        this.baseURIStack.push(this.baseURIStack.peek());
                    }
                    if ((string3.equals("catalog") || string3.equals("group")) && attributes2.getValue("prefer") != null) {
                        block72: {
                            object2 = attributes2.getValue("prefer");
                            if (((String)object2).equals("public")) {
                                object2 = "yes";
                            } else if (((String)object2).equals("system")) {
                                object2 = "no";
                            } else {
                                this.debug.message(1, "Invalid prefer: must be 'system' or 'public'", string3);
                                object2 = this.catalog.getDefaultOverride();
                            }
                            n2 = Catalog.OVERRIDE;
                            vector.add((String)object2);
                            this.overrideStack.push(object2);
                            this.debug.message(4, "override", (String)object2);
                            try {
                                catalogEntry = new CatalogEntry(n2, vector);
                                this.catalog.addEntry(catalogEntry);
                            }
                            catch (CatalogException catalogException) {
                                if (catalogException.getExceptionType() == 3) {
                                    this.debug.message(1, "Invalid catalog entry type", string3);
                                }
                                if (catalogException.getExceptionType() != 2) break block72;
                                this.debug.message(1, "Invalid catalog entry (override)", string3);
                            }
                        }
                        n2 = -1;
                        vector = new Vector();
                    } else {
                        this.overrideStack.push(this.overrideStack.peek());
                    }
                    if (string3.equals("delegatePublic")) {
                        if (this.checkAttributes(attributes2, "publicIdStartString", "catalog")) {
                            n2 = Catalog.DELEGATE_PUBLIC;
                            vector.add(attributes2.getValue("publicIdStartString"));
                            vector.add(attributes2.getValue("catalog"));
                            this.debug.message(4, "delegatePublic", PublicId.normalize(attributes2.getValue("publicIdStartString")), attributes2.getValue("catalog"));
                        }
                    } else if (string3.equals("delegateSystem")) {
                        if (this.checkAttributes(attributes2, "systemIdStartString", "catalog")) {
                            n2 = Catalog.DELEGATE_SYSTEM;
                            vector.add(attributes2.getValue("systemIdStartString"));
                            vector.add(attributes2.getValue("catalog"));
                            this.debug.message(4, "delegateSystem", attributes2.getValue("systemIdStartString"), attributes2.getValue("catalog"));
                        }
                    } else if (string3.equals("delegateURI")) {
                        if (this.checkAttributes(attributes2, "uriStartString", "catalog")) {
                            n2 = Catalog.DELEGATE_URI;
                            vector.add(attributes2.getValue("uriStartString"));
                            vector.add(attributes2.getValue("catalog"));
                            this.debug.message(4, "delegateURI", attributes2.getValue("uriStartString"), attributes2.getValue("catalog"));
                        }
                    } else if (string3.equals("rewriteSystem")) {
                        if (this.checkAttributes(attributes2, "systemIdStartString", "rewritePrefix")) {
                            n2 = Catalog.REWRITE_SYSTEM;
                            vector.add(attributes2.getValue("systemIdStartString"));
                            vector.add(attributes2.getValue("rewritePrefix"));
                            this.debug.message(4, "rewriteSystem", attributes2.getValue("systemIdStartString"), attributes2.getValue("rewritePrefix"));
                        }
                    } else if (string3.equals("rewriteURI")) {
                        if (this.checkAttributes(attributes2, "uriStartString", "rewritePrefix")) {
                            n2 = Catalog.REWRITE_URI;
                            vector.add(attributes2.getValue("uriStartString"));
                            vector.add(attributes2.getValue("rewritePrefix"));
                            this.debug.message(4, "rewriteURI", attributes2.getValue("uriStartString"), attributes2.getValue("rewritePrefix"));
                        }
                    } else if (string3.equals("nextCatalog")) {
                        if (this.checkAttributes(attributes2, "catalog")) {
                            n2 = Catalog.CATALOG;
                            vector.add(attributes2.getValue("catalog"));
                            this.debug.message(4, "nextCatalog", attributes2.getValue("catalog"));
                        }
                    } else if (string3.equals("public")) {
                        if (this.checkAttributes(attributes2, "publicId", "uri")) {
                            n2 = Catalog.PUBLIC;
                            vector.add(attributes2.getValue("publicId"));
                            vector.add(attributes2.getValue("uri"));
                            this.debug.message(4, "public", PublicId.normalize(attributes2.getValue("publicId")), attributes2.getValue("uri"));
                        }
                    } else if (string3.equals("system")) {
                        if (this.checkAttributes(attributes2, "systemId", "uri")) {
                            n2 = Catalog.SYSTEM;
                            vector.add(attributes2.getValue("systemId"));
                            vector.add(attributes2.getValue("uri"));
                            this.debug.message(4, "system", attributes2.getValue("systemId"), attributes2.getValue("uri"));
                        }
                    } else if (string3.equals("uri")) {
                        if (this.checkAttributes(attributes2, "name", "uri")) {
                            n2 = Catalog.URI;
                            vector.add(attributes2.getValue("name"));
                            vector.add(attributes2.getValue("uri"));
                            this.debug.message(4, "uri", attributes2.getValue("name"), attributes2.getValue("uri"));
                        }
                    } else if (!string3.equals("catalog") && !string3.equals("group")) {
                        this.debug.message(1, "Invalid catalog entry type", string3);
                    }
                    if (n2 >= 0) {
                        try {
                            object2 = new CatalogEntry(n2, vector);
                            this.catalog.addEntry((CatalogEntry)object2);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string3);
                            }
                            if (catalogException.getExceptionType() != 2) break block73;
                            this.debug.message(1, "Invalid catalog entry", string3);
                        }
                    }
                }
            }
            if (string2 != null && tr9401NamespaceName.equals(string2) && !bl) {
                if (attributes2.getValue("xml:base") != null) {
                    block74: {
                        object2 = attributes2.getValue("xml:base");
                        n2 = Catalog.BASE;
                        vector.add((String)object2);
                        this.baseURIStack.push(object2);
                        this.debug.message(4, "xml:base", (String)object2);
                        try {
                            catalogEntry = new CatalogEntry(n2, vector);
                            this.catalog.addEntry(catalogEntry);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string3);
                            }
                            if (catalogException.getExceptionType() != 2) break block74;
                            this.debug.message(1, "Invalid catalog entry (base)", string3);
                        }
                    }
                    n2 = -1;
                    vector = new Vector();
                } else {
                    this.baseURIStack.push(this.baseURIStack.peek());
                }
                if (string3.equals("doctype")) {
                    n2 = Catalog.DOCTYPE;
                    vector.add(attributes2.getValue("name"));
                    vector.add(attributes2.getValue("uri"));
                } else if (string3.equals("document")) {
                    n2 = Catalog.DOCUMENT;
                    vector.add(attributes2.getValue("uri"));
                } else if (string3.equals("dtddecl")) {
                    n2 = Catalog.DTDDECL;
                    vector.add(attributes2.getValue("publicId"));
                    vector.add(attributes2.getValue("uri"));
                } else if (string3.equals("entity")) {
                    n2 = Catalog.ENTITY;
                    vector.add(attributes2.getValue("name"));
                    vector.add(attributes2.getValue("uri"));
                } else if (string3.equals("linktype")) {
                    n2 = Catalog.LINKTYPE;
                    vector.add(attributes2.getValue("name"));
                    vector.add(attributes2.getValue("uri"));
                } else if (string3.equals("notation")) {
                    n2 = Catalog.NOTATION;
                    vector.add(attributes2.getValue("name"));
                    vector.add(attributes2.getValue("uri"));
                } else if (string3.equals("sgmldecl")) {
                    n2 = Catalog.SGMLDECL;
                    vector.add(attributes2.getValue("uri"));
                } else {
                    this.debug.message(1, "Invalid catalog entry type", string3);
                }
                if (n2 >= 0) {
                    try {
                        object2 = new CatalogEntry(n2, vector);
                        this.catalog.addEntry((CatalogEntry)object2);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", string3);
                        }
                        if (catalogException.getExceptionType() != 2) break block75;
                        this.debug.message(1, "Invalid catalog entry", string3);
                    }
                }
            }
        }
    }

    public boolean checkAttributes(Attributes attributes2, String string2) {
        if (attributes2.getValue(string2) == null) {
            this.debug.message(1, "Error: required attribute " + string2 + " missing.");
            return false;
        }
        return true;
    }

    public boolean checkAttributes(Attributes attributes2, String string2, String string3) {
        return this.checkAttributes(attributes2, string2) && this.checkAttributes(attributes2, string3);
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        block11: {
            CatalogEntry catalogEntry;
            String string5;
            String string6;
            boolean bl;
            Vector<String> vector;
            int n2;
            block10: {
                n2 = -1;
                vector = new Vector<String>();
                bl = this.inExtensionNamespace();
                if (string2 != null && !bl && (namespaceName.equals(string2) || tr9401NamespaceName.equals(string2))) {
                    string6 = (String)this.baseURIStack.pop();
                    string5 = (String)this.baseURIStack.peek();
                    if (!string5.equals(string6)) {
                        n2 = Catalog.BASE;
                        vector.add(string5);
                        this.debug.message(4, "(reset) xml:base", string5);
                        try {
                            catalogEntry = new CatalogEntry(n2, vector);
                            this.catalog.addEntry(catalogEntry);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                this.debug.message(1, "Invalid catalog entry type", string3);
                            }
                            if (catalogException.getExceptionType() != 2) break block10;
                            this.debug.message(1, "Invalid catalog entry (rbase)", string3);
                        }
                    }
                }
            }
            if (string2 != null && namespaceName.equals(string2) && !bl && (string3.equals("catalog") || string3.equals("group"))) {
                string6 = (String)this.overrideStack.pop();
                string5 = (String)this.overrideStack.peek();
                if (!string5.equals(string6)) {
                    n2 = Catalog.OVERRIDE;
                    vector.add(string5);
                    this.overrideStack.push(string5);
                    this.debug.message(4, "(reset) override", string5);
                    try {
                        catalogEntry = new CatalogEntry(n2, vector);
                        this.catalog.addEntry(catalogEntry);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            this.debug.message(1, "Invalid catalog entry type", string3);
                        }
                        if (catalogException.getExceptionType() != 2) break block11;
                        this.debug.message(1, "Invalid catalog entry (roverride)", string3);
                    }
                }
            }
        }
        this.namespaceStack.pop();
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    public void skippedEntity(String string2) throws SAXException {
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }

    public void endPrefixMapping(String string2) throws SAXException {
    }
}

