/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.readers;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogException;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogManager;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.BootstrapResolver;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.Debug;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.CatalogReader;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.SAXCatalogParser;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.SAXParserHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXCatalogReader
implements CatalogReader,
ContentHandler,
DocumentHandler {
    protected SAXParserFactory parserFactory = null;
    protected String parserClass = null;
    protected Hashtable namespaceMap = new Hashtable();
    private SAXCatalogParser saxParser = null;
    private boolean abandonHope = false;
    private Catalog catalog;
    protected Debug debug;

    public void setParserFactory(SAXParserFactory sAXParserFactory) {
        this.parserFactory = sAXParserFactory;
    }

    public void setParserClass(String string2) {
        this.parserClass = string2;
    }

    public SAXParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public SAXCatalogReader() {
        this.debug = CatalogManager.getStaticManager().debug;
        this.parserFactory = null;
        this.parserClass = null;
    }

    public SAXCatalogReader(SAXParserFactory sAXParserFactory) {
        this.debug = CatalogManager.getStaticManager().debug;
        this.parserFactory = sAXParserFactory;
    }

    public SAXCatalogReader(String string2) {
        this.debug = CatalogManager.getStaticManager().debug;
        this.parserClass = string2;
    }

    public void setCatalogParser(String string2, String string3, String string4) {
        if (string2 == null) {
            this.namespaceMap.put(string3, string4);
        } else {
            this.namespaceMap.put("{" + string2 + "}" + string3, string4);
        }
    }

    public String getCatalogParser(String string2, String string3) {
        if (string2 == null) {
            return (String)this.namespaceMap.get(string3);
        }
        return (String)this.namespaceMap.get("{" + string2 + "}" + string3);
    }

    public void readCatalog(Catalog catalog, String string2) throws MalformedURLException, IOException, CatalogException {
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file:///" + string2);
        }
        this.debug = catalog.getCatalogManager().debug;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.readCatalog(catalog, uRLConnection.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", uRL.toString());
        }
    }

    public void readCatalog(Catalog catalog, InputStream inputStream) throws IOException, CatalogException {
        if (this.parserFactory == null && this.parserClass == null) {
            this.debug.message(1, "Cannot read SAX catalog without a parser");
            throw new CatalogException(6);
        }
        this.debug = catalog.getCatalogManager().debug;
        BootstrapResolver bootstrapResolver = catalog.getCatalogManager().getBootstrapResolver();
        this.catalog = catalog;
        try {
            if (this.parserFactory != null) {
                SAXParser sAXParser = this.parserFactory.newSAXParser();
                SAXParserHandler sAXParserHandler = new SAXParserHandler();
                sAXParserHandler.setContentHandler(this);
                if (bootstrapResolver != null) {
                    sAXParserHandler.setEntityResolver(bootstrapResolver);
                }
                sAXParser.parse(new InputSource(inputStream), (DefaultHandler)sAXParserHandler);
            } else {
                Parser parser = (Parser)Class.forName(this.parserClass).newInstance();
                parser.setDocumentHandler(this);
                if (bootstrapResolver != null) {
                    parser.setEntityResolver(bootstrapResolver);
                }
                parser.parse(new InputSource(inputStream));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CatalogException(6);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CatalogException(6);
        }
        catch (InstantiationException instantiationException) {
            throw new CatalogException(6);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CatalogException(5);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            UnknownHostException unknownHostException = new UnknownHostException();
            FileNotFoundException fileNotFoundException = new FileNotFoundException();
            if (exception != null) {
                if (exception.getClass() == unknownHostException.getClass()) {
                    throw new CatalogException(7, exception.toString());
                }
                if (exception.getClass() == fileNotFoundException.getClass()) {
                    throw new CatalogException(7, exception.toString());
                }
            }
            throw new CatalogException(sAXException);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.saxParser != null) {
            this.saxParser.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        this.saxParser = null;
        this.abandonHope = false;
    }

    public void endDocument() throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endDocument();
        }
    }

    public void startElement(String string2, AttributeList attributeList) throws SAXException {
        if (this.abandonHope) {
            return;
        }
        if (this.saxParser == null) {
            String string3;
            String string4 = "";
            if (string2.indexOf(58) > 0) {
                string4 = string2.substring(0, string2.indexOf(58));
            }
            if ((string3 = string2).indexOf(58) > 0) {
                string3 = string3.substring(string3.indexOf(58) + 1);
            }
            String string5 = null;
            string5 = string4.length() == 0 ? attributeList.getValue("xmlns") : attributeList.getValue("xmlns:" + string4);
            String string6 = this.getCatalogParser(string5, string3);
            if (string6 == null) {
                this.abandonHope = true;
                if (string5 == null) {
                    this.debug.message(2, "No Catalog parser for " + string2);
                } else {
                    this.debug.message(2, "No Catalog parser for {" + string5 + "}" + string2);
                }
                return;
            }
            try {
                this.saxParser = (SAXCatalogParser)Class.forName(string6).newInstance();
                this.saxParser.setCatalog(this.catalog);
                this.saxParser.startDocument();
                this.saxParser.startElement(string2, attributeList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classNotFoundException.toString());
            }
            catch (InstantiationException instantiationException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, illegalAccessException.toString());
            }
            catch (ClassCastException classCastException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classCastException.toString());
            }
        } else {
            this.saxParser.startElement(string2, attributeList);
        }
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        if (this.abandonHope) {
            return;
        }
        if (this.saxParser == null) {
            String string5 = this.getCatalogParser(string2, string3);
            if (string5 == null) {
                this.abandonHope = true;
                if (string2 == null) {
                    this.debug.message(2, "No Catalog parser for " + string3);
                } else {
                    this.debug.message(2, "No Catalog parser for {" + string2 + "}" + string3);
                }
                return;
            }
            try {
                this.saxParser = (SAXCatalogParser)Class.forName(string5).newInstance();
                this.saxParser.setCatalog(this.catalog);
                this.saxParser.startDocument();
                this.saxParser.startElement(string2, string3, string4, attributes2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classNotFoundException.toString());
            }
            catch (InstantiationException instantiationException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, illegalAccessException.toString());
            }
            catch (ClassCastException classCastException) {
                this.saxParser = null;
                this.abandonHope = true;
                this.debug.message(2, classCastException.toString());
            }
        } else {
            this.saxParser.startElement(string2, string3, string4, attributes2);
        }
    }

    public void endElement(String string2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endElement(string2);
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endElement(string2, string3, string4);
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.characters(cArray, n2, n3);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.ignorableWhitespace(cArray, n2, n3);
        }
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.processingInstruction(string2, string3);
        }
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.startPrefixMapping(string2, string3);
        }
    }

    public void endPrefixMapping(String string2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.endPrefixMapping(string2);
        }
    }

    public void skippedEntity(String string2) throws SAXException {
        if (this.saxParser != null) {
            this.saxParser.skippedEntity(string2);
        }
    }
}

