/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.tools;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CatalogResolver
implements EntityResolver,
URIResolver {
    public boolean namespaceAware = true;
    public boolean validating = false;
    private Catalog catalog = null;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();

    public CatalogResolver() {
        this.initializeCatalogs(false);
    }

    public CatalogResolver(boolean bl) {
        this.initializeCatalogs(bl);
    }

    public CatalogResolver(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.initializeCatalogs(!this.catalogManager.getUseStaticCatalog());
    }

    private void initializeCatalogs(boolean bl) {
        this.catalog = this.catalogManager.getCatalog();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getResolvedEntity(String string2, String string3) {
        String string4 = null;
        if (this.catalog == null) {
            this.catalogManager.debug.message(1, "Catalog resolution attempted with null catalog; ignored");
            return null;
        }
        if (string3 != null) {
            try {
                string4 = this.catalog.resolveSystem(string3);
            }
            catch (MalformedURLException malformedURLException) {
                this.catalogManager.debug.message(1, "Malformed URL exception trying to resolve", string2);
                string4 = null;
            }
            catch (IOException iOException) {
                this.catalogManager.debug.message(1, "I/O exception trying to resolve", string2);
                string4 = null;
            }
        }
        if (string4 == null) {
            if (string2 != null) {
                try {
                    string4 = this.catalog.resolvePublic(string2, string3);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed URL exception trying to resolve", string2);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "I/O exception trying to resolve", string2);
                }
            }
            if (string4 != null) {
                this.catalogManager.debug.message(2, "Resolved public", string2, string4);
            }
        } else {
            this.catalogManager.debug.message(2, "Resolved system", string3, string4);
        }
        return string4;
    }

    public InputSource resolveEntity(String string2, String string3) {
        String string4 = this.getResolvedEntity(string2, string3);
        if (string4 != null) {
            try {
                InputSource inputSource = new InputSource(string4);
                inputSource.setPublicId(string2);
                URL uRL = new URL(string4);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource", string4);
                return null;
            }
        }
        return null;
    }

    public Source resolve(String string2, String string3) throws TransformerException {
        Object object2;
        String string4 = string2;
        String string5 = null;
        int n2 = string2.indexOf("#");
        if (n2 >= 0) {
            string4 = string2.substring(0, n2);
            string5 = string2.substring(n2 + 1);
        }
        String string6 = null;
        try {
            string6 = this.catalog.resolveURI(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string6 == null) {
            try {
                object2 = null;
                if (string3 == null) {
                    object2 = new URL(string4);
                    string6 = ((URL)object2).toString();
                } else {
                    URL uRL = new URL(string3);
                    object2 = string2.length() == 0 ? uRL : new URL(uRL, string4);
                    string6 = ((URL)object2).toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string7 = this.makeAbsolute(string3);
                if (!string7.equals(string3)) {
                    return this.resolve(string2, string7);
                }
                throw new TransformerException("Malformed URL " + string2 + "(base " + string3 + ")", malformedURLException);
            }
        }
        this.catalogManager.debug.message(2, "Resolved URI", string2, string6);
        object2 = new SAXSource();
        ((SAXSource)object2).setInputSource(new InputSource(string6));
        return object2;
    }

    private String makeAbsolute(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        try {
            URL uRL = new URL(string2);
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = System.getProperty("user.dir");
            String string4 = "";
            string4 = string3.endsWith("/") ? "file://" + string3 + string2 : "file://" + string3 + "/" + string2;
            try {
                URL uRL = new URL(string4);
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string2;
            }
        }
    }
}

