/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.tools;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogManager;
import com.ibm.xml.xml4j.internal.s1.resolver.tools.CatalogResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class ResolvingParser
implements Parser,
DTDHandler,
DocumentHandler,
EntityResolver {
    public static boolean namespaceAware = true;
    public static boolean validating = false;
    public static boolean suppressExplanation = false;
    private SAXParser saxParser = null;
    private Parser parser = null;
    private DocumentHandler documentHandler = null;
    private DTDHandler dtdHandler = null;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();
    private CatalogResolver catalogResolver = null;
    private CatalogResolver piCatalogResolver = null;
    private boolean allowXMLCatalogPI = false;
    private boolean oasisXMLCatalogPI = false;
    private URL baseURL = null;

    public ResolvingParser() {
        this.initParser();
    }

    public ResolvingParser(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.initParser();
    }

    private void initParser() {
        this.catalogResolver = new CatalogResolver(this.catalogManager);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(namespaceAware);
        sAXParserFactory.setValidating(validating);
        try {
            this.saxParser = sAXParserFactory.newSAXParser();
            this.parser = this.saxParser.getParser();
            this.documentHandler = null;
            this.dtdHandler = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Catalog getCatalog() {
        return this.catalogResolver.getCatalog();
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.setupParse(inputSource.getSystemId());
        try {
            this.parser.parse(inputSource);
        }
        catch (InternalError internalError) {
            this.explain(inputSource.getSystemId());
            throw internalError;
        }
    }

    public void parse(String string2) throws IOException, SAXException {
        this.setupParse(string2);
        try {
            this.parser.parse(string2);
        }
        catch (InternalError internalError) {
            this.explain(string2);
            throw internalError;
        }
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.setLocale(locale);
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(cArray, n2, n3);
        }
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
    }

    public void endElement(String string2) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(string2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(cArray, n2, n3);
        }
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        if (string2.equals("oasis-xml-catalog")) {
            URL uRL = null;
            String string4 = string3;
            int n2 = string4.indexOf("catalog=");
            if (n2 >= 0 && (string4 = string4.substring(n2 + 8)).length() > 1) {
                String string5 = string4.substring(0, 1);
                n2 = (string4 = string4.substring(1)).indexOf(string5);
                if (n2 >= 0) {
                    string4 = string4.substring(0, n2);
                    try {
                        uRL = this.baseURL != null ? new URL(this.baseURL, string4) : new URL(string4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (this.allowXMLCatalogPI) {
                if (this.catalogManager.allowOasisXMLCatalogPI()) {
                    this.catalogManager.debug.message(4, "oasis-xml-catalog PI", string3);
                    if (uRL != null) {
                        try {
                            this.catalogManager.debug.message(4, "oasis-xml-catalog", uRL.toString());
                            this.oasisXMLCatalogPI = true;
                            if (this.piCatalogResolver == null) {
                                this.piCatalogResolver = new CatalogResolver(true);
                            }
                            this.piCatalogResolver.getCatalog().parseCatalog(uRL.toString());
                        }
                        catch (Exception exception) {
                            this.catalogManager.debug.message(3, "Exception parsing oasis-xml-catalog: " + uRL.toString());
                        }
                    } else {
                        this.catalogManager.debug.message(3, "PI oasis-xml-catalog unparseable: " + string3);
                    }
                } else {
                    this.catalogManager.debug.message(4, "PI oasis-xml-catalog ignored: " + string3);
                }
            } else {
                this.catalogManager.debug.message(3, "PI oasis-xml-catalog occurred in an invalid place: " + string3);
            }
        } else if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(string2, string3);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler != null) {
            this.documentHandler.startDocument();
        }
    }

    public void startElement(String string2, AttributeList attributeList) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.documentHandler != null) {
            this.documentHandler.startElement(string2, attributeList);
        }
    }

    public void notationDecl(String string2, String string3, String string4) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.dtdHandler != null) {
            this.dtdHandler.notationDecl(string2, string3, string4);
        }
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
        this.allowXMLCatalogPI = false;
        if (this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(string2, string3, string4, string5);
        }
    }

    public InputSource resolveEntity(String string2, String string3) {
        this.allowXMLCatalogPI = false;
        String string4 = this.catalogResolver.getResolvedEntity(string2, string3);
        if (string4 == null && this.piCatalogResolver != null) {
            string4 = this.piCatalogResolver.getResolvedEntity(string2, string3);
        }
        if (string4 != null) {
            try {
                InputSource inputSource = new InputSource(string4);
                inputSource.setPublicId(string2);
                URL uRL = new URL(string4);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource", string4);
                return null;
            }
        }
        return null;
    }

    private void setupParse(String string2) {
        this.allowXMLCatalogPI = true;
        this.parser.setEntityResolver(this);
        this.parser.setDocumentHandler(this);
        this.parser.setDTDHandler(this);
        String string3 = System.getProperty("user.dir");
        URL uRL = null;
        string3.replace('\\', '/');
        try {
            uRL = new URL("file:///" + string3 + "/basename");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        try {
            this.baseURL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL != null) {
                try {
                    this.baseURL = new URL(uRL, string2);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.baseURL = null;
                }
            }
            this.baseURL = null;
        }
    }

    private void explain(String string2) {
        if (!suppressExplanation) {
            System.out.println("Parser probably encountered bad URI in " + string2);
            System.out.println("For example, replace '/some/uri' with 'file:/some/uri'.");
        }
    }
}

