/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.tools;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogManager;
import com.ibm.xml.xml4j.internal.s1.resolver.tools.CatalogResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ResolvingXMLFilter
extends XMLFilterImpl {
    public static boolean suppressExplanation = false;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();
    private CatalogResolver catalogResolver = null;
    private CatalogResolver piCatalogResolver = null;
    private boolean allowXMLCatalogPI = false;
    private boolean oasisXMLCatalogPI = false;
    private URL baseURL = null;

    public ResolvingXMLFilter() {
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public ResolvingXMLFilter(XMLReader xMLReader) {
        super(xMLReader);
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public ResolvingXMLFilter(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public ResolvingXMLFilter(XMLReader xMLReader, CatalogManager catalogManager) {
        super(xMLReader);
        this.catalogManager = catalogManager;
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public Catalog getCatalog() {
        return this.catalogResolver.getCatalog();
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.allowXMLCatalogPI = true;
        this.setupBaseURI(inputSource.getSystemId());
        try {
            super.parse(inputSource);
        }
        catch (InternalError internalError) {
            this.explain(inputSource.getSystemId());
            throw internalError;
        }
    }

    public void parse(String string2) throws IOException, SAXException {
        this.allowXMLCatalogPI = true;
        this.setupBaseURI(string2);
        try {
            super.parse(string2);
        }
        catch (InternalError internalError) {
            this.explain(string2);
            throw internalError;
        }
    }

    public InputSource resolveEntity(String string2, String string3) {
        this.allowXMLCatalogPI = false;
        String string4 = this.catalogResolver.getResolvedEntity(string2, string3);
        if (string4 == null && this.piCatalogResolver != null) {
            string4 = this.piCatalogResolver.getResolvedEntity(string2, string3);
        }
        if (string4 != null) {
            try {
                InputSource inputSource = new InputSource(string4);
                inputSource.setPublicId(string2);
                URL uRL = new URL(string4);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource", string4);
                return null;
            }
        }
        return null;
    }

    public void notationDecl(String string2, String string3, String string4) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.notationDecl(string2, string3, string4);
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.unparsedEntityDecl(string2, string3, string4, string5);
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.startElement(string2, string3, string4, attributes2);
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
        if (string2.equals("oasis-xml-catalog")) {
            URL uRL = null;
            String string4 = string3;
            int n2 = string4.indexOf("catalog=");
            if (n2 >= 0 && (string4 = string4.substring(n2 + 8)).length() > 1) {
                String string5 = string4.substring(0, 1);
                n2 = (string4 = string4.substring(1)).indexOf(string5);
                if (n2 >= 0) {
                    string4 = string4.substring(0, n2);
                    try {
                        uRL = this.baseURL != null ? new URL(this.baseURL, string4) : new URL(string4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (this.allowXMLCatalogPI) {
                if (this.catalogManager.allowOasisXMLCatalogPI()) {
                    this.catalogManager.debug.message(4, "oasis-xml-catalog PI", string3);
                    if (uRL != null) {
                        try {
                            this.catalogManager.debug.message(4, "oasis-xml-catalog", uRL.toString());
                            this.oasisXMLCatalogPI = true;
                            if (this.piCatalogResolver == null) {
                                this.piCatalogResolver = new CatalogResolver(true);
                            }
                            this.piCatalogResolver.getCatalog().parseCatalog(uRL.toString());
                        }
                        catch (Exception exception) {
                            this.catalogManager.debug.message(3, "Exception parsing oasis-xml-catalog: " + uRL.toString());
                        }
                    } else {
                        this.catalogManager.debug.message(3, "PI oasis-xml-catalog unparseable: " + string3);
                    }
                } else {
                    this.catalogManager.debug.message(4, "PI oasis-xml-catalog ignored: " + string3);
                }
            } else {
                this.catalogManager.debug.message(3, "PI oasis-xml-catalog occurred in an invalid place: " + string3);
            }
        } else {
            super.processingInstruction(string2, string3);
        }
    }

    private void setupBaseURI(String string2) {
        String string3 = System.getProperty("user.dir");
        URL uRL = null;
        string3.replace('\\', '/');
        try {
            uRL = new URL("file:///" + string3 + "/basename");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        try {
            this.baseURL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL != null) {
                try {
                    this.baseURL = new URL(uRL, string2);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.baseURL = null;
                }
            }
            this.baseURL = null;
        }
    }

    private void explain(String string2) {
        if (!suppressExplanation) {
            System.out.println("XMLReader probably encountered bad URI in " + string2);
            System.out.println("For example, replace '/some/uri' with 'file:/some/uri'.");
        }
        suppressExplanation = true;
    }
}

