/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.serialize.HTMLSerializer;
import com.ibm.xml.xml4j.internal.s1.serialize.OutputFormat;
import com.ibm.xml.xml4j.internal.s1.serialize.Serializer;
import com.ibm.xml.xml4j.internal.s1.serialize.SerializerFactory;
import com.ibm.xml.xml4j.internal.s1.serialize.TextSerializer;
import com.ibm.xml.xml4j.internal.s1.serialize.XHTMLSerializer;
import com.ibm.xml.xml4j.internal.s1.serialize.XMLSerializer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string2) {
        this._method = string2;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{string2});
            throw new IllegalArgumentException(string3);
        }
    }

    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    public Serializer makeSerializer(Writer writer, OutputFormat outputFormat) {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    public Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(outputFormat);
        serializer.setOutputByteStream(outputStream);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat outputFormat) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(outputFormat);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(outputFormat);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(outputFormat);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(string2);
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

