/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import com.ibm.xml.xml4j.internal.s1.util.XMLSymbols;
import com.ibm.xml.xml4j.internal.s1.xni.NamespaceContext;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NamespaceSupport
implements NamespaceContext {
    protected String[] fNamespace = new String[32];
    protected int fNamespaceSize;
    protected int[] fContext = new int[8];
    protected int fCurrentContext;
    protected String[] fPrefixes = new String[16];

    public NamespaceSupport() {
    }

    public NamespaceSupport(NamespaceContext namespaceContext) {
        this.pushContext();
        Enumeration enumeration = namespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = namespaceContext.getURI(string2);
            this.declarePrefix(string2, string3);
        }
    }

    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = this.fNamespaceSize;
        this.fNamespace[this.fNamespaceSize++] = XMLSymbols.PREFIX_XML;
        this.fNamespace[this.fNamespaceSize++] = NamespaceContext.XML_URI;
        this.fNamespace[this.fNamespaceSize++] = XMLSymbols.PREFIX_XMLNS;
        this.fNamespace[this.fNamespaceSize++] = NamespaceContext.XMLNS_URI;
        ++this.fCurrentContext;
    }

    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] nArray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, nArray, 0, this.fContext.length);
            this.fContext = nArray;
        }
        this.fContext[++this.fCurrentContext] = this.fNamespaceSize;
    }

    public void popContext() {
        this.fNamespaceSize = this.fContext[this.fCurrentContext--];
    }

    public boolean declarePrefix(String string2, String string3) {
        if (string2 == XMLSymbols.PREFIX_XML || string2 == XMLSymbols.PREFIX_XMLNS) {
            return false;
        }
        for (int i = this.fNamespaceSize; i > this.fContext[this.fCurrentContext]; i -= 2) {
            if (this.fNamespace[i - 2] != string2) continue;
            this.fNamespace[i - 1] = string3;
            return true;
        }
        if (this.fNamespaceSize == this.fNamespace.length) {
            String[] stringArray = new String[this.fNamespaceSize * 2];
            System.arraycopy(this.fNamespace, 0, stringArray, 0, this.fNamespaceSize);
            this.fNamespace = stringArray;
        }
        this.fNamespace[this.fNamespaceSize++] = string2;
        this.fNamespace[this.fNamespaceSize++] = string3;
        return true;
    }

    public String getURI(String string2) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (this.fNamespace[i - 2] != string2) continue;
            return this.fNamespace[i - 1];
        }
        return null;
    }

    public String getPrefix(String string2) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (this.fNamespace[i - 1] != string2 || this.getURI(this.fNamespace[i - 2]) != string2) continue;
            return this.fNamespace[i - 2];
        }
        return null;
    }

    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    public String getDeclaredPrefixAt(int n2) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + n2 * 2];
    }

    public Enumeration getAllPrefixes() {
        Object object2;
        int n2 = 0;
        if (this.fPrefixes.length < this.fNamespace.length / 2) {
            object2 = new String[this.fNamespaceSize];
            this.fPrefixes = object2;
        }
        object2 = null;
        boolean bl = true;
        for (int i = 2; i < this.fNamespaceSize - 2; i += 2) {
            object2 = this.fNamespace[i + 2];
            for (int j = 0; j < n2; ++j) {
                if (this.fPrefixes[j] != object2) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.fPrefixes[n2++] = object2;
            }
            bl = true;
        }
        return new Prefixes(this.fPrefixes, n2);
    }

    public boolean containsPrefix(String string2) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (this.fNamespace[i - 2] != string2) continue;
            return true;
        }
        return false;
    }

    protected final class Prefixes
    implements Enumeration {
        private String[] prefixes;
        private int counter = 0;
        private int size = 0;

        public Prefixes(String[] stringArray, int n2) {
            this.prefixes = stringArray;
            this.size = n2;
        }

        public boolean hasMoreElements() {
            return this.counter < this.size;
        }

        public Object nextElement() {
            if (this.counter < this.size) {
                return NamespaceSupport.this.fPrefixes[this.counter++];
            }
            throw new NoSuchElementException("Illegal access to Namespace prefixes enumeration.");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.size; ++i) {
                stringBuffer.append(this.prefixes[i]);
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }
}

