/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import com.ibm.xml.xml4j.internal.s1.util.PrimeNumberSequenceGenerator;
import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class SoftReferenceSymbolTable
extends SymbolTable {
    protected SREntry[] fBuckets = null;
    private final ReferenceQueue fReferenceQueue;

    public SoftReferenceSymbolTable(int n2, float f2) {
        super(1, f2);
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.fLoadFactor = f2;
        this.fTableSize = n2;
        this.fBuckets = new SREntry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * f2);
        this.fCount = 0;
        this.fReferenceQueue = new ReferenceQueue();
    }

    public SoftReferenceSymbolTable(int n2) {
        this(n2, 0.75f);
    }

    public SoftReferenceSymbolTable() {
        this(101, 0.75f);
    }

    public String addSymbol(String string2) {
        this.clean();
        int n2 = 0;
        int n3 = this.hash(string2) % this.fTableSize;
        SREntry sREntry = this.fBuckets[n3];
        while (sREntry != null) {
            SREntryData sREntryData = (SREntryData)sREntry.get();
            if (sREntryData != null) {
                if (sREntryData.symbol.equals(string2)) {
                    return sREntryData.symbol;
                }
                ++n2;
            }
            sREntry = sREntry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n3 = this.hash(string2) % this.fTableSize;
        } else if (n2 >= this.fCollisionThreshold) {
            this.rebalance();
            n3 = this.hash(string2) % this.fTableSize;
        }
        string2 = string2.intern();
        this.fBuckets[n3] = sREntry = new SREntry(string2, this.fBuckets[n3], n3, this.fReferenceQueue);
        ++this.fCount;
        return string2;
    }

    public String addSymbol(char[] cArray, int n2, int n3) {
        Object object2;
        this.clean();
        int n4 = 0;
        int n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        Object object3 = this.fBuckets[n5];
        while (object3 != null) {
            block7: {
                object2 = (SREntryData)((SoftReference)object3).get();
                if (object2 != null) {
                    if (n3 == ((SREntryData)object2).characters.length) {
                        for (int i = 0; i < n3; ++i) {
                            if (cArray[n2 + i] == ((SREntryData)object2).characters[i]) continue;
                            ++n4;
                            break block7;
                        }
                        return ((SREntryData)object2).symbol;
                    }
                    ++n4;
                }
            }
            object3 = ((SREntry)object3).next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        } else if (n4 >= this.fCollisionThreshold) {
            this.rebalance();
            n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        }
        object3 = new String(cArray, n2, n3).intern();
        this.fBuckets[n5] = object2 = new SREntry((String)object3, cArray, n2, n3, this.fBuckets[n5], n5, this.fReferenceQueue);
        ++this.fCount;
        return object3;
    }

    protected void rehash() {
        this.rehashCommon(this.fBuckets.length * 2 + 1);
    }

    protected void compact() {
        this.rehashCommon((int)((float)this.fCount / this.fLoadFactor) * 2 + 1);
    }

    protected void rebalance() {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[32];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.rehashCommon(this.fBuckets.length);
    }

    private void rehashCommon(int n2) {
        int n3 = this.fBuckets.length;
        SREntry[] sREntryArray = this.fBuckets;
        SREntry[] sREntryArray2 = new SREntry[n2];
        this.fThreshold = (int)((float)n2 * this.fLoadFactor);
        this.fBuckets = sREntryArray2;
        this.fTableSize = this.fBuckets.length;
        int n4 = n3;
        while (n4-- > 0) {
            SREntry sREntry = sREntryArray[n4];
            while (sREntry != null) {
                SREntry sREntry2 = sREntry;
                sREntry = sREntry.next;
                SREntryData sREntryData = (SREntryData)sREntry2.get();
                if (sREntryData != null) {
                    int n5 = this.hash(sREntryData.symbol) % n2;
                    if (sREntryArray2[n5] != null) {
                        sREntryArray2[n5].prev = sREntry2;
                    }
                    sREntry2.bucket = n5;
                    sREntry2.next = sREntryArray2[n5];
                    sREntryArray2[n5] = sREntry2;
                } else {
                    sREntry2.bucket = -1;
                    sREntry2.next = null;
                    --this.fCount;
                }
                sREntry2.prev = null;
            }
        }
    }

    public boolean containsSymbol(String string2) {
        int n2 = this.hash(string2) % this.fTableSize;
        int n3 = string2.length();
        SREntry sREntry = this.fBuckets[n2];
        while (sREntry != null) {
            block4: {
                SREntryData sREntryData = (SREntryData)sREntry.get();
                if (sREntryData != null && n3 == sREntryData.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (string2.charAt(i) == sREntryData.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            sREntry = sREntry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        SREntry sREntry = this.fBuckets[n4];
        while (sREntry != null) {
            block4: {
                SREntryData sREntryData = (SREntryData)sREntry.get();
                if (sREntryData != null && n3 == sREntryData.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (cArray[n2 + i] == sREntryData.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            sREntry = sREntry.next;
        }
        return false;
    }

    private void removeEntry(SREntry sREntry) {
        int n2 = sREntry.bucket;
        if (n2 >= 0) {
            if (sREntry.next != null) {
                sREntry.next.prev = sREntry.prev;
            }
            if (sREntry.prev != null) {
                sREntry.prev.next = sREntry.next;
            } else {
                this.fBuckets[n2] = sREntry.next;
            }
            --this.fCount;
        }
    }

    private void clean() {
        SREntry sREntry = (SREntry)this.fReferenceQueue.poll();
        if (sREntry != null) {
            do {
                this.removeEntry(sREntry);
            } while ((sREntry = (SREntry)this.fReferenceQueue.poll()) != null);
            if (this.fCount < this.fThreshold >> 2) {
                this.compact();
            }
        }
    }

    protected static final class SREntryData {
        public final String symbol;
        public final char[] characters;

        public SREntryData(String string2) {
            this.symbol = string2;
            this.characters = new char[this.symbol.length()];
            this.symbol.getChars(0, this.characters.length, this.characters, 0);
        }

        public SREntryData(String string2, char[] cArray, int n2, int n3) {
            this.symbol = string2;
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
        }
    }

    protected static final class SREntry
    extends SoftReference {
        public SREntry next;
        public SREntry prev;
        public int bucket;

        public SREntry(String string2, SREntry sREntry, int n2, ReferenceQueue referenceQueue) {
            super(new SREntryData(string2), referenceQueue);
            this.initialize(sREntry, n2);
        }

        public SREntry(String string2, char[] cArray, int n2, int n3, SREntry sREntry, int n4, ReferenceQueue referenceQueue) {
            super(new SREntryData(string2, cArray, n2, n3), referenceQueue);
            this.initialize(sREntry, n4);
        }

        private void initialize(SREntry sREntry, int n2) {
            this.next = sREntry;
            if (sREntry != null) {
                sREntry.prev = this;
            }
            this.prev = null;
            this.bucket = n2;
        }
    }
}

