/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import com.ibm.xml.xml4j.internal.s1.util.PrimeNumberSequenceGenerator;

public class SymbolHash {
    protected static final int TABLE_SIZE = 101;
    protected static final int MAX_HASH_COLLISIONS = 40;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected int fTableSize;
    protected Entry[] fBuckets;
    protected int fNum = 0;
    protected int[] fHashMultipliers;

    public SymbolHash() {
        this(101);
    }

    public SymbolHash(int n2) {
        this.fTableSize = n2;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public void put(Object object2, Object object3) {
        int n2 = 0;
        int n3 = this.hash(object2);
        int n4 = n3 % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            if (object2.equals(entry.key)) {
                entry.value = object3;
                return;
            }
            ++n2;
            entry = entry.next;
        }
        if (this.fNum >= this.fTableSize) {
            this.rehash();
            n4 = n3 % this.fTableSize;
        } else if (n2 >= 40 && object2 instanceof String) {
            this.rebalance();
            n4 = this.hash(object2) % this.fTableSize;
        }
        this.fBuckets[n4] = entry = new Entry(object2, object3, this.fBuckets[n4]);
        ++this.fNum;
    }

    public Object get(Object object2) {
        int n2 = this.hash(object2) % this.fTableSize;
        Entry entry = this.search(object2, n2);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public int getLength() {
        return this.fNum;
    }

    public int getValues(Object[] objectArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.fTableSize && n3 < this.fNum; ++i) {
            Entry entry = this.fBuckets[i];
            while (entry != null) {
                objectArray[n2 + n3] = entry.value;
                ++n3;
                entry = entry.next;
            }
        }
        return this.fNum;
    }

    public Object[] getEntries() {
        Object[] objectArray = new Object[this.fNum << 1];
        int n2 = 0;
        for (int i = 0; i < this.fTableSize && n2 < this.fNum << 1; ++i) {
            Entry entry = this.fBuckets[i];
            while (entry != null) {
                objectArray[n2] = entry.key;
                objectArray[++n2] = entry.value;
                ++n2;
                entry = entry.next;
            }
        }
        return objectArray;
    }

    public SymbolHash makeClone() {
        SymbolHash symbolHash = new SymbolHash(this.fTableSize);
        symbolHash.fNum = this.fNum;
        symbolHash.fHashMultipliers = this.fHashMultipliers != null ? (int[])this.fHashMultipliers.clone() : null;
        for (int i = 0; i < this.fTableSize; ++i) {
            if (this.fBuckets[i] == null) continue;
            symbolHash.fBuckets[i] = this.fBuckets[i].makeClone();
        }
        return symbolHash;
    }

    public void clear() {
        for (int i = 0; i < this.fTableSize; ++i) {
            this.fBuckets[i] = null;
        }
        this.fNum = 0;
        this.fHashMultipliers = null;
    }

    protected Entry search(Object object2, int n2) {
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            if (object2.equals(entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    protected int hash(Object object2) {
        if (this.fHashMultipliers == null || !(object2 instanceof String)) {
            return object2.hashCode() & Integer.MAX_VALUE;
        }
        return this.hash0((String)object2);
    }

    private int hash0(String string2) {
        int n2 = 0;
        int n3 = string2.length();
        int[] nArray = this.fHashMultipliers;
        for (int i = 0; i < n3; ++i) {
            n2 = n2 * nArray[i & 0x1F] + string2.charAt(i);
        }
        return n2 & Integer.MAX_VALUE;
    }

    protected void rehash() {
        this.rehashCommon((this.fBuckets.length << 1) + 1);
    }

    protected void rebalance() {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[32];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.rehashCommon(this.fBuckets.length);
    }

    private void rehashCommon(int n2) {
        int n3 = this.fBuckets.length;
        Entry[] entryArray = this.fBuckets;
        Entry[] entryArray2 = new Entry[n2];
        this.fBuckets = entryArray2;
        this.fTableSize = this.fBuckets.length;
        int n4 = n3;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = this.hash(entry2.key) % n2;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    protected static final class Entry {
        public Object key;
        public Object value;
        public Entry next;

        public Entry() {
            this.key = null;
            this.value = null;
            this.next = null;
        }

        public Entry(Object object2, Object object3, Entry entry) {
            this.key = object2;
            this.value = object3;
            this.next = entry;
        }

        public Entry makeClone() {
            Entry entry = new Entry();
            entry.key = this.key;
            entry.value = this.value;
            if (this.next != null) {
                entry.next = this.next.makeClone();
            }
            return entry;
        }
    }
}

