/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import com.ibm.xml.xml4j.internal.s1.util.PrimeNumberSequenceGenerator;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected static final int MAX_HASH_COLLISIONS = 40;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected Entry[] fBuckets = null;
    protected int fTableSize;
    protected transient int fCount;
    protected int fThreshold;
    protected float fLoadFactor;
    protected final int fCollisionThreshold;
    protected int[] fHashMultipliers;

    public SymbolTable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.fLoadFactor = f2;
        this.fTableSize = n2;
        this.fBuckets = new Entry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * f2);
        this.fCollisionThreshold = (int)(40.0f * f2);
        this.fCount = 0;
    }

    public SymbolTable(int n2) {
        this(n2, 0.75f);
    }

    public SymbolTable() {
        this(101, 0.75f);
    }

    public String addSymbol(String string2) {
        int n2 = 0;
        int n3 = this.hash(string2) % this.fTableSize;
        Entry entry = this.fBuckets[n3];
        while (entry != null) {
            if (entry.symbol.equals(string2)) {
                return entry.symbol;
            }
            ++n2;
            entry = entry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n3 = this.hash(string2) % this.fTableSize;
        } else if (n2 >= this.fCollisionThreshold) {
            this.rebalance();
            n3 = this.hash(string2) % this.fTableSize;
        }
        this.fBuckets[n3] = entry = new Entry(string2, this.fBuckets[n3]);
        ++this.fCount;
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n5];
        while (entry != null) {
            block6: {
                if (n3 == entry.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (cArray[n2 + i] == entry.characters[i]) continue;
                        ++n4;
                        break block6;
                    }
                    return entry.symbol;
                }
                ++n4;
            }
            entry = entry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        } else if (n4 >= this.fCollisionThreshold) {
            this.rebalance();
            n5 = this.hash(cArray, n2, n3) % this.fTableSize;
        }
        this.fBuckets[n5] = entry = new Entry(cArray, n2, n3, this.fBuckets[n5]);
        ++this.fCount;
        return entry.symbol;
    }

    public int hash(String string2) {
        if (this.fHashMultipliers == null) {
            return string2.hashCode() & Integer.MAX_VALUE;
        }
        return this.hash0(string2);
    }

    private int hash0(String string2) {
        int n2 = 0;
        int n3 = string2.length();
        int[] nArray = this.fHashMultipliers;
        for (int i = 0; i < n3; ++i) {
            n2 = n2 * nArray[i & 0x1F] + string2.charAt(i);
        }
        return n2 & Integer.MAX_VALUE;
    }

    public int hash(char[] cArray, int n2, int n3) {
        if (this.fHashMultipliers == null) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                n4 = n4 * 31 + cArray[n2 + i];
            }
            return n4 & Integer.MAX_VALUE;
        }
        return this.hash0(cArray, n2, n3);
    }

    private int hash0(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int[] nArray = this.fHashMultipliers;
        for (int i = 0; i < n3; ++i) {
            n4 = n4 * nArray[i & 0x1F] + cArray[n2 + i];
        }
        return n4 & Integer.MAX_VALUE;
    }

    protected void rehash() {
        this.rehashCommon(this.fBuckets.length * 2 + 1);
    }

    protected void rebalance() {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[32];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.rehashCommon(this.fBuckets.length);
    }

    private void rehashCommon(int n2) {
        int n3 = this.fBuckets.length;
        Entry[] entryArray = this.fBuckets;
        Entry[] entryArray2 = new Entry[n2];
        this.fThreshold = (int)((float)n2 * this.fLoadFactor);
        this.fBuckets = entryArray2;
        this.fTableSize = this.fBuckets.length;
        int n4 = n3;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = this.hash(entry2.symbol) % n2;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public boolean containsSymbol(String string2) {
        int n2 = this.hash(string2) % this.fTableSize;
        int n3 = string2.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (string2.charAt(i) == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (cArray[n2 + i] == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public final String symbol;
        public final char[] characters;
        public Entry next;

        public Entry(String string2, Entry entry) {
            this.symbol = string2.intern();
            this.characters = new char[string2.length()];
            string2.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n2, int n3, Entry entry) {
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

