/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import com.ibm.xml.xml4j.internal.s1.util.AugmentationsImpl;
import com.ibm.xml.xml4j.internal.s1.util.PrimeNumberSequenceGenerator;
import com.ibm.xml.xml4j.internal.s1.xni.Augmentations;
import com.ibm.xml.xml4j.internal.s1.xni.QName;
import com.ibm.xml.xml4j.internal.s1.xni.XMLAttributes;

public class XMLAttributesImpl
implements XMLAttributes {
    protected static final int TABLE_SIZE = 101;
    protected static final int MAX_HASH_COLLISIONS = 40;
    protected static final int MULTIPLIERS_SIZE = 32;
    protected static final int MULTIPLIERS_MASK = 31;
    protected static final int SIZE_LIMIT = 20;
    protected boolean fNamespaces = true;
    protected int fLargeCount = 1;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];
    protected Attribute[] fAttributeTableView;
    protected int[] fAttributeTableViewChainState;
    protected int fTableViewBuckets;
    protected boolean fIsTableViewConsistent;
    protected int[] fHashMultipliers;

    public XMLAttributesImpl() {
        this(101);
    }

    public XMLAttributesImpl(int n2) {
        this.fTableViewBuckets = n2;
        for (int i = 0; i < this.fAttributes.length; ++i) {
            this.fAttributes[i] = new Attribute();
        }
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
    }

    public int addAttribute(QName qName, String string2, String string3) {
        Attribute[] attributeArray;
        int n2;
        if (this.fLength < 20) {
            int n3 = n2 = qName.uri != null && qName.uri.length() != 0 ? this.getIndexFast(qName.uri, qName.localpart) : this.getIndexFast(qName.rawname);
            if (n2 == -1) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    attributeArray = new Attribute[this.fAttributes.length + 4];
                    System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributeArray.length; ++i) {
                        attributeArray[i] = new Attribute();
                    }
                    this.fAttributes = attributeArray;
                }
            }
        } else if (qName.uri == null || qName.uri.length() == 0 || (n2 = this.getIndexFast(qName.uri, qName.localpart)) == -1) {
            int n4;
            if (!this.fIsTableViewConsistent || this.fLength == 20 || this.fLength > 20 && this.fLength > this.fTableViewBuckets) {
                this.prepareAndPopulateTableView();
                this.fIsTableViewConsistent = true;
            }
            if (this.fAttributeTableViewChainState[n4 = this.getTableViewBucket(qName.rawname)] != this.fLargeCount) {
                n2 = this.fLength;
                if (this.fLength++ == this.fAttributes.length) {
                    Attribute[] attributeArray2 = new Attribute[this.fAttributes.length << 1];
                    System.arraycopy(this.fAttributes, 0, attributeArray2, 0, this.fAttributes.length);
                    for (int i = this.fAttributes.length; i < attributeArray2.length; ++i) {
                        attributeArray2[i] = new Attribute();
                    }
                    this.fAttributes = attributeArray2;
                }
                this.fAttributeTableViewChainState[n4] = this.fLargeCount;
                this.fAttributes[n2].next = null;
                this.fAttributeTableView[n4] = this.fAttributes[n2];
            } else {
                int n5 = 0;
                Attribute attribute2 = this.fAttributeTableView[n4];
                while (attribute2 != null && attribute2.name.rawname != qName.rawname) {
                    attribute2 = attribute2.next;
                    ++n5;
                }
                if (attribute2 == null) {
                    n2 = this.fLength;
                    if (this.fLength++ == this.fAttributes.length) {
                        Attribute[] attributeArray3 = new Attribute[this.fAttributes.length << 1];
                        System.arraycopy(this.fAttributes, 0, attributeArray3, 0, this.fAttributes.length);
                        for (int i = this.fAttributes.length; i < attributeArray3.length; ++i) {
                            attributeArray3[i] = new Attribute();
                        }
                        this.fAttributes = attributeArray3;
                    }
                    if (n5 >= 40) {
                        this.fAttributes[n2].name.setValues(qName);
                        this.rebalanceTableView(this.fLength);
                    } else {
                        this.fAttributes[n2].next = this.fAttributeTableView[n4];
                        this.fAttributeTableView[n4] = this.fAttributes[n2];
                    }
                } else {
                    n2 = this.getIndexFast(qName.rawname);
                }
            }
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string2;
        attributeArray.value = string3;
        attributeArray.nonNormalizedValue = string3;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
        return n2;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int n2) {
        this.fIsTableViewConsistent = false;
        if (n2 < this.fLength - 1) {
            Attribute attribute2 = this.fAttributes[n2];
            System.arraycopy(this.fAttributes, n2 + 1, this.fAttributes, n2, this.fLength - n2 - 1);
            this.fAttributes[this.fLength - 1] = attribute2;
        }
        --this.fLength;
    }

    public void setName(int n2, QName qName) {
        this.fAttributes[n2].name.setValues(qName);
    }

    public void getName(int n2, QName qName) {
        qName.setValues(this.fAttributes[n2].name);
    }

    public void setType(int n2, String string2) {
        this.fAttributes[n2].type = string2;
    }

    public void setValue(int n2, String string2) {
        Attribute attribute2 = this.fAttributes[n2];
        attribute2.value = string2;
        attribute2.nonNormalizedValue = string2;
    }

    public void setNonNormalizedValue(int n2, String string2) {
        if (string2 == null) {
            string2 = this.fAttributes[n2].value;
        }
        this.fAttributes[n2].nonNormalizedValue = string2;
    }

    public String getNonNormalizedValue(int n2) {
        String string2 = this.fAttributes[n2].nonNormalizedValue;
        return string2;
    }

    public void setSpecified(int n2, boolean bl) {
        this.fAttributes[n2].specified = bl;
    }

    public boolean isSpecified(int n2) {
        return this.fAttributes[n2].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.getReportableType(this.fAttributes[n2].type);
    }

    public String getType(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    public String getValue(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].value;
    }

    public String getValue(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.fAttributes[n2].value : null;
    }

    public String getName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.rawname;
    }

    public int getIndex(String string2) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute2 = this.fAttributes[i];
            if (attribute2.name.rawname == null || !attribute2.name.rawname.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String string2, String string3) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute2 = this.fAttributes[i];
            if (attribute2.name.localpart == null || !attribute2.name.localpart.equals(string3) || string2 != attribute2.name.uri && (string2 == null || attribute2.name.uri == null || !attribute2.name.uri.equals(string2))) continue;
            return i;
        }
        return -1;
    }

    public String getLocalName(int n2) {
        if (!this.fNamespaces) {
            return "";
        }
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].name.localpart;
    }

    public String getQName(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string2 = this.fAttributes[n2].name.rawname;
        return string2 != null ? string2 : "";
    }

    public String getType(String string2, String string3) {
        if (!this.fNamespaces) {
            return null;
        }
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.getReportableType(this.fAttributes[n2].type) : null;
    }

    public String getPrefix(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string2 = this.fAttributes[n2].name.prefix;
        return string2 != null ? string2 : "";
    }

    public String getURI(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        String string2 = this.fAttributes[n2].name.uri;
        return string2;
    }

    public String getValue(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.getValue(n2) : null;
    }

    public Augmentations getAugmentations(String string2, String string3) {
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    public Augmentations getAugmentations(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.fAttributes[n2].augs : null;
    }

    public Augmentations getAugmentations(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fAttributes[n2].augs;
    }

    public void setAugmentations(int n2, Augmentations augmentations) {
        this.fAttributes[n2].augs = augmentations;
    }

    public void setURI(int n2, String string2) {
        this.fAttributes[n2].name.uri = string2;
    }

    public void setSchemaId(int n2, boolean bl) {
        this.fAttributes[n2].schemaId = bl;
    }

    public boolean getSchemaId(int n2) {
        if (n2 < 0 || n2 >= this.fLength) {
            return false;
        }
        return this.fAttributes[n2].schemaId;
    }

    public boolean getSchemaId(String string2) {
        int n2 = this.getIndex(string2);
        return n2 != -1 ? this.fAttributes[n2].schemaId : false;
    }

    public boolean getSchemaId(String string2, String string3) {
        if (!this.fNamespaces) {
            return false;
        }
        int n2 = this.getIndex(string2, string3);
        return n2 != -1 ? this.fAttributes[n2].schemaId : false;
    }

    public int getIndexFast(String string2) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute2 = this.fAttributes[i];
            if (attribute2.name.rawname != string2) continue;
            return i;
        }
        return -1;
    }

    public void addAttributeNS(QName qName, String string2, String string3) {
        Attribute[] attributeArray;
        int n2 = this.fLength;
        if (this.fLength++ == this.fAttributes.length) {
            attributeArray = this.fLength < 20 ? new Attribute[this.fAttributes.length + 4] : new Attribute[this.fAttributes.length << 1];
            System.arraycopy(this.fAttributes, 0, attributeArray, 0, this.fAttributes.length);
            for (int i = this.fAttributes.length; i < attributeArray.length; ++i) {
                attributeArray[i] = new Attribute();
            }
            this.fAttributes = attributeArray;
        }
        attributeArray = this.fAttributes[n2];
        attributeArray.name.setValues(qName);
        attributeArray.type = string2;
        attributeArray.value = string3;
        attributeArray.nonNormalizedValue = string3;
        attributeArray.specified = false;
        attributeArray.augs.removeAllItems();
    }

    public QName checkDuplicatesNS() {
        int n2 = this.fLength;
        if (n2 <= 20) {
            Attribute[] attributeArray = this.fAttributes;
            for (int i = 0; i < n2 - 1; ++i) {
                Attribute attribute2 = attributeArray[i];
                for (int j = i + 1; j < n2; ++j) {
                    Attribute attribute3 = attributeArray[j];
                    if (attribute2.name.localpart != attribute3.name.localpart || attribute2.name.uri != attribute3.name.uri) continue;
                    return attribute3.name;
                }
            }
            return null;
        }
        return this.checkManyDuplicatesNS();
    }

    private QName checkManyDuplicatesNS() {
        this.fIsTableViewConsistent = false;
        this.prepareTableView();
        int n2 = this.fLength;
        Attribute[] attributeArray = this.fAttributes;
        Attribute[] attributeArray2 = this.fAttributeTableView;
        int[] nArray = this.fAttributeTableViewChainState;
        int n3 = this.fLargeCount;
        for (int i = 0; i < n2; ++i) {
            Attribute attribute2 = attributeArray[i];
            int n4 = this.getTableViewBucket(attribute2.name.localpart, attribute2.name.uri);
            if (nArray[n4] != n3) {
                nArray[n4] = n3;
                attribute2.next = null;
                attributeArray2[n4] = attribute2;
                continue;
            }
            int n5 = 0;
            Attribute attribute3 = attributeArray2[n4];
            while (attribute3 != null) {
                if (attribute3.name.localpart == attribute2.name.localpart && attribute3.name.uri == attribute2.name.uri) {
                    return attribute2.name;
                }
                attribute3 = attribute3.next;
                ++n5;
            }
            if (n5 >= 40) {
                this.rebalanceTableViewNS(i + 1);
                n3 = this.fLargeCount;
                continue;
            }
            attribute2.next = attributeArray2[n4];
            attributeArray2[n4] = attribute2;
        }
        return null;
    }

    public int getIndexFast(String string2, String string3) {
        for (int i = 0; i < this.fLength; ++i) {
            Attribute attribute2 = this.fAttributes[i];
            if (attribute2.name.localpart != string3 || attribute2.name.uri != string2) continue;
            return i;
        }
        return -1;
    }

    private String getReportableType(String string2) {
        if (string2.charAt(0) == '(') {
            return "NMTOKEN";
        }
        return string2;
    }

    protected int getTableViewBucket(String string2) {
        return (this.hash(string2) & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    protected int getTableViewBucket(String string2, String string3) {
        if (string3 == null) {
            return (this.hash(string2) & Integer.MAX_VALUE) % this.fTableViewBuckets;
        }
        return (this.hash(string2, string3) & Integer.MAX_VALUE) % this.fTableViewBuckets;
    }

    private int hash(String string2) {
        if (this.fHashMultipliers == null) {
            return string2.hashCode();
        }
        return this.hash0(string2);
    }

    private int hash(String string2, String string3) {
        if (this.fHashMultipliers == null) {
            return string2.hashCode() + string3.hashCode() * 31;
        }
        return this.hash0(string2) + this.hash0(string3) * this.fHashMultipliers[32];
    }

    private int hash0(String string2) {
        int n2 = 0;
        int n3 = string2.length();
        int[] nArray = this.fHashMultipliers;
        for (int i = 0; i < n3; ++i) {
            n2 = n2 * nArray[i & 0x1F] + string2.charAt(i);
        }
        return n2;
    }

    protected void cleanTableView() {
        if (++this.fLargeCount < 0) {
            if (this.fAttributeTableViewChainState != null) {
                for (int i = this.fTableViewBuckets - 1; i >= 0; --i) {
                    this.fAttributeTableViewChainState[i] = 0;
                }
            }
            this.fLargeCount = 1;
        }
    }

    private void growTableView() {
        int n2 = this.fLength;
        int n3 = this.fTableViewBuckets;
        do {
            if ((n3 = (n3 << 1) + 1) >= 0) continue;
            n3 = Integer.MAX_VALUE;
            break;
        } while (n2 > n3);
        this.fTableViewBuckets = n3;
        this.fAttributeTableView = null;
        this.fLargeCount = 1;
    }

    protected void prepareTableView() {
        if (this.fLength > this.fTableViewBuckets) {
            this.growTableView();
        }
        if (this.fAttributeTableView == null) {
            this.fAttributeTableView = new Attribute[this.fTableViewBuckets];
            this.fAttributeTableViewChainState = new int[this.fTableViewBuckets];
        } else {
            this.cleanTableView();
        }
    }

    protected void prepareAndPopulateTableView() {
        this.prepareAndPopulateTableView(this.fLength);
    }

    private void prepareAndPopulateTableView(int n2) {
        this.prepareTableView();
        for (int i = 0; i < n2; ++i) {
            Attribute attribute2 = this.fAttributes[i];
            int n3 = this.getTableViewBucket(attribute2.name.rawname);
            if (this.fAttributeTableViewChainState[n3] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n3] = this.fLargeCount;
                attribute2.next = null;
                this.fAttributeTableView[n3] = attribute2;
                continue;
            }
            attribute2.next = this.fAttributeTableView[n3];
            this.fAttributeTableView[n3] = attribute2;
        }
    }

    private void prepareAndPopulateTableViewNS(int n2) {
        this.prepareTableView();
        for (int i = 0; i < n2; ++i) {
            Attribute attribute2 = this.fAttributes[i];
            int n3 = this.getTableViewBucket(attribute2.name.localpart, attribute2.name.uri);
            if (this.fAttributeTableViewChainState[n3] != this.fLargeCount) {
                this.fAttributeTableViewChainState[n3] = this.fLargeCount;
                attribute2.next = null;
                this.fAttributeTableView[n3] = attribute2;
                continue;
            }
            attribute2.next = this.fAttributeTableView[n3];
            this.fAttributeTableView[n3] = attribute2;
        }
    }

    private void rebalanceTableView(int n2) {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[33];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.prepareAndPopulateTableView(n2);
    }

    private void rebalanceTableViewNS(int n2) {
        if (this.fHashMultipliers == null) {
            this.fHashMultipliers = new int[33];
        }
        PrimeNumberSequenceGenerator.generateSequence(this.fHashMultipliers);
        this.prepareAndPopulateTableViewNS(n2);
    }

    static class Attribute {
        public final QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;
        public boolean schemaId;
        public Augmentations augs = new AugmentationsImpl();
        public Attribute next;

        Attribute() {
        }
    }
}

